/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.envvar;

import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;

public class EnvironmentVariable
implements IEnvironmentVariable,
Cloneable {
    protected String fName;
    protected String fValue;
    protected String fDelimiter;
    protected int fOperation;

    public EnvironmentVariable(String name, String value, int op, String delimiter) {
        this.fName = name;
        this.fOperation = op;
        this.fValue = value;
        this.fDelimiter = delimiter == null ? EnvironmentVariableManager.getDefault().getDefaultDelimiter() : delimiter;
    }

    protected EnvironmentVariable() {
        this.fDelimiter = EnvironmentVariableManager.getDefault().getDefaultDelimiter();
    }

    public EnvironmentVariable(String name) {
        this(name, null, 1, null);
    }

    public EnvironmentVariable(String name, String value) {
        this(name, value, 1, null);
    }

    public EnvironmentVariable(String name, String value, String delimiter) {
        this(name, value, 1, delimiter);
    }

    public EnvironmentVariable(IEnvironmentVariable var) {
        this(var.getName(), var.getValue(), var.getOperation(), var.getDelimiter());
    }

    public String getName() {
        return this.fName;
    }

    public String getValue() {
        return this.fValue;
    }

    public int getOperation() {
        return this.fOperation;
    }

    public String getDelimiter() {
        return this.fDelimiter;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fDelimiter == null ? 0 : this.fDelimiter.hashCode());
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + this.fOperation;
        result = 31 * result + (this.fValue == null ? 0 : this.fValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IEnvironmentVariable)) {
            return super.equals(obj);
        }
        IEnvironmentVariable other = (IEnvironmentVariable)obj;
        if (!this.equals(this.fName, other.getName())) {
            return false;
        }
        if (!this.equals(this.fValue, other.getValue())) {
            return false;
        }
        if (!this.equals(this.fDelimiter, other.getDelimiter())) {
            return false;
        }
        return this.fOperation == other.getOperation();
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.fName != null) {
            sb.append(this.fName);
        }
        if (this.fValue != null) {
            sb.append("=").append(this.fValue);
        }
        sb.append(" ").append(this.fDelimiter);
        switch (this.fOperation) {
            case 1: {
                sb.append(" [REPL]");
                break;
            }
            case 2: {
                sb.append(" [REM]");
                break;
            }
            case 3: {
                sb.append(" [PREP]");
                break;
            }
            case 4: {
                sb.append(" [APP]");
                break;
            }
            default: {
                sb.append(" [NONE]");
            }
        }
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

