/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.changegenerator;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModification;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ContainerNode;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ModificationScopeStack;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.UnhandledASTModificationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTModificationHelper {
    private final ModificationScopeStack modificationStore;

    public ASTModificationHelper(ModificationScopeStack stack) {
        this.modificationStore = stack;
    }

    public <T extends IASTNode> T[] createModifiedChildArray(IASTNode parent, T[] unmodifiedChildren, Class<T> clazz) {
        ArrayList<IASTNode> modifiedChildren = new ArrayList<IASTNode>(Arrays.asList(unmodifiedChildren));
        T[] TArray = unmodifiedChildren;
        int n = unmodifiedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            T currentChild = TArray[n2];
            for (ASTModification childModification : this.modificationsForNode((IASTNode)currentChild)) {
                try {
                    IASTNode newNode = (IASTNode)this.cast(childModification.getNewNode(), clazz);
                    switch (childModification.getKind()) {
                        case REPLACE: {
                            if (newNode != null) {
                                modifiedChildren.add(modifiedChildren.indexOf(childModification.getTargetNode()), newNode);
                            }
                            modifiedChildren.remove(childModification.getTargetNode());
                            break;
                        }
                        case INSERT_BEFORE: 
                        case APPEND_CHILD: {
                            throw new UnhandledASTModificationException(childModification);
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new UnhandledASTModificationException(childModification);
                }
            }
            ++n2;
        }
        block12: for (ASTModification parentModification : this.modificationsForNode(parent)) {
            switch (parentModification.getKind()) {
                case APPEND_CHILD: {
                    IASTNode newNode = parentModification.getNewNode();
                    IASTNode appendedTNode = (IASTNode)this.cast(newNode, clazz);
                    if (appendedTNode != null) {
                        modifiedChildren.add(appendedTNode);
                        break;
                    }
                    if (!(newNode instanceof ContainerNode)) break;
                    ContainerNode nodeContainer = (ContainerNode)newNode;
                    for (IASTNode currentNode : nodeContainer.getNodes()) {
                        IASTNode tnode = (IASTNode)this.cast(currentNode, clazz);
                        if (tnode == null) continue;
                        modifiedChildren.add(tnode);
                    }
                    continue block12;
                }
                case INSERT_BEFORE: {
                    IASTNode newNode = parentModification.getNewNode();
                    if (newNode instanceof ContainerNode) {
                        ContainerNode contNode = (ContainerNode)newNode;
                        for (IASTNode node : contNode.getNodes()) {
                            this.insertNode(clazz, modifiedChildren, parentModification, node);
                        }
                        continue block12;
                    }
                    this.insertNode(clazz, modifiedChildren, parentModification, newNode);
                }
            }
        }
        return modifiedChildren.toArray((IASTNode[])this.newArrayInstance(clazz, modifiedChildren.size()));
    }

    private <T> void insertNode(Class<T> clazz, ArrayList<T> modifiedChildren, ASTModification parentModification, IASTNode newNode) {
        T insertedTNode = this.cast(newNode, clazz);
        int targetNodeIndex = modifiedChildren.indexOf(parentModification.getTargetNode());
        if (targetNodeIndex >= 0) {
            modifiedChildren.add(targetNodeIndex, insertedTNode);
        }
    }

    private <T> T[] newArrayInstance(Class<T> clazz, int size) {
        return (Object[])Array.newInstance(clazz, size);
    }

    private <T> T cast(IASTNode node, Class<T> clazz) {
        if (clazz.isInstance(node)) {
            return (T)node;
        }
        return null;
    }

    public List<ASTModification> modificationsForNode(IASTNode targetNode) {
        List<ASTModification> modificationsForNode = this.modificationStore.getModifiedNodes().contains(targetNode) ? this.modificationStore.getModificationsForNode(targetNode) : Collections.emptyList();
        return modificationsForNode;
    }

    public IASTInitializer getInitializer(IASTDeclarator decl) {
        IASTInitializer initializer = decl.getInitializer();
        if (initializer != null) {
            for (ASTModification childModification : this.modificationsForNode(initializer)) {
                switch (childModification.getKind()) {
                    case REPLACE: {
                        if (childModification.getNewNode() instanceof IASTInitializer) {
                            return (IASTInitializer)childModification.getNewNode();
                        }
                        if (childModification.getNewNode() == null) {
                            return null;
                        }
                        throw new UnhandledASTModificationException(childModification);
                    }
                    case INSERT_BEFORE: {
                        throw new UnhandledASTModificationException(childModification);
                    }
                    case APPEND_CHILD: {
                        throw new UnhandledASTModificationException(childModification);
                    }
                }
            }
        } else {
            for (ASTModification parentModification : this.modificationsForNode(decl)) {
                IASTNode newNode;
                if (parentModification.getKind() != ASTModification.ModificationKind.APPEND_CHILD || !((newNode = parentModification.getNewNode()) instanceof IASTInitializer)) continue;
                return (IASTInitializer)newNode;
            }
        }
        return initializer;
    }

    public <T extends IASTNode> T getNodeAfterReplacement(T replacedNode) {
        List<ASTModification> modifications = this.modificationsForNode(replacedNode);
        for (ASTModification currentModification : modifications) {
            try {
                if (currentModification.getKind() != ASTModification.ModificationKind.REPLACE) continue;
                return (T)currentModification.getNewNode();
            }
            catch (ClassCastException classCastException) {
                throw new UnhandledASTModificationException(currentModification);
            }
        }
        return replacedNode;
    }
}

