/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.envvar;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.envvar.EnvironmentChangeEvent;
import org.eclipse.cdt.internal.core.envvar.ICoreEnvironmentVariableSupplier;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.utils.envvar.StorableEnvironment;
import org.eclipse.cdt.utils.envvar.StorableEnvironmentLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefinedEnvironmentSupplier
extends StorableEnvironmentLoader
implements ICoreEnvironmentVariableSupplier {
    public static final String NODENAME = "environment";
    public static final String PREFNAME_WORKSPACE = "workspace";
    public static final String PREFNAME_PROJECT = "project";
    public static final String NODENAME_CFG = "project";
    private StorableEnvironment fWorkspaceVariables;

    protected StorableEnvironment getEnvironment(Object context) {
        return this.getEnvironment(context, true);
    }

    protected StorableEnvironment getEnvironment(Object context, boolean forceLoad) {
        StorableEnvironment env = null;
        if (context instanceof IInternalCCfgInfo) {
            try {
                CConfigurationSpecSettings settings = ((IInternalCCfgInfo)context).getSpecSettings();
                env = settings.getEnvironment();
                if (env == null && forceLoad) {
                    env = this.loadEnvironment(context, settings.isReadOnly());
                    settings.setEnvironment(env);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        } else if (context instanceof IWorkspace || context == null) {
            if (this.fWorkspaceVariables == null && forceLoad) {
                this.fWorkspaceVariables = this.loadEnvironment(context, false);
            }
            env = this.fWorkspaceVariables;
        }
        return env;
    }

    @Override
    protected StorableEnvironmentLoader.ISerializeInfo getSerializeInfo(Object context) {
        Preferences prefs;
        StorableEnvironmentLoader.ISerializeInfo serializeInfo = null;
        if (context instanceof ICConfigurationDescription) {
            final ICConfigurationDescription cfg = (ICConfigurationDescription)context;
            final String name = cfg.getId();
            if (name != null) {
                serializeInfo = new StorableEnvironmentLoader.ISerializeInfo(){

                    public Preferences getNode() {
                        return UserDefinedEnvironmentSupplier.this.getConfigurationNode(cfg.getProjectDescription());
                    }

                    public String getPrefName() {
                        return name;
                    }
                };
            }
        } else if ((context == null || context instanceof IWorkspace) && (prefs = this.getWorkspaceNode()) != null) {
            serializeInfo = new StorableEnvironmentLoader.ISerializeInfo(){

                public Preferences getNode() {
                    return prefs;
                }

                public String getPrefName() {
                    return UserDefinedEnvironmentSupplier.PREFNAME_WORKSPACE;
                }
            };
        }
        return serializeInfo;
    }

    private Preferences getConfigurationNode(ICProjectDescription projDes) {
        Preferences prefNode = this.getProjectNode(projDes);
        if (prefNode == null) {
            return null;
        }
        return prefNode.node("project");
    }

    private Preferences getProjectNode(ICProjectDescription projDes) {
        if (projDes == null) {
            return null;
        }
        IProject project = projDes.getProject();
        if (!project.exists()) {
            return null;
        }
        IEclipsePreferences prefNode = new ProjectScope(project).getNode("org.eclipse.cdt.core");
        if (prefNode == null) {
            return null;
        }
        return prefNode.node(NODENAME);
    }

    private Preferences getWorkspaceNode() {
        IEclipsePreferences prefNode = new InstanceScope().getNode("org.eclipse.cdt.core");
        if (prefNode == null) {
            return null;
        }
        return prefNode.node(NODENAME);
    }

    public void checkInexistentConfigurations(ICProjectDescription projDes) {
        Preferences prefNode = this.getConfigurationNode(projDes);
        if (prefNode == null) {
            return;
        }
        try {
            String[] ids = prefNode.keys();
            boolean found = false;
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (projDes.getConfigurationById(id) == null) {
                    prefNode.remove(id);
                    found = true;
                }
                ++n2;
            }
            if (found) {
                prefNode.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void storeWorkspaceEnvironment(boolean force) {
        if (this.fWorkspaceVariables != null) {
            try {
                this.storeEnvironment(this.fWorkspaceVariables, ResourcesPlugin.getWorkspace(), force, true);
            }
            catch (CoreException coreException) {}
        }
    }

    public StorableEnvironment getWorkspaceEnvironmentCopy() {
        StorableEnvironment envVar = this.getEnvironment(null);
        return new StorableEnvironment(envVar, false);
    }

    public boolean setWorkspaceEnvironment(StorableEnvironment env) {
        StorableEnvironment oldEnv = this.getEnvironment(null);
        this.fWorkspaceVariables = new StorableEnvironment(env, false);
        EnvironmentChangeEvent event = UserDefinedEnvironmentSupplier.createEnvironmentChangeEvent(this.fWorkspaceVariables.getVariables(), oldEnv.getVariables());
        this.storeWorkspaceEnvironment(true);
        return event != null;
    }

    static EnvironmentChangeEvent createEnvironmentChangeEvent(IEnvironmentVariable[] newVars, IEnvironmentVariable[] oldVars) {
        IEnvironmentVariable[] addedVars = null;
        IEnvironmentVariable[] removedVars = null;
        IEnvironmentVariable[] changedVars = null;
        if (oldVars == null || oldVars.length == 0) {
            if (newVars != null && newVars.length != 0) {
                addedVars = (IEnvironmentVariable[])newVars.clone();
            }
        } else if (newVars == null || newVars.length == 0) {
            removedVars = (IEnvironmentVariable[])oldVars.clone();
        } else {
            HashSet<VarKey> newSet = new HashSet<VarKey>(newVars.length);
            HashSet<VarKey> oldSet = new HashSet<VarKey>(oldVars.length);
            Object object = newVars;
            int n = newVars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable newVar = object[n2];
                newSet.add(new VarKey(newVar, true));
                ++n2;
            }
            object = oldVars;
            n = oldVars.length;
            n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable oldVar = object[n2];
                oldSet.add(new VarKey(oldVar, true));
                ++n2;
            }
            HashSet newSetCopy = (HashSet)newSet.clone();
            newSet.removeAll(oldSet);
            oldSet.removeAll(newSetCopy);
            if (newSet.size() != 0) {
                addedVars = UserDefinedEnvironmentSupplier.varsFromKeySet(newSet);
            }
            if (oldSet.size() != 0) {
                removedVars = UserDefinedEnvironmentSupplier.varsFromKeySet(oldSet);
            }
            newSetCopy.removeAll(newSet);
            HashSet<VarKey> modifiedSet = new HashSet<VarKey>(newSetCopy.size());
            for (VarKey key : newSetCopy) {
                modifiedSet.add(new VarKey(key.getVariable(), false));
            }
            IEnvironmentVariable[] iEnvironmentVariableArray = oldVars;
            int n3 = oldVars.length;
            int n4 = 0;
            while (n4 < n3) {
                IEnvironmentVariable oldVar = iEnvironmentVariableArray[n4];
                modifiedSet.remove(new VarKey(oldVar, false));
                ++n4;
            }
            if (modifiedSet.size() != 0) {
                changedVars = UserDefinedEnvironmentSupplier.varsFromKeySet(modifiedSet);
            }
        }
        if (addedVars != null || removedVars != null || changedVars != null) {
            return new EnvironmentChangeEvent(addedVars, removedVars, changedVars);
        }
        return null;
    }

    static IEnvironmentVariable[] varsFromKeySet(Set<VarKey> set) {
        IEnvironmentVariable[] vars = new IEnvironmentVariable[set.size()];
        int i = 0;
        for (VarKey key : set) {
            vars[i] = key.getVariable();
            ++i;
        }
        return vars;
    }

    public void storeProjectEnvironment(ICProjectDescription des, boolean force) {
        ICConfigurationDescription[] cfgs;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = des.getConfigurations();
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            this.storeEnvironment(cfg, force, false);
            ++n2;
        }
        Preferences node = this.getProjectNode(des);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private void storeEnvironment(Object context, boolean force, boolean flush) {
        StorableEnvironment env = this.getEnvironment(context, false);
        if (env != null) {
            try {
                this.storeEnvironment(env, context, force, flush);
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public IEnvironmentVariable getVariable(String name, Object context) {
        if (this.getValidName(name) == null) {
            return null;
        }
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        return env.getVariable(name);
    }

    @Override
    public IEnvironmentVariable[] getVariables(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        return this.filterVariables(env.getVariables());
    }

    public IEnvironmentVariable createVariable(String name, String value, int op, String delimiter, Object context) {
        if (this.getValidName(name) == null) {
            return null;
        }
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        IEnvironmentVariable var = env.createVariable(name, value, op, delimiter);
        if (env.isChanged()) {
            env.setChanged(false);
        }
        return var;
    }

    public IEnvironmentVariable deleteVariable(String name, Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        IEnvironmentVariable var = env.deleteVariable(name);
        return var;
    }

    public void deleteAll(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return;
        }
        env.deleteAll();
    }

    public void setVariables(IEnvironmentVariable[] vars, Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return;
        }
        env.setVariales(vars);
        if (env.isChanged()) {
            env.setChanged(false);
        }
    }

    protected String getValidName(String name) {
        if (name == null || (name = name.trim()).length() == 0) {
            return null;
        }
        return name;
    }

    protected IEnvironmentVariable[] filterVariables(IEnvironmentVariable[] variables) {
        return EnvVarOperationProcessor.filterVariables(variables, null);
    }

    @Override
    public boolean appendEnvironment(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return true;
        }
        return env.appendEnvironment();
    }

    public boolean appendContributedEnvironment(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return true;
        }
        return env.appendContributedEnvironment();
    }

    public void setAppendEnvironment(boolean append, Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env != null) {
            env.setAppendEnvironment(append);
        }
    }

    public void setAppendContributedEnvironment(boolean append, Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env != null) {
            env.setAppendContributedEnvironment(append);
        }
    }

    public void restoreDefaults(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env != null) {
            env.restoreDefaults();
        }
    }

    static class VarKey {
        private IEnvironmentVariable fVar;
        private boolean fNameOnly;
        private int fCode;

        VarKey(IEnvironmentVariable var, boolean nameOnly) {
            this.fVar = var;
            this.fNameOnly = nameOnly;
        }

        public IEnvironmentVariable getVariable() {
            return this.fVar;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VarKey)) {
                return false;
            }
            VarKey other = (VarKey)obj;
            IEnvironmentVariable otherVar = other.fVar;
            if (this.fVar == otherVar) {
                return true;
            }
            if (!CDataUtil.objectsEqual(this.fVar.getName(), otherVar.getName())) {
                return false;
            }
            if (this.fNameOnly) {
                return true;
            }
            if (this.fVar.getOperation() != otherVar.getOperation()) {
                return false;
            }
            if (!CDataUtil.objectsEqual(this.fVar.getValue(), otherVar.getValue())) {
                return false;
            }
            return CDataUtil.objectsEqual(this.fVar.getDelimiter(), otherVar.getDelimiter());
        }

        public int hashCode() {
            int code = this.fCode;
            if (code == 0) {
                code = 47;
                String tmp = this.fVar.getName();
                if (tmp != null) {
                    code += tmp.hashCode();
                }
                if (this.fNameOnly) {
                    return code;
                }
                code += this.fVar.getOperation();
                tmp = this.fVar.getValue();
                if (tmp != null) {
                    code += tmp.hashCode();
                }
                if ((tmp = this.fVar.getDelimiter()) != null) {
                    code += tmp.hashCode();
                }
                this.fCode = code;
            }
            return code;
        }
    }
}

