/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICBuildSetting;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionWorkspacePreferences;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationDataProvider;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.ICProjectConverter;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.CSettingEntryFactory;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.cdt.core.settings.model.util.ListComparator;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.core.settings.model.util.PatternNameMap;
import org.eclipse.cdt.internal.core.CConfigBasedDescriptorManager;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.settings.model.AbstractCProjectDescriptionStorage;
import org.eclipse.cdt.internal.core.settings.model.CConfigExtensionReference;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDataProviderDescriptor;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescription;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsManager;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettinsDeltaCalculator;
import org.eclipse.cdt.internal.core.settings.model.CProjectConverterDesciptor;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionDelta;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionStorageManager;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionWorkspacePreferences;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ExtensionContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.ICDataProxyContainer;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.PathEntryConfigurationDataProvider;
import org.eclipse.cdt.internal.core.settings.model.ResourceChangeHandler;
import org.eclipse.cdt.internal.core.settings.model.ScannerInfoProviderProxy;
import org.eclipse.cdt.internal.core.settings.model.SettingsContext;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.cdt.internal.core.settings.model.xml.InternalXmlStorageElement;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlStorage;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CProjectDescriptionManager
implements ICProjectDescriptionManager {
    public static final int INTERNAL_GET_IGNORE_CLOSE = Integer.MIN_VALUE;
    private static final String VERSION_ELEMENT_NAME = "fileVersion";
    public static final Version MIN_DESCRIPTION_VERSION = new Version("4.0");
    public static final Version DESCRIPTION_VERSION = new Version("5.0");
    public static final String MODULE_ID = "org.eclipse.cdt.core.settings";
    static final String CONFIGURATION = "cconfiguration";
    private static final ICLanguageSettingEntry[] EMPTY_LANGUAGE_SETTINGS_ENTRIES_ARRAY = new ICLanguageSettingEntry[0];
    private static final ICElementDelta[] EMPTY_CELEMENT_DELTA = new ICElementDelta[0];
    private static final ICLanguageSetting[] EMPTY_LANGUAGE_SETTINGS_ARRAY = new ICLanguageSetting[0];
    private static final String PREFERENCES_STORAGE = "preferences";
    private static final String PREFERENCE_BUILD_SYSTEM_ELEMENT = "buildSystem";
    private static final String PREFERENCES_ELEMENT = "preferences";
    private static final String ID = "id";
    private static final String PREFERENCE_CFG_ID_PREFIX = "preference.";
    private static final String PREFERENCE_CFG_NAME = SettingsModelMessages.getString("CProjectDescriptionManager.15");
    private static final String ROOT_PREFERENCE_ELEMENT = "preferences";
    private static final String DEFAULT_CFG_ID_PREFIX = "org.eclipse.cdt.core.default.config";
    private static final String DEFAULT_CFG_NAME = "Configuration";
    private static final QualifiedName SCANNER_INFO_PROVIDER_PROPERTY = new QualifiedName("org.eclipse.cdt.core", "scannerInfoProvider");
    private volatile Map<String, CConfigurationDataProviderDescriptor> fProviderMap;
    private volatile CProjectConverterDesciptor[] fConverters;
    private Set<ListenerDescriptor> fListeners = new CopyOnWriteArraySet<ListenerDescriptor>();
    private Map<String, CConfigurationDescriptionCache> fPreferenceMap = new HashMap<String, CConfigurationDescriptionCache>();
    private volatile CConfigBasedDescriptorManager fDescriptorManager;
    private ResourceChangeHandler fRcChangeHandler;
    private CProjectDescriptionWorkspacePreferences fPreferences;
    private boolean fAllowEmptyCreatingDescription = true;
    private ICDataProxyContainer fPrefUpdater = new ICDataProxyContainer(){

        public void updateChild(CDataProxy child, boolean write) {
            if (write) {
                try {
                    ((CConfigurationDescription)child).doWritable();
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
        }

        public ICSettingObject[] getChildSettings() {
            return CProjectDescriptionManager.this.fPreferenceMap.values().toArray(new CConfigurationDescriptionCache[CProjectDescriptionManager.this.fPreferenceMap.size()]);
        }
    };
    private static volatile CProjectDescriptionManager fInstance;
    ThreadLocal<Boolean> settingProjectDescription = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    private CProjectDescriptionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CProjectDescriptionManager getInstance() {
        if (fInstance != null) return fInstance;
        Class<CProjectDescriptionManager> clazz = CProjectDescriptionManager.class;
        synchronized (CProjectDescriptionManager.class) {
            if (fInstance != null) return fInstance;
            fInstance = new CProjectDescriptionManager();
            fInstance.initProviderInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fInstance;
        }
    }

    public void projectClosedRemove(IProject project) {
        CProjectDescriptionStorageManager.getInstance().projectClosedRemove(project);
    }

    public ICProjectDescription projectMove(IProject from, IProject to) {
        CProjectDescriptionStorageManager.getInstance().projectMove(from, to);
        int flags = -2147483644;
        CProjectDescription des = (CProjectDescription)this.getProjectDescription(to, flags);
        if (des != null) {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = des.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfgDes = iCConfigurationDescriptionArray[n2];
                des.updateChild((CConfigurationDescription)cfgDes, true);
                ++n2;
            }
        }
        return des;
    }

    public Job startup() {
        if (this.fRcChangeHandler == null) {
            this.fRcChangeHandler = new ResourceChangeHandler();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fRcChangeHandler, 7);
            if (this.fDescriptorManager == null) {
                this.fDescriptorManager = CConfigBasedDescriptorManager.getInstance();
                this.fDescriptorManager.startup();
            }
            CExternalSettingsManager.getInstance().startup();
        }
        return this.createPostStartupJob();
    }

    private Job createPostStartupJob() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Job rcJob = new Job(SettingsModelMessages.getString("CProjectDescriptionManager.0")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CProjectDescriptionManager.this.startSaveParticipant();
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                    return e.getStatus();
                }
                return new Status(0, "org.eclipse.cdt.core", 0, "", null);
            }
        };
        rcJob.setRule((ISchedulingRule)root);
        rcJob.setPriority(10);
        rcJob.setSystem(true);
        return rcJob;
    }

    private void startSaveParticipant() throws CoreException {
        ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant("org.eclipse.cdt.core", (ISaveParticipant)this.fRcChangeHandler);
        if (lastState != null) {
            lastState.processResourceChangeEvents((IResourceChangeListener)this.fRcChangeHandler);
        }
    }

    public void shutdown() {
        CExternalSettingsManager.getInstance().shutdown();
        if (this.fDescriptorManager != null) {
            this.fDescriptorManager.shutdown();
            this.fDescriptorManager = null;
        }
        if (this.fRcChangeHandler != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fRcChangeHandler);
            this.fRcChangeHandler = null;
        }
        CProjectDescriptionStorageManager.getInstance().shutdown();
    }

    @Override
    public ICProjectDescription getProjectDescription(IProject project, boolean write) {
        return this.getProjectDescription(project, true, write);
    }

    public ICProjectDescription getProjectDescription(IProject project, boolean load, boolean write) {
        int flags = load ? 0 : 8;
        return this.getProjectDescription(project, flags |= write ? 4 : 0);
    }

    @Override
    public ICProjectDescription getProjectDescription(IProject project, int flags) {
        try {
            return this.getProjectDescriptionInternal(project, flags);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private ICProjectDescription getProjectDescriptionInternal(IProject project, int flags) throws CoreException {
        AbstractCProjectDescriptionStorage storage = this.getProjectDescriptionStorage(project);
        return storage.getProjectDescription(flags, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Job runWspModification(IWorkspaceRunnable runnable, IProgressMonitor monitor) {
        return CProjectDescriptionManager.runWspModification(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), monitor);
    }

    public static Job runWspModification(final IWorkspaceRunnable runnable, final ISchedulingRule rule, IProgressMonitor monitor) {
        Job currentJob;
        boolean scheduleRule;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(scheduleRule = ResourcesPlugin.getWorkspace().isTreeLocked()) && (currentJob = Job.getJobManager().currentJob()) != null && currentJob.getRule() != null && !currentJob.getRule().contains(rule)) {
            scheduleRule = true;
        }
        if (!scheduleRule) {
            IJobManager mngr = Job.getJobManager();
            try {
                try {
                    mngr.beginRule(rule, monitor);
                    CProjectDescriptionManager.runAtomic(runnable, rule, monitor);
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                    if (!scheduleRule) {
                        monitor.done();
                    }
                    mngr.endRule(rule);
                }
            }
            finally {
                if (!scheduleRule) {
                    monitor.done();
                }
                mngr.endRule(rule);
            }
        } else {
            Job job = new Job(SettingsModelMessages.getString("CProjectDescriptionManager.12")){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            CProjectDescriptionManager.runAtomic(runnable, rule, monitor);
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                            IStatus iStatus = e.getStatus();
                            monitor.done();
                            return iStatus;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule(rule);
            job.setSystem(true);
            job.schedule();
            return job;
        }
        return null;
    }

    private static void runAtomic(final IWorkspaceRunnable r, ISchedulingRule rule, IProgressMonitor monitor) throws CoreException {
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        wsp.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    r.run(monitor);
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", e.getMessage(), (Throwable)e));
                }
            }
        }, rule, 1, monitor);
    }

    @Override
    public void updateProjectDescriptions(IProject[] projects, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IWorkspace wsp = ResourcesPlugin.getWorkspace();
            if (projects == null) {
                projects = wsp.getRoot().getProjects();
            }
            final ICProjectDescription[] dess = new ICProjectDescription[projects.length];
            int num = 0;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                ICProjectDescription des = this.getProjectDescription(project, false, true);
                if (des != null) {
                    dess[num++] = des;
                }
                ++n2;
            }
            if (num != 0) {
                final int[] fi = new int[]{num};
                CProjectDescriptionManager.runWspModification(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        monitor.beginTask(SettingsModelMessages.getString("CProjectDescriptionManager.13"), fi[0]);
                        ICProjectDescription[] iCProjectDescriptionArray = dess;
                        int n = dess.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block6: {
                                ICProjectDescription des = iCProjectDescriptionArray[n2];
                                if (des == null) break;
                                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                                try {
                                    try {
                                        CProjectDescriptionManager.this.setProjectDescription(des.getProject(), des, true, (IProgressMonitor)subMonitor);
                                    }
                                    catch (CoreException e) {
                                        CCorePlugin.log(e);
                                        subMonitor.done();
                                        break block6;
                                    }
                                }
                                catch (Throwable throwable) {
                                    subMonitor.done();
                                    throw throwable;
                                }
                                subMonitor.done();
                            }
                            ++n2;
                        }
                    }
                }, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    public ICProjectConverter getConverter(IProject project, String oldOwnerId, ICProjectDescription des) {
        CProjectConverterDesciptor[] converterDess = this.getConverterDescriptors();
        ICProjectConverter converter = null;
        CProjectConverterDesciptor[] cProjectConverterDesciptorArray = converterDess;
        int n = converterDess.length;
        int n2 = 0;
        while (n2 < n) {
            CProjectConverterDesciptor converterDes = cProjectConverterDesciptorArray[n2];
            if (converterDes.canConvertProject(project, oldOwnerId, des)) {
                try {
                    converter = converterDes.getConverter();
                }
                catch (CoreException coreException) {}
                if (converter != null) break;
            }
            ++n2;
        }
        return converter;
    }

    private CProjectConverterDesciptor[] getConverterDescriptors() {
        if (this.fConverters == null) {
            this.initConverterInfoSynch();
        }
        return this.fConverters;
    }

    private synchronized void initConverterInfoSynch() {
        if (this.fConverters != null) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core.projectConverter");
        IExtension[] exts = extensionPoint.getExtensions();
        CProjectConverterDesciptor[] dess = new CProjectConverterDesciptor[exts.length];
        int i = 0;
        while (i < exts.length) {
            dess[i] = new CProjectConverterDesciptor(exts[i]);
            ++i;
        }
        this.fConverters = dess;
    }

    @Override
    public ICProjectDescription createProjectDescription(IProject project, boolean loadIfExists) throws CoreException {
        return this.createProjectDescription(project, loadIfExists, false);
    }

    @Override
    public ICProjectDescription createProjectDescription(IProject project, boolean loadIfExists, boolean creating) throws CoreException {
        int flags = 36;
        flags |= loadIfExists ? 0 : 16;
        return this.getProjectDescriptionInternal(project, flags |= creating ? 64 : 0);
    }

    public ScannerInfoProviderProxy getScannerInfoProviderProxy(IProject project) {
        ICProjectDescription des = this.getProjectDescription(project, false);
        if (des == null) {
            return new ScannerInfoProviderProxy(project);
        }
        ScannerInfoProviderProxy provider = (ScannerInfoProviderProxy)des.getSessionProperty(SCANNER_INFO_PROVIDER_PROPERTY);
        if (provider == null) {
            provider = new ScannerInfoProviderProxy(project);
            des.setSessionProperty(SCANNER_INFO_PROVIDER_PROPERTY, provider);
        } else {
            provider.updateProject(project);
        }
        return provider;
    }

    @Override
    public ICProjectDescription getProjectDescription(IProject project) {
        return this.getProjectDescription(project, true);
    }

    public boolean checkHandleActiveCfgChange(CProjectDescription newDes, ICProjectDescription oldDes, IProjectDescription eDes, IProgressMonitor monitor) {
        if (newDes == null) {
            return false;
        }
        ICConfigurationDescription newCfg = newDes.getActiveConfiguration();
        if (newCfg == null) {
            return false;
        }
        ICConfigurationDescription oldCfg = oldDes != null ? oldDes.getActiveConfiguration() : null;
        this.checkActiveCfgChange(newDes, oldDes);
        this.checkSettingCfgChange(newDes, oldDes);
        boolean modified = false;
        try {
            if (this.checkBuildSystemChange(eDes, newCfg, oldCfg, monitor)) {
                modified = true;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        try {
            if (this.checkProjectRefChange(eDes, newDes, newCfg, oldCfg, monitor)) {
                modified = true;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return modified;
    }

    private Collection<IProject> projSetFromProjNameSet(Collection<String> projNames) {
        if (projNames.size() == 0) {
            return new HashSet<IProject>(0);
        }
        LinkedHashSet<IProject> set = new LinkedHashSet<IProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (String sproj : projNames) {
            set.add(root.getProject(sproj));
        }
        return set;
    }

    private boolean checkProjectRefChange(IProjectDescription des, ICProjectDescription newCDesc, ICConfigurationDescription newCfg, ICConfigurationDescription oldCfg, IProgressMonitor monitor) throws CoreException {
        if (newCfg == null) {
            return false;
        }
        Map<String, String> oldMap = oldCfg != null ? oldCfg.getReferenceInfo() : Collections.EMPTY_MAP;
        Map<String, String> newMap = newCfg.getReferenceInfo();
        if (newMap.equals(oldMap)) {
            return false;
        }
        HashSet<String> removedRefs = new HashSet<String>();
        if (oldCfg != null && oldCfg.getId().equals(newCfg.getId())) {
            removedRefs.addAll(oldMap.keySet());
            removedRefs.removeAll(newMap.keySet());
        }
        LinkedHashSet<String> allRefs = new LinkedHashSet<String>();
        ICConfigurationDescription[] iCConfigurationDescriptionArray = newCDesc.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            allRefs.addAll(cfg.getReferenceInfo().keySet());
            ++n2;
        }
        removedRefs.removeAll(allRefs);
        LinkedHashSet<IProject> oldProjects = new LinkedHashSet<IProject>(Arrays.asList(des.getReferencedProjects()));
        Collection<IProject> newProjects = this.projSetFromProjNameSet(allRefs);
        if (removedRefs.isEmpty() && oldProjects.containsAll(newProjects)) {
            return false;
        }
        oldProjects.addAll(newProjects);
        oldProjects.removeAll(this.projSetFromProjNameSet(removedRefs));
        des.setReferencedProjects(oldProjects.toArray(new IProject[oldProjects.size()]));
        return true;
    }

    private boolean checkActiveCfgChange(CProjectDescription des, ICProjectDescription oldDes) {
        ICConfigurationDescription oldCfg = oldDes != null ? oldDes.getActiveConfiguration() : null;
        String oldId = oldCfg != null ? oldCfg.getId() : null;
        return des.checkPersistActiveCfg(oldId, false);
    }

    private boolean checkSettingCfgChange(CProjectDescription des, ICProjectDescription oldDes) {
        ICConfigurationDescription oldCfg = oldDes != null ? oldDes.getDefaultSettingConfiguration() : null;
        String oldId = oldCfg != null ? oldCfg.getId() : null;
        return des.checkPersistSettingCfg(oldId, false);
    }

    private boolean checkBuildSystemChange(IProjectDescription des, ICConfigurationDescription newCfg, ICConfigurationDescription oldCfg, IProgressMonitor monitor) throws CoreException {
        List<Object> conflictingNatures;
        String newBsId = newCfg != null ? newCfg.getBuildSystemId() : null;
        String oldBsId = oldCfg != null ? oldCfg.getBuildSystemId() : null;
        CConfigurationDataProviderDescriptor newDr = newBsId != null ? this.getCfgProviderDescriptor(newBsId) : null;
        CConfigurationDataProviderDescriptor oldDr = oldBsId != null ? this.getCfgProviderDescriptor(oldBsId) : null;
        List<Object> oldNatures = conflictingNatures = Collections.emptyList();
        List<Object> newNatures = conflictingNatures;
        if (oldDr != null) {
            oldNatures = Arrays.asList(oldDr.getNatureIds());
        }
        if (newDr != null) {
            newNatures = Arrays.asList(newDr.getNatureIds());
            conflictingNatures = Arrays.asList(newDr.getConflictingNatureIds());
        }
        Object[] natureIds = des.getNatureIds();
        HashSet toRemove = new HashSet(oldNatures);
        toRemove.removeAll(newNatures);
        toRemove.addAll(conflictingNatures);
        LinkedHashSet<String> cur = new LinkedHashSet<String>(Arrays.asList(natureIds));
        cur.addAll(newNatures);
        cur.removeAll(toRemove);
        Object[] newNatureIds = cur.toArray(new String[cur.size()]);
        if (!Arrays.equals(newNatureIds, natureIds)) {
            des.setNatureIds((String[])newNatureIds);
            return true;
        }
        return false;
    }

    @Override
    public void setProjectDescription(IProject project, ICProjectDescription des) throws CoreException {
        this.setProjectDescription(project, des, false, null);
    }

    @Override
    public void setProjectDescription(IProject project, ICProjectDescription des, boolean force, IProgressMonitor monitor) throws CoreException {
        int flags = force ? 1 : 0;
        this.setProjectDescription(project, des, flags, monitor);
    }

    static boolean checkFlags(int flags, int check) {
        return (flags & check) == check;
    }

    @Override
    public void setProjectDescription(IProject project, ICProjectDescription des, int flags, IProgressMonitor monitor) throws CoreException {
        try {
            this.settingProjectDescription.set(true);
            if (des != null) {
                if (!project.isAccessible()) {
                    throw ExceptionFactory.createCoreException(MessageFormat.format((String)CCorePlugin.getResourceString("ProjectDescription.ProjectNotAccessible"), (Object[])new Object[]{project.getName()}));
                }
                if (!(des.isValid() || this.fAllowEmptyCreatingDescription && des.isCdtProjectCreating())) {
                    throw ExceptionFactory.createCoreException(String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.17")) + project.getName());
                }
                if (!CProjectDescriptionManager.checkFlags(flags, 1) && !des.isModified()) {
                    return;
                }
                if (((CProjectDescription)des).isLoading()) {
                    throw ExceptionFactory.createCoreException("description is being loadded");
                }
                if (((CProjectDescription)des).isApplying()) {
                    throw ExceptionFactory.createCoreException("description is being applied");
                }
            }
            CProjectDescriptionStorageManager.getInstance().setProjectDescription(project, des, flags, monitor);
        }
        finally {
            this.settingProjectDescription.set(false);
        }
    }

    public boolean isCurrentThreadSetProjectDescription() {
        return this.settingProjectDescription.get();
    }

    private AbstractCProjectDescriptionStorage getProjectDescriptionStorage(IProject project) throws CoreException {
        if (project == null || !project.isAccessible()) {
            throw ExceptionFactory.createCoreException(MessageFormat.format((String)CCorePlugin.getResourceString("ProjectDescription.ProjectNotAccessible"), (Object[])new Object[]{project != null ? project.getName() : "<null>"}));
        }
        AbstractCProjectDescriptionStorage storage = CProjectDescriptionStorageManager.getInstance().getProjectDescriptionStorage(project);
        if (storage == null) {
            throw ExceptionFactory.createCoreException(String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.FailedToGetStorage")) + project.getName());
        }
        return storage;
    }

    public ICSettingsStorage getStorageForElement(IProject project, ICStorageElement element) throws CoreException {
        if (project != null) {
            return this.getProjectDescriptionStorage(project).getStorageForElement(element);
        }
        return new XmlStorage((InternalXmlStorageElement)element);
    }

    private void serializePreference(String key, InternalXmlStorageElement element) throws CoreException {
        Document doc = element.fElement.getOwnerDocument();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        FileOutputStream fileStream = null;
        try {
            byte[] bytes;
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            File file = this.getPreferenceFile(key);
            String utfString = stream.toString("UTF-8");
            if (!file.exists()) {
                file.createNewFile();
            }
            fileStream = new FileOutputStream(file);
            try {
                bytes = utfString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = utfString.getBytes();
            }
            fileStream.write(bytes);
            fileStream.close();
            stream.close();
        }
        catch (TransformerConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (TransformerException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (IOException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    ICLanguageSetting findLanguagSettingForFile(String fileName, IProject project, ICLanguageSetting[] settings) {
        String ext;
        ICLanguageSetting setting = null;
        int index = fileName.lastIndexOf(46);
        if (index > 0 && (ext = fileName.substring(index + 1).trim()).length() > 0) {
            setting = this.findLanguageSettingForExtension(ext, settings);
        }
        return setting;
    }

    public ICLanguageSetting findLanguageSettingForContentTypeId(String id, ICLanguageSetting[] settings) {
        ICLanguageSetting[] iCLanguageSettingArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting setting = iCLanguageSettingArray[n2];
            Object[] ids = setting.getSourceContentTypeIds();
            if (ListComparator.indexOf(id, ids) != -1) {
                return setting;
            }
            ++n2;
        }
        return null;
    }

    public ICLanguageSetting[] findCompatibleSettingsForContentTypeId(String id, ICLanguageSetting[] settings) {
        String[] exts;
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType cType = manager.getContentType(id);
        if (cType != null && (exts = cType.getFileSpecs(8)) != null && exts.length != 0) {
            ArrayList<ICLanguageSetting> list = new ArrayList<ICLanguageSetting>();
            String[] stringArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                ICLanguageSetting setting = this.findLanguageSettingForExtension(ext, settings);
                if (setting != null) {
                    list.add(setting);
                }
                ++n2;
            }
            return list.toArray(new ICLanguageSetting[list.size()]);
        }
        return EMPTY_LANGUAGE_SETTINGS_ARRAY;
    }

    public ICLanguageSetting findLanguageSettingForExtension(String ext, ICLanguageSetting[] settings) {
        ICLanguageSetting[] iCLanguageSettingArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting setting = iCLanguageSettingArray[n2];
            String[] exts = setting.getSourceExtensions();
            if (exts != null && exts.length != 0) {
                String[] stringArray = exts;
                int n3 = exts.length;
                int n4 = 0;
                while (n4 < n3) {
                    String ex = stringArray[n4];
                    if (ext.equals(ex)) {
                        return setting;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    Map<String, ICStorageElement> createCfgStorages(ICProjectDescription des) throws CoreException {
        LinkedHashMap<String, ICStorageElement> map = new LinkedHashMap<String, ICStorageElement>();
        ICStorageElement rootElement = des.getStorage(MODULE_ID, false);
        if (rootElement != null) {
            ICStorageElement[] children;
            ICStorageElement[] iCStorageElementArray = children = rootElement.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                ICStorageElement el = iCStorageElementArray[n2];
                if (CONFIGURATION.equals(el.getName()) && (id = el.getAttribute(ID)) != null) {
                    map.put(id, el);
                }
                ++n2;
            }
        }
        return map;
    }

    ICStorageElement createStorage(ICSettingsStorage storage, String cfgId) throws CoreException {
        ICStorageElement rootElement = storage.getStorage(MODULE_ID, true);
        ICStorageElement[] children = rootElement.getChildren();
        ICStorageElement element = null;
        ICStorageElement[] iCStorageElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement el = iCStorageElementArray[n2];
            if (CONFIGURATION.equals(el.getName()) && cfgId.equals(el.getAttribute(ID))) {
                element = el;
                break;
            }
            ++n2;
        }
        if (element == null) {
            element = rootElement.createChild(CONFIGURATION);
            element.setAttribute(ID, cfgId);
        }
        return element;
    }

    ICStorageElement createStorage(ICSettingsStorage storage, String cfgId, ICStorageElement base) throws CoreException {
        ICStorageElement[] children;
        ICStorageElement rootElement = storage.getStorage(MODULE_ID, true);
        ICStorageElement[] iCStorageElementArray = children = rootElement.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (CONFIGURATION.equals(child.getName()) && cfgId.equals(child.getAttribute(ID))) {
                throw ExceptionFactory.createCoreException(MessageFormat.format((String)SettingsModelMessages.getString("CProjectDescriptionManager.cfgIDAlreadyExists"), (Object[])new Object[]{cfgId}));
            }
            ++n2;
        }
        ICStorageElement config = rootElement.importChild(base);
        config.setAttribute(ID, cfgId);
        return config;
    }

    void removeStorage(ICSettingsStorage storage, String cfgId) throws CoreException {
        ICStorageElement rootElement = storage.getStorage(MODULE_ID, false);
        if (rootElement != null) {
            ICStorageElement[] children;
            ICStorageElement[] iCStorageElementArray = children = rootElement.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ICStorageElement el = iCStorageElementArray[n2];
                if (CONFIGURATION.equals(el.getName()) && cfgId.equals(el.getAttribute(ID))) {
                    rootElement.removeChild(el);
                    break;
                }
                ++n2;
            }
        }
    }

    CConfigurationData loadData(ICConfigurationDescription des, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CConfigurationDataProvider provider = this.getProvider(des);
        return provider.loadConfiguration(des, monitor);
    }

    CConfigurationData applyData(CConfigurationDescriptionCache des, ICConfigurationDescription baseDescription, CConfigurationData base, SettingsContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CConfigurationDataProvider provider = this.getProvider(des);
        context.init(des);
        return provider.applyConfiguration(des, baseDescription, base, context, monitor);
    }

    void notifyCached(ICConfigurationDescription des, CConfigurationData data, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CConfigurationDataProvider provider = this.getProvider(des);
            provider.dataCached(des, data, monitor);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    void removeData(ICConfigurationDescription des, CConfigurationData data, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CConfigurationDataProvider provider = this.getProvider(des);
        provider.removeConfiguration(des, data, monitor);
    }

    CConfigurationData createData(ICConfigurationDescription des, ICConfigurationDescription baseDescription, CConfigurationData base, boolean clone, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CConfigurationDataProvider provider = this.getProvider(des);
        return provider.createConfiguration(des, baseDescription, base, clone, monitor);
    }

    private CConfigurationDataProvider getProvider(ICConfigurationDescription des) throws CoreException {
        CConfigurationDataProviderDescriptor providerDes = this.getCfgProviderDescriptor(des);
        if (providerDes == null) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.1"));
        }
        return providerDes.getProvider();
    }

    private CConfigurationDataProviderDescriptor getCfgProviderDescriptor(ICConfigurationDescription des) {
        return this.getCfgProviderDescriptor(des.getBuildSystemId());
    }

    private CConfigurationDataProviderDescriptor getCfgProviderDescriptor(String id) {
        this.initProviderInfo();
        return this.fProviderMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProviderInfo() {
        if (this.fProviderMap != null) {
            return;
        }
        CProjectDescriptionManager cProjectDescriptionManager = this;
        synchronized (cProjectDescriptionManager) {
            if (this.fProviderMap != null) {
                return;
            }
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core.CConfigurationDataProvider");
            IExtension[] exts = extensionPoint.getExtensions();
            this.fProviderMap = new HashMap<String, CConfigurationDataProviderDescriptor>(exts.length);
            IExtension[] iExtensionArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                CConfigurationDataProviderDescriptor des = new CConfigurationDataProviderDescriptor(ext);
                this.fProviderMap.put(des.getId(), des);
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public ICStorageElement createPreferenceStorage(String key, boolean createEmptyIfNotFound, boolean readOnly) throws CoreException {
        try {
            block35: {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                doc = null;
                element = null;
                stream = null;
                try {
                    stream = this.getPreferenceProperty(key);
                    if (stream != null) {
                        doc = builder.parse(stream);
                        rootElement = doc.getFirstChild();
                        if (rootElement.getNodeType() != 7) {
                            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.2"));
                        }
                        fileVersion = rootElement.getNodeValue();
                        version = new Version(fileVersion);
                        if (CProjectDescriptionManager.MIN_DESCRIPTION_VERSION.compareTo((Object)version) > 0 || CProjectDescriptionManager.DESCRIPTION_VERSION.compareTo((Object)version) < 0) {
                            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.3"));
                        }
                        nodes = doc.getElementsByTagName("preferences");
                        if (nodes.getLength() == 0) {
                            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.4"));
                        }
                        node = nodes.item(0);
                        if (node.getNodeType() != 1) {
                            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.5"));
                        }
                        element = (Element)node;
                    } else if (!createEmptyIfNotFound) {
                        throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.6"));
                    }
                }
                catch (FactoryConfigurationError e) {
                    if (!createEmptyIfNotFound) {
                        throw ExceptionFactory.createCoreException(e.getLocalizedMessage());
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException v0) {}
                    }
                    break block35;
                }
                catch (SAXException e) {
                    if (!createEmptyIfNotFound) {
                        throw ExceptionFactory.createCoreException(e);
                    }
                    ** if (stream == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            stream.close();
                        }
                        catch (IOException v1) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block35;
                    }
                }
                catch (IOException e) {
                    if (!createEmptyIfNotFound) {
                        throw ExceptionFactory.createCoreException(e);
                    }
                    ** if (stream == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            stream.close();
                        }
                        catch (IOException v2) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block35;
                    }
                    {
                        catch (Throwable var11_15) {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException v3) {}
                            }
                            throw var11_15;
                        }
                    }
                }
                if (stream == null) break block35;
                try {
                    stream.close();
                }
                catch (IOException v4) {}
            }
            if (element == null) {
                doc = builder.newDocument();
                instruction = doc.createProcessingInstruction("fileVersion", CProjectDescriptionManager.DESCRIPTION_VERSION.toString());
                doc.appendChild(instruction);
                element = doc.createElement("preferences");
                doc.appendChild(element);
            }
            return new InternalXmlStorageElement(element, null, false, readOnly);
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    private InputStream getPreferenceProperty(String key) {
        FileInputStream stream = null;
        File file = this.getPreferenceFile(key);
        if (file.exists()) {
            try {
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                CCorePlugin.log(e);
            }
        }
        return stream;
    }

    private File getPreferenceFile(String key) {
        IPath path = CCorePlugin.getDefault().getStateLocation();
        path = path.append(key);
        return path.toFile();
    }

    public static File toLocalFile(URI uri, IProgressMonitor monitor) throws CoreException {
        IFileStore fileStore = EFS.getStore((URI)uri);
        File localFile = fileStore.toLocalFile(0, monitor);
        if (localFile == null) {
            localFile = fileStore.toLocalFile(4096, monitor);
        }
        return localFile;
    }

    ICDescriptionDelta createDelta(ICProjectDescription newDescription, ICProjectDescription oldDescription) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newDescription, oldDescription);
        if (delta.getDeltaKind() == 3) {
            ICConfigurationDescription cfg;
            ICConfigurationDescription[] cfgs;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = newDescription.getConfigurations();
            int n = cfgs.length;
            int n2 = 0;
            while (n2 < n) {
                cfg = iCConfigurationDescriptionArray[n2];
                ICConfigurationDescription oldCfg = oldDescription.getConfigurationById(cfg.getId());
                CProjectDescriptionDelta cfgDelta = this.createDelta(cfg, oldCfg);
                if (cfgDelta != null) {
                    delta.addChild(cfgDelta);
                }
                ++n2;
            }
            iCConfigurationDescriptionArray = cfgs = oldDescription.getConfigurations();
            n = cfgs.length;
            n2 = 0;
            while (n2 < n) {
                cfg = iCConfigurationDescriptionArray[n2];
                ICConfigurationDescription newCfg = newDescription.getConfigurationById(cfg.getId());
                if (newCfg == null) {
                    delta.addChild(this.createDelta(null, cfg));
                }
                ++n2;
            }
            if (this.checkCfgChange(newDescription, oldDescription, true)) {
                delta.addChangeFlags(1);
            }
            if (this.checkCfgChange(newDescription, oldDescription, false)) {
                delta.addChangeFlags(0x200000);
            }
            if (oldDescription.isCdtProjectCreating() && !newDescription.isCdtProjectCreating()) {
                delta.addChangeFlags(0x400000);
            }
        }
        return delta.isEmpty() ? null : delta;
    }

    private boolean checkCfgChange(ICProjectDescription newDes, ICProjectDescription oldDes, boolean active) {
        ICConfigurationDescription oldCfg;
        ICConfigurationDescription newCfg;
        if (active) {
            newCfg = newDes.getActiveConfiguration();
            oldCfg = oldDes.getActiveConfiguration();
        } else {
            newCfg = newDes.getDefaultSettingConfiguration();
            oldCfg = oldDes.getDefaultSettingConfiguration();
        }
        if (newCfg == null) {
            return oldCfg != null;
        }
        if (oldCfg == null) {
            return true;
        }
        return !newCfg.getId().equals(oldCfg.getId());
    }

    private ICDescriptionDelta findDelta(String id, ICDescriptionDelta delta) {
        ICDescriptionDelta[] children;
        ICDescriptionDelta[] iCDescriptionDeltaArray = children = delta.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICDescriptionDelta child = iCDescriptionDeltaArray[n2];
            ICSettingObject obj = child.getSetting();
            if (obj.getId().equals(id)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    public int calculateDescriptorFlags(ICConfigurationDescription newCfg, ICConfigurationDescription oldCfg) {
        try {
            int flags = 0;
            CConfigurationSpecSettings newSettings = ((IInternalCCfgInfo)((Object)newCfg)).getSpecSettings();
            CConfigurationSpecSettings oldSettings = ((IInternalCCfgInfo)((Object)oldCfg)).getSpecSettings();
            String newId = newSettings.getCOwnerId();
            String oldId = oldSettings.getCOwnerId();
            if (!CDataUtil.objectsEqual(newId, oldId)) {
                flags |= 0x100000;
            }
            Map<String, CConfigExtensionReference[]> newMap = newSettings.getExtensionMapCopy();
            Map<String, CConfigExtensionReference[]> oldMap = oldSettings.getExtensionMapCopy();
            Iterator<Map.Entry<String, CConfigExtensionReference[]>> iter = newMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, CConfigExtensionReference[]> entry = iter.next();
                iter.remove();
                CConfigExtensionReference[] oldRefs = oldMap.remove(entry.getKey());
                if (oldRefs == null) {
                    flags |= 0x80000;
                    break;
                }
                CConfigExtensionReference[] newRefs = entry.getValue();
                if (newRefs.length != oldRefs.length) {
                    flags |= 0x80000;
                    break;
                }
                HashSet<CConfigExtensionReference> newSet = new HashSet<CConfigExtensionReference>(Arrays.asList(newRefs));
                HashSet<CConfigExtensionReference> oldSet = new HashSet<CConfigExtensionReference>(Arrays.asList(oldRefs));
                if (newSet.size() != oldSet.size()) {
                    flags |= 0x80000;
                    break;
                }
                newSet.removeAll(oldSet);
                if (newSet.size() == 0) continue;
                flags |= 0x80000;
                break;
            }
            return flags;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public CProjectDescriptionDelta createDelta(ICConfigurationDescription newCfg, ICConfigurationDescription oldCfg) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newCfg, oldCfg);
        IInternalCCfgInfo newInfo = (IInternalCCfgInfo)((Object)newCfg);
        IInternalCCfgInfo oldInfo = (IInternalCCfgInfo)((Object)oldCfg);
        if (delta.getDeltaKind() == 3) {
            int n;
            int n2;
            ICSourceEntry[] iCSourceEntryArray;
            boolean found;
            int n3;
            ICSourceEntry[] iCSourceEntryArray2;
            ICSourceEntry[] oldEntries;
            ICSourceEntry[] newEntries;
            CProjectDescriptionDelta tpsDelta;
            Object newDes;
            ICFolderDescription foDes;
            ICFolderDescription[] foDess;
            ICFolderDescription[] iCFolderDescriptionArray = foDess = newCfg.getFolderDescriptions();
            int n4 = foDess.length;
            int n5 = 0;
            while (n5 < n4) {
                foDes = iCFolderDescriptionArray[n5];
                ICResourceDescription oldDes = oldCfg.getResourceDescription(foDes.getPath(), true);
                if (oldDes != null && oldDes.getType() == 4) {
                    CProjectDescriptionDelta foDelta = this.createDelta(foDes, (ICFolderDescription)oldDes);
                    if (foDelta != null) {
                        delta.addChild(foDelta);
                    }
                } else {
                    delta.addChild(this.createDelta(foDes, null));
                }
                ++n5;
            }
            iCFolderDescriptionArray = foDess = oldCfg.getFolderDescriptions();
            n4 = foDess.length;
            n5 = 0;
            while (n5 < n4) {
                foDes = iCFolderDescriptionArray[n5];
                newDes = newCfg.getResourceDescription(foDes.getPath(), true);
                if (newDes == null || newDes.getType() != 4) {
                    delta.addChild(this.createDelta(null, foDes));
                }
                ++n5;
            }
            ICFileDescription[] fiDess = newCfg.getFileDescriptions();
            newDes = fiDess;
            int n6 = fiDess.length;
            n4 = 0;
            while (n4 < n6) {
                Object fiDes = newDes[n4];
                ICResourceDescription oldDes = oldCfg.getResourceDescription(fiDes.getPath(), true);
                if (oldDes != null && oldDes.getType() == 8) {
                    CProjectDescriptionDelta fiDelta = this.createDelta((ICFileDescription)fiDes, (ICFileDescription)oldDes);
                    if (fiDelta != null) {
                        delta.addChild(fiDelta);
                    }
                } else {
                    delta.addChild(this.createDelta((ICFileDescription)fiDes, null));
                }
                ++n4;
            }
            fiDess = oldCfg.getFileDescriptions();
            newDes = fiDess;
            n6 = fiDess.length;
            n4 = 0;
            while (n4 < n6) {
                Object fiDes = newDes[n4];
                ICResourceDescription newDes2 = newCfg.getResourceDescription(fiDes.getPath(), true);
                if (newDes2 == null || newDes2.getType() != 8) {
                    delta.addChild(this.createDelta(null, (ICFileDescription)fiDes));
                }
                ++n4;
            }
            CProjectDescriptionDelta bsDelta = this.createDelta(newCfg.getBuildSetting(), oldCfg.getBuildSetting());
            if (bsDelta != null) {
                delta.addChild(bsDelta);
            }
            if ((tpsDelta = this.createDelta(newCfg.getTargetPlatformSetting(), oldCfg.getTargetPlatformSetting())) != null) {
                delta.addChild(tpsDelta);
            }
            if (!newCfg.getName().equals(oldCfg.getName())) {
                delta.addChangeFlags(2);
            }
            if (!CDataUtil.objectsEqual(newCfg.getDescription(), oldCfg.getDescription())) {
                delta.addChangeFlags(4);
            }
            if ((newEntries = newCfg.getSourceEntries()).length > (oldEntries = oldCfg.getSourceEntries()).length) {
                delta.addChangeFlags(8192);
            } else {
                iCSourceEntryArray2 = newEntries;
                n3 = newEntries.length;
                int fiDelta = 0;
                while (fiDelta < n3) {
                    ICSourceEntry newEntry = iCSourceEntryArray2[fiDelta];
                    found = false;
                    iCSourceEntryArray = oldEntries;
                    n2 = oldEntries.length;
                    n = 0;
                    while (n < n2) {
                        ICSourceEntry oldEntry = iCSourceEntryArray[n];
                        if (newEntry.equals(oldEntry)) {
                            found = true;
                            break;
                        }
                        ++n;
                    }
                    if (!found) {
                        delta.addChangeFlags(8192);
                        break;
                    }
                    ++fiDelta;
                }
            }
            if (oldEntries.length > newEntries.length) {
                delta.addChangeFlags(16384);
            } else {
                iCSourceEntryArray2 = oldEntries;
                n3 = oldEntries.length;
                int fiDelta = 0;
                while (fiDelta < n3) {
                    ICSourceEntry oldEntry = iCSourceEntryArray2[fiDelta];
                    found = false;
                    iCSourceEntryArray = newEntries;
                    n2 = newEntries.length;
                    n = 0;
                    while (n < n2) {
                        ICSourceEntry newEntry = iCSourceEntryArray[n];
                        if (oldEntry.equals(newEntry)) {
                            found = true;
                            break;
                        }
                        ++n;
                    }
                    if (!found) {
                        delta.addChangeFlags(16384);
                        break;
                    }
                    ++fiDelta;
                }
            }
            try {
                CConfigurationSpecSettings newSettings = newInfo.getSpecSettings();
                CConfigurationSpecSettings oldSettings = oldInfo.getSpecSettings();
                if (!newSettings.extRefSettingsEqual(oldSettings)) {
                    delta.addChangeFlags(524288);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            this.calculateCfgExtSettingsDelta(delta);
            int drFlags = this.calculateDescriptorFlags(newCfg, oldCfg);
            if (drFlags != 0) {
                delta.addChangeFlags(drFlags);
            }
        }
        return delta.isEmpty() ? null : delta;
    }

    private void calculateCfgExtSettingsDelta(CProjectDescriptionDelta delta) {
        int cfgRefFlags;
        ICConfigurationDescription newDes = (ICConfigurationDescription)delta.getNewSetting();
        ICConfigurationDescription oldDes = (ICConfigurationDescription)delta.getOldSetting();
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = this.getSettingChange(newDes, oldDes);
        int flags = 0;
        int addedRemoved = 98304;
        if (deltas != null) {
            CExternalSettinsDeltaCalculator.ExtSettingsDelta[] extSettingsDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                CExternalSettinsDeltaCalculator.ExtSettingsDelta dt = extSettingsDeltaArray[n2];
                ICSettingEntry[][] d = dt.getEntriesDelta();
                if (d[0] != null) {
                    flags |= 0x8000;
                }
                if (d[1] != null) {
                    flags |= 0x10000;
                }
                if ((flags & addedRemoved) == addedRemoved) break;
                ++n2;
            }
            if (flags != 0) {
                delta.addChangeFlags(flags);
            }
        }
        if ((cfgRefFlags = this.calcRefChangeFlags(newDes, oldDes)) != 0) {
            delta.addChangeFlags(cfgRefFlags);
        }
    }

    private int calcRefChangeFlags(ICConfigurationDescription newDes, ICConfigurationDescription oldDes) {
        Map<String, String> newMap = newDes != null ? newDes.getReferenceInfo() : null;
        Map<String, String> oldMap = oldDes != null ? oldDes.getReferenceInfo() : null;
        int flags = 0;
        if (newMap == null || newMap.size() == 0) {
            if (oldMap != null && oldMap.size() != 0) {
                flags = 262144;
            }
        } else if (oldMap == null || oldMap.size() == 0) {
            flags = 131072;
        } else {
            boolean stop = false;
            for (Map.Entry<String, String> newEntry : newMap.entrySet()) {
                String oldCfg;
                String newProj = newEntry.getKey();
                String newCfg = newEntry.getValue();
                if (newCfg.equals(oldCfg = oldMap.remove(newProj))) continue;
                flags |= 0x20000;
                if (oldCfg != null) {
                    flags |= 0x40000;
                    stop = true;
                }
                if (stop) break;
            }
            if (!oldMap.isEmpty()) {
                flags |= 0x40000;
            }
        }
        return flags;
    }

    private CExternalSettinsDeltaCalculator.ExtSettingsDelta[] getSettingChange(ICConfigurationDescription newDes, ICConfigurationDescription oldDes) {
        CExternalSetting[] newSettings = newDes != null ? (CExternalSetting[])newDes.getExternalSettings() : null;
        CExternalSetting[] oldSettings = oldDes != null ? (CExternalSetting[])oldDes.getExternalSettings() : null;
        return CExternalSettinsDeltaCalculator.getInstance().getSettingChange(newSettings, oldSettings);
    }

    private CProjectDescriptionDelta createDelta(ICFolderDescription newFo, ICFolderDescription oldFo) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newFo, oldFo);
        if (delta.getDeltaKind() == 3) {
            ICLanguageSetting[] newLss = newFo.getLanguageSettings();
            ICLanguageSetting[] oldLss = oldFo.getLanguageSettings();
            ArrayList<ICLanguageSetting> newList = new ArrayList<ICLanguageSetting>(Arrays.asList(newLss));
            ArrayList<ICLanguageSetting> oldList = new ArrayList<ICLanguageSetting>(Arrays.asList(oldLss));
            List<ICLanguageSetting[]> matched = this.sortSettings(newList, oldList);
            for (ICLanguageSetting[] match : matched) {
                CProjectDescriptionDelta lsDelta = this.createDelta(match[0], match[1]);
                if (lsDelta == null) continue;
                delta.addChild(lsDelta);
            }
            for (ICLanguageSetting added : newList) {
                delta.addChild(this.createDelta(added, null));
            }
            for (ICLanguageSetting removed : oldList) {
                delta.addChild(this.createDelta(null, removed));
            }
            if (newFo.isExcluded() != oldFo.isExcluded()) {
                delta.addChangeFlags(4096);
            }
        }
        return delta.isEmpty() ? null : delta;
    }

    private List<ICLanguageSetting[]> sortSettings(List<ICLanguageSetting> settings1, List<ICLanguageSetting> settings2) {
        ICLanguageSetting[] match;
        Iterator<ICLanguageSetting> iter2;
        ICLanguageSetting setting2;
        ICLanguageSetting setting1;
        ArrayList<ICLanguageSetting[]> result = new ArrayList<ICLanguageSetting[]>();
        Iterator<ICLanguageSetting> iter1 = settings1.iterator();
        block0: while (iter1.hasNext()) {
            setting1 = iter1.next();
            Iterator<ICLanguageSetting> iter22 = settings2.iterator();
            while (iter22.hasNext()) {
                setting2 = iter22.next();
                if (!setting2.getId().equals(setting1.getId())) continue;
                iter1.remove();
                iter22.remove();
                ICLanguageSetting[] match2 = new ICLanguageSetting[]{setting1, setting2};
                result.add(match2);
                continue block0;
            }
        }
        iter1 = settings1.iterator();
        block2: while (iter1.hasNext()) {
            setting1 = iter1.next();
            String lId = setting1.getLanguageId();
            if (lId == null) continue;
            iter2 = settings2.iterator();
            while (iter2.hasNext()) {
                setting2 = iter2.next();
                if (!lId.equals(setting2.getLanguageId())) continue;
                iter1.remove();
                iter2.remove();
                match = new ICLanguageSetting[]{setting1, setting2};
                result.add(match);
                continue block2;
            }
        }
        iter1 = settings1.iterator();
        block4: while (iter1.hasNext()) {
            setting1 = iter1.next();
            Object[] cTypeIds1 = setting1.getSourceContentTypeIds();
            if (cTypeIds1.length == 0) continue;
            iter2 = settings2.iterator();
            while (iter2.hasNext()) {
                setting2 = iter2.next();
                if (!Arrays.equals(cTypeIds1, setting2.getSourceContentTypeIds())) continue;
                iter1.remove();
                iter2.remove();
                match = new ICLanguageSetting[]{setting1, setting2};
                result.add(match);
                continue block4;
            }
        }
        iter1 = settings1.iterator();
        block6: while (iter1.hasNext()) {
            Object[] srcExts;
            setting1 = iter1.next();
            if (setting1.getSourceContentTypeIds().length != 0 || (srcExts = setting1.getSourceExtensions()).length == 0) continue;
            iter2 = settings2.iterator();
            while (iter2.hasNext()) {
                setting2 = iter2.next();
                if (setting2.getSourceContentTypeIds().length != 0 || !Arrays.equals(srcExts, setting2.getSourceExtensions())) continue;
                iter1.remove();
                iter2.remove();
                match = new ICLanguageSetting[]{setting1, setting2};
                result.add(match);
                continue block6;
            }
        }
        return result;
    }

    private CProjectDescriptionDelta createDelta(ICFileDescription newFi, ICFileDescription oldFi) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newFi, oldFi);
        if (delta.getDeltaKind() == 3) {
            CProjectDescriptionDelta lsDelta = this.createDelta(newFi.getLanguageSetting(), oldFi.getLanguageSetting());
            if (lsDelta != null) {
                delta.addChild(lsDelta);
            }
            if (newFi.isExcluded() != oldFi.isExcluded()) {
                delta.addChangeFlags(4096);
            }
        }
        return delta.isEmpty() ? null : delta;
    }

    private CProjectDescriptionDelta createDelta(ICLanguageSetting newLs, ICLanguageSetting oldLs) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newLs, oldLs);
        if (delta.getDeltaKind() == 3) {
            Object[] oldExts;
            Object[] newExts;
            if (!CDataUtil.objectsEqual(newLs.getLanguageId(), oldLs.getLanguageId())) {
                delta.addChangeFlags(16);
            }
            int[] kinds = KindBasedStore.getLanguageEntryKinds();
            int addedKinds = 0;
            int removedKinds = 0;
            int reorderedKinds = 0;
            int[] nArray = kinds;
            int n = kinds.length;
            int n2 = 0;
            while (n2 < n) {
                ICLanguageSettingEntry[] oldEntries;
                int kind = nArray[n2];
                ICLanguageSettingEntry[] newEntries = newLs.getSettingEntries(kind);
                boolean[] change = this.calculateSettingsChanges(newEntries, oldEntries = oldLs.getSettingEntries(kind));
                if (change[0]) {
                    addedKinds |= kind;
                }
                if (change[1]) {
                    removedKinds |= kind;
                }
                if (change[2]) {
                    reorderedKinds |= kind;
                }
                ++n2;
            }
            delta.setAddedLanguageEntriesKinds(addedKinds);
            delta.setRemovedLanguageEntriesKinds(removedKinds);
            delta.setReorderedLanguageEntriesKinds(reorderedKinds);
            Object[] newCtIds = newLs.getSourceContentTypeIds();
            Object[] oldCtIds = oldLs.getSourceContentTypeIds();
            if (!Arrays.equals(newCtIds, oldCtIds)) {
                delta.addChangeFlags(32);
            }
            if (!Arrays.equals(newExts = newLs.getSourceExtensions(), oldExts = oldLs.getSourceExtensions())) {
                delta.addChangeFlags(64);
            }
        }
        return delta.isEmpty() ? null : delta;
    }

    private boolean[] calculateSettingsChanges(ICLanguageSettingEntry[] newEntries, ICLanguageSettingEntry[] oldEntries) {
        boolean found;
        boolean[] result = new boolean[3];
        if (oldEntries == null) {
            return result;
        }
        if (newEntries == null) {
            newEntries = EMPTY_LANGUAGE_SETTINGS_ENTRIES_ARRAY;
        }
        HashSet<ICLanguageSettingEntry> newEntrySet = new HashSet<ICLanguageSettingEntry>(Arrays.asList(newEntries));
        HashSet<ICLanguageSettingEntry> oldEntrySet = new HashSet<ICLanguageSettingEntry>(Arrays.asList(oldEntries));
        ICLanguageSettingEntry[] iCLanguageSettingEntryArray = oldEntries;
        int n = oldEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSettingEntry oldEntry = iCLanguageSettingEntryArray[n2];
            found = false;
            if (newEntrySet.contains(oldEntry)) {
                found = true;
                break;
            }
            if (!found) {
                result[1] = true;
                break;
            }
            ++n2;
        }
        iCLanguageSettingEntryArray = newEntries;
        n = newEntries.length;
        n2 = 0;
        while (n2 < n) {
            ICLanguageSettingEntry newEntry = iCLanguageSettingEntryArray[n2];
            found = false;
            if (oldEntrySet.contains(newEntry)) {
                found = true;
                break;
            }
            if (!found) {
                result[0] = true;
                break;
            }
            ++n2;
        }
        if (!result[0] && !result[1] && oldEntries.length == newEntries.length) {
            int i = 0;
            while (i < newEntries.length) {
                if (!newEntries[i].equals(oldEntries[i])) {
                    result[2] = true;
                    break;
                }
                ++i;
            }
        }
        if (!result[0] && !result[1] && oldEntries.length != newEntries.length) {
            result[2] = true;
        }
        return result;
    }

    private CProjectDescriptionDelta createDelta(ICBuildSetting newBuildSetting, ICBuildSetting oldBuildSetting) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newBuildSetting, oldBuildSetting);
        if (!Arrays.equals(newBuildSetting.getErrorParserIDs(), oldBuildSetting.getErrorParserIDs())) {
            delta.addChangeFlags(2048);
        }
        return delta.isEmpty() ? null : delta;
    }

    private CProjectDescriptionDelta createDelta(ICTargetPlatformSetting newTPS, ICTargetPlatformSetting oldTPS) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newTPS, oldTPS);
        if (!Arrays.equals(newTPS.getBinaryParserIds(), oldTPS.getBinaryParserIds())) {
            delta.addChangeFlags(1024);
        }
        return delta.isEmpty() ? null : delta;
    }

    ICElementDelta[] generateCElementDeltas(ICProject cProject, ICDescriptionDelta projDesDelta) {
        if (projDesDelta == null) {
            return EMPTY_CELEMENT_DELTA;
        }
        int kind = projDesDelta.getDeltaKind();
        switch (kind) {
            case 3: {
                ICProjectDescription newDes = (ICProjectDescription)projDesDelta.getNewSetting();
                ICProjectDescription oldDes = (ICProjectDescription)projDesDelta.getOldSetting();
                ICConfigurationDescription indexCfg = newDes.getDefaultSettingConfiguration();
                ICConfigurationDescription oldIndexCfg = oldDes.getDefaultSettingConfiguration();
                ICDescriptionDelta indexDelta = oldIndexCfg != null && oldIndexCfg.getId().equals(indexCfg.getId()) ? this.findDelta(indexCfg.getId(), projDesDelta) : this.createDelta(indexCfg, oldIndexCfg);
                if (indexDelta != null) {
                    ArrayList<CElementDelta> list = new ArrayList<CElementDelta>();
                    this.generateCElementDeltasFromCfgDelta(cProject, indexDelta, list);
                    return list.toArray(new ICElementDelta[list.size()]);
                }
                return EMPTY_CELEMENT_DELTA;
            }
        }
        return EMPTY_CELEMENT_DELTA;
    }

    private List<CElementDelta> generateCElementDeltasFromCfgDelta(ICProject cProject, ICDescriptionDelta cfgDelta, List<CElementDelta> list) {
        int kind = cfgDelta.getDeltaKind();
        switch (kind) {
            case 3: {
                ICDescriptionDelta[] children;
                int descriptionFlags = cfgDelta.getChangeFlags();
                int celementFlags = 0;
                if ((descriptionFlags & 0x2000) != 0) {
                    celementFlags |= 0x100;
                }
                if ((descriptionFlags & 0x4000) != 0) {
                    celementFlags |= 0x200;
                }
                if (celementFlags != 0) {
                    CElementDelta cElDelta = new CElementDelta(cProject.getCModel());
                    cElDelta.changed(cProject, celementFlags);
                    list.add(cElDelta);
                }
                ICDescriptionDelta[] iCDescriptionDeltaArray = children = cfgDelta.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ICDescriptionDelta child = iCDescriptionDeltaArray[n2];
                    int type = child.getSettingType();
                    if (type == 8 || type == 4) {
                        this.generateCElementDeltasFromResourceDelta(cProject, child, list);
                    }
                    ++n2;
                }
                break;
            }
        }
        return list;
    }

    private void generateCElementDeltasFromResourceDelta(ICProject cProject, ICDescriptionDelta delta, List<CElementDelta> list) {
        ICResourceDescription newRcDes;
        IPath path;
        ICResourceDescription oldRcDes;
        int kind = delta.getDeltaKind();
        ICDescriptionDelta parentDelta = delta.getParent();
        switch (kind) {
            case 1: {
                oldRcDes = (ICResourceDescription)delta.getOldSetting();
                path = oldRcDes.getPath();
                newRcDes = ((ICConfigurationDescription)parentDelta.getNewSetting()).getResourceDescription(path, false);
                break;
            }
            case 2: {
                newRcDes = (ICResourceDescription)delta.getNewSetting();
                path = newRcDes.getPath();
                oldRcDes = ((ICConfigurationDescription)parentDelta.getOldSetting()).getResourceDescription(path, false);
                break;
            }
            case 3: {
                newRcDes = (ICResourceDescription)delta.getNewSetting();
                path = newRcDes.getPath();
                oldRcDes = (ICResourceDescription)delta.getOldSetting();
                break;
            }
            default: {
                CCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.core", String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.illegalDeltaKind")) + kind));
                return;
            }
        }
        path = path.makeRelative();
        ICElement el = null;
        try {
            el = cProject.findElement(path);
        }
        catch (CModelException cModelException) {
            return;
        }
        IResource rc = el.getResource();
        if (rc != null) {
            CElementDelta ceRcDelta = new CElementDelta(el.getCModel());
            ceRcDelta.changed(el, 2);
            list.add(ceRcDelta);
            if (rc.getType() == 1) {
                String fileName = path.lastSegment();
                ICLanguageSetting newLS = this.getLanguageSetting(newRcDes, fileName);
                ICLanguageSetting oldLS = this.getLanguageSetting(oldRcDes, fileName);
                CProjectDescriptionDelta ld = this.createDelta(newLS, oldLS);
                this.generateCElementDeltasFromLanguageDelta(el, ld, list);
            } else {
                if (newRcDes.getType() != 4) {
                    CCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.core", String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.wrongTypeOfResourceDescription")) + newRcDes));
                    return;
                }
                ICFolderDescription newFoDes = (ICFolderDescription)newRcDes;
                if (oldRcDes.getType() != 4) {
                    CCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.core", String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.wrongTypeOfResourceDescription")) + oldRcDes));
                    return;
                }
                ICFolderDescription oldFoDes = (ICFolderDescription)oldRcDes;
                CProjectDescriptionDelta folderDelta = this.createDelta(newFoDes, oldFoDes);
                if (folderDelta != null) {
                    ICDescriptionDelta[] iCDescriptionDeltaArray = folderDelta.getChildren();
                    int n = iCDescriptionDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICDescriptionDelta child = iCDescriptionDeltaArray[n2];
                        if (child.getSettingType() == 16) {
                            this.generateCElementDeltasFromLanguageDelta(el, child, list);
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    private ICLanguageSetting getLanguageSetting(ICResourceDescription rcDes, String fileName) {
        if (rcDes.getType() == 8) {
            return ((ICFileDescription)rcDes).getLanguageSetting();
        }
        return ((ICFolderDescription)rcDes).getLanguageSettingForFile(fileName);
    }

    private List<CElementDelta> generateCElementDeltasFromLanguageDelta(ICElement el, ICDescriptionDelta delta, List<CElementDelta> list) {
        if (delta == null) {
            return list;
        }
        int flags = 0;
        flags |= this.calculateEntriesFlags(delta.getAddedEntriesKinds(), true);
        flags |= this.calculateEntriesFlags(delta.getRemovedEntriesKinds(), false);
        if ((flags |= this.calculateEntriesFlags(delta.getReorderedEntriesKinds(), true)) != 0) {
            CElementDelta cElDelta = new CElementDelta(el.getCModel());
            cElDelta.changed(el, flags);
            list.add(cElDelta);
        }
        return list;
    }

    private int calculateEntriesFlags(int languageDeltaKinds, boolean added) {
        int[] kindsArray;
        int flags = 0;
        int[] nArray = kindsArray = this.kindsToArray(languageDeltaKinds);
        int n = kindsArray.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            switch (element) {
                case 1: {
                    flags |= 0x800;
                    break;
                }
                case 2: {
                    flags |= 0x800;
                    break;
                }
                case 4: {
                    flags |= 0x400;
                    break;
                }
                case 8: {
                    flags |= 0x400;
                    break;
                }
                case 16: {
                    flags |= added ? 4096 : 8192;
                    break;
                }
                case 32: {
                    flags |= added ? 4096 : 8192;
                }
            }
            ++n2;
        }
        return flags;
    }

    int[] kindsToArray(int kinds) {
        int[] allKinds = KindBasedStore.getLanguageEntryKinds();
        int[] kindsArray = new int[allKinds.length];
        int num = 0;
        int[] nArray = allKinds;
        int n = allKinds.length;
        int n2 = 0;
        while (n2 < n) {
            int kind = nArray[n2];
            if ((kind & kinds) != 0) {
                kindsArray[num++] = kind;
            }
            ++n2;
        }
        if (num < allKinds.length) {
            int[] tmp = new int[num];
            if (num > 0) {
                System.arraycopy(kindsArray, 0, tmp, 0, num);
            }
            kindsArray = tmp;
        }
        return kindsArray;
    }

    @Override
    public void addCProjectDescriptionListener(ICProjectDescriptionListener listener, int eventTypes) {
        this.fListeners.add(new ListenerDescriptor(listener, eventTypes));
    }

    @Override
    public void removeCProjectDescriptionListener(ICProjectDescriptionListener listener) {
        for (ListenerDescriptor listenerDescriptor : this.fListeners) {
            if (!listenerDescriptor.fListener.equals(listener)) continue;
            this.fListeners.remove(listenerDescriptor);
            break;
        }
    }

    public void notifyListeners(CProjectDescriptionEvent event) {
        int eventType = event.getEventType();
        for (ListenerDescriptor listener : this.fListeners) {
            if (!listener.handlesEvent(eventType)) continue;
            listener.fListener.handleEvent(event);
        }
    }

    void checkRemovedConfigurations(ICDescriptionDelta delta) {
        ICDescriptionDelta[] cfgDeltas;
        if (delta == null) {
            return;
        }
        ICDescriptionDelta[] iCDescriptionDeltaArray = cfgDeltas = delta.getChildren();
        int n = cfgDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            ICDescriptionDelta cfgDelta = iCDescriptionDeltaArray[n2];
            if (cfgDelta.getDeltaKind() == 1) {
                CConfigurationDescriptionCache des = (CConfigurationDescriptionCache)cfgDelta.getOldSetting();
                CConfigurationData data = des.getConfigurationData();
                try {
                    this.removeData(des, data, null);
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
    }

    @Override
    public ICConfigurationDescription getPreferenceConfiguration(String buildSystemId) throws CoreException {
        return this.getPreferenceConfiguration(buildSystemId, true);
    }

    private void runContextOperations(SettingsContext context, IProgressMonitor monitor) {
        IWorkspaceRunnable toRun = context.createOperationRunnable();
        if (toRun != null) {
            CProjectDescriptionManager.runWspModification(toRun, monitor);
        } else if (monitor != null) {
            monitor.done();
        }
    }

    @Override
    public ICConfigurationDescription getPreferenceConfiguration(String buildSystemId, boolean write) throws CoreException {
        ICConfigurationDescription des = this.getLoaddedPreference(buildSystemId);
        if (des == null) {
            try {
                des = this.loadPreference(buildSystemId);
            }
            catch (CoreException coreException) {}
            if (des == null) {
                try {
                    des = this.createNewPreference(buildSystemId);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            this.setLoaddedPreference(buildSystemId, (CConfigurationDescriptionCache)des);
        }
        if (des != null && write) {
            try {
                des = this.createWritablePreference((CConfigurationDescriptionCache)des);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return des;
    }

    @Override
    public void setPreferenceConfiguration(String buildSystemId, ICConfigurationDescription des) throws CoreException {
        if (!this.needSavePreference(buildSystemId, des)) {
            return;
        }
        CConfigurationDescriptionCache cache = this.createPreferenceCache(des);
        this.savePreferenceConfiguration(buildSystemId, cache);
        this.setLoaddedPreference(buildSystemId, cache);
    }

    private void savePreferenceConfiguration(String buildStystemId, CConfigurationDescriptionCache cache) throws CoreException {
        ICStorageElement el = cache.getSpecSettings().getRootStorageElement();
        this.saveBuildSystemConfigPreferenceStorage(buildStystemId, el);
    }

    private void saveBuildSystemConfigPreferenceStorage(String buildSystemId, ICStorageElement el) throws CoreException {
        ICStorageElement cur = this.getBuildSystemConfigPreferenceStorage(buildSystemId);
        ICStorageElement parent = cur.getParent();
        parent.removeChild(cur);
        parent.importChild(el);
        this.savePreferenceStorage("preferences", MODULE_ID, parent);
    }

    private boolean needSavePreference(String buildSystemId, ICConfigurationDescription des) {
        return des.isModified() || !des.isPreferenceConfiguration() || !des.getBuildSystemId().equals(buildSystemId);
    }

    private ICConfigurationDescription createWritablePreference(CConfigurationDescriptionCache cache) throws CoreException {
        return new CConfigurationDescription(cache, this.fPrefUpdater);
    }

    private CConfigurationDescriptionCache createPreferenceCache(ICConfigurationDescription des) throws CoreException {
        IInternalCCfgInfo cfgDes = (IInternalCCfgInfo)((Object)des);
        CConfigurationData baseData = cfgDes.getConfigurationData(false);
        CConfigurationDescriptionCache baseCache = null;
        if (baseData instanceof CConfigurationDescriptionCache) {
            baseCache = (CConfigurationDescriptionCache)baseData;
            baseData = baseCache.getConfigurationData();
        }
        CConfigurationSpecSettings settings = cfgDes.getSpecSettings();
        ICStorageElement rootEl = this.getBuildSystemConfigPreferenceStorage(des.getBuildSystemId(), true, false);
        ICStorageElement rootParent = rootEl.getParent();
        rootParent.removeChild(rootEl);
        ICStorageElement baseRootEl = settings.getRootStorageElement();
        rootEl = rootParent.importChild(baseRootEl);
        CConfigurationDescriptionCache cache = new CConfigurationDescriptionCache(des, baseData, baseCache, cfgDes.getSpecSettings(), null, rootEl);
        CSettingEntryFactory factory = new CSettingEntryFactory();
        SettingsContext context = new SettingsContext(null);
        cache.applyData(factory, context);
        cache.doneInitialization();
        factory.clear();
        this.runContextOperations(context, null);
        return cache;
    }

    private ICConfigurationDescription createNewPreference(String buildSystemId) throws CoreException {
        ICStorageElement cfgEl = this.getBuildSystemConfigPreferenceStorage(buildSystemId, true, false);
        String id = PREFERENCE_CFG_ID_PREFIX + buildSystemId;
        CConfigurationDescription des = new CConfigurationDescription(id, PREFERENCE_CFG_NAME, buildSystemId, cfgEl, this.fPrefUpdater);
        return this.createPreferenceCache(des);
    }

    ICStorageElement getBuildSystemConfigPreferenceStorage(String buildSystemId) throws CoreException {
        return this.getBuildSystemConfigPreferenceStorage(buildSystemId, true, false);
    }

    private ICStorageElement getBuildSystemConfigPreferenceStorage(String buildSystemId, boolean createIfNotDound, boolean readOnly) throws CoreException {
        ICStorageElement el = this.getPreferenceStorage("preferences", MODULE_ID, createIfNotDound, readOnly);
        ICStorageElement cfgEl = null;
        if (el != null) {
            ICStorageElement[] children;
            ICStorageElement[] iCStorageElementArray = children = el.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ICStorageElement child = iCStorageElementArray[n2];
                if (PREFERENCE_BUILD_SYSTEM_ELEMENT.equals(child.getName()) && buildSystemId.equals(child.getAttribute(ID))) {
                    cfgEl = child;
                    break;
                }
                ++n2;
            }
            if (cfgEl == null) {
                cfgEl = el.createChild(PREFERENCE_BUILD_SYSTEM_ELEMENT);
                cfgEl.setAttribute(ID, buildSystemId);
            }
        }
        return cfgEl;
    }

    private ICConfigurationDescription loadPreference(String buildSystemId) throws CoreException {
        ICStorageElement el = this.getPreferenceStorage("preferences", MODULE_ID, false, false);
        ICStorageElement[] children = el.getChildren();
        ICStorageElement cfgEl = null;
        ICStorageElement[] iCStorageElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (PREFERENCE_BUILD_SYSTEM_ELEMENT.equals(child.getName()) && buildSystemId.equals(child.getAttribute(ID))) {
                cfgEl = child;
                break;
            }
            ++n2;
        }
        CConfigurationDescriptionCache cache = new CConfigurationDescriptionCache(cfgEl, null);
        CSettingEntryFactory factory = new CSettingEntryFactory();
        cache.loadData(factory);
        cache.doneInitialization();
        factory.clear();
        return cache;
    }

    public ICStorageElement getPreferenceStorage(String prefKey, String storageId, boolean createIfNotDound, boolean readOnly) throws CoreException {
        XmlStorage store = this.getPreferenceStore(prefKey, createIfNotDound, readOnly);
        return store.getStorage(storageId, createIfNotDound);
    }

    private XmlStorage getPreferenceStore(String prefKey, boolean createIfNotDound, boolean readOnly) throws CoreException {
        ICStorageElement el = this.createPreferenceStorage(prefKey, createIfNotDound, readOnly);
        XmlStorage store = new XmlStorage((InternalXmlStorageElement)el);
        return store;
    }

    public void savePreferenceStorage(String prefKey, String storageId, ICStorageElement el) throws CoreException {
        XmlStorage store = this.getPreferenceStore(prefKey, true, false);
        store.importStorage(storageId, el);
        InternalXmlStorageElement rootEl = new InternalXmlStorageElement(store.fElement, store.isReadOnly());
        this.serializePreference(prefKey, rootEl);
    }

    private CConfigurationDescriptionCache getLoaddedPreference(String buildSystemId) {
        return this.fPreferenceMap.get(buildSystemId);
    }

    private void setLoaddedPreference(String buildSystemId, CConfigurationDescriptionCache des) {
        this.fPreferenceMap.put(buildSystemId, des);
    }

    public CConfigBasedDescriptorManager getDescriptorManager() {
        return this.fDescriptorManager;
    }

    public CConfigurationData createDefaultConfigData(IProject project, CDataFactory factory) throws CoreException {
        return this.createDefaultConfigData(project, CDataUtil.genId(DEFAULT_CFG_ID_PREFIX), DEFAULT_CFG_NAME, factory);
    }

    public CConfigurationData createDefaultConfigData(IProject project, String id, String name, CDataFactory factory) throws CoreException {
        if (factory == null) {
            factory = new CDataFactory();
        }
        CConfigurationData data = CDataUtil.createEmptyData(id, name, factory, true);
        factory.setModified(data, false);
        return data;
    }

    public boolean isNewStyleIndexCfg(IProject project) {
        ICProjectDescription des = this.getProjectDescription(project, false);
        if (des != null) {
            return this.isNewStyleIndexCfg(des);
        }
        return false;
    }

    public boolean isNewStyleIndexCfg(ICProjectDescription des) {
        ICConfigurationDescription cfgDes = des.getDefaultSettingConfiguration();
        if (cfgDes != null) {
            return this.isNewStyleCfg(cfgDes);
        }
        return false;
    }

    @Override
    public boolean isNewStyleProject(IProject project) {
        return this.isNewStyleProject(this.getProjectDescription(project, false));
    }

    @Override
    public boolean isNewStyleProject(ICProjectDescription des) {
        if (des == null) {
            return false;
        }
        return this.isNewStyleIndexCfg(des);
    }

    public boolean isNewStyleCfg(ICConfigurationDescription cfgDes) {
        if (cfgDes == null) {
            return false;
        }
        CConfigurationData data = ((IInternalCCfgInfo)((Object)cfgDes)).getConfigurationData(false);
        if (data instanceof CConfigurationDescriptionCache) {
            data = ((CConfigurationDescriptionCache)data).getConfigurationData();
        }
        return data != null && !PathEntryConfigurationDataProvider.isPathEntryData(data);
    }

    static ICLanguageSetting getLanguageSettingForFile(ICConfigurationDescription cfgDes, IPath path, boolean ignoreExcludeStatus) {
        int segCount = path.segmentCount();
        if (segCount == 0) {
            return null;
        }
        ICResourceDescription rcDes = cfgDes.getResourceDescription(path, false);
        if (rcDes == null || !ignoreExcludeStatus && rcDes.isExcluded()) {
            return null;
        }
        if (rcDes.getType() == 4) {
            return ((ICFolderDescription)rcDes).getLanguageSettingForFile(path.lastSegment());
        }
        return ((ICFileDescription)rcDes).getLanguageSetting();
    }

    private static HashMap<HashSet<String>, CLanguageData> createExtSetToLDataMap(IProject project, CLanguageData[] lDatas) {
        HashMap<HashSet<String>, CLanguageData> map = new HashMap<HashSet<String>, CLanguageData>();
        CLanguageData[] cLanguageDataArray = lDatas;
        int n = lDatas.length;
        int n2 = 0;
        while (n2 < n) {
            CLanguageData lData = cLanguageDataArray[n2];
            String[] exts = CDataUtil.getSourceExtensions(project, lData);
            HashSet<String> set = new HashSet<String>(Arrays.asList(exts));
            map.put(set, lData);
            ++n2;
        }
        return map;
    }

    static boolean removeNonCustomSettings(IProject project, CConfigurationData data) {
        PathSettingsContainer cont = CDataUtil.createRcDataHolder(data);
        PathSettingsContainer[] children = cont.getChildren(false);
        boolean modified = false;
        PathSettingsContainer[] pathSettingsContainerArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            PathSettingsContainer parent;
            PathSettingsContainer child = pathSettingsContainerArray[n2];
            CResourceData childRcData = (CResourceData)child.getValue();
            if (childRcData.getType() == 4) {
                CResourceData parentRcData = null;
                parent = child.getParentContainer();
                while ((parentRcData = (CResourceData)parent.getValue()).getType() != 4) {
                    parent = parent.getParentContainer();
                }
                if (!CProjectDescriptionManager.settingsCustomized(project, (CFolderData)parentRcData, (CFolderData)childRcData, parent.isRoot())) {
                    try {
                        data.removeResourceData(childRcData);
                        child.remove();
                        modified = true;
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
            } else {
                parent = child.getParentContainer();
                if (!CProjectDescriptionManager.settingsCustomized(project, (CResourceData)parent.getValue(), (CFileData)childRcData)) {
                    try {
                        data.removeResourceData(childRcData);
                        child.remove();
                        modified = true;
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
            }
            ++n2;
        }
        return modified;
    }

    private static boolean settingsCustomized(IProject project, CFolderData parent, CFolderData child, boolean isParentRoot) {
        if (CProjectDescriptionManager.baseSettingsCustomized(parent, child)) {
            return true;
        }
        CLanguageData[] childLDatas = child.getLanguageDatas();
        CLanguageData[] parentLDatas = parent.getLanguageDatas();
        if (!isParentRoot && childLDatas.length != parentLDatas.length) {
            return true;
        }
        HashMap<HashSet<String>, CLanguageData> parentMap = CProjectDescriptionManager.createExtSetToLDataMap(project, parentLDatas);
        HashMap<HashSet<String>, CLanguageData> childMap = CProjectDescriptionManager.createExtSetToLDataMap(project, childLDatas);
        for (Map.Entry<HashSet<String>, CLanguageData> childEntry : childMap.entrySet()) {
            CLanguageData parentLData = parentMap.get(childEntry.getKey());
            if (parentLData == null) {
                return true;
            }
            CLanguageData childLData = childEntry.getValue();
            if (CProjectDescriptionManager.langDatasEqual(parentLData, childLData)) continue;
            return true;
        }
        return false;
    }

    private static boolean settingsCustomized(IProject project, CResourceData parent, CFileData child) {
        if (CProjectDescriptionManager.baseSettingsCustomized(parent, child)) {
            return true;
        }
        CLanguageData lData = child.getLanguageData();
        if (parent.getType() == 4) {
            CFolderData foParent = (CFolderData)parent;
            IPath childPath = child.getPath();
            String fileName = childPath.lastSegment();
            if (PatternNameMap.isPatternName(fileName)) {
                return true;
            }
            CLanguageData parentLangData = CDataUtil.findLanguagDataForFile(fileName, project, foParent);
            return !CProjectDescriptionManager.langDatasEqual(lData, parentLangData);
        }
        CFileData fiParent = (CFileData)parent;
        CLanguageData parentLangData = fiParent.getLanguageData();
        return !CProjectDescriptionManager.langDatasEqual(lData, parentLangData);
    }

    static boolean langDatasEqual(CLanguageData lData1, CLanguageData lData2) {
        int[] kinds;
        if (lData1 == null) {
            return lData2 == null;
        }
        if (lData2 == null) {
            return false;
        }
        int[] nArray = kinds = KindBasedStore.getLanguageEntryKinds();
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] entries2;
            int kind = nArray[n2];
            Object[] entries1 = lData1.getEntries(kind);
            if (!Arrays.equals(entries1, entries2 = lData2.getEntries(kind))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean baseSettingsCustomized(CResourceData parent, CResourceData child) {
        return child.hasCustomSettings();
    }

    @Override
    public ICProjectDescriptionWorkspacePreferences getProjectDescriptionWorkspacePreferences(boolean write) {
        if (this.fPreferences == null) {
            try {
                this.fPreferences = this.loadPreferences();
            }
            catch (CoreException coreException) {}
            if (this.fPreferences == null) {
                this.fPreferences = new CProjectDescriptionWorkspacePreferences(null, null, true);
            }
        }
        CProjectDescriptionWorkspacePreferences prefs = this.fPreferences;
        if (write) {
            prefs = new CProjectDescriptionWorkspacePreferences(prefs, false);
        }
        return prefs;
    }

    @Override
    public boolean setProjectDescriptionWorkspacePreferences(ICProjectDescriptionWorkspacePreferences prefs, boolean updateProjects, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        boolean changed = false;
        ICProjectDescriptionWorkspacePreferences oldPrefs = this.getProjectDescriptionWorkspacePreferences(false);
        try {
            try {
                if (oldPrefs != prefs && prefs.getConfigurationRelations() != oldPrefs.getConfigurationRelations()) {
                    changed = true;
                }
                if (changed) {
                    if (!(prefs instanceof CProjectDescriptionWorkspacePreferences)) {
                        throw new IllegalArgumentException();
                    }
                    CProjectDescriptionWorkspacePreferences basePrefs = (CProjectDescriptionWorkspacePreferences)prefs;
                    this.fPreferences = new CProjectDescriptionWorkspacePreferences(basePrefs, null, true);
                    this.storePreferences(this.fPreferences);
                    if (updateProjects) {
                        this.updateProjectDescriptions(null, monitor);
                    }
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return changed;
    }

    private void storePreferences(CProjectDescriptionWorkspacePreferences prefs) throws CoreException {
        ICStorageElement el = this.getCProjectDescriptionPreferencesElement(true, false);
        prefs.serialize(el);
        this.saveCProjectDescriptionPreferencesElement(el);
    }

    private void saveCProjectDescriptionPreferencesElement(ICStorageElement el) throws CoreException {
        ICStorageElement cur = this.getCProjectDescriptionPreferencesElement(true, false);
        ICStorageElement parent = cur.getParent();
        parent.removeChild(cur);
        parent.importChild(el);
        this.savePreferenceStorage("preferences", MODULE_ID, parent);
    }

    private CProjectDescriptionWorkspacePreferences loadPreferences() throws CoreException {
        ICStorageElement el = this.getCProjectDescriptionPreferencesElement(false, true);
        return new CProjectDescriptionWorkspacePreferences(el, null, true);
    }

    private ICStorageElement getCProjectDescriptionPreferencesElement(boolean createIfNotFound, boolean readOnly) throws CoreException {
        ICStorageElement[] children;
        ICStorageElement el = this.getPreferenceStorage("preferences", MODULE_ID, createIfNotFound, readOnly);
        ICStorageElement[] iCStorageElementArray = children = el.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if ("preferences".equals(child.getName())) {
                return child;
            }
            ++n2;
        }
        if (createIfNotFound) {
            return el.createChild("preferences");
        }
        throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.14"));
    }

    @Override
    public void updateExternalSettingsProviders(String[] ids, IProgressMonitor monitor) {
        ExtensionContainerFactory.updateReferencedProviderIds(ids, monitor);
    }

    boolean isEmptyCreatingDescriptionAllowed() {
        return this.fAllowEmptyCreatingDescription;
    }

    void setEmptyCreatingDescriptionAllowed(boolean allow) {
        this.fAllowEmptyCreatingDescription = allow;
    }

    static class CompositeWorkspaceRunnable
    implements IWorkspaceRunnable {
        private List<IWorkspaceRunnable> fRunnables = new ArrayList<IWorkspaceRunnable>();
        private String fName;
        private boolean fStopOnErr;

        CompositeWorkspaceRunnable(String name) {
            if (name == null) {
                name = "";
            }
            this.fName = name;
        }

        public void add(IWorkspaceRunnable runnable) {
            this.fRunnables.add(runnable);
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                monitor.beginTask(this.fName, this.fRunnables.size());
                for (IWorkspaceRunnable r : this.fRunnables) {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                    try {
                        r.run((IProgressMonitor)subMonitor);
                    }
                    catch (CoreException e) {
                        if (this.fStopOnErr) {
                            throw e;
                        }
                        subMonitor.done();
                        continue;
                    }
                    catch (RuntimeException e) {
                        try {
                            if (!this.fStopOnErr) continue;
                            throw e;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            subMonitor.done();
                        }
                    }
                    subMonitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        public boolean isEmpty() {
            return this.fRunnables.isEmpty();
        }
    }

    private static class ListenerDescriptor {
        final ICProjectDescriptionListener fListener;
        final int fEventTypes;

        public ListenerDescriptor(ICProjectDescriptionListener listener, int eventTypes) {
            this.fListener = listener;
            this.fEventTypes = eventTypes;
        }

        public boolean handlesEvent(int eventType) {
            return (eventType & this.fEventTypes) != 0;
        }
    }
}

