/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.DebugCoreMessages;
import org.eclipse.cdt.debug.core.ICBreakpointListener;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.breakpointactions.BreakpointActionManager;
import org.eclipse.cdt.debug.core.command.CCommandAdapterFactory;
import org.eclipse.cdt.debug.core.disassembly.IDisassemblyContextService;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.internal.core.DebugConfiguration;
import org.eclipse.cdt.debug.internal.core.ICDebugInternalConstants;
import org.eclipse.cdt.debug.internal.core.ListenerList;
import org.eclipse.cdt.debug.internal.core.SessionManager;
import org.eclipse.cdt.debug.internal.core.disassembly.DisassemblyContextService;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CommonSourceLookupDirector;
import org.eclipse.cdt.debug.internal.core.sourcelookup.SourceUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.osgi.framework.BundleContext;

public class CDebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.core";
    public static final int INTERNAL_ERROR = 1000;
    private static CDebugCorePlugin plugin;
    private HashMap<String, DebugConfiguration> fDebugConfigurations;
    private HashSet<String> fActiveDebugConfigurations;
    private ListenerList fBreakpointListeners;
    private BreakpointActionManager breakpointActionManager;
    private DisassemblyContextService fDisassemblyContextService;
    public static final String CDEBUGGER_EXTENSION_POINT_ID = "CDebugger";
    public static final String DEBUGGER_ELEMENT = "debugger";
    public static final String BREAKPOINT_ACTION_EXTENSION_POINT_ID = "BreakpointActionType";
    public static final String ACTION_TYPE_ELEMENT = "actionType";
    public static final String BREAKPOINT_EXTENSION_EXTENSION_POINT_ID = "BreakpointExtension";
    public static final String BREAKPOINT_EXTENSION_ELEMENT = "breakpointExtension";
    private CommonSourceLookupDirector fCommonSourceLookupDirector;
    private SessionManager fSessionManager = null;

    public CDebugCorePlugin() {
        plugin = this;
    }

    public static CDebugCorePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static void log(Throwable t) {
        DebugException de;
        IStatus status;
        Throwable top = t;
        if (t instanceof DebugException && (status = (de = (DebugException)t).getStatus()).getException() != null) {
            top = status.getException();
        }
        CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, "Internal error logged from CDI Debug: ", top));
    }

    public static void log(IStatus status) {
        CDebugCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        CDebugCorePlugin.getDefault().getLog().log((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 1000, message, null));
    }

    private void initializeDebugConfiguration() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CDebugCorePlugin.getUniqueIdentifier(), CDEBUGGER_EXTENSION_POINT_ID);
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fDebugConfigurations = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            if (configurationElement.getName().equals(DEBUGGER_ELEMENT)) {
                DebugConfiguration configType = new DebugConfiguration(configurationElement);
                this.fDebugConfigurations.put(configType.getID(), configType);
            }
            ++i;
        }
    }

    private void initializeActiveDebugConfigurations() {
        this.fActiveDebugConfigurations = new HashSet(this.getDebugConfigurations().length);
        this.fActiveDebugConfigurations.addAll(this.fDebugConfigurations.keySet());
        String[] filteredTypes = CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_FILTERED_DEBUGGERS).split("\\,");
        this.fActiveDebugConfigurations.removeAll(Arrays.asList(filteredTypes));
    }

    public ICDebugConfiguration[] getDebugConfigurations() {
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        return this.fDebugConfigurations.values().toArray(new ICDebugConfiguration[this.fDebugConfigurations.size()]);
    }

    public ICDebugConfiguration[] getActiveDebugConfigurations() {
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        if (this.fActiveDebugConfigurations == null) {
            this.initializeActiveDebugConfigurations();
        }
        ArrayList<DebugConfiguration> list = new ArrayList<DebugConfiguration>(this.fActiveDebugConfigurations.size());
        for (String id : this.fActiveDebugConfigurations) {
            DebugConfiguration dc = this.fDebugConfigurations.get(id);
            if (dc == null) continue;
            list.add(dc);
        }
        return list.toArray(new ICDebugConfiguration[list.size()]);
    }

    public ICDebugConfiguration[] getDefaultActiveDebugConfigurations() {
        List<String> filtered = Arrays.asList(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultString(ICDebugConstants.PREF_FILTERED_DEBUGGERS).split("\\,"));
        HashMap<String, DebugConfiguration> all = new HashMap<String, DebugConfiguration>(this.fDebugConfigurations);
        all.keySet().removeAll(filtered);
        return all.values().toArray(new ICDebugConfiguration[all.size()]);
    }

    public void saveFilteredDebugConfigurations(ICDebugConfiguration[] configurations) {
        this.disposeActiveDebugConfigurations();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < configurations.length) {
            sb.append(configurations[i].getID()).append(',');
            ++i;
        }
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_FILTERED_DEBUGGERS, sb.toString());
        CDebugCorePlugin.getDefault().savePluginPreferences();
    }

    public void saveDefaultDebugConfiguration(String id) {
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_DEFAULT_DEBUGGER_TYPE, id != null ? id : "");
    }

    public ICDebugConfiguration getDefaultDebugConfiguration() {
        ICDebugConfiguration result = null;
        try {
            result = this.getDebugConfiguration(CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_DEFAULT_DEBUGGER_TYPE));
        }
        catch (CoreException coreException) {}
        return result;
    }

    public ICDebugConfiguration getDefaultDefaultDebugConfiguration() {
        ICDebugConfiguration result = null;
        try {
            result = this.getDebugConfiguration(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultString(ICDebugConstants.PREF_DEFAULT_DEBUGGER_TYPE));
        }
        catch (CoreException coreException) {}
        return result;
    }

    public boolean isDefaultDebugConfiguration(String id) {
        return id.compareTo(CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_DEFAULT_DEBUGGER_TYPE)) == 0;
    }

    public ICDebugConfiguration getDebugConfiguration(String id) throws CoreException {
        ICDebugConfiguration dbgCfg;
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        if ((dbgCfg = (ICDebugConfiguration)this.fDebugConfigurations.get(id)) == null) {
            Status status = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 100, DebugCoreMessages.getString("CDebugCorePlugin.0"), null);
            throw new CoreException((IStatus)status);
        }
        return dbgCfg;
    }

    protected SessionManager getSessionManager() {
        return this.fSessionManager;
    }

    protected void setSessionManager(SessionManager sm) {
        if (this.fSessionManager != null) {
            this.fSessionManager.dispose();
        }
        this.fSessionManager = sm;
    }

    public void saveCommonSourceLocations(ICSourceLocation[] locations) {
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_SOURCE_LOCATIONS, SourceUtils.getCommonSourceLocationsMemento(locations));
    }

    public ICSourceLocation[] getCommonSourceLocations() {
        return SourceUtils.getCommonSourceLocationsFromMemento(CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_SOURCE_LOCATIONS));
    }

    public void addCBreakpointListener(ICBreakpointListener listener) {
        this.fBreakpointListeners.add(listener);
    }

    public void removeCBreakpointListener(ICBreakpointListener listener) {
        this.fBreakpointListeners.remove(listener);
    }

    public Object[] getCBreakpointListeners() {
        if (this.fBreakpointListeners == null) {
            return new Object[0];
        }
        return this.fBreakpointListeners.getListeners();
    }

    private void createBreakpointListenersList() {
        this.fBreakpointListeners = new ListenerList(1);
    }

    private void disposeBreakpointListenersList() {
        this.fBreakpointListeners.removeAll();
        this.fBreakpointListeners = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeCommonSourceLookupDirector();
        this.createCommandAdapterFactory();
        this.createBreakpointListenersList();
        this.createDisassemblyContextService();
        this.setSessionManager(new SessionManager());
        this.setDefaultLaunchDelegates();
    }

    public void stop(BundleContext context) throws Exception {
        this.setSessionManager(null);
        this.disposeDisassemblyContextService();
        this.disposeBreakpointListenersList();
        this.disposeCommonSourceLookupDirector();
        this.disposeDebugConfigurations();
        super.stop(context);
    }

    private void createCommandAdapterFactory() {
        IAdapterManager manager = Platform.getAdapterManager();
        CCommandAdapterFactory actionFactory = new CCommandAdapterFactory();
        manager.registerAdapters((IAdapterFactory)actionFactory, IRestart.class);
    }

    private void initializeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector == null) {
            this.fCommonSourceLookupDirector = new CommonSourceLookupDirector();
            String newMemento = CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugInternalConstants.PREF_COMMON_SOURCE_CONTAINERS);
            if (newMemento.length() == 0) {
                this.fCommonSourceLookupDirector.initializeParticipants();
                this.convertSourceLocations(this.fCommonSourceLookupDirector);
            } else {
                try {
                    this.fCommonSourceLookupDirector.initializeFromMemento(newMemento);
                }
                catch (CoreException e) {
                    CDebugCorePlugin.log(e.getStatus());
                }
            }
        }
    }

    private void disposeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector != null) {
            this.fCommonSourceLookupDirector.dispose();
        }
    }

    public CSourceLookupDirector getCommonSourceLookupDirector() {
        return this.fCommonSourceLookupDirector;
    }

    private void convertSourceLocations(CommonSourceLookupDirector director) {
        director.setSourceContainers(SourceUtils.convertSourceLocations(this.getCommonSourceLocations()));
    }

    private void disposeActiveDebugConfigurations() {
        if (this.fActiveDebugConfigurations != null) {
            this.fActiveDebugConfigurations.clear();
            this.fActiveDebugConfigurations = null;
        }
    }

    private void disposeDebugConfigurations() {
        this.disposeActiveDebugConfigurations();
        if (this.fDebugConfigurations != null) {
            this.fDebugConfigurations.clear();
            this.fDebugConfigurations = null;
        }
    }

    public BreakpointActionManager getBreakpointActionManager() {
        if (this.breakpointActionManager == null) {
            this.breakpointActionManager = new BreakpointActionManager();
        }
        return this.breakpointActionManager;
    }

    private void createDisassemblyContextService() {
        this.fDisassemblyContextService = new DisassemblyContextService();
    }

    public IDisassemblyContextService getDisassemblyContextService() {
        return this.fDisassemblyContextService;
    }

    private void disposeDisassemblyContextService() {
        if (this.fDisassemblyContextService != null) {
            this.fDisassemblyContextService.dispose();
        }
    }

    private void setDefaultLaunchDelegates() {
        block19: {
            ILaunchConfigurationType localCfg;
            block18: {
                HashSet<String> debugSet;
                ILaunchManager launchMgr;
                block17: {
                    int n;
                    block16: {
                        launchMgr = DebugPlugin.getDefault().getLaunchManager();
                        debugSet = new HashSet<String>();
                        debugSet.add("debug");
                        localCfg = launchMgr.getLaunchConfigurationType("org.eclipse.cdt.launch.applicationLaunchType");
                        try {
                            ILaunchDelegate[] delegates;
                            if (localCfg.getPreferredDelegate(debugSet) != null) break block16;
                            ILaunchDelegate[] iLaunchDelegateArray = delegates = localCfg.getDelegates(debugSet);
                            n = delegates.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ILaunchDelegate delegate = iLaunchDelegateArray[n2];
                                if ("org.eclipse.cdt.dsf.gdb.launch.localCLaunch".equals(delegate.getId())) {
                                    localCfg.setPreferredDelegate(debugSet, delegate);
                                    break;
                                }
                                ++n2;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ILaunchConfigurationType attachCfg = launchMgr.getLaunchConfigurationType("org.eclipse.cdt.launch.attachLaunchType");
                    try {
                        ILaunchDelegate[] delegates;
                        if (attachCfg.getPreferredDelegate(debugSet) != null) break block17;
                        ILaunchDelegate[] iLaunchDelegateArray = delegates = attachCfg.getDelegates(debugSet);
                        int n3 = delegates.length;
                        n = 0;
                        while (n < n3) {
                            ILaunchDelegate delegate = iLaunchDelegateArray[n];
                            if ("org.eclipse.cdt.dsf.gdb.launch.attachCLaunch".equals(delegate.getId())) {
                                attachCfg.setPreferredDelegate(debugSet, delegate);
                                break;
                            }
                            ++n;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ILaunchConfigurationType postMortemCfg = launchMgr.getLaunchConfigurationType("org.eclipse.cdt.launch.postmortemLaunchType");
                try {
                    ILaunchDelegate[] delegates;
                    if (postMortemCfg.getPreferredDelegate(debugSet) != null) break block18;
                    ILaunchDelegate[] iLaunchDelegateArray = delegates = postMortemCfg.getDelegates(debugSet);
                    int n = delegates.length;
                    int n4 = 0;
                    while (n4 < n) {
                        ILaunchDelegate delegate = iLaunchDelegateArray[n4];
                        if ("org.eclipse.cdt.dsf.gdb.launch.coreCLaunch".equals(delegate.getId())) {
                            postMortemCfg.setPreferredDelegate(debugSet, delegate);
                            break;
                        }
                        ++n4;
                    }
                }
                catch (CoreException coreException) {}
            }
            HashSet<String> runSet = new HashSet<String>();
            runSet.add("run");
            try {
                ILaunchDelegate[] delegates;
                if (localCfg.getPreferredDelegate(runSet) != null) break block19;
                ILaunchDelegate[] iLaunchDelegateArray = delegates = localCfg.getDelegates(runSet);
                int n = delegates.length;
                int n5 = 0;
                while (n5 < n) {
                    ILaunchDelegate delegate = iLaunchDelegateArray[n5];
                    if ("org.eclipse.cdt.cdi.launch.localCLaunch".equals(delegate.getId())) {
                        localCfg.setPreferredDelegate(runSet, delegate);
                        break;
                    }
                    ++n5;
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

