/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.sourcelookup.AbsolutePathSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.ProgramRelativePathSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupParticipant;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;

public class CSourceLookupDirector
extends AbstractSourceLookupDirector {
    private static Set<String> fSupportedTypes;
    private static Object fSupportedTypesLock;

    static {
        fSupportedTypesLock = new Object();
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new CSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        this.readSupportedContainerTypes();
        return fSupportedTypes.contains(type.getId());
    }

    public boolean contains(String source) {
        ISourceContainer[] containers = this.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            if (this.contains(containers[i], source)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(ICBreakpoint breakpoint) {
        try {
            String handle = breakpoint.getSourceHandle();
            ISourceContainer[] containers = this.getSourceContainers();
            int i = 0;
            while (true) {
                if (i >= containers.length) {
                    return false;
                }
                if (this.contains(containers[i], handle)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public boolean contains(IProject project) {
        ISourceContainer[] containers = this.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            if (this.contains(containers[i], project)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contains(ISourceContainer container, IProject project) {
        if (container instanceof ProjectSourceContainer && ((ProjectSourceContainer)container).getProject().equals((Object)project)) {
            return true;
        }
        try {
            ISourceContainer[] containers = container.getSourceContainers();
            int i = 0;
            while (true) {
                if (i >= containers.length) {
                    return false;
                }
                if (this.contains(containers[i], project)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contains(ISourceContainer container, String sourceName) {
        IContainer folder;
        IPath folderPath;
        IProject project;
        IPath projPath;
        Path path = new Path(sourceName);
        if (!path.isValidPath(sourceName)) {
            return false;
        }
        if (container instanceof ProjectSourceContainer && (projPath = (project = ((ProjectSourceContainer)container).getProject()).getLocation()) != null && projPath.isPrefixOf((IPath)path)) {
            IFile file = ((ProjectSourceContainer)container).getProject().getFile(path.removeFirstSegments(projPath.segmentCount()));
            if (file == null) return false;
            if (!file.exists()) return false;
            return true;
        }
        if (container instanceof FolderSourceContainer && (folderPath = (folder = ((FolderSourceContainer)container).getContainer()).getLocation()) != null && folderPath.isPrefixOf((IPath)path)) {
            IFile file = ((FolderSourceContainer)container).getContainer().getFile(path.removeFirstSegments(folderPath.segmentCount()));
            if (file == null) return false;
            if (!file.exists()) return false;
            return true;
        }
        if (container instanceof DirectorySourceContainer) {
            File dir = ((DirectorySourceContainer)container).getDirectory();
            boolean searchSubfolders = ((DirectorySourceContainer)container).isComposite();
            Path dirPath = new Path(dir.getAbsolutePath());
            if (searchSubfolders) return dirPath.isPrefixOf((IPath)path);
            if (dirPath.segmentCount() + 1 == path.segmentCount()) {
                return dirPath.isPrefixOf((IPath)path);
            }
        }
        if (container instanceof MappingSourceContainer) {
            if (((MappingSourceContainer)container).getCompilationPath(sourceName) == null) return false;
            return true;
        }
        if (container instanceof AbsolutePathSourceContainer) {
            return ((AbsolutePathSourceContainer)container).isValidAbsoluteFilePath(sourceName);
        }
        if (container instanceof ProgramRelativePathSourceContainer) {
            try {
                Object[] elements = ((ProgramRelativePathSourceContainer)container).findSourceElements(sourceName);
                if (elements.length <= 0) return false;
                return true;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        try {
            ISourceContainer[] containers = container.getSourceContainers();
            int i = 0;
            while (true) {
                if (i >= containers.length) {
                    return false;
                }
                if (this.contains(containers[i], sourceName)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public IPath getCompilationPath(String sourceName) {
        IPath path = null;
        ISourceContainer[] containers = this.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            IPath cp = this.getCompilationPath(containers[i], sourceName);
            if (cp != null) {
                path = cp;
                break;
            }
            ++i;
        }
        return path;
    }

    private IPath getCompilationPath(ISourceContainer container, String sourceName) {
        IPath path = null;
        if (container instanceof MappingSourceContainer) {
            path = ((MappingSourceContainer)container).getCompilationPath(sourceName);
        } else {
            try {
                ISourceContainer[] containers = container.getSourceContainers();
                int i = 0;
                while (i < containers.length) {
                    path = this.getCompilationPath(containers[i], sourceName);
                    if (path == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (CoreException coreException) {}
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSupportedContainerTypes() {
        Object object = fSupportedTypesLock;
        synchronized (object) {
            if (fSupportedTypes == null) {
                fSupportedTypes = new HashSet<String>();
                String name = "org.eclipse.cdt.debug.core.supportedSourceContainerTypes";
                IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(name);
                if (extensionPoint != null) {
                    IExtension[] iExtensionArray = extensionPoint.getExtensions();
                    int n = iExtensionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                        int n3 = iConfigurationElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement configurationElements = iConfigurationElementArray[n4];
                            String id = configurationElements.getAttribute("id");
                            if (id != null) {
                                fSupportedTypes.add(id);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        }
    }
}

