/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.linux.x86.launch;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.debug.edc.launch.AbstractFinalLaunchSequence;
import org.eclipse.cdt.debug.edc.launch.ChooseProcessItem;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.linux.x86.LinuxDebugger;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IProcesses;

public class LinuxFinalLaunchSequence
extends AbstractFinalLaunchSequence {
    public LinuxFinalLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm) {
        super(executor, launch, pm, "Configuring Linux Debugger", "Aborting configuring Linux debugger");
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        boolean doAttach = false;
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("attach")) {
                doAttach = true;
            }
        }
        catch (CoreException coreException) {}
        this.steps.add(this.trackerStep);
        this.steps.add(this.initFindPeerStep);
        this.steps.add(this.initRunControlStep);
        this.steps.add(this.initRegistersServiceStep);
        this.steps.add(this.initMemoryServiceStep);
        this.steps.add(this.initProcessesServiceStep);
        this.steps.add(doAttach ? this.attachStep : this.launchStep);
        this.steps.add(this.cleanupStep);
    }

    protected ChooseProcessItem chooseProcess(ChooseProcessItem[] processes, String defaultSelection) throws CoreException {
        return LinuxDebugger.chooseProcess(processes);
    }

    protected void specifyRequiredPeer() {
        this.peerAttributes.put("DebugSupport", "GDB Remote Protocol");
    }

    public void attachProcess(EDCLaunch launch, final IProcesses tcfProcService, final RequestMonitor requestMonitor) {
        try {
            IProcessInfo[] processes = this.getProcessList();
            int numProcesses = processes.length;
            ChooseProcessItem[] items = null;
            items = new ChooseProcessItem[numProcesses];
            int i = 0;
            while (i < numProcesses) {
                items[i] = new ChooseProcessItem(Integer.toString(processes[i].getPid()), processes[i].getName());
                ++i;
            }
            ChooseProcessItem selected = this.chooseProcess(items, "");
            int selectedIndex = 0;
            selectedIndex = 0;
            while (selectedIndex < numProcesses) {
                if (selected.processID.equals(items[selectedIndex].processID)) break;
                ++selectedIndex;
            }
            final IProcessInfo proc = processes[selectedIndex];
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    tcfProcService.start(Integer.toString(proc.getPid()), proc.getName(), new String[]{""}, null, true, new IProcesses.DoneStart(){

                        public void doneStart(IToken token, Exception error, IProcesses.ProcessContext process) {
                            if (error != null) {
                                requestMonitor.setStatus((IStatus)new Status(4, LinuxDebugger.getUniqueIdentifier(), error.getLocalizedMessage(), (Throwable)error));
                            }
                            requestMonitor.done();
                        }
                    });
                }
            });
        }
        catch (CoreException e) {
            requestMonitor.setStatus((IStatus)new Status(4, LinuxDebugger.getUniqueIdentifier(), e.getMessage()));
            requestMonitor.done();
            return;
        }
    }

    private IProcessInfo[] getProcessList() {
        IProcessList processList = null;
        try {
            processList = CCorePlugin.getDefault().getProcessList();
        }
        catch (CoreException coreException) {}
        if (processList != null) {
            return processList.getProcessList();
        }
        return null;
    }
}

