/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.ui;

import org.eclipse.cdt.debug.edc.launch.ChooseProcessItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ChooseProcessDialog
extends TrayDialog {
    private static final String AUTOTEST_UID = ".uid";
    private static final int PROCESS_ID_COLUMN = 0;
    private static final int PROCESS_NAME_COLUMN = 1;
    private ChooseProcessItem[] processesOnTarget;
    private ChooseProcessItem selectedProcess;
    private String defaultProcessName;
    private Text filterText;
    private ToolBarManager clearFilterToolBar;
    private ItemFilter nameFilter = new ItemFilter();
    private TableViewer viewer;
    private int lastSortColumn = 0;
    private int sortDirection = 1;
    public static final ImageDescriptor clearImageDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.gif");

    public ChooseProcessDialog(ChooseProcessItem[] processesOnTarget, String defaultProcessName, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.processesOnTarget = processesOnTarget;
        this.defaultProcessName = defaultProcessName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Attach to Process");
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        TableColumn[] columns;
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label label = new Label(dialogArea, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText("Choose a process to attach");
        Composite filterComposite = new Composite(dialogArea, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        filterComposite.setLayout((Layout)gridLayout);
        this.filterText = new Text(filterComposite, 2436);
        this.filterText.setText("type filter text");
        this.filterText.setToolTipText("Filter the visible items by name, using prefix, ? = any character, * = any string, or camel case initials");
        GridData gd_filterText = new GridData(16384, 0x1000000, false, false);
        gd_filterText.widthHint = 200;
        this.filterText.setLayoutData((Object)gd_filterText);
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Display display = ChooseProcessDialog.this.filterText.getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!ChooseProcessDialog.this.filterText.isDisposed()) {
                            ChooseProcessDialog.this.filterText.selectAll();
                        }
                    }
                });
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseProcessDialog.this.FilterItems();
                ChooseProcessDialog.this.clearFilterToolBar.getControl().setVisible(ChooseProcessDialog.this.filterText.getText().length() > 0);
            }
        });
        this.clearFilterToolBar = new ToolBarManager(0x800100);
        this.clearFilterToolBar.createControl(filterComposite);
        Action clearTextAction = new Action("", 1){

            public void run() {
                ChooseProcessDialog.this.filterText.setText("");
                ChooseProcessDialog.this.FilterItems();
            }
        };
        clearTextAction.setToolTipText("Clear");
        clearTextAction.setImageDescriptor(clearImageDesc);
        clearTextAction.setDisabledImageDescriptor(clearImageDesc);
        this.clearFilterToolBar.add((IAction)clearTextAction);
        this.clearFilterToolBar.update(false);
        this.clearFilterToolBar.getControl().setVisible(false);
        this.viewer = new TableViewer(dialogArea, 67588);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setData(AUTOTEST_UID, (Object)"table");
        TableColumn processIdColumn = new TableColumn(table, 16384);
        processIdColumn.setText("ID");
        processIdColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseProcessDialog.this.updateSortDirection(0);
                ViewerComparator comparator = ChooseProcessDialog.this.getViewerComparator(0);
                ChooseProcessDialog.this.viewer.setComparator(comparator);
                ChooseProcessDialog.this.setColumnSorting((TableColumn)e.getSource(), ChooseProcessDialog.this.sortDirection);
            }
        });
        processIdColumn.setData(AUTOTEST_UID, (Object)"processIdColumn");
        TableColumn processNameColumn = new TableColumn(table, 16384);
        processNameColumn.setText("Name");
        processNameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseProcessDialog.this.updateSortDirection(1);
                ViewerComparator comparator = ChooseProcessDialog.this.getViewerComparator(1);
                ChooseProcessDialog.this.viewer.setComparator(comparator);
                ChooseProcessDialog.this.setColumnSorting((TableColumn)e.getSource(), ChooseProcessDialog.this.sortDirection);
            }
        });
        processNameColumn.setData(AUTOTEST_UID, (Object)"processNameColumn");
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProcessesLabelProvider());
        this.viewer.setInput((Object)this.processesOnTarget);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object object = selection.getFirstElement();
                ChooseProcessDialog.this.selectedProcess = (ChooseProcessItem)object;
                ChooseProcessDialog.this.okPressed();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Button okButton = ChooseProcessDialog.this.getButton(0);
                if (okButton != null) {
                    okButton.setEnabled(!event.getSelection().isEmpty());
                }
            }
        });
        this.setColumnSorting(processIdColumn, this.sortDirection);
        table.setHeaderVisible(true);
        TableColumn[] tableColumnArray = columns = this.viewer.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.pack();
            ++n2;
        }
        ChooseProcessItem defaultProcess = this.findProcessByName(this.defaultProcessName);
        if (defaultProcess == null) {
            defaultProcess = this.processesOnTarget[0];
        }
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)defaultProcess), true);
        return dialogArea;
    }

    private void FilterItems() {
        String pattern = this.filterText.getText();
        if (pattern.length() == 0) {
            this.viewer.removeFilter((ViewerFilter)this.nameFilter);
        } else {
            this.nameFilter.setPattern(pattern);
            if (this.viewer.getFilters().length == 0) {
                this.viewer.addFilter((ViewerFilter)this.nameFilter);
            } else {
                this.viewer.refresh();
            }
        }
    }

    private ChooseProcessItem findProcessByName(String processName) {
        ChooseProcessItem[] chooseProcessItemArray = this.processesOnTarget;
        int n = this.processesOnTarget.length;
        int n2 = 0;
        while (n2 < n) {
            ChooseProcessItem process = chooseProcessItemArray[n2];
            if (processName.startsWith(process.processName)) {
                return process;
            }
            ++n2;
        }
        return null;
    }

    protected Point getInitialSize() {
        return new Point(300, 375);
    }

    public ChooseProcessItem getSelectedProcess() {
        return this.selectedProcess;
    }

    protected ViewerComparator getViewerComparator(int column) {
        switch (column) {
            case 1: {
                return new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        String p1 = ((ChooseProcessItem)e1).processName;
                        String p2 = ((ChooseProcessItem)e2).processName;
                        if (p1 == null || p2 == null) {
                            return 0;
                        }
                        return p1.compareToIgnoreCase(p2) * ChooseProcessDialog.this.sortDirection;
                    }
                };
            }
            case 0: {
                return new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        String p1 = ((ChooseProcessItem)e1).processID;
                        String p2 = ((ChooseProcessItem)e2).processID;
                        int i1 = 0;
                        int i2 = 0;
                        try {
                            i1 = Integer.parseInt(p1);
                            i2 = Integer.parseInt(p2);
                        }
                        catch (Exception exception) {}
                        return (i1 - i2) * ChooseProcessDialog.this.sortDirection;
                    }
                };
            }
        }
        return null;
    }

    protected void okPressed() {
        StructuredSelection selectedItems = (StructuredSelection)this.viewer.getSelection();
        Object object = selectedItems.getFirstElement();
        this.selectedProcess = (ChooseProcessItem)object;
        super.okPressed();
    }

    protected void setColumnSorting(TableColumn column, int order) {
        Table table = this.viewer.getTable();
        table.setSortColumn(column);
        table.setSortDirection(order > 0 ? 128 : 1024);
    }

    public void setProcessesOnTarget(ChooseProcessItem[] processesOnTarget) {
        this.processesOnTarget = processesOnTarget;
    }

    protected void updateSortDirection(int column) {
        if (this.lastSortColumn == column) {
            this.sortDirection *= -1;
        } else {
            this.sortDirection = 1;
            this.lastSortColumn = column;
        }
    }

    public class ItemFilter
    extends ViewerFilter {
        private SearchPattern searchPattern = new SearchPattern();

        public ItemFilter() {
            this.searchPattern.setPattern("");
        }

        public boolean match(String str) {
            return this.searchPattern.matches(str);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.match(((ChooseProcessItem)element).processName);
        }

        public void setPattern(String pattern) {
            this.searchPattern.setPattern(pattern);
        }
    }

    private class ProcessesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProcessesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ChooseProcessItem) {
                ChooseProcessItem process = (ChooseProcessItem)element;
                if (columnIndex == 1) {
                    return process.processName;
                }
                if (columnIndex == 0) {
                    return process.processID;
                }
            }
            return null;
        }
    }
}

