/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.actions;

import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.formatter.FormatExtensionManager;
import org.eclipse.cdt.debug.edc.internal.ui.EDCDebugUI;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;

public class ToggleCustomFormattingCommandHandler
extends AbstractHandler {
    public ToggleCustomFormattingCommandHandler() {
        Command command;
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandSupport = (ICommandService)workbench.getAdapter(ICommandService.class);
        if (commandSupport != null && (command = commandSupport.getCommand("org.eclipse.cdt.debug.edc.ui.toggleCustomFormatting")) != null) {
            try {
                State state = command.getState("org.eclipse.ui.commands.toggleState");
                if (state != null) {
                    state.setValue((Object)new Boolean(FormatExtensionManager.instance().isEnabled()));
                }
            }
            catch (Exception e) {
                EDCDebugUI.getMessageLogger().logError(null, (Throwable)e);
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        boolean enabled = HandlerUtil.toggleCommandState((Command)command);
        FormatExtensionManager.instance().setEnabled(!enabled);
        IEclipsePreferences scope = new InstanceScope().getNode("org.eclipse.cdt.debug.edc");
        scope.putBoolean("variable_formats_enabled", !enabled);
        try {
            scope.flush();
        }
        catch (BackingStoreException e) {
            EDCDebugger.getMessageLogger().logError(null, (Throwable)e);
        }
        this.refreshViewer(event);
        return null;
    }

    private void refreshViewer(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractDebugView) {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            IDebugContextService debugContextService = DebugUITools.getDebugContextManager().getContextService(window);
            ISelection context = debugContextService.getActiveContext();
            if (context instanceof IStructuredSelection) {
                IVMProvider vmProvider;
                IVMAdapter adapter;
                Object viewerInput = ((IStructuredSelection)context).getFirstElement();
                IPresentationContext presentationContext = ((TreeModelViewer)((AbstractDebugView)activePart).getViewer()).getPresentationContext();
                if (viewerInput instanceof IAdaptable && presentationContext != null && (adapter = (IVMAdapter)((IAdaptable)viewerInput).getAdapter(IVMAdapter.class)) != null && (vmProvider = adapter.getVMProvider(presentationContext)) instanceof ICachingVMProvider) {
                    ((ICachingVMProvider)vmProvider).refresh();
                }
            }
        }
    }
}

