/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.launch;

import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SnapshotTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab {
    private Text albumText;
    private Button browseButton;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "snapshot_launch_configuration_dialog_main_tab");
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createAlbumGroup(comp, 1);
    }

    public String getName() {
        return "Main";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateAlbumFromConfig(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", this.albumText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected void createAlbumGroup(Composite parent, int colSpan) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        mainComp.setLayoutData((Object)gd);
        Label albumLabel = new Label(mainComp, 0);
        albumLabel.setText("Snapshot album:");
        gd = new GridData();
        gd.horizontalSpan = 3;
        albumLabel.setLayoutData((Object)gd);
        this.albumText = new Text(mainComp, 2052);
        gd = new GridData(768);
        this.albumText.setLayoutData((Object)gd);
        this.albumText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                SnapshotTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.browseButton = this.createPushButton(mainComp, "Browse...", null);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SnapshotTab.this.handleBrowseButtonSelected();
                SnapshotTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void handleBrowseButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.albumText.getText());
        String newAlbum = fileDialog.open();
        this.albumText.setText(newAlbum);
    }

    protected void updateAlbumFromConfig(ILaunchConfiguration config) {
        try {
            String albumName = config.getAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", "");
            this.albumText.setText(albumName);
        }
        catch (CoreException ce) {
            EDCDebugger.getMessageLogger().logError("Can't update launch configuration", (Throwable)ce);
        }
    }
}

