/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui;

import java.text.MessageFormat;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.formatter.FormatExtensionManager;
import org.eclipse.cdt.debug.edc.internal.ui.AbstractEDCDetailPane;
import org.eclipse.cdt.debug.edc.internal.ui.EDCDetailPaneFactory;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;

public class CustomFormatDetailPane
extends AbstractEDCDetailPane {
    public static final String ID = "CustomFormatDetailPane";
    public static final String DESCRIPTION = "A detail pane to display custom formats";
    public static final String NAME = "Custom Format Details";

    public static IVariableValueConverter getCustomConverter(IEDCExpression expression) {
        IType exprType = TypeUtils.getStrippedType((IType)expression.getEvaluatedType());
        IVariableValueConverter customConverter = FormatExtensionManager.instance().getDetailValueConverter(exprType);
        return customConverter;
    }

    protected Job createDisplayDetailJob(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        return new DisplayDetailJob(selection);
    }

    protected boolean canSetValue(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        IEDCExpression expression = EDCDetailPaneFactory.getExpressionFromSelectedElement(selection.getFirstElement());
        EDCLaunch launch = EDCLaunch.getLaunchForSession((String)expression.getSessionId());
        if (launch.isSnapshotLaunch()) {
            return false;
        }
        IVariableValueConverter customConverter = CustomFormatDetailPane.getCustomConverter(expression);
        return customConverter.canEditValue();
    }

    protected Job createSetValueJob(IStructuredSelection selection, String newValue) {
        if (selection.isEmpty()) {
            return null;
        }
        return new SetValueJob(selection, newValue);
    }

    protected void createActions() {
        super.createActions();
    }

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    protected boolean isEditingEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        IEDCExpression expression = EDCDetailPaneFactory.getExpressionFromSelectedElement(selection.getFirstElement());
        if (expression == null) {
            return false;
        }
        IVariableValueConverter customConverter = CustomFormatDetailPane.getCustomConverter(expression);
        return customConverter.canEditValue();
    }

    public void display(IStructuredSelection selection) {
        if (this.currentSelection != null && this.currentSelection.equals(selection)) {
            return;
        }
        super.display(selection);
    }

    public abstract class CustomDetailJob
    extends Job {
        protected IEDCExpression expressionDMC;
        protected IVariableValueConverter customConverter;

        public CustomDetailJob(String name) {
            super(name);
        }

        protected void setExpressionDMC(IEDCExpression expressionDMC) {
            this.expressionDMC = expressionDMC;
        }

        protected void setCustomConverter(IVariableValueConverter customConverter) {
            this.customConverter = customConverter;
        }
    }

    public class DisplayDetailJob
    extends CustomDetailJob {
        public DisplayDetailJob(IStructuredSelection selection) {
            super("compute variable details");
            this.setExpressionDMC(EDCDetailPaneFactory.getExpressionFromSelectedElement(selection.getFirstElement()));
            this.setCustomConverter(CustomFormatDetailPane.getCustomConverter(this.expressionDMC));
        }

        protected IStatus run(IProgressMonitor monitor) {
            String text;
            GetCustomValueQuery customValueQuery = new GetCustomValueQuery();
            try {
                this.expressionDMC.getExecutor().execute((Runnable)((Object)customValueQuery));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                return Status.CANCEL_STATUS;
            }
            try {
                text = (String)customValueQuery.get();
            }
            catch (Throwable e) {
                text = MessageFormat.format("Could not get custom value: {0}", e.getMessage());
            }
            final String _text = text;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ((DisplayDetailJob)DisplayDetailJob.this).CustomFormatDetailPane.this.document.set(_text == null ? "" : _text);
                }
            });
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void canceling() {
            super.canceling();
            DisplayDetailJob displayDetailJob = this;
            synchronized (displayDetailJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class GetCustomValueQuery
        extends Query<String> {
            private GetCustomValueQuery() {
            }

            protected void execute(DataRequestMonitor<String> rm) {
                try {
                    try {
                        rm.setData((Object)DisplayDetailJob.this.customConverter.getValue((IExpressions.IExpressionDMContext)DisplayDetailJob.this.expressionDMC));
                    }
                    catch (Throwable t) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc.ui", t.getMessage()));
                        rm.done();
                    }
                }
                finally {
                    rm.done();
                }
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                DisplayDetailJob.this.cancel();
                return super.cancel(mayInterruptIfRunning);
            }
        }
    }

    public class SetValueJob
    extends CustomDetailJob {
        private final String newValue;

        public SetValueJob(IStructuredSelection selection, String newValue) {
            super("set variable value");
            this.setExpressionDMC(EDCDetailPaneFactory.getExpressionFromSelectedElement(selection.getFirstElement()));
            this.setCustomConverter(CustomFormatDetailPane.getCustomConverter(this.expressionDMC));
            this.newValue = newValue;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SetCustomValueQuery setValueQuery = new SetCustomValueQuery();
            this.expressionDMC.getExecutor().execute((Runnable)((Object)setValueQuery));
            try {
                setValueQuery.get();
            }
            catch (Throwable e) {
                return new Status(4, "org.eclipse.cdt.debug.edc.ui", MessageFormat.format("Could not set custom value: {0}", e.getMessage()));
            }
            return Status.OK_STATUS;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SetCustomValueQuery
        extends Query<Object> {
            private SetCustomValueQuery() {
            }

            protected void execute(DataRequestMonitor<Object> rm) {
                try {
                    try {
                        SetValueJob.this.customConverter.setValue((IExpressions.IExpressionDMContext)SetValueJob.this.expressionDMC, SetValueJob.this.newValue);
                    }
                    catch (Throwable t) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc.ui", t.getMessage()));
                        rm.done();
                    }
                }
                finally {
                    rm.done();
                }
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                SetValueJob.this.cancel();
                return super.cancel(mayInterruptIfRunning);
            }
        }
    }
}

