/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.actions;

import java.util.HashSet;
import org.eclipse.cdt.debug.edc.internal.ui.actions.AbstractEDCCommandHandler;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public abstract class AbstractSnapshotCommandHandler
extends AbstractEDCCommandHandler {
    public void debugContextChanged(DebugContextEvent event) {
        super.debugContextChanged(event);
        if (this.isEnabled()) {
            if (this.isSnapshotSession()) {
                this.removePlatformDebugUI();
            } else {
                this.restorePlatformDebugUI();
            }
        } else {
            this.restorePlatformDebugUI();
        }
    }

    private void removePlatformDebugUI() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
                IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
                HashSet enabledActivityIds = new HashSet(activityManager.getEnabledActivityIds());
                if (enabledActivityIds.remove("org.eclipse.cdt.debug.edc.ui.platformDebugActivity")) {
                    workbenchActivitySupport.setEnabledActivityIds(enabledActivityIds);
                }
            }
        });
    }

    private void restorePlatformDebugUI() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
                IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
                HashSet<String> enabledActivityIds = new HashSet<String>(activityManager.getEnabledActivityIds());
                if (enabledActivityIds.add("org.eclipse.cdt.debug.edc.ui.platformDebugActivity")) {
                    workbenchActivitySupport.setEnabledActivityIds(enabledActivityIds);
                }
            }
        });
    }
}

