/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.launch;

import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDebuggerTab
extends AbstractLaunchConfigurationTab {
    protected boolean fIsInitializing;
    protected Button fStopInMain;
    protected Text fStopInMainSymbol;
    protected boolean fAttachMode = false;

    public AbstractDebuggerTab(boolean attach) {
        this.fAttachMode = attach;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpID());
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createOptionsComposite(comp);
    }

    protected void update() {
        if (!this.isInitializing()) {
            super.updateLaunchConfigurationDialog();
        }
    }

    protected void createOptionsComposite(Composite parent) {
        Composite optionsComp = new Composite(parent, 0);
        int numberOfColumns = this.fAttachMode ? 1 : 3;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        optionsComp.setLayout((Layout)layout);
        optionsComp.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        if (!this.fAttachMode) {
            this.fStopInMain = this.createCheckButton(optionsComp, "Stop on startup at: ");
            this.fStopInMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractDebuggerTab.this.fStopInMainSymbol.setEnabled(AbstractDebuggerTab.this.fStopInMain.getSelection());
                    AbstractDebuggerTab.this.update();
                }
            });
            this.fStopInMainSymbol = new Text(optionsComp, 2052);
            GridData gridData = new GridData(4, 2, false, false);
            gridData.widthHint = 100;
            this.fStopInMainSymbol.setLayoutData((Object)gridData);
            this.fStopInMainSymbol.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent evt) {
                    AbstractDebuggerTab.this.update();
                }
            });
        }
    }

    public String getName() {
        return "Debugger";
    }

    public String getId() {
        return this.getTabID();
    }

    public Image getImage() {
        return LaunchImages.get((String)LaunchImages.IMG_VIEW_DEBUGGER_TAB);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setInitializing(true);
        try {
            if (!this.fAttachMode) {
                this.fStopInMain.setSelection(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true));
                this.fStopInMainSymbol.setText(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main"));
                this.fStopInMainSymbol.setEnabled(this.fStopInMain.getSelection());
            }
        }
        catch (CoreException coreException) {}
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (!this.fAttachMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", this.fStopInMain.getSelection());
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", this.fStopInMainSymbol.getText());
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        if (this.fAttachMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
        } else {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
        }
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    protected void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (this.fStopInMain != null && this.fStopInMainSymbol != null) {
            String mainSymbol = this.fStopInMainSymbol.getText().trim();
            if (this.fStopInMain.getSelection() && mainSymbol.length() == 0) {
                this.setErrorMessage("The \"Stop on startup at\" field can not be empty.");
                return false;
            }
        }
        return super.isValid(config);
    }

    protected abstract String getTabID();

    protected abstract String getHelpID();
}

