/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.ui.console;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.edc.ui.console.ConsoleLogManager;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.MessageConsole;

public abstract class AbstractLoggingConsoleFactory
implements IConsoleFactory {
    private static Map<String, IChannel> channelMappings = new HashMap<String, IChannel>();

    protected abstract String getConsoleType();

    protected abstract String getLogId();

    protected abstract String getConsoleTitle();

    public static void setChannel(String consoleType, String logId, IChannel channel) {
        channelMappings.put(AbstractLoggingConsoleFactory.createKey(consoleType, logId), channel);
    }

    public static void openConsole(String consoleType, String consoleTitle, String logId, IChannel channel, boolean clearConsole) {
        MessageConsole console;
        if (channel != null) {
            AbstractLoggingConsoleFactory.setChannel(consoleType, logId, channel);
        }
        ConsoleLogManager manager = null;
        if (channel != null && (manager = ConsoleLogManager.findExisting(consoleType, logId, channel)) == null) {
            manager = ConsoleLogManager.create(consoleType, logId, channel);
        }
        if ((console = AbstractLoggingConsoleFactory.findConsole(consoleType)) == null) {
            console = new MessageConsole(consoleTitle, consoleType, null, true);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        } else if (manager != null) {
            if (clearConsole) {
                console.clearConsole();
            }
            manager.addConsole(console);
        }
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
    }

    public void openConsole() {
        AbstractLoggingConsoleFactory.openConsole(this.getConsoleType(), this.getConsoleTitle(), this.getLogId(), AbstractLoggingConsoleFactory.getChannel(this.createKey()), false);
    }

    private String createKey() {
        return AbstractLoggingConsoleFactory.createKey(this.getConsoleType(), this.getLogId());
    }

    private static String createKey(String consoleType, String logId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(consoleType);
        stringBuilder.append("|");
        stringBuilder.append(logId);
        return stringBuilder.toString();
    }

    private static IChannel getChannel(String key) {
        return channelMappings.get(key);
    }

    private static MessageConsole findConsole(String consoleType) {
        IConsole[] consoles;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole c = iConsoleArray[n2];
            if (consoleType.equals(c.getType())) {
                return (MessageConsole)c;
            }
            ++n2;
        }
        return null;
    }
}

