/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.x86;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.Registers;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.service.DsfSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X86Registers
extends Registers {
    public static final int EBX = 3;
    public static final int ESP = 4;
    public static final int EBP = 5;
    public static final int ESI = 6;
    public static final int EDI = 7;
    public static String[] generalRegisterNames = new String[]{"EAX", "ECX", "EDX", "EBX", "ESP", "EBP", "ESI", "EDI", "GS", "FS", "ES", "DS", "EIP", "CS", "EFL", "SS"};
    public static String[] generalRegisterDescriptions = new String[]{"EAX", "ECX", "EDX", "EBX", "ESP", "EBP", "ESI", "EDI", "GS", "FS", "ES", "DS", "EIP", "CS", "EFL", "SS"};

    public X86Registers(DsfSession session) {
        super(session, new String[]{IRegisters.class.getName(), Registers.class.getName(), X86Registers.class.getName()});
    }

    protected List<Registers.RegisterGroupDMC> createGroupsForContext(IEDCExecutionDMC ctx) {
        List<Registers.RegisterGroupDMC> groups = super.createGroupsForContext(ctx);
        if (groups.size() > 0) {
            return groups;
        }
        groups = Collections.synchronizedList(new ArrayList());
        if (ctx instanceof IProcesses.IThreadDMContext) {
            groups.add(new Registers.RegisterGroupDMC((Registers)this, (Registers)this, ctx, "General", "General x86 Registers", "GPX"));
        }
        return groups;
    }

    protected List<Registers.RegisterDMC> createRegistersForGroup(Registers.RegisterGroupDMC registerGroupDMC) {
        ArrayList<Registers.RegisterDMC> registers = super.createRegistersForGroup(registerGroupDMC);
        if (registers.size() > 0) {
            return registers;
        }
        registers = new ArrayList<Registers.RegisterDMC>();
        String groupID = registerGroupDMC.getID();
        if (groupID.equals("GPX")) {
            int i = 0;
            while (i < generalRegisterNames.length) {
                registers.add(new Registers.RegisterDMC((Registers)this, registerGroupDMC.getExecutionDMC(), generalRegisterNames[i], generalRegisterDescriptions[i], generalRegisterNames[i]));
                ++i;
            }
        }
        return registers;
    }

    public String getRegisterNameFromCommonID(int id) {
        if (id < generalRegisterNames.length) {
            return generalRegisterNames[id];
        }
        return null;
    }
}

