/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.x86.disassembler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.IJumpToAddress;
import org.eclipse.cdt.debug.edc.JumpToAddress;
import org.eclipse.cdt.debug.edc.disassembler.DisassembledInstruction;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembledInstruction;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.x86.disassembler.AssemblyFormatterX86;
import org.eclipse.cdt.debug.edc.x86.disassembler.OpcodeX86;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionParserX86 {
    public static final int ADDRESS_MODE_16BIT = 1;
    public static final int ADDRESS_MODE_32BIT = 2;
    public static final int ADDRESS_MODE_64BIT = 4;
    private final List<Integer> prefixes = new ArrayList<Integer>();
    private final List<Integer> prefixesUsed = new ArrayList<Integer>();
    private final List<Byte> opcode = new ArrayList<Byte>();
    private ModRM modRM;
    private SIB sib;
    private String[] operandStrings;
    private int addressMode = 2;
    private Map<String, Object> disassemblerOptions = null;
    private final IAddress address;
    private final ByteBuffer codeBuffer;
    private final int startPosition;
    private DisassembledInstruction result = null;
    private boolean parsed = false;
    private boolean indirectAddressing;
    private boolean isMemoryOperand;
    private int operandSize;
    private String nameSizeSuffix;
    private boolean honorSrcSize;
    private IAddress jumpToAddr;

    public InstructionParserX86(IAddress addr, ByteBuffer codeBuffer) {
        this.address = addr;
        this.codeBuffer = codeBuffer;
        this.startPosition = codeBuffer.position();
    }

    private void initialize() {
        this.codeBuffer.position(this.startPosition);
        this.prefixes.clear();
        this.prefixesUsed.clear();
        this.opcode.clear();
        this.nameSizeSuffix = null;
        this.honorSrcSize = false;
        this.modRM = null;
        this.sib = null;
        this.operandStrings = null;
        this.jumpToAddr = null;
        this.result = new DisassembledInstruction();
    }

    public IDisassembledInstruction getResult() throws CoreException {
        if (!this.parsed) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("AddressMode", 2);
            this.disassemble(options);
        }
        return this.result;
    }

    public DisassembledInstruction disassemble(Map<String, Object> options) throws CoreException {
        Object mode;
        this.initialize();
        this.parsed = true;
        this.disassemblerOptions = options;
        if (this.codeBuffer.order() == ByteOrder.BIG_ENDIAN) {
            this.codeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        if ((mode = options.get("AddressMode")) != null) {
            this.addressMode = (Integer)mode;
        }
        String mnemonics = null;
        CoreException err = null;
        try {
            this.getPrefix();
            byte b1 = this.codeBuffer.get();
            this.opcode.add(b1);
            if (b1 == 15) {
                byte b2 = this.codeBuffer.get();
                this.opcode.add(b2);
                if (b2 == 56 || b2 == 58) {
                    byte b3 = this.codeBuffer.get();
                    this.opcode.add(b3);
                    mnemonics = this.parseOpcode(3, b3);
                } else {
                    mnemonics = this.parseOpcode(2, b2);
                }
            } else {
                mnemonics = this.parseOpcode(1, b1);
            }
        }
        catch (BufferUnderflowException e) {
            err = EDCDebugger.newCoreException((String)"Error: end of code buffer reached.", (Throwable)e);
        }
        catch (CoreException e) {
            err = e;
        }
        int instSize = this.codeBuffer.position() - this.startPosition;
        this.result.setSize(instSize);
        StringBuffer asmOutput = new StringBuffer();
        if (this.checkBooleanOption("ShowAddresses") || err != null) {
            asmOutput.append(AssemblyFormatterX86.formatForAddressColumn((IAddress)this.address));
        }
        if (this.checkBooleanOption("ShowBytes") || err != null) {
            int currPos = this.codeBuffer.position();
            asmOutput.append(AssemblyFormatterX86.formatForByteColumn((ByteBuffer)this.codeBuffer, (int)this.startPosition, (int)instSize));
            this.codeBuffer.position(currPos);
        }
        if (err != null) {
            String msg = "Fail to disassemble this instruction (address + code-bytes): " + asmOutput.toString();
            msg = String.valueOf(msg) + "\nCause: " + err.getMessage();
            throw EDCDebugger.newCoreException((String)msg);
        }
        this.result.setAddress(this.address);
        this.fillInJumpToAddres();
        asmOutput.append(mnemonics);
        this.result.setMnemonics(asmOutput.toString());
        return this.result;
    }

    private void fillInJumpToAddres() {
        boolean isSoleDestination = false;
        boolean isSubroutineAddress = false;
        String addrExpression = null;
        JumpToAddress jta = null;
        if (this.isConditonalJump(this.opcode)) {
            assert (this.jumpToAddr != null);
            isSoleDestination = false;
        } else if (this.isAbsoluteJump(this.opcode)) {
            isSoleDestination = true;
            addrExpression = this.operandStrings[0];
        } else if (this.isCall(this.opcode)) {
            isSoleDestination = true;
            isSubroutineAddress = true;
            addrExpression = this.operandStrings[0];
        } else if (this.isNearReturn(this.opcode)) {
            isSoleDestination = true;
            isSubroutineAddress = false;
            addrExpression = "ret-near";
        } else if (this.isFarReturn(this.opcode)) {
            isSoleDestination = true;
            isSubroutineAddress = false;
            addrExpression = "ret-far";
        } else if (this.isLoop(this.opcode)) {
            isSoleDestination = false;
            isSubroutineAddress = false;
            assert (this.jumpToAddr != null);
        } else {
            return;
        }
        if (this.jumpToAddr != null) {
            jta = new JumpToAddress(this.jumpToAddr, isSoleDestination, isSubroutineAddress);
        } else {
            assert (addrExpression != null);
            jta = new JumpToAddress(addrExpression, isSoleDestination, isSubroutineAddress);
        }
        this.result.setJumpToAddress((IJumpToAddress)jta);
    }

    private boolean isLoop(List<Byte> opcode) {
        int code;
        return opcode.size() == 1 && (code = opcode.get(0) & 0xFF) >= 224 && code <= 226;
    }

    private boolean isNearReturn(List<Byte> opcode) {
        int code;
        return opcode.size() == 1 && ((code = opcode.get(0) & 0xFF) == 194 || code == 195);
    }

    private boolean isFarReturn(List<Byte> opcode) {
        int code;
        return opcode.size() == 1 && ((code = opcode.get(0) & 0xFF) == 202 || code == 203);
    }

    private boolean isCall(List<Byte> opcode) {
        if (opcode.size() == 1) {
            int code = opcode.get(0) & 0xFF;
            if (code == 232 || code == 154) {
                return true;
            }
            if (code == 255) {
                assert (this.modRM != null);
                if (this.modRM.reg == 2 || this.modRM.reg == 3) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAbsoluteJump(List<Byte> opcode) {
        if (opcode.size() == 1) {
            int code = opcode.get(0) & 0xFF;
            if (code >= 233 && code <= 235) {
                return true;
            }
            if (code == 255) {
                assert (this.modRM != null);
                if (this.modRM.reg == 4 || this.modRM.reg == 5) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isConditonalJump(List<Byte> opcode) {
        int code;
        return opcode.size() == 1 ? (code = opcode.get(0) & 0xFF) >= 112 && code <= 127 : opcode.size() == 2 && (code = opcode.get(1) & 0xFF) >= 128 && code <= 143;
    }

    private boolean checkBooleanOption(String option) {
        if (!this.disassemblerOptions.containsKey(option)) {
            return false;
        }
        Boolean value = (Boolean)this.disassemblerOptions.get(option);
        return value;
    }

    private String parseOpcode(int opcodeByteCnt, byte opcodeLastByte) throws CoreException {
        String[] operandDescs;
        OpcodeX86 opc = null;
        int opcodeID = opcodeLastByte & 0xFF;
        if (opcodeByteCnt == 1) {
            opc = this.lookupOneByteOpcode(opcodeID);
        } else if (opcodeByteCnt == 2) {
            opc = this.lookupTwoByteOpcode(opcodeID);
        } else if (opcodeByteCnt == 3) {
            opc = this.lookupThreeByteOpcode(opcodeID);
        }
        assert (opc != null);
        if (opc.needModRM() && this.modRM == null) {
            this.modRM = this.getModRM(this.codeBuffer.get());
        }
        if (opc.getName().endsWith("S")) {
            this.honorSrcSize = true;
        }
        if ((operandDescs = opc.getOperandDescriptors()) != null) {
            int opCnt = operandDescs.length;
            this.operandStrings = new String[opCnt];
            int i = 0;
            while (i < opCnt) {
                String seg;
                this.isMemoryOperand = false;
                this.operandSize = 32;
                String opr = this.parseOperand(operandDescs[i]);
                if (this.isMemoryOperand && (seg = this.getSegmentRegisterFromPrefix()) != null) {
                    opr = String.valueOf(seg) + ":" + opr;
                }
                this.operandStrings[i] = opr;
                if ((!this.honorSrcSize && i == 0 || this.honorSrcSize && i > 0) && (this.isMemoryOperand || AssemblyFormatterX86.sInstructionsSuffixFromRegisterOperand.contains(opc.getName()))) {
                    this.nameSizeSuffix = AssemblyFormatterX86.instructionNameSizeSuffix((int)this.operandSize);
                }
                ++i;
            }
        }
        ArrayList<Integer> instPrefixes = new ArrayList<Integer>(this.prefixes);
        instPrefixes.removeAll(this.prefixesUsed);
        return AssemblyFormatterX86.formatInstruction(instPrefixes, opc.getName(), this.nameSizeSuffix, this.operandStrings);
    }

    private OpcodeX86 lookupOneByteOpcode(int opcodeID) throws CoreException {
        OpcodeX86 opc;
        for (int p : this.prefixes) {
            Map<Integer, OpcodeX86> submap;
            if (!OpcodeX86.sOpcodeMap_OneByteWithPrefix.containsKey(p) || !(submap = OpcodeX86.sOpcodeMap_OneByteWithPrefix.get(p)).containsKey(opcodeID)) continue;
            this.prefixesUsed.add(p);
            OpcodeX86 opc2 = submap.get(opcodeID);
            return opc2;
        }
        if (OpcodeX86.sOpcodeMap_OneByteExtension.containsKey(opcodeID)) {
            this.modRM = this.getModRM(this.codeBuffer.get());
            OpcodeX86 opc3 = OpcodeX86.sOpcodeMap_OneByteExtension.get(opcodeID).get(this.modRM.reg);
            if (opc3 == null) {
                throw EDCDebugger.newCoreException((String)MessageFormat.format("Extension opcode \"0x{0} /{1}\" is not supported by the disassembler yet.", Integer.toHexString(opcodeID), this.modRM.reg));
            }
            return opc3;
        }
        if (opcodeID >= 216 && opcodeID <= 223) {
            opc = this.lookupEscapeOpcode(opcodeID);
            if (opc != null) {
                return opc;
            }
        } else {
            opc = OpcodeX86.sOpcodeMap_OneByte.get(opcodeID);
        }
        if (opc == null) {
            throw EDCDebugger.newCoreException((String)MessageFormat.format("Opcode \"0x{0}\" is not supported by the disassembler yet.", Integer.toHexString(opcodeID)));
        }
        return opc;
    }

    private OpcodeX86 lookupEscapeOpcode(int opcodeID) throws CoreException {
        int key;
        int modRMByte;
        OpcodeX86 opc = null;
        if (opcodeID < 216 || opcodeID > 223) {
            return null;
        }
        if (this.modRM == null) {
            this.modRM = this.getModRM(this.codeBuffer.get());
        }
        int index = (modRMByte = this.modRM.mod << 6 | this.modRM.reg << 3 | this.modRM.rm) <= 191 ? 0 : 1;
        int n = key = modRMByte <= 191 ? this.modRM.reg : modRMByte;
        if (!OpcodeX86.sOpcodeMap_Escape.containsKey(opcodeID)) {
            return null;
        }
        Map<Integer, OpcodeX86> subMap = OpcodeX86.sOpcodeMap_Escape.get(opcodeID).get(index);
        opc = subMap.get(key);
        if (opc == null) {
            throw EDCDebugger.newCoreException((String)MessageFormat.format("Escape Opcode \"0x{0}\" with ModRM \"{1}\" is not supported by the disassembler yet.", Integer.toHexString(opcodeID), Integer.toHexString(modRMByte)));
        }
        return opc;
    }

    private OpcodeX86 lookupTwoByteOpcode(int opcodeID) throws CoreException {
        for (int p : this.prefixes) {
            Map<Integer, OpcodeX86> submap;
            if (!OpcodeX86.sOpcodeMap_TwoByteWithPrefix.containsKey(p) || !(submap = OpcodeX86.sOpcodeMap_TwoByteWithPrefix.get(p)).containsKey(opcodeID)) continue;
            this.prefixesUsed.add(p);
            OpcodeX86 opc = submap.get(opcodeID);
            return opc;
        }
        int keyToExtensionMap = opcodeID << 4;
        if (OpcodeX86.sOpcodeMap_TwoByteExtension.containsKey(keyToExtensionMap)) {
            this.modRM = this.getModRM(this.codeBuffer.get());
            OpcodeX86 opc = OpcodeX86.sOpcodeMap_TwoByteExtension.get(keyToExtensionMap |= this.modRM.mod).get(this.modRM.reg);
            if (opc == OpcodeX86.sVaringOpcode) {
                opc = OpcodeX86.selectExtensionOpcodeByRM(opcodeID, this.modRM);
            }
            if (opc == null) {
                throw EDCDebugger.newCoreException((String)MessageFormat.format("Extension opcode \"{0} {1} /{2}\" is not supported by the disassembler yet.", Integer.toHexString(this.opcode.get(0).byteValue()), Integer.toHexString(opcodeID), this.modRM.reg));
            }
            return opc;
        }
        OpcodeX86 opc = OpcodeX86.sOpcodeMap_TwoByte.get(opcodeID);
        if (opc == null) {
            throw EDCDebugger.newCoreException((String)MessageFormat.format("Two-byte opcode \"{0} {1}\" is not supported by the disassembler yet.", AssemblyFormatterX86.toHexString((byte)this.opcode.get(0), (boolean)false), AssemblyFormatterX86.toHexString((int)opcodeID, (boolean)false)));
        }
        return opc;
    }

    private OpcodeX86 lookupThreeByteOpcode(int opcodeID) throws CoreException {
        OpcodeX86 opc;
        for (int p : this.prefixes) {
            Map<Integer, OpcodeX86> submap;
            if (!OpcodeX86.sOpcodeMap_ThreeByteWithPrefix.containsKey(p) || !(submap = OpcodeX86.sOpcodeMap_ThreeByteWithPrefix.get(p)).containsKey(opcodeID)) continue;
            this.prefixesUsed.add(p);
            OpcodeX86 opc2 = submap.get(opcodeID);
            return opc2;
        }
        if (this.opcode.get(1) == 56) {
            opc = OpcodeX86.sOpcodeMap_ThreeByte_0F38.get(opcodeID);
        } else {
            assert (this.opcode.get(1) == 58) : "Invalid three byte opcode.";
            opc = OpcodeX86.sOpcodeMap_ThreeByte_0F3A.get(opcodeID);
        }
        if (opc == null) {
            throw EDCDebugger.newCoreException((String)MessageFormat.format("Three-byte opcode \"{0} {1}\" is not supported by the disassembler yet.", AssemblyFormatterX86.toHexString((byte)this.opcode.get(0), (boolean)false), AssemblyFormatterX86.toHexString((byte)this.opcode.get(1), (boolean)false), AssemblyFormatterX86.toHexString((int)opcodeID, (boolean)false)));
        }
        return opc;
    }

    private ModRM getModRM(byte b) {
        ModRM ret = new ModRM();
        ret.mod = b >> 6 & 3;
        ret.reg = b >> 3 & 7;
        ret.rm = b & 7;
        return ret;
    }

    private SIB getSIB(byte b) {
        SIB ret = new SIB();
        ret.scale = b >> 6 & 3;
        ret.index = b >> 3 & 7;
        ret.base = b & 7;
        return ret;
    }

    private String parseOperand(String operandDescriptor) throws CoreException {
        this.indirectAddressing = false;
        String ret = null;
        if (operandDescriptor.charAt(0) == '*') {
            this.indirectAddressing = true;
            operandDescriptor = operandDescriptor.substring(1);
        }
        if (this.isRegisterID(operandDescriptor)) {
            String reg = new String(operandDescriptor);
            if (this.addressMode == 2) {
                if (this.prefixes.contains(102)) {
                    this.prefixesUsed.add(102);
                    if (reg.length() == 3) {
                        reg = reg.substring(1);
                    }
                } else {
                    reg = reg.replace('r', 'e');
                }
            }
            ret = AssemblyFormatterX86.formatRegister((String)reg.toLowerCase(), (boolean)this.indirectAddressing);
        } else {
            char addressingMethod = operandDescriptor.charAt(0);
            assert (Character.isUpperCase(addressingMethod));
            char[] operandType = operandDescriptor.substring(1).toCharArray();
            ret = this.addressOperand(addressingMethod, operandType);
        }
        return ret;
    }

    private String addressOperand(char addressingMethod, char[] operandType) throws CoreException {
        String methodName = "addressing_" + addressingMethod;
        Method handler = null;
        try {
            handler = this.getClass().getMethod(methodName, char[].class);
        }
        catch (SecurityException e) {
            EDCDebugger.getMessageLogger().logError(null, (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw EDCDebugger.newCoreException((String)MessageFormat.format("Addressing method \"{0}\" is not supported yet.", Character.valueOf(addressingMethod)));
        }
        try {
            String op = (String)handler.invoke((Object)this, new Object[]{operandType});
            return op;
        }
        catch (IllegalArgumentException e) {
            EDCDebugger.getMessageLogger().logError(null, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            EDCDebugger.getMessageLogger().logError(null, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            cause.printStackTrace();
            if (cause instanceof BufferUnderflowException) {
                throw EDCDebugger.newCoreException((String)"End of code buffer reached.", (Throwable)((Exception)cause));
            }
            if (cause instanceof CoreException) {
                throw (CoreException)cause;
            }
            String ex = cause.getMessage() != null ? cause.getMessage() : cause.getClass().getName();
            throw EDCDebugger.newCoreException((String)("Exception or error: " + ex));
        }
        return null;
    }

    public String addressing_A(char[] operandType) throws CoreException {
        String operand = null;
        switch (operandType[0]) {
            case 'p': {
                int offset = this.addressMode == 1 ? this.codeBuffer.getShort() : this.codeBuffer.getInt();
                short seg = this.codeBuffer.getShort();
                operand = AssemblyFormatterX86.formatFarPointer((short)seg, (int)offset);
                break;
            }
            default: {
                throw EDCDebugger.newCoreException((String)MessageFormat.format("Operand descriptor \"{0}{1}{2}\" is not supported yet.", Character.valueOf('A'), Character.valueOf(operandType[0]), operandType.length > 1 ? Character.valueOf(operandType[1]) : ""));
            }
        }
        return operand;
    }

    public String addressing_C(char[] operandType) throws CoreException {
        return this.registerFromModRM_Reg('C', operandType);
    }

    public String addressing_D(char[] operandType) throws CoreException {
        return this.registerFromModRM_Reg('D', operandType);
    }

    public String addressing_E(char[] operandType) throws CoreException {
        if (this.modRM == null) {
            throw EDCDebugger.newCoreException((String)"ModRM required but not available.");
        }
        if (this.modRM.mod == 3) {
            return this.registerFromModRM_RM('E', operandType);
        }
        this.isMemoryOperand = true;
        return this.memoryFromModRM('E', operandType);
    }

    public String addressing_G(char[] operandType) throws CoreException {
        return this.registerFromModRM_Reg('G', operandType);
    }

    public String addressing_I(char[] operandType) throws CoreException {
        int imm;
        switch (operandType[0]) {
            case 'b': {
                imm = this.codeBuffer.get();
                break;
            }
            case 'w': {
                imm = this.codeBuffer.getShort();
                break;
            }
            case 'v': 
            case 'z': {
                if (this.addressMode == 1) {
                    imm = this.codeBuffer.getShort();
                    break;
                }
                if (this.prefixes.contains(102)) {
                    this.prefixesUsed.add(102);
                    imm = this.codeBuffer.getShort();
                    break;
                }
                imm = this.codeBuffer.getInt();
                break;
            }
            default: {
                throw EDCDebugger.newCoreException((String)MessageFormat.format("Operand descriptor \"{0}{1}{2}\" is not supported yet.", Character.valueOf('I'), Character.valueOf(operandType[0]), operandType.length > 1 ? Character.valueOf(operandType[1]) : ""));
            }
        }
        return AssemblyFormatterX86.formatImmediate((int)imm);
    }

    public String addressing_J(char[] operandType) throws CoreException {
        switch (operandType[0]) {
            case 'b': {
                int offset = this.codeBuffer.get();
                break;
            }
            case 'z': {
                int offset;
                if (this.addressMode == 1) {
                    offset = this.codeBuffer.getShort();
                    break;
                }
                offset = this.codeBuffer.getInt();
                break;
            }
            default: {
                throw EDCDebugger.newCoreException((String)MessageFormat.format("Operand descriptor \"{0}{1}{2}\" is not supported yet.", Character.valueOf('J'), Character.valueOf(operandType[0]), operandType.length > 1 ? Character.valueOf(operandType[1]) : ""));
            }
        }
        this.jumpToAddr = this.address.add((long)(offset += this.codeBuffer.position() - this.startPosition));
        this.isMemoryOperand = true;
        return AssemblyFormatterX86.formatForCode((IAddress)this.jumpToAddr);
    }

    public String addressing_M(char[] operandType) throws CoreException {
        assert (this.modRM != null);
        if (this.modRM.mod == 3) {
            throw EDCDebugger.newCoreException((String)("Invalid Opcode at " + this.address.toHexAddressString()));
        }
        this.isMemoryOperand = true;
        return this.memoryFromModRM('M', operandType);
    }

    public String addressing_N(char[] operandType) throws CoreException {
        return this.registerFromModRM_RM('N', operandType);
    }

    public String addressing_O(char[] operandType) throws CoreException {
        int offset = this.addressMode == 1 ? this.codeBuffer.getShort() : this.codeBuffer.getInt();
        this.isMemoryOperand = true;
        return AssemblyFormatterX86.formatOffset((int)offset);
    }

    public String addressing_R(char[] operandType) throws CoreException {
        return this.registerFromModRM_RM('R', operandType);
    }

    public String addressing_S(char[] operandType) throws CoreException {
        return this.registerFromModRM_Reg('S', operandType);
    }

    public String addressing_U(char[] operandType) throws CoreException {
        return this.registerFromModRM_RM('U', operandType);
    }

    public String addressing_V(char[] operandType) throws CoreException {
        return this.registerFromModRM_Reg('V', operandType);
    }

    public String addressing_X(char[] operandType) throws CoreException {
        switch (operandType[0]) {
            case 'b': {
                this.operandSize = 8;
                break;
            }
            case 'v': 
            case 'z': {
                this.operandSize = 32;
                if (!this.prefixes.contains(102)) break;
                this.prefixesUsed.add(102);
                this.operandSize = 16;
                break;
            }
            default: {
                throw EDCDebugger.newCoreException((String)MessageFormat.format("Operand descriptor \"{0}{1}{2}\" is not supported yet.", Character.valueOf('X'), Character.valueOf(operandType[0]), operandType.length > 1 ? Character.valueOf(operandType[1]) : ""));
            }
        }
        this.isMemoryOperand = true;
        return AssemblyFormatterX86.registerPair_DSrSI(this.addressMode);
    }

    public String addressing_Y(char[] operandType) throws CoreException {
        switch (operandType[0]) {
            case 'b': {
                this.operandSize = 8;
                break;
            }
            case 'v': 
            case 'z': {
                this.operandSize = 32;
                if (!this.prefixes.contains(102)) break;
                this.prefixesUsed.add(102);
                this.operandSize = 16;
                break;
            }
            default: {
                throw EDCDebugger.newCoreException((String)MessageFormat.format("Operand descriptor \"{0}{1}{2}\" is not supported yet.", Character.valueOf('Y'), Character.valueOf(operandType[0]), operandType.length > 1 ? Character.valueOf(operandType[1]) : ""));
            }
        }
        this.isMemoryOperand = true;
        return AssemblyFormatterX86.registerPair_ESrDI(this.addressMode);
    }

    private boolean isRegisterID(String operandDescriptor) {
        return operandDescriptor.length() > 1 && Character.isUpperCase(operandDescriptor.charAt(1));
    }

    private void getPrefix() {
        this.codeBuffer.mark();
        int b = this.codeBuffer.get() & 0xFF;
        if (b >= 64 && b <= 79) {
            if (this.addressMode == 4) {
                this.prefixes.add(b);
                this.getPrefix();
            } else {
                this.codeBuffer.reset();
            }
        } else if (OpcodeX86.sAllPrefixes.contains(b)) {
            this.prefixes.add(b);
            this.getPrefix();
        } else {
            this.codeBuffer.reset();
        }
    }

    private String memoryFromModRM(char addressingMethod, char[] operandType) throws CoreException {
        boolean useBase;
        boolean useIndex;
        if (this.modRM.rm == 4) {
            byte b = this.codeBuffer.get();
            this.sib = this.getSIB(b);
        }
        int displacement = 0;
        int baseRegID = 0;
        int indexRegID = 0;
        boolean useDisplacement = true;
        if (this.modRM.mod == 1) {
            displacement = this.codeBuffer.get();
        } else if (this.modRM.mod == 2 || this.modRM.mod == 0 && this.modRM.rm == 5 || this.modRM.mod == 0 && this.modRM.rm == 4 && this.sib.base == 5) {
            displacement = this.codeBuffer.getInt();
        } else {
            useDisplacement = false;
        }
        if (this.modRM.rm == 4) {
            useIndex = this.sib.index != 4;
            useBase = this.sib.base != 5 || this.modRM.mod != 0;
            indexRegID = this.sib.index;
            baseRegID = this.sib.base;
        } else {
            useIndex = false;
            useBase = this.modRM.rm != 5 || this.modRM.mod != 0;
            baseRegID = this.modRM.rm;
        }
        this.operandSize = 32;
        if (operandType.length > 0 && operandType[0] == 'b') {
            this.operandSize = 8;
        } else if (this.prefixes.contains(102)) {
            this.prefixesUsed.add(102);
            this.operandSize = 16;
        }
        if (!useBase) {
            baseRegID = -1;
        }
        if (!useIndex) {
            indexRegID = -1;
        }
        return AssemblyFormatterX86.format(this.indirectAddressing, useDisplacement ? Integer.valueOf(displacement) : null, baseRegID, indexRegID, this.sib != null ? this.sib.scale : 0);
    }

    private String getRegisterName(int regID, char addressingMethod, char[] operandType) throws CoreException {
        int key;
        switch (operandType[0]) {
            case 'b': {
                key = 8;
                break;
            }
            case 'w': {
                key = 16;
                break;
            }
            case 'd': {
                key = 32;
                break;
            }
            case 'q': {
                key = 64;
                break;
            }
            case 'v': 
            case 'z': {
                if (this.addressMode == 1) {
                    key = 16;
                    break;
                }
                key = 32;
                if (!this.prefixes.contains(102)) break;
                this.prefixesUsed.add(102);
                key = 16;
                break;
            }
            default: {
                throw EDCDebugger.newCoreException((String)MessageFormat.format("Operand descriptor \"{0}{1}{2}\" is not supported yet.", Character.valueOf(addressingMethod), Character.valueOf(operandType[0]), operandType.length > 1 ? Character.valueOf(operandType[1]) : ""));
            }
        }
        this.operandSize = key;
        String operand = this.indirectAddressing ? "*" : "";
        try {
            String[] names = null;
            switch (addressingMethod) {
                case 'E': 
                case 'G': 
                case 'R': {
                    names = AssemblyFormatterX86.sGPRNames.get(key);
                    break;
                }
                case 'C': {
                    names = AssemblyFormatterX86.sControlRegisterNames;
                    break;
                }
                case 'D': {
                    names = AssemblyFormatterX86.sDebugRegisterNames;
                    break;
                }
                case 'S': {
                    names = AssemblyFormatterX86.sSegmentRegisterNames;
                    break;
                }
                case 'N': 
                case 'P': {
                    throw EDCDebugger.newCoreException((String)"MMX registers are not supported by the disassembler yet.");
                }
                case 'U': 
                case 'V': {
                    throw EDCDebugger.newCoreException((String)"XMM registers are not supported by the disassembler yet.");
                }
                default: {
                    assert (false) : MessageFormat.format("unsupported addressing method \"{0}\" for getting register.", Character.valueOf(addressingMethod));
                    break;
                }
            }
            operand = String.valueOf(operand) + names[regID];
        }
        catch (Exception e) {
            e.printStackTrace();
            throw EDCDebugger.newCoreException((String)MessageFormat.format("Invalid register ID {0} in instruction.", regID));
        }
        return operand;
    }

    private String registerFromModRM_Reg(char addressingMethod, char[] operandType) throws CoreException {
        return this.getRegisterName(this.modRM.reg, addressingMethod, operandType);
    }

    private String registerFromModRM_RM(char addressingMethod, char[] operandType) throws CoreException {
        return this.getRegisterName(this.modRM.rm, addressingMethod, operandType);
    }

    private String getSegmentRegisterFromPrefix() {
        String seg = null;
        for (int p : this.prefixes) {
            if (!OpcodeX86.sPrefixesForOperand.contains(p)) continue;
            this.prefixesUsed.add(p);
            seg = AssemblyFormatterX86.formatPrefix(p);
        }
        return seg;
    }

    class ModRM {
        public int mod;
        public int reg;
        public int rm;

        ModRM() {
        }
    }

    class SIB {
        public int scale;
        public int index;
        public int base;

        SIB() {
        }
    }
}

