/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.x86.disassembler;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.IAddressExpressionEvaluator;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.IEDCMemory;
import org.eclipse.cdt.debug.edc.services.Registers;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.MemoryByte;

public class AddressExpressionEvaluatorX86
implements IAddressExpressionEvaluator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IAddress evaluate(IRunControl.IExecutionDMContext context, String expression, IRegisters regService, IMemory memService) throws CoreException {
        Addr64 ret = null;
        Addr64 memAddr = null;
        Registers edcRegService = (Registers)regService;
        if (expression.startsWith("*")) {
            String token;
            String str = expression.substring(1);
            StringTokenizer tokenizer = new StringTokenizer(str, "(,)");
            int tokenCnt = tokenizer.countTokens();
            if (tokenCnt == 1) {
                token = tokenizer.nextToken();
                if (token.startsWith("%")) {
                    String regName = token.substring(1).toUpperCase();
                    String val = edcRegService.getRegisterValue(context, regName);
                    ret = new Addr64(val, 16);
                } else {
                    memAddr = new Addr64(token.substring(2), 16);
                }
            } else {
                if (tokenCnt < 2 || tokenCnt > 4) throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", MessageFormat.format("Jump address expression {0} is invalid.", expression)));
                token = tokenizer.nextToken();
                assert (!token.startsWith("-"));
                BigInteger offset = new BigInteger(token.substring(2), 16);
                String baseReg = null;
                String indexReg = null;
                int scale = 1;
                if (tokenCnt == 2) {
                    indexReg = tokenizer.nextToken().substring(1).toUpperCase();
                    scale = 1;
                } else if (tokenCnt == 3) {
                    indexReg = tokenizer.nextToken().substring(1).toUpperCase();
                    scale = Integer.valueOf(tokenizer.nextToken());
                } else if (tokenCnt == 4) {
                    baseReg = tokenizer.nextToken().substring(1).toUpperCase();
                    indexReg = tokenizer.nextToken().substring(1).toUpperCase();
                    scale = Integer.valueOf(tokenizer.nextToken());
                }
                long base = 0L;
                long index = 0L;
                if (baseReg != null) {
                    base = Long.valueOf(edcRegService.getRegisterValue((IRunControl.IExecutionDMContext)((IEDCExecutionDMC)context), baseReg), 16);
                }
                if (indexReg != null) {
                    index = Long.valueOf(edcRegService.getRegisterValue((IRunControl.IExecutionDMContext)((IEDCExecutionDMC)context), indexReg), 16);
                }
                memAddr = new Addr64(offset).add(base + index * (long)scale);
            }
        } else if (expression.startsWith("$")) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", MessageFormat.format("Far jump address {0} is not supported yet.", expression)));
        }
        if (ret != null) return ret;
        if (memAddr == null) return ret;
        ArrayList memBuffer = new ArrayList();
        IStatus st = ((IEDCMemory)memService).getMemory((IEDCExecutionDMC)context, memAddr, memBuffer, 4, 1);
        if (!st.isOK()) {
            throw new CoreException(st);
        }
        byte[] bytes = new byte[memBuffer.size()];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = ((MemoryByte)memBuffer.get(i)).getValue();
            ++i;
        }
        return new Addr64(new BigInteger(bytes));
    }
}

