/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.x86.disassembler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.x86.disassembler.AssemblyFormatterX86;
import org.eclipse.cdt.debug.edc.x86.disassembler.InstructionParserX86;

public class OpcodeX86 {
    private String name;
    private boolean needModRM;
    private String[] operandDescriptors;
    public static final char INDIRECT_INDICATOR = '*';
    public static final String SIZE_FLAG_TARGET = "T";
    public static final String SIZE_FLAG_SOURCE = "S";
    static final int PREFIX_LOCK = 240;
    static final int PREFIX_REPNZ = 242;
    static final int PREFIX_REPZ = 243;
    static final int PREFIX_SEGOVR_CS = 46;
    static final int PREFIX_SEGOVR_SS = 54;
    static final int PREFIX_SEGOVR_DS = 62;
    static final int PREFIX_SEGOVR_ES = 38;
    static final int PREFIX_SEGOVR_FS = 100;
    static final int PREFIX_SEGOVR_GS = 101;
    static final int PREFIX_BRANCH_NOT_TAKEN = 46;
    static final int PREFIX_BRANCH_TAKEN = 62;
    static final int PREFIX_OPERAND_SIZE_OVERRIDE = 102;
    static final int PREFIX_ADDRESS_SIZE_OVERRIDE = 103;
    static List<Integer> sAllPrefixes = new ArrayList<Integer>(){
        {
            this.add(240);
            this.add(242);
            this.add(243);
            this.add(46);
            this.add(54);
            this.add(62);
            this.add(38);
            this.add(100);
            this.add(101);
            this.add(46);
            this.add(62);
            this.add(102);
            this.add(103);
        }
    };
    static List<Integer> sPrefixesForOperand = new ArrayList<Integer>(){
        {
            this.add(46);
            this.add(54);
            this.add(62);
            this.add(38);
            this.add(100);
            this.add(101);
        }
    };
    static List<Integer> sPrefixesForInstruction = new ArrayList<Integer>(){
        {
            this.add(240);
            this.add(242);
            this.add(243);
        }
    };
    static final String[] OD_AL_iDX = new String[]{"AL", "*DX"};
    static final String[] OD_AL_Ib = new String[]{"AL", "Ib"};
    static final String[] OD_AL_Ob = new String[]{"AL", "Ob"};
    static final String[] OD_AL_Xb = new String[]{"AL", "Xb"};
    static final String[] OD_AL_Yb = new String[]{"AL", "Yb"};
    static final String[] OD_Ap = new String[]{"Ap"};
    static final String[] OD_AX = new String[]{"AX"};
    static final String[] OD_Cd_Rd = new String[]{"Cd", "Rd"};
    static final String[] OD_CS = new String[]{"CS"};
    static final String[] OD_Dd_Rd = new String[]{"Dd", "Rd"};
    static final String[] OD_DS = new String[]{"DS"};
    static final String[] OD_iDX_AL = new String[]{"*DX", "AL"};
    static final String[] OD_iDX_eAX = new String[]{"*DX", "eAX"};
    static final String[] OD_iDX_Xb = new String[]{"*DX", "Xb"};
    static final String[] OD_iDX_Xz = new String[]{"*DX", "Xz"};
    static final String[] OD_iEp = new String[]{"*Ep"};
    static final String[] OD_iEv = new String[]{"*Ev"};
    static final String[] OD_Eb_CL = new String[]{"Eb", "CL"};
    static final String[] OD_Eb_Gb = new String[]{"Eb", "Gb"};
    static final String[] OD_Eb_Ib = new String[]{"Eb", "Ib"};
    static final String[] OD_Eb = new String[]{"Eb"};
    static final String[] OD_ES = new String[]{"ES"};
    static final String[] OD_Ev = new String[]{"Ev"};
    static final String[] OD_Ew = new String[]{"Ew"};
    static final String[] OD_Ev_CL = new String[]{"Ev", "CL"};
    static final String[] OD_Ev_Gv = new String[]{"Ev", "Gv"};
    static final String[] OD_Ev_Gv_Ib = new String[]{"Ev", "Gv", "Ib"};
    static final String[] OD_Ev_Gv_CL = new String[]{"Ev", "Gv", "CL"};
    static final String[] OD_Ev_Ib = new String[]{"Ev", "Ib"};
    static final String[] OD_Ev_Iz = new String[]{"Ev", "Iz"};
    static final String[] OD_Ev_Sw = new String[]{"Ev", "Sw"};
    static final String[] OD_Ew_Gw = new String[]{"Ew", "Gw"};
    static final String[] OD_eAX = new String[]{"eAX"};
    static final String[] OD_eAX_iDX = new String[]{"eAX", "*DX"};
    static final String[] OD_eAX_Ib = new String[]{"eAX", "Ib"};
    static final String[] OD_eCX = new String[]{"eCX"};
    static final String[] OD_eDX = new String[]{"eDX"};
    static final String[] OD_eBX = new String[]{"eBX"};
    static final String[] OD_eSP = new String[]{"eSP"};
    static final String[] OD_eBP = new String[]{"eBP"};
    static final String[] OD_eSI = new String[]{"eSI"};
    static final String[] OD_eDI = new String[]{"eDI"};
    static final String[] OD_FS = new String[]{"FS"};
    static final String[] OD_Gb_Eb = new String[]{"Gb", "Eb"};
    static final String[] OD_GS = new String[]{"GS"};
    static final String[] OD_Gv_Eb = new String[]{"Gv", "Eb"};
    static final String[] OD_Gv_Ev = new String[]{"Gv", "Ev"};
    static final String[] OD_Gv_Ev_Ib = new String[]{"Gv", "Ev", "Ib"};
    static final String[] OD_Gv_Ev_Iz = new String[]{"Gv", "Ev", "Iz"};
    static final String[] OD_Gv_Ew = new String[]{"Gv", "Ew"};
    static final String[] OD_Gv_M = new String[]{"Gv", "M"};
    static final String[] OD_Gv_Ma = OD_Gv_M;
    static final String[] OD_Gv_Mp = new String[]{"Gv", "Mp"};
    static final String[] OD_Gv_Mv = new String[]{"Gv", "Mv"};
    static final String[] OD_Gz_Mp = new String[]{"Gz", "Mp"};
    static final String[] OD_Ib = new String[]{"Ib"};
    static final String[] OD_Ib_AL = new String[]{"Ib", "AL"};
    static final String[] OD_Ib_eAX = new String[]{"Ib", "eAX"};
    static final String[] OD_Iw = new String[]{"Iw"};
    static final String[] OD_Iw_Ib = new String[]{"Iw", "Ib"};
    static final String[] OD_Iz = new String[]{"Iz"};
    static final String[] OD_Jb = new String[]{"Jb"};
    static final String[] OD_Jz = new String[]{"Jz"};
    static final String[] OD_Ms = new String[]{"Ms"};
    static final String[] OD_Mv_Gv = new String[]{"Mv", "Gv"};
    static final String[] OD_m14byte = new String[]{"m14byte"};
    static final String[] OD_Ob_AL = new String[]{"Ob", "AL"};
    static final String[] OD_Ov_rAX = new String[]{"Ov", "rAX"};
    static final String[] OD_Rd_Cd = new String[]{"Rd", "Cd"};
    static final String[] OD_Rd_Dd = new String[]{"Rd", "Dd"};
    static final String[] OD_RvMw = OD_Ev;
    static final String[] OD_rAX = new String[]{"rAX"};
    static final String[] OD_rAX_Iz = new String[]{"rAX", "Iz"};
    static final String[] OD_rAX_rAX = new String[]{"rAX", "rAX"};
    static final String[] OD_rAX_Ov = new String[]{"rAX", "Ov"};
    static final String[] OD_rAX_Xv = new String[]{"rAX", "Xv"};
    static final String[] OD_rCX = new String[]{"rCX"};
    static final String[] OD_rCX_rAX = new String[]{"rCX", "rAX"};
    static final String[] OD_rDX = new String[]{"rDX"};
    static final String[] OD_rBX = new String[]{"rBX"};
    static final String[] OD_rSP = new String[]{"rSP"};
    static final String[] OD_rBP = new String[]{"rBP"};
    static final String[] OD_rSI = new String[]{"rSI"};
    static final String[] OD_rDI = new String[]{"rDI"};
    static final String[] OD_rDX_rAX = new String[]{"rDX", "rAX"};
    static final String[] OD_rBX_rAX = new String[]{"rBX", "rAX"};
    static final String[] OD_rSP_rAX = new String[]{"rSP", "rAX"};
    static final String[] OD_rBP_rAX = new String[]{"rBP", "rAX"};
    static final String[] OD_rSI_rAX = new String[]{"rSI", "rAX"};
    static final String[] OD_rDI_rAX = new String[]{"rDI", "rAX"};
    static final String[] OD_ST0 = new String[]{"ST(0)"};
    static final String[] OD_ST1 = new String[]{"ST(1)"};
    static final String[] OD_ST2 = new String[]{"ST(2)"};
    static final String[] OD_ST3 = new String[]{"ST(3)"};
    static final String[] OD_ST4 = new String[]{"ST(4)"};
    static final String[] OD_ST5 = new String[]{"ST(5)"};
    static final String[] OD_ST6 = new String[]{"ST(6)"};
    static final String[] OD_ST7 = new String[]{"ST(7)"};
    static final String[] OD_ST_ST0 = new String[]{"ST", "ST(0)"};
    static final String[] OD_ST_ST1 = new String[]{"ST", "ST(1)"};
    static final String[] OD_ST_ST2 = new String[]{"ST", "ST(2)"};
    static final String[] OD_ST_ST3 = new String[]{"ST", "ST(3)"};
    static final String[] OD_ST_ST4 = new String[]{"ST", "ST(4)"};
    static final String[] OD_ST_ST5 = new String[]{"ST", "ST(5)"};
    static final String[] OD_ST_ST6 = new String[]{"ST", "ST(6)"};
    static final String[] OD_ST_ST7 = new String[]{"ST", "ST(7)"};
    static final String[] OD_ST0_ST = new String[]{"ST(0)", "ST"};
    static final String[] OD_ST1_ST = new String[]{"ST(1)", "ST"};
    static final String[] OD_ST2_ST = new String[]{"ST(2)", "ST"};
    static final String[] OD_ST3_ST = new String[]{"ST(3)", "ST"};
    static final String[] OD_ST4_ST = new String[]{"ST(4)", "ST"};
    static final String[] OD_ST5_ST = new String[]{"ST(5)", "ST"};
    static final String[] OD_ST6_ST = new String[]{"ST(6)", "ST"};
    static final String[] OD_ST7_ST = new String[]{"ST(7)", "ST"};
    static final String[] OD_SS = new String[]{"SS"};
    static final String[] OD_Sw_Ew = new String[]{"Sw", "Ew"};
    static final String[] OD_Vss_Wss = new String[]{"Vss", "Wss"};
    static final String[] OD_Wss_Vss = new String[]{"Wss", "Vss"};
    static final String[] OD_Xb_Yb = new String[]{"Xb", "Yb"};
    static final String[] OD_Xv_Yv = new String[]{"Xv", "Yv"};
    static final String[] OD_Yb_iDX = new String[]{"Yb", "*DX"};
    static final String[] OD_Yb_AL = new String[]{"Yb", "AL"};
    static final String[] OD_Yv_rAX = new String[]{"Yv", "rAX"};
    static final String[] OD_Yz_iDX = new String[]{"Yz", "*DX"};
    static final String[] OD_NO_OPERAND = null;
    public static final OpcodeX86 sInvalidOpcode = new OpcodeX86("<Invalid>", false, OD_NO_OPERAND);
    public static final OpcodeX86 sVaringOpcode = new OpcodeX86("<Varing>", false, OD_NO_OPERAND);
    public static Map<Integer, OpcodeX86> sOpcodeMap_OneByte = new HashMap<Integer, OpcodeX86>(){
        {
            this.put(0, new OpcodeX86("add", true, OD_Eb_Gb));
            this.put(1, new OpcodeX86("add", true, OD_Ev_Gv));
            this.put(2, new OpcodeX86("add", true, OD_Gb_Eb));
            this.put(3, new OpcodeX86("add", true, OD_Gv_Ev));
            this.put(4, new OpcodeX86("add", false, OD_AL_Ib));
            this.put(5, new OpcodeX86("add", false, OD_rAX_Iz));
            this.put(6, new OpcodeX86("push", false, OD_ES));
            this.put(7, new OpcodeX86("pop", false, OD_ES));
            this.put(8, new OpcodeX86("or", true, OD_Eb_Gb));
            this.put(9, new OpcodeX86("or", true, OD_Ev_Gv));
            this.put(10, new OpcodeX86("or", true, OD_Gb_Eb));
            this.put(11, new OpcodeX86("or", true, OD_Gv_Ev));
            this.put(12, new OpcodeX86("or", false, OD_AL_Ib));
            this.put(13, new OpcodeX86("or", false, OD_rAX_Iz));
            this.put(14, new OpcodeX86("push", false, OD_CS));
            this.put(16, new OpcodeX86("adc", true, OD_Eb_Gb));
            this.put(17, new OpcodeX86("adc", true, OD_Ev_Gv));
            this.put(18, new OpcodeX86("adc", true, OD_Gb_Eb));
            this.put(19, new OpcodeX86("adc", true, OD_Gv_Ev));
            this.put(20, new OpcodeX86("adc", false, OD_AL_Ib));
            this.put(21, new OpcodeX86("adc", false, OD_rAX_Iz));
            this.put(22, new OpcodeX86("push", false, OD_SS));
            this.put(23, new OpcodeX86("pop", false, OD_SS));
            this.put(24, new OpcodeX86("sbb", true, OD_Eb_Gb));
            this.put(25, new OpcodeX86("sbb", true, OD_Ev_Gv));
            this.put(26, new OpcodeX86("sbb", true, OD_Gb_Eb));
            this.put(27, new OpcodeX86("sbb", true, OD_Gv_Ev));
            this.put(28, new OpcodeX86("sbb", false, OD_AL_Ib));
            this.put(29, new OpcodeX86("sbb", false, OD_rAX_Iz));
            this.put(30, new OpcodeX86("push", false, OD_DS));
            this.put(31, new OpcodeX86("pop", false, OD_DS));
            this.put(32, new OpcodeX86("and", true, OD_Eb_Gb));
            this.put(33, new OpcodeX86("and", true, OD_Ev_Gv));
            this.put(34, new OpcodeX86("and", true, OD_Gb_Eb));
            this.put(35, new OpcodeX86("and", true, OD_Gv_Ev));
            this.put(36, new OpcodeX86("and", false, OD_AL_Ib));
            this.put(37, new OpcodeX86("and", false, OD_rAX_Iz));
            this.put(39, new OpcodeX86("daa", false, OD_NO_OPERAND));
            this.put(40, new OpcodeX86("sub", true, OD_Eb_Gb));
            this.put(41, new OpcodeX86("sub", true, OD_Ev_Gv));
            this.put(42, new OpcodeX86("sub", true, OD_Gb_Eb));
            this.put(43, new OpcodeX86("sub", true, OD_Gv_Ev));
            this.put(44, new OpcodeX86("sub", false, OD_AL_Ib));
            this.put(45, new OpcodeX86("sub", false, OD_rAX_Iz));
            this.put(47, new OpcodeX86("das", false, OD_NO_OPERAND));
            this.put(48, new OpcodeX86("xor", true, OD_Eb_Gb));
            this.put(49, new OpcodeX86("xor", true, OD_Ev_Gv));
            this.put(50, new OpcodeX86("xor", true, OD_Gb_Eb));
            this.put(51, new OpcodeX86("xor", true, OD_Gv_Ev));
            this.put(52, new OpcodeX86("xor", false, OD_AL_Ib));
            this.put(53, new OpcodeX86("xor", false, OD_rAX_Iz));
            this.put(55, new OpcodeX86("aaa", false, null));
            this.put(56, new OpcodeX86("cmp", true, OD_Eb_Gb));
            this.put(57, new OpcodeX86("cmp", true, OD_Ev_Gv));
            this.put(58, new OpcodeX86("cmp", true, OD_Gb_Eb));
            this.put(59, new OpcodeX86("cmp", true, OD_Gv_Ev));
            this.put(60, new OpcodeX86("cmp", false, OD_AL_Ib));
            this.put(61, new OpcodeX86("cmp", false, OD_rAX_Iz));
            this.put(63, new OpcodeX86("aas", false, OD_NO_OPERAND));
            this.put(64, new OpcodeX86("inc", false, OD_eAX));
            this.put(65, new OpcodeX86("inc", false, OD_eCX));
            this.put(66, new OpcodeX86("inc", false, OD_eDX));
            this.put(67, new OpcodeX86("inc", false, OD_eBX));
            this.put(68, new OpcodeX86("inc", false, OD_eSP));
            this.put(69, new OpcodeX86("inc", false, OD_eBP));
            this.put(70, new OpcodeX86("inc", false, OD_eSI));
            this.put(71, new OpcodeX86("inc", false, OD_eDI));
            this.put(72, new OpcodeX86("dec", false, OD_eAX));
            this.put(73, new OpcodeX86("dec", false, OD_eCX));
            this.put(74, new OpcodeX86("dec", false, OD_eDX));
            this.put(75, new OpcodeX86("dec", false, OD_eBX));
            this.put(76, new OpcodeX86("dec", false, OD_eSP));
            this.put(77, new OpcodeX86("dec", false, OD_eBP));
            this.put(78, new OpcodeX86("dec", false, OD_eSI));
            this.put(79, new OpcodeX86("dec", false, OD_eDI));
            this.put(80, new OpcodeX86("push", false, OD_rAX));
            this.put(81, new OpcodeX86("push", false, OD_rCX));
            this.put(82, new OpcodeX86("push", false, OD_rDX));
            this.put(83, new OpcodeX86("push", false, OD_rBX));
            this.put(84, new OpcodeX86("push", false, OD_rSP));
            this.put(85, new OpcodeX86("push", false, OD_rBP));
            this.put(86, new OpcodeX86("push", false, OD_rSI));
            this.put(87, new OpcodeX86("push", false, OD_rDI));
            this.put(88, new OpcodeX86("pop", false, OD_rAX));
            this.put(89, new OpcodeX86("pop", false, OD_rCX));
            this.put(90, new OpcodeX86("pop", false, OD_rDX));
            this.put(91, new OpcodeX86("pop", false, OD_rBX));
            this.put(92, new OpcodeX86("pop", false, OD_rSP));
            this.put(93, new OpcodeX86("pop", false, OD_rBP));
            this.put(94, new OpcodeX86("pop", false, OD_rSI));
            this.put(95, new OpcodeX86("pop", false, OD_rDI));
            this.put(96, new OpcodeX86("pusha", false, OD_NO_OPERAND));
            this.put(97, new OpcodeX86("popa", false, OD_NO_OPERAND));
            this.put(98, new OpcodeX86("bound", true, OD_Gv_Ma));
            AssemblyFormatterX86.sInstructionsNotReverseOperand.add("bound");
            this.put(99, new OpcodeX86("arpl", true, OD_Ew_Gw));
            this.put(104, new OpcodeX86("push", false, OD_Iz));
            this.put(105, new OpcodeX86("imul", true, OD_Gv_Ev_Iz));
            this.put(106, new OpcodeX86("push", false, OD_Ib));
            this.put(107, new OpcodeX86("imul", true, OD_Gv_Ev_Ib));
            this.put(108, new OpcodeX86("insT", false, OD_Yb_iDX));
            this.put(109, new OpcodeX86("insT", false, OD_Yz_iDX));
            this.put(110, new OpcodeX86("outsS", false, OD_iDX_Xb));
            this.put(111, new OpcodeX86("outsS", false, OD_iDX_Xz));
            this.put(112, new OpcodeX86("jo", false, OD_Jb));
            this.put(113, new OpcodeX86("jno", false, OD_Jb));
            this.put(114, new OpcodeX86("jb", false, OD_Jb));
            this.put(115, new OpcodeX86("jae", false, OD_Jb));
            this.put(116, new OpcodeX86("je", false, OD_Jb));
            this.put(117, new OpcodeX86("jne", false, OD_Jb));
            this.put(118, new OpcodeX86("jbe", false, OD_Jb));
            this.put(119, new OpcodeX86("ja", false, OD_Jb));
            this.put(120, new OpcodeX86("js", false, OD_Jb));
            this.put(121, new OpcodeX86("jns", false, OD_Jb));
            this.put(122, new OpcodeX86("jp", false, OD_Jb));
            this.put(123, new OpcodeX86("jnp", false, OD_Jb));
            this.put(124, new OpcodeX86("jl", false, OD_Jb));
            this.put(125, new OpcodeX86("jge", false, OD_Jb));
            this.put(126, new OpcodeX86("jle", false, OD_Jb));
            this.put(127, new OpcodeX86("jg", false, OD_Jb));
            this.put(132, new OpcodeX86("test", true, OD_Eb_Gb));
            this.put(133, new OpcodeX86("test", true, OD_Ev_Gv));
            this.put(134, new OpcodeX86("xchg", true, OD_Eb_Gb));
            this.put(135, new OpcodeX86("xchg", true, OD_Ev_Gv));
            this.put(136, new OpcodeX86("mov", true, OD_Eb_Gb));
            this.put(137, new OpcodeX86("mov", true, OD_Ev_Gv));
            this.put(138, new OpcodeX86("mov", true, OD_Gb_Eb));
            this.put(139, new OpcodeX86("mov", true, OD_Gv_Ev));
            this.put(140, new OpcodeX86("mov", true, OD_Ev_Sw));
            this.put(141, new OpcodeX86("lea", true, OD_Gv_M));
            this.put(142, new OpcodeX86("mov", true, OD_Sw_Ew));
            this.put(144, new OpcodeX86("nop", false, OD_NO_OPERAND));
            this.put(145, new OpcodeX86("xchg", false, OD_rCX_rAX));
            this.put(146, new OpcodeX86("xchg", false, OD_rDX_rAX));
            this.put(147, new OpcodeX86("xchg", false, OD_rBX_rAX));
            this.put(148, new OpcodeX86("xchg", false, OD_rSP_rAX));
            this.put(149, new OpcodeX86("xchg", false, OD_rBP_rAX));
            this.put(150, new OpcodeX86("xchg", false, OD_rSI_rAX));
            this.put(151, new OpcodeX86("xchg", false, OD_rDI_rAX));
            this.put(152, new OpcodeX86("cwtl", false, OD_NO_OPERAND));
            this.put(153, new OpcodeX86("cltd", false, OD_NO_OPERAND));
            this.put(154, new OpcodeX86("call", false, OD_Ap));
            this.put(155, new OpcodeX86("fwait", false, OD_NO_OPERAND));
            this.put(156, new OpcodeX86("pushf", false, OD_NO_OPERAND));
            this.put(157, new OpcodeX86("popf", false, OD_NO_OPERAND));
            this.put(158, new OpcodeX86("sahf", false, OD_NO_OPERAND));
            this.put(159, new OpcodeX86("lahf", false, OD_NO_OPERAND));
            this.put(160, new OpcodeX86("mov", false, OD_AL_Ob));
            this.put(161, new OpcodeX86("mov", false, OD_rAX_Ov));
            this.put(162, new OpcodeX86("mov", false, OD_Ob_AL));
            this.put(163, new OpcodeX86("mov", false, OD_Ov_rAX));
            this.put(164, new OpcodeX86("movsT", false, OD_Xb_Yb));
            this.put(165, new OpcodeX86("movsT", false, OD_Xv_Yv));
            AssemblyFormatterX86.sInstructionsNotReverseOperand.add("movsT");
            this.put(166, new OpcodeX86("cmpsT", false, OD_Xb_Yb));
            this.put(167, new OpcodeX86("cmpsT", false, OD_Xv_Yv));
            this.put(168, new OpcodeX86("test", false, OD_AL_Ib));
            this.put(169, new OpcodeX86("test", false, OD_rAX_Iz));
            this.put(170, new OpcodeX86("stosT", false, OD_Yb_AL));
            this.put(171, new OpcodeX86("stosT", false, OD_Yv_rAX));
            this.put(172, new OpcodeX86("lodsT", false, OD_AL_Xb));
            this.put(173, new OpcodeX86("lodsT", false, OD_rAX_Xv));
            this.put(174, new OpcodeX86("scasT", false, OD_AL_Yb));
            this.put(175, new OpcodeX86("scasT", false, OD_rAX_Xv));
            this.put(176, new OpcodeX86("mov", false, OD_AL_Ib));
            this.put(177, new OpcodeX86("mov", false, new String[]{"CL", "Ib"}));
            this.put(178, new OpcodeX86("mov", false, new String[]{"DL", "Ib"}));
            this.put(179, new OpcodeX86("mov", false, new String[]{"BL", "Ib"}));
            this.put(180, new OpcodeX86("mov", false, new String[]{"AH", "Ib"}));
            this.put(181, new OpcodeX86("mov", false, new String[]{"CH", "Ib"}));
            this.put(182, new OpcodeX86("mov", false, new String[]{"DH", "Ib"}));
            this.put(183, new OpcodeX86("mov", false, new String[]{"BH", "Ib"}));
            this.put(184, new OpcodeX86("mov", false, new String[]{"rAX", "Iv"}));
            this.put(185, new OpcodeX86("mov", false, new String[]{"rCX", "Iv"}));
            this.put(186, new OpcodeX86("mov", false, new String[]{"rDX", "Iv"}));
            this.put(187, new OpcodeX86("mov", false, new String[]{"rBX", "Iv"}));
            this.put(188, new OpcodeX86("mov", false, new String[]{"rSP", "Iv"}));
            this.put(189, new OpcodeX86("mov", false, new String[]{"rBP", "Iv"}));
            this.put(190, new OpcodeX86("mov", false, new String[]{"rSI", "Iv"}));
            this.put(191, new OpcodeX86("mov", false, new String[]{"rDI", "Iv"}));
            this.put(194, new OpcodeX86("ret", false, OD_Iw));
            this.put(195, new OpcodeX86("ret", false, OD_NO_OPERAND));
            this.put(196, new OpcodeX86("les", true, OD_Gz_Mp));
            this.put(197, new OpcodeX86("lds", true, OD_Gz_Mp));
            this.put(200, new OpcodeX86("enter", false, OD_Iw_Ib));
            AssemblyFormatterX86.sInstructionsNotReverseOperand.add("enter");
            this.put(201, new OpcodeX86("leave", false, OD_NO_OPERAND));
            this.put(202, new OpcodeX86("lret", false, OD_Iw));
            this.put(203, new OpcodeX86("lret", false, OD_NO_OPERAND));
            this.put(204, new OpcodeX86("int3", false, OD_NO_OPERAND));
            this.put(205, new OpcodeX86("int", false, OD_Ib));
            this.put(206, new OpcodeX86("into", false, OD_NO_OPERAND));
            this.put(207, new OpcodeX86("iret", false, OD_NO_OPERAND));
            this.put(212, new OpcodeX86("aam", false, OD_Ib));
            this.put(213, new OpcodeX86("aad", false, OD_Ib));
            this.put(214, sInvalidOpcode);
            this.put(215, new OpcodeX86("xlat", false, OD_NO_OPERAND));
            this.put(224, new OpcodeX86("loopne", false, OD_Jb));
            this.put(225, new OpcodeX86("loope", false, OD_Jb));
            this.put(226, new OpcodeX86("loop", false, OD_Jb));
            this.put(227, new OpcodeX86("jcxz", false, OD_Jb));
            this.put(228, new OpcodeX86("in", false, OD_AL_Ib));
            this.put(229, new OpcodeX86("in", false, OD_eAX_Ib));
            this.put(230, new OpcodeX86("out", false, OD_Ib_AL));
            this.put(231, new OpcodeX86("out", false, OD_Ib_eAX));
            this.put(232, new OpcodeX86("call", false, OD_Jz));
            this.put(233, new OpcodeX86("jmp", false, OD_Jz));
            this.put(234, new OpcodeX86("ljmp", false, OD_Ap));
            this.put(235, new OpcodeX86("jmp", false, OD_Jb));
            this.put(236, new OpcodeX86("in", false, OD_AL_iDX));
            this.put(237, new OpcodeX86("in", false, OD_eAX_iDX));
            this.put(238, new OpcodeX86("out", false, OD_iDX_AL));
            this.put(239, new OpcodeX86("out", false, OD_iDX_eAX));
            this.put(241, sInvalidOpcode);
            this.put(244, new OpcodeX86("hlt", false, OD_NO_OPERAND));
            this.put(245, new OpcodeX86("cmc", false, OD_NO_OPERAND));
            this.put(248, new OpcodeX86("clc", false, OD_NO_OPERAND));
            this.put(249, new OpcodeX86("stc", false, OD_NO_OPERAND));
            this.put(250, new OpcodeX86("cli", false, OD_NO_OPERAND));
            this.put(251, new OpcodeX86("sti", false, OD_NO_OPERAND));
            this.put(252, new OpcodeX86("cld", false, OD_NO_OPERAND));
            this.put(253, new OpcodeX86("std", false, OD_NO_OPERAND));
        }
    };
    public static Map<Integer, Map<Integer, OpcodeX86>> sOpcodeMap_OneByteExtension = new HashMap<Integer, Map<Integer, OpcodeX86>>(){
        {
            this.put(128, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("addT", true, OD_Eb_Ib));
                    this.put(1, new OpcodeX86("orT", true, OD_Eb_Ib));
                    this.put(2, new OpcodeX86("adcT", true, OD_Eb_Ib));
                    this.put(3, new OpcodeX86("sbbT", true, OD_Eb_Ib));
                    this.put(4, new OpcodeX86("andT", true, OD_Eb_Ib));
                    this.put(5, new OpcodeX86("subT", true, OD_Eb_Ib));
                    this.put(6, new OpcodeX86("xorT", true, OD_Eb_Ib));
                    this.put(7, new OpcodeX86("cmpT", true, OD_Eb_Ib));
                }
            });
            this.put(129, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("addT", true, OD_Ev_Iz));
                    this.put(1, new OpcodeX86("orT", true, OD_Ev_Iz));
                    this.put(2, new OpcodeX86("adcT", true, OD_Ev_Iz));
                    this.put(3, new OpcodeX86("sbbT", true, OD_Ev_Iz));
                    this.put(4, new OpcodeX86("andT", true, OD_Ev_Iz));
                    this.put(5, new OpcodeX86("subT", true, OD_Ev_Iz));
                    this.put(6, new OpcodeX86("xorT", true, OD_Ev_Iz));
                    this.put(7, new OpcodeX86("cmpT", true, OD_Ev_Iz));
                }
            });
            this.put(130, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("addT", true, OD_Eb_Ib));
                    this.put(1, new OpcodeX86("orT", true, OD_Eb_Ib));
                    this.put(2, new OpcodeX86("adcT", true, OD_Eb_Ib));
                    this.put(3, new OpcodeX86("sbbT", true, OD_Eb_Ib));
                    this.put(4, new OpcodeX86("andT", true, OD_Eb_Ib));
                    this.put(5, new OpcodeX86("subT", true, OD_Eb_Ib));
                    this.put(6, new OpcodeX86("xorT", true, OD_Eb_Ib));
                    this.put(7, new OpcodeX86("cmpT", true, OD_Eb_Ib));
                }
            });
            this.put(131, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("addT", true, OD_Ev_Ib));
                    this.put(1, new OpcodeX86("orT", true, OD_Ev_Ib));
                    this.put(2, new OpcodeX86("adcT", true, OD_Ev_Ib));
                    this.put(3, new OpcodeX86("sbbT", true, OD_Ev_Ib));
                    this.put(4, new OpcodeX86("andT", true, OD_Ev_Ib));
                    this.put(5, new OpcodeX86("subT", true, OD_Ev_Ib));
                    this.put(6, new OpcodeX86("xorT", true, OD_Ev_Ib));
                    this.put(7, new OpcodeX86("cmpT", true, OD_Ev_Ib));
                }
            });
            this.put(143, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("pop", true, OD_Ev));
                    this.put(1, sInvalidOpcode);
                    this.put(2, sInvalidOpcode);
                    this.put(3, sInvalidOpcode);
                    this.put(4, sInvalidOpcode);
                    this.put(5, sInvalidOpcode);
                    this.put(6, sInvalidOpcode);
                    this.put(7, sInvalidOpcode);
                }
            });
            this.put(192, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("rolT", true, OD_Eb_Ib));
                    this.put(1, new OpcodeX86("rorT", true, OD_Eb_Ib));
                    this.put(2, new OpcodeX86("rclT", true, OD_Eb_Ib));
                    this.put(3, new OpcodeX86("rcrT", true, OD_Eb_Ib));
                    this.put(4, new OpcodeX86("shlT", true, OD_Eb_Ib));
                    this.put(5, new OpcodeX86("shrT", true, OD_Eb_Ib));
                    this.put(6, sInvalidOpcode);
                    this.put(7, new OpcodeX86("sarT", true, OD_Eb_Ib));
                }
            });
            this.put(193, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("rolT", true, OD_Ev_Ib));
                    this.put(1, new OpcodeX86("rorT", true, OD_Ev_Ib));
                    this.put(2, new OpcodeX86("rclT", true, OD_Ev_Ib));
                    this.put(3, new OpcodeX86("rcrT", true, OD_Ev_Ib));
                    this.put(4, new OpcodeX86("shlT", true, OD_Ev_Ib));
                    this.put(5, new OpcodeX86("shrT", true, OD_Ev_Ib));
                    this.put(6, sInvalidOpcode);
                    this.put(7, new OpcodeX86("sarT", true, OD_Ev_Ib));
                }
            });
            this.put(208, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("rol", true, OD_Eb));
                    this.put(1, new OpcodeX86("ror", true, OD_Eb));
                    this.put(2, new OpcodeX86("rcl", true, OD_Eb));
                    this.put(3, new OpcodeX86("rcr", true, OD_Eb));
                    this.put(4, new OpcodeX86("shl", true, OD_Eb));
                    this.put(5, new OpcodeX86("shr", true, OD_Eb));
                    this.put(6, sInvalidOpcode);
                    this.put(7, new OpcodeX86("sar", true, OD_Eb));
                }
            });
            this.put(209, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("rolT", true, OD_Ev));
                    this.put(1, new OpcodeX86("rorT", true, OD_Ev));
                    this.put(2, new OpcodeX86("rclT", true, OD_Ev));
                    this.put(3, new OpcodeX86("rcrT", true, OD_Ev));
                    this.put(4, new OpcodeX86("shlT", true, OD_Ev));
                    this.put(5, new OpcodeX86("shrT", true, OD_Ev));
                    this.put(6, sInvalidOpcode);
                    this.put(7, new OpcodeX86("sarT", true, OD_Ev));
                }
            });
            this.put(210, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("rol", true, OD_Eb_CL));
                    this.put(1, new OpcodeX86("ror", true, OD_Eb_CL));
                    this.put(2, new OpcodeX86("rcl", true, OD_Eb_CL));
                    this.put(3, new OpcodeX86("rcr", true, OD_Eb_CL));
                    this.put(4, new OpcodeX86("shl", true, OD_Eb_CL));
                    this.put(5, new OpcodeX86("shr", true, OD_Eb_CL));
                    this.put(6, sInvalidOpcode);
                    this.put(7, new OpcodeX86("sar", true, OD_Eb_CL));
                }
            });
            this.put(211, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("rol", true, OD_Ev_CL));
                    this.put(1, new OpcodeX86("ror", true, OD_Ev_CL));
                    this.put(2, new OpcodeX86("rcl", true, OD_Ev_CL));
                    this.put(3, new OpcodeX86("rcr", true, OD_Ev_CL));
                    this.put(4, new OpcodeX86("shl", true, OD_Ev_CL));
                    this.put(5, new OpcodeX86("shr", true, OD_Ev_CL));
                    this.put(6, sInvalidOpcode);
                    this.put(7, new OpcodeX86("sar", true, OD_Ev_CL));
                }
            });
            this.put(246, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("testT", true, OD_Eb_Ib));
                    this.put(1, sInvalidOpcode);
                    this.put(2, new OpcodeX86("notT", true, OD_Eb));
                    this.put(3, new OpcodeX86("negT", true, OD_Eb));
                    this.put(4, new OpcodeX86("mulT", true, OD_Eb));
                    this.put(5, new OpcodeX86("imulT", true, OD_Eb));
                    this.put(6, new OpcodeX86("divT", true, OD_Eb));
                    this.put(7, new OpcodeX86("idivT", true, OD_Eb));
                }
            });
            this.put(247, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("testT", true, OD_Ev_Iz));
                    this.put(1, sInvalidOpcode);
                    this.put(2, new OpcodeX86("notT", true, OD_Ev));
                    this.put(3, new OpcodeX86("negT", true, OD_Ev));
                    this.put(4, new OpcodeX86("mulT", true, OD_Ev));
                    this.put(5, new OpcodeX86("imulT", true, OD_Ev));
                    this.put(6, new OpcodeX86("divT", true, OD_Ev));
                    this.put(7, new OpcodeX86("idivT", true, OD_Ev));
                }
            });
            this.put(254, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("incb", true, OD_Eb));
                    this.put(1, new OpcodeX86("decb", true, OD_Eb));
                    this.put(2, sInvalidOpcode);
                    this.put(3, sInvalidOpcode);
                    this.put(4, sInvalidOpcode);
                    this.put(5, sInvalidOpcode);
                    this.put(6, sInvalidOpcode);
                    this.put(7, sInvalidOpcode);
                }
            });
            this.put(255, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("incT", true, OD_Ev));
                    this.put(1, new OpcodeX86("decT", true, OD_Ev));
                    this.put(2, new OpcodeX86("call", true, OD_iEv));
                    this.put(3, new OpcodeX86("call", true, OD_iEp));
                    this.put(4, new OpcodeX86("jmp", true, OD_iEv));
                    this.put(5, new OpcodeX86("jmp", true, OD_iEp));
                    this.put(6, new OpcodeX86("pushT", true, OD_Ev));
                    this.put(7, sInvalidOpcode);
                }
            });
            this.put(198, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("movT", true, OD_Eb_Ib));
                    this.put(1, sInvalidOpcode);
                    this.put(2, sInvalidOpcode);
                    this.put(3, sInvalidOpcode);
                    this.put(4, sInvalidOpcode);
                    this.put(5, sInvalidOpcode);
                    this.put(6, sInvalidOpcode);
                    this.put(7, sInvalidOpcode);
                }
            });
            this.put(199, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("movT", true, OD_Ev_Iz));
                    this.put(1, sInvalidOpcode);
                    this.put(2, sInvalidOpcode);
                    this.put(3, sInvalidOpcode);
                    this.put(4, sInvalidOpcode);
                    this.put(5, sInvalidOpcode);
                    this.put(6, sInvalidOpcode);
                    this.put(7, sInvalidOpcode);
                }
            });
        }
    };
    public static Map<Integer, Map<Integer, OpcodeX86>> sOpcodeMap_OneByteWithPrefix = new HashMap<Integer, Map<Integer, OpcodeX86>>(){
        {
            this.put(102, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(144, new OpcodeX86("xchg", false, OD_rAX_rAX));
                }
            });
            this.put(243, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(144, new OpcodeX86("pause", false, OD_NO_OPERAND));
                }
            });
        }
    };
    public static Map<Integer, Map<Integer, OpcodeX86>> sOpcodeMap_TwoByteWithPrefix = new HashMap<Integer, Map<Integer, OpcodeX86>>(){
        {
            this.put(243, new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(16, new OpcodeX86("movss", false, OD_Vss_Wss));
                    this.put(17, new OpcodeX86("movss", false, OD_Wss_Vss));
                    this.put(184, new OpcodeX86("popcnt", true, OD_Gv_Ev));
                }
            });
        }
    };
    public static Map<Integer, OpcodeX86> sOpcodeMap_TwoByte = new HashMap<Integer, OpcodeX86>(){
        {
            this.put(2, new OpcodeX86("lar", true, OD_Gv_Ew));
            this.put(3, new OpcodeX86("lsl", true, OD_Gv_Ew));
            this.put(4, sInvalidOpcode);
            this.put(5, new OpcodeX86("syscall", false, OD_NO_OPERAND));
            this.put(6, new OpcodeX86("clts", false, OD_NO_OPERAND));
            this.put(7, new OpcodeX86("sysret", false, OD_NO_OPERAND));
            this.put(8, new OpcodeX86("invd", false, OD_NO_OPERAND));
            this.put(9, new OpcodeX86("wbinvd", false, OD_NO_OPERAND));
            this.put(10, sInvalidOpcode);
            this.put(11, sInvalidOpcode);
            this.put(12, sInvalidOpcode);
            this.put(13, new OpcodeX86("nop", true, OD_Ev));
            this.put(14, sInvalidOpcode);
            this.put(15, sInvalidOpcode);
            this.put(32, new OpcodeX86("mov", true, OD_Rd_Cd));
            this.put(33, new OpcodeX86("mov", true, OD_Rd_Dd));
            this.put(34, new OpcodeX86("mov", true, OD_Cd_Rd));
            this.put(35, new OpcodeX86("mov", true, OD_Dd_Rd));
            this.put(36, sInvalidOpcode);
            this.put(37, sInvalidOpcode);
            this.put(38, sInvalidOpcode);
            this.put(39, sInvalidOpcode);
            this.put(48, new OpcodeX86("wrmsr", false, OD_NO_OPERAND));
            this.put(49, new OpcodeX86("rdtsc", false, OD_NO_OPERAND));
            this.put(50, new OpcodeX86("rdmsr", false, OD_NO_OPERAND));
            this.put(51, new OpcodeX86("rdpmc", false, OD_NO_OPERAND));
            this.put(52, new OpcodeX86("sysenter", false, OD_NO_OPERAND));
            this.put(53, new OpcodeX86("sysexit", false, OD_NO_OPERAND));
            this.put(54, sInvalidOpcode);
            this.put(55, new OpcodeX86("getsec", false, OD_NO_OPERAND));
            this.put(57, sInvalidOpcode);
            this.put(59, sInvalidOpcode);
            this.put(60, sInvalidOpcode);
            this.put(61, sInvalidOpcode);
            this.put(62, sInvalidOpcode);
            this.put(63, sInvalidOpcode);
            this.put(64, new OpcodeX86("cmovo", true, OD_Gv_Ev));
            this.put(65, new OpcodeX86("cmovno", true, OD_Gv_Ev));
            this.put(66, new OpcodeX86("cmovb", true, OD_Gv_Ev));
            this.put(67, new OpcodeX86("cmovae", true, OD_Gv_Ev));
            this.put(68, new OpcodeX86("cmove", true, OD_Gv_Ev));
            this.put(69, new OpcodeX86("cmovne", true, OD_Gv_Ev));
            this.put(70, new OpcodeX86("cmovbe", true, OD_Gv_Ev));
            this.put(71, new OpcodeX86("cmovnbe", true, OD_Gv_Ev));
            this.put(72, new OpcodeX86("cmovs", true, OD_Gv_Ev));
            this.put(73, new OpcodeX86("cmovns", true, OD_Gv_Ev));
            this.put(74, new OpcodeX86("cmovp", true, OD_Gv_Ev));
            this.put(75, new OpcodeX86("cmovnp", true, OD_Gv_Ev));
            this.put(76, new OpcodeX86("cmovnge", true, OD_Gv_Ev));
            this.put(77, new OpcodeX86("cmovge", true, OD_Gv_Ev));
            this.put(78, new OpcodeX86("cmovng", true, OD_Gv_Ev));
            this.put(79, new OpcodeX86("cmovg", true, OD_Gv_Ev));
            this.put(128, new OpcodeX86("jo", false, OD_Jz));
            this.put(129, new OpcodeX86("jno", false, OD_Jz));
            this.put(130, new OpcodeX86("jb", false, OD_Jz));
            this.put(131, new OpcodeX86("jae", false, OD_Jz));
            this.put(132, new OpcodeX86("je", false, OD_Jz));
            this.put(133, new OpcodeX86("jne", false, OD_Jz));
            this.put(134, new OpcodeX86("jbe", false, OD_Jz));
            this.put(135, new OpcodeX86("ja", false, OD_Jz));
            this.put(136, new OpcodeX86("js", false, OD_Jz));
            this.put(137, new OpcodeX86("jns", false, OD_Jz));
            this.put(138, new OpcodeX86("jp", false, OD_Jz));
            this.put(139, new OpcodeX86("jnp", false, OD_Jz));
            this.put(140, new OpcodeX86("jl", false, OD_Jz));
            this.put(141, new OpcodeX86("jge", false, OD_Jz));
            this.put(142, new OpcodeX86("jle", false, OD_Jz));
            this.put(143, new OpcodeX86("jg", false, OD_Jz));
            this.put(144, new OpcodeX86("seto", true, OD_Eb));
            this.put(145, new OpcodeX86("setno", true, OD_Eb));
            this.put(146, new OpcodeX86("setb", true, OD_Eb));
            this.put(147, new OpcodeX86("setae", true, OD_Eb));
            this.put(148, new OpcodeX86("sete", true, OD_Eb));
            this.put(149, new OpcodeX86("setne", true, OD_Eb));
            this.put(150, new OpcodeX86("setbe", true, OD_Eb));
            this.put(151, new OpcodeX86("seta", true, OD_Eb));
            this.put(152, new OpcodeX86("sets", true, OD_Eb));
            this.put(153, new OpcodeX86("setns", true, OD_Eb));
            this.put(154, new OpcodeX86("setp", true, OD_Eb));
            this.put(155, new OpcodeX86("setnp", true, OD_Eb));
            this.put(156, new OpcodeX86("setl", true, OD_Eb));
            this.put(157, new OpcodeX86("setge", true, OD_Eb));
            this.put(158, new OpcodeX86("setle", true, OD_Eb));
            this.put(159, new OpcodeX86("setg", true, OD_Eb));
            this.put(160, new OpcodeX86("push", false, OD_FS));
            this.put(161, new OpcodeX86("pop", false, OD_FS));
            this.put(162, new OpcodeX86("cpuid", false, OD_NO_OPERAND));
            this.put(163, new OpcodeX86("bt", true, OD_Ev_Gv));
            this.put(164, new OpcodeX86("shld", true, OD_Ev_Gv_Ib));
            this.put(165, new OpcodeX86("shld", true, OD_Ev_Gv_CL));
            this.put(166, sInvalidOpcode);
            this.put(167, sInvalidOpcode);
            this.put(168, new OpcodeX86("push", false, OD_GS));
            this.put(169, new OpcodeX86("pop", false, OD_GS));
            this.put(170, new OpcodeX86("rsm", false, OD_NO_OPERAND));
            this.put(171, new OpcodeX86("bts", true, OD_Ev_Gv));
            this.put(172, new OpcodeX86("shrd", true, OD_Ev_Gv_Ib));
            this.put(173, new OpcodeX86("shrd", true, OD_Ev_Gv_CL));
            this.put(175, new OpcodeX86("imul", true, OD_Gv_Ev));
            this.put(176, new OpcodeX86("cmpxchg", true, OD_Eb_Gb));
            this.put(177, new OpcodeX86("cmpxchg", true, OD_Ev_Gv));
            this.put(178, new OpcodeX86("lss", true, OD_Gv_Mp));
            this.put(179, new OpcodeX86("btr", true, OD_Ev_Gv));
            this.put(180, new OpcodeX86("lfs", true, OD_Gv_Mp));
            this.put(181, new OpcodeX86("lgs", true, OD_Gv_Mp));
            this.put(182, new OpcodeX86("movzbT", true, OD_Gv_Eb));
            AssemblyFormatterX86.sInstructionsSuffixFromRegisterOperand.add("movzbT");
            this.put(183, new OpcodeX86("movzwT", true, OD_Gv_Ew));
            AssemblyFormatterX86.sInstructionsSuffixFromRegisterOperand.add("movzwT");
            this.put(184, new OpcodeX86("jmpe", false, OD_NO_OPERAND));
            this.put(185, sInvalidOpcode);
            this.put(187, new OpcodeX86("btc", true, OD_Ev_Gv));
            this.put(188, new OpcodeX86("bsf", true, OD_Gv_Ev));
            this.put(189, new OpcodeX86("bsr", true, OD_Gv_Ev));
            this.put(190, new OpcodeX86("movsbT", true, OD_Gv_Eb));
            AssemblyFormatterX86.sInstructionsSuffixFromRegisterOperand.add("movsbT");
            this.put(191, new OpcodeX86("movswT", true, OD_Gv_Ew));
            AssemblyFormatterX86.sInstructionsSuffixFromRegisterOperand.add("movswT");
            this.put(192, new OpcodeX86("xadd", true, OD_Eb_Gb));
            this.put(193, new OpcodeX86("xadd", true, OD_Ev_Gv));
            this.put(200, new OpcodeX86("bswap", false, OD_eAX));
            this.put(201, new OpcodeX86("bswap", false, OD_eCX));
            this.put(202, new OpcodeX86("bswap", false, OD_eDX));
            this.put(203, new OpcodeX86("bswap", false, OD_eBX));
            this.put(204, new OpcodeX86("bswap", false, OD_eSP));
            this.put(205, new OpcodeX86("bswap", false, OD_eBP));
            this.put(206, new OpcodeX86("bswap", false, OD_eSI));
            this.put(207, new OpcodeX86("bswap", false, OD_eDI));
        }
    };
    public static Map<Integer, Map<Integer, OpcodeX86>> sOpcodeMap_TwoByteExtension = new HashMap<Integer, Map<Integer, OpcodeX86>>(){
        {
            HashMap<Integer, OpcodeX86> subMap_00 = new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("sldt", true, OD_RvMw));
                    this.put(1, new OpcodeX86("str", true, OD_RvMw));
                    this.put(2, new OpcodeX86("lldt", true, OD_Ew));
                    this.put(3, new OpcodeX86("ltr", true, OD_Ew));
                    this.put(4, new OpcodeX86("verr", true, OD_Ew));
                    this.put(5, new OpcodeX86("verw", true, OD_Ew));
                    this.put(6, sInvalidOpcode);
                    this.put(7, sInvalidOpcode);
                }
            };
            this.put(0, subMap_00);
            this.put(1, subMap_00);
            this.put(2, subMap_00);
            this.put(3, subMap_00);
            HashMap<Integer, OpcodeX86> subMap_01_0_2 = new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, new OpcodeX86("sgdt", true, OD_Ms));
                    this.put(1, new OpcodeX86("sidt", true, OD_Ms));
                    this.put(2, new OpcodeX86("lgdt", true, OD_Ms));
                    this.put(3, new OpcodeX86("lidt", true, OD_Ms));
                    this.put(4, new OpcodeX86("smsw", true, OD_RvMw));
                    this.put(5, sInvalidOpcode);
                    this.put(6, new OpcodeX86("lmsw", true, OD_Ew));
                }
            };
            HashMap<Integer, OpcodeX86> subMap_01_3 = new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, sVaringOpcode);
                    this.put(1, sVaringOpcode);
                    this.put(2, sVaringOpcode);
                    this.put(3, sInvalidOpcode);
                    this.put(4, new OpcodeX86("smsw", true, OD_RvMw));
                    this.put(5, sInvalidOpcode);
                    this.put(6, new OpcodeX86("lmsw", true, OD_Ew));
                    this.put(7, sVaringOpcode);
                }
            };
            this.put(16, subMap_01_0_2);
            this.put(17, subMap_01_0_2);
            this.put(18, subMap_01_0_2);
            this.put(19, subMap_01_3);
            HashMap<Integer, OpcodeX86> subMap_ba = new HashMap<Integer, OpcodeX86>(){
                {
                    this.put(0, sInvalidOpcode);
                    this.put(1, sInvalidOpcode);
                    this.put(2, sInvalidOpcode);
                    this.put(3, sInvalidOpcode);
                    this.put(4, new OpcodeX86("btT", true, OD_Ev_Ib));
                    this.put(5, new OpcodeX86("btsT", true, OD_Ev_Ib));
                    this.put(6, new OpcodeX86("btrT", true, OD_Ev_Ib));
                    this.put(7, new OpcodeX86("btcT", true, OD_Ev_Ib));
                }
            };
            this.put(2976, subMap_ba);
            this.put(2977, subMap_ba);
            this.put(2978, subMap_ba);
            this.put(2979, subMap_ba);
        }
    };
    public static Map<Integer, OpcodeX86> sOpcodeMap_ThreeByte_0F38 = new HashMap<Integer, OpcodeX86>(){
        {
            this.put(240, new OpcodeX86("movbe", true, OD_Gv_Mv));
            this.put(241, new OpcodeX86("movbe", true, OD_Mv_Gv));
        }
    };
    public static Map<Integer, OpcodeX86> sOpcodeMap_ThreeByte_0F3A = new HashMap<Integer, OpcodeX86>(){};
    public static Map<Integer, Map<Integer, OpcodeX86>> sOpcodeMap_ThreeByteWithPrefix = new HashMap<Integer, Map<Integer, OpcodeX86>>();
    public static Map<Integer, List<Map<Integer, OpcodeX86>>> sOpcodeMap_Escape = new HashMap<Integer, List<Map<Integer, OpcodeX86>>>(){
        {
            this.put(216, new ArrayList<Map<Integer, OpcodeX86>>(){
                {
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(0, new OpcodeX86("fadds", true, OD_Ev));
                            this.put(1, new OpcodeX86("fmuls", true, OD_Ev));
                            this.put(2, new OpcodeX86("fcoms", true, OD_Ev));
                            this.put(3, new OpcodeX86("fcomps", true, OD_Ev));
                            this.put(4, new OpcodeX86("fsubs", true, OD_Ev));
                            this.put(5, new OpcodeX86("fsubrs", true, OD_Ev));
                            this.put(6, new OpcodeX86("fdivs", true, OD_Ev));
                            this.put(7, new OpcodeX86("fdivrs", true, OD_Ev));
                        }
                    });
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(192, new OpcodeX86("fadd", true, OD_ST_ST0));
                            this.put(193, new OpcodeX86("fadd", true, OD_ST_ST1));
                            this.put(194, new OpcodeX86("fadd", true, OD_ST_ST2));
                            this.put(195, new OpcodeX86("fadd", true, OD_ST_ST3));
                            this.put(196, new OpcodeX86("fadd", true, OD_ST_ST4));
                            this.put(197, new OpcodeX86("fadd", true, OD_ST_ST5));
                            this.put(198, new OpcodeX86("fadd", true, OD_ST_ST6));
                            this.put(199, new OpcodeX86("fadd", true, OD_ST_ST7));
                            this.put(200, new OpcodeX86("fmul", true, OD_ST_ST0));
                            this.put(201, new OpcodeX86("fmul", true, OD_ST_ST1));
                            this.put(202, new OpcodeX86("fmul", true, OD_ST_ST2));
                            this.put(203, new OpcodeX86("fmul", true, OD_ST_ST3));
                            this.put(204, new OpcodeX86("fmul", true, OD_ST_ST4));
                            this.put(205, new OpcodeX86("fmul", true, OD_ST_ST5));
                            this.put(206, new OpcodeX86("fmul", true, OD_ST_ST6));
                            this.put(207, new OpcodeX86("fmul", true, OD_ST_ST7));
                            this.put(208, new OpcodeX86("fcom", true, OD_ST_ST0));
                            this.put(209, new OpcodeX86("fcom", true, OD_ST_ST1));
                            this.put(210, new OpcodeX86("fcom", true, OD_ST_ST2));
                            this.put(211, new OpcodeX86("fcom", true, OD_ST_ST3));
                            this.put(212, new OpcodeX86("fcom", true, OD_ST_ST4));
                            this.put(213, new OpcodeX86("fcom", true, OD_ST_ST5));
                            this.put(214, new OpcodeX86("fcom", true, OD_ST_ST6));
                            this.put(215, new OpcodeX86("fcom", true, OD_ST_ST7));
                            this.put(216, new OpcodeX86("fcomp", true, OD_ST_ST0));
                            this.put(217, new OpcodeX86("fcomp", true, OD_ST_ST1));
                            this.put(218, new OpcodeX86("fcomp", true, OD_ST_ST2));
                            this.put(219, new OpcodeX86("fcomp", true, OD_ST_ST3));
                            this.put(220, new OpcodeX86("fcomp", true, OD_ST_ST4));
                            this.put(221, new OpcodeX86("fcomp", true, OD_ST_ST5));
                            this.put(222, new OpcodeX86("fcomp", true, OD_ST_ST6));
                            this.put(223, new OpcodeX86("fcomp", true, OD_ST_ST7));
                            this.put(224, new OpcodeX86("fsub", true, OD_ST_ST0));
                            this.put(225, new OpcodeX86("fsub", true, OD_ST_ST1));
                            this.put(226, new OpcodeX86("fsub", true, OD_ST_ST2));
                            this.put(227, new OpcodeX86("fsub", true, OD_ST_ST3));
                            this.put(228, new OpcodeX86("fsub", true, OD_ST_ST4));
                            this.put(229, new OpcodeX86("fsub", true, OD_ST_ST5));
                            this.put(230, new OpcodeX86("fsub", true, OD_ST_ST6));
                            this.put(231, new OpcodeX86("fsub", true, OD_ST_ST7));
                            this.put(232, new OpcodeX86("fsubr", true, OD_ST_ST0));
                            this.put(233, new OpcodeX86("fsubr", true, OD_ST_ST1));
                            this.put(234, new OpcodeX86("fsubr", true, OD_ST_ST2));
                            this.put(235, new OpcodeX86("fsubr", true, OD_ST_ST3));
                            this.put(236, new OpcodeX86("fsubr", true, OD_ST_ST4));
                            this.put(237, new OpcodeX86("fsubr", true, OD_ST_ST5));
                            this.put(238, new OpcodeX86("fsubr", true, OD_ST_ST6));
                            this.put(239, new OpcodeX86("fsubr", true, OD_ST_ST7));
                            this.put(240, new OpcodeX86("fdiv", true, OD_ST_ST0));
                            this.put(241, new OpcodeX86("fdiv", true, OD_ST_ST1));
                            this.put(242, new OpcodeX86("fdiv", true, OD_ST_ST2));
                            this.put(243, new OpcodeX86("fdiv", true, OD_ST_ST3));
                            this.put(244, new OpcodeX86("fdiv", true, OD_ST_ST4));
                            this.put(245, new OpcodeX86("fdiv", true, OD_ST_ST5));
                            this.put(246, new OpcodeX86("fdiv", true, OD_ST_ST6));
                            this.put(247, new OpcodeX86("fdiv", true, OD_ST_ST7));
                            this.put(248, new OpcodeX86("fdivr", true, OD_ST_ST0));
                            this.put(249, new OpcodeX86("fdivr", true, OD_ST_ST1));
                            this.put(250, new OpcodeX86("fdivr", true, OD_ST_ST2));
                            this.put(251, new OpcodeX86("fdivr", true, OD_ST_ST3));
                            this.put(252, new OpcodeX86("fdivr", true, OD_ST_ST4));
                            this.put(253, new OpcodeX86("fdivr", true, OD_ST_ST5));
                            this.put(254, new OpcodeX86("fdivr", true, OD_ST_ST6));
                            this.put(255, new OpcodeX86("fdivr", true, OD_ST_ST7));
                        }
                    });
                }
            });
            this.put(217, new ArrayList<Map<Integer, OpcodeX86>>(){
                {
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(0, new OpcodeX86("flds", true, OD_Ev));
                            this.put(1, sInvalidOpcode);
                            this.put(2, new OpcodeX86("fsts", true, OD_Ev));
                            this.put(3, new OpcodeX86("fstps", true, OD_Ev));
                            this.put(4, new OpcodeX86("fldenv", true, OD_Ev));
                            this.put(5, new OpcodeX86("fldcw", true, OD_Ev));
                            this.put(6, new OpcodeX86("fnstenv", true, OD_Ev));
                            this.put(7, new OpcodeX86("fnstcw", true, OD_Ev));
                        }
                    });
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(192, new OpcodeX86("fld", true, OD_ST0));
                            this.put(193, new OpcodeX86("fld", true, OD_ST1));
                            this.put(194, new OpcodeX86("fld", true, OD_ST2));
                            this.put(195, new OpcodeX86("fld", true, OD_ST3));
                            this.put(196, new OpcodeX86("fld", true, OD_ST4));
                            this.put(197, new OpcodeX86("fld", true, OD_ST5));
                            this.put(198, new OpcodeX86("fld", true, OD_ST6));
                            this.put(199, new OpcodeX86("fld", true, OD_ST7));
                            this.put(200, new OpcodeX86("fxch", true, OD_ST0));
                            this.put(201, new OpcodeX86("fxch", true, OD_ST1));
                            this.put(202, new OpcodeX86("fxch", true, OD_ST2));
                            this.put(203, new OpcodeX86("fxch", true, OD_ST3));
                            this.put(204, new OpcodeX86("fxch", true, OD_ST4));
                            this.put(205, new OpcodeX86("fxch", true, OD_ST5));
                            this.put(206, new OpcodeX86("fxch", true, OD_ST6));
                            this.put(207, new OpcodeX86("fxch", true, OD_ST7));
                            this.put(208, new OpcodeX86("fnop", true, OD_NO_OPERAND));
                            this.put(209, sInvalidOpcode);
                            this.put(210, sInvalidOpcode);
                            this.put(211, sInvalidOpcode);
                            this.put(212, sInvalidOpcode);
                            this.put(213, sInvalidOpcode);
                            this.put(214, sInvalidOpcode);
                            this.put(215, sInvalidOpcode);
                            this.put(216, sInvalidOpcode);
                            this.put(217, sInvalidOpcode);
                            this.put(218, sInvalidOpcode);
                            this.put(219, sInvalidOpcode);
                            this.put(220, sInvalidOpcode);
                            this.put(221, sInvalidOpcode);
                            this.put(222, sInvalidOpcode);
                            this.put(223, sInvalidOpcode);
                            this.put(224, new OpcodeX86("fchs", true, OD_NO_OPERAND));
                            this.put(225, new OpcodeX86("fabs", true, OD_NO_OPERAND));
                            this.put(226, sInvalidOpcode);
                            this.put(227, sInvalidOpcode);
                            this.put(228, new OpcodeX86("ftst", true, OD_NO_OPERAND));
                            this.put(229, new OpcodeX86("fxam", true, OD_NO_OPERAND));
                            this.put(230, sInvalidOpcode);
                            this.put(231, sInvalidOpcode);
                            this.put(232, new OpcodeX86("fld1", true, OD_NO_OPERAND));
                            this.put(233, new OpcodeX86("fldl2t", true, OD_NO_OPERAND));
                            this.put(234, new OpcodeX86("fldl2e", true, OD_NO_OPERAND));
                            this.put(235, new OpcodeX86("fldpi", true, OD_NO_OPERAND));
                            this.put(236, new OpcodeX86("fldlg2", true, OD_NO_OPERAND));
                            this.put(237, new OpcodeX86("fldln2", true, OD_NO_OPERAND));
                            this.put(238, new OpcodeX86("fldz", true, OD_NO_OPERAND));
                            this.put(239, sInvalidOpcode);
                            this.put(240, new OpcodeX86("f2xm1", true, OD_NO_OPERAND));
                            this.put(241, new OpcodeX86("fyl2x", true, OD_NO_OPERAND));
                            this.put(242, new OpcodeX86("fptan", true, OD_NO_OPERAND));
                            this.put(243, new OpcodeX86("fpatan", true, OD_NO_OPERAND));
                            this.put(244, new OpcodeX86("fxtract", true, OD_NO_OPERAND));
                            this.put(245, new OpcodeX86("fprem1", true, OD_NO_OPERAND));
                            this.put(246, new OpcodeX86("fdecstp", true, OD_NO_OPERAND));
                            this.put(247, new OpcodeX86("fincstp", true, OD_NO_OPERAND));
                            this.put(248, new OpcodeX86("fprem", true, OD_NO_OPERAND));
                            this.put(249, new OpcodeX86("fyl2xp1", true, OD_NO_OPERAND));
                            this.put(250, new OpcodeX86("fsqrt", true, OD_NO_OPERAND));
                            this.put(251, new OpcodeX86("fsincos", true, OD_NO_OPERAND));
                            this.put(252, new OpcodeX86("frndint", true, OD_NO_OPERAND));
                            this.put(253, new OpcodeX86("fscale", true, OD_NO_OPERAND));
                            this.put(254, new OpcodeX86("fsin", true, OD_NO_OPERAND));
                            this.put(255, new OpcodeX86("fcos", true, OD_NO_OPERAND));
                        }
                    });
                }
            });
            this.put(218, new ArrayList<Map<Integer, OpcodeX86>>(){
                {
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(0, new OpcodeX86("fiaddl", true, OD_Ev));
                            this.put(1, new OpcodeX86("fimull", true, OD_Ev));
                            this.put(2, new OpcodeX86("ficoml", true, OD_Ev));
                            this.put(3, new OpcodeX86("ficompl", true, OD_Ev));
                            this.put(4, new OpcodeX86("fisubl", true, OD_Ev));
                            this.put(5, new OpcodeX86("fisubrl", true, OD_Ev));
                            this.put(6, new OpcodeX86("fidivl", true, OD_Ev));
                            this.put(7, new OpcodeX86("fidivrl", true, OD_Ev));
                        }
                    });
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(192, new OpcodeX86("fcmovb", true, OD_ST_ST0));
                            this.put(193, new OpcodeX86("fcmovb", true, OD_ST_ST1));
                            this.put(194, new OpcodeX86("fcmovb", true, OD_ST_ST2));
                            this.put(195, new OpcodeX86("fcmovb", true, OD_ST_ST3));
                            this.put(196, new OpcodeX86("fcmovb", true, OD_ST_ST4));
                            this.put(197, new OpcodeX86("fcmovb", true, OD_ST_ST5));
                            this.put(198, new OpcodeX86("fcmovb", true, OD_ST_ST6));
                            this.put(199, new OpcodeX86("fcmovb", true, OD_ST_ST7));
                            this.put(200, new OpcodeX86("fcmove", true, OD_ST_ST0));
                            this.put(201, new OpcodeX86("fcmove", true, OD_ST_ST1));
                            this.put(202, new OpcodeX86("fcmove", true, OD_ST_ST2));
                            this.put(203, new OpcodeX86("fcmove", true, OD_ST_ST3));
                            this.put(204, new OpcodeX86("fcmove", true, OD_ST_ST4));
                            this.put(205, new OpcodeX86("fcmove", true, OD_ST_ST5));
                            this.put(206, new OpcodeX86("fcmove", true, OD_ST_ST6));
                            this.put(207, new OpcodeX86("fcmove", true, OD_ST_ST7));
                            this.put(208, new OpcodeX86("fcmovbe", true, OD_ST_ST0));
                            this.put(209, new OpcodeX86("fcmovbe", true, OD_ST_ST1));
                            this.put(210, new OpcodeX86("fcmovbe", true, OD_ST_ST2));
                            this.put(211, new OpcodeX86("fcmovbe", true, OD_ST_ST3));
                            this.put(212, new OpcodeX86("fcmovbe", true, OD_ST_ST4));
                            this.put(213, new OpcodeX86("fcmovbe", true, OD_ST_ST5));
                            this.put(214, new OpcodeX86("fcmovbe", true, OD_ST_ST6));
                            this.put(215, new OpcodeX86("fcmovbe", true, OD_ST_ST7));
                            this.put(216, new OpcodeX86("fcmovu", true, OD_ST_ST0));
                            this.put(217, new OpcodeX86("fcmovu", true, OD_ST_ST1));
                            this.put(218, new OpcodeX86("fcmovu", true, OD_ST_ST2));
                            this.put(219, new OpcodeX86("fcmovu", true, OD_ST_ST3));
                            this.put(220, new OpcodeX86("fcmovu", true, OD_ST_ST4));
                            this.put(221, new OpcodeX86("fcmovu", true, OD_ST_ST5));
                            this.put(222, new OpcodeX86("fcmovu", true, OD_ST_ST6));
                            this.put(223, new OpcodeX86("fcmovu", true, OD_ST_ST7));
                            this.put(224, sInvalidOpcode);
                            this.put(225, sInvalidOpcode);
                            this.put(226, sInvalidOpcode);
                            this.put(227, sInvalidOpcode);
                            this.put(228, sInvalidOpcode);
                            this.put(229, sInvalidOpcode);
                            this.put(230, sInvalidOpcode);
                            this.put(231, sInvalidOpcode);
                            this.put(232, sInvalidOpcode);
                            this.put(233, new OpcodeX86("fucompp", true, OD_NO_OPERAND));
                            this.put(234, sInvalidOpcode);
                            this.put(235, sInvalidOpcode);
                            this.put(236, sInvalidOpcode);
                            this.put(237, sInvalidOpcode);
                            this.put(238, sInvalidOpcode);
                            this.put(239, sInvalidOpcode);
                            this.put(240, sInvalidOpcode);
                            this.put(241, sInvalidOpcode);
                            this.put(242, sInvalidOpcode);
                            this.put(243, sInvalidOpcode);
                            this.put(244, sInvalidOpcode);
                            this.put(245, sInvalidOpcode);
                            this.put(246, sInvalidOpcode);
                            this.put(247, sInvalidOpcode);
                            this.put(248, sInvalidOpcode);
                            this.put(249, sInvalidOpcode);
                            this.put(250, sInvalidOpcode);
                            this.put(251, sInvalidOpcode);
                            this.put(252, sInvalidOpcode);
                            this.put(253, sInvalidOpcode);
                            this.put(254, sInvalidOpcode);
                            this.put(255, sInvalidOpcode);
                        }
                    });
                }
            });
            this.put(219, new ArrayList<Map<Integer, OpcodeX86>>(){
                {
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(0, new OpcodeX86("fildl", true, OD_Ev));
                            this.put(1, new OpcodeX86("fisttpl", true, OD_Ev));
                            this.put(2, new OpcodeX86("fistl", true, OD_Ev));
                            this.put(3, new OpcodeX86("fistpl", true, OD_Ev));
                            this.put(4, sInvalidOpcode);
                            this.put(5, new OpcodeX86("fldt", true, OD_Ev));
                            this.put(6, sInvalidOpcode);
                            this.put(7, new OpcodeX86("fstpt", true, OD_Ev));
                        }
                    });
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(192, new OpcodeX86("fcmovnb", true, OD_ST_ST0));
                            this.put(193, new OpcodeX86("fcmovnb", true, OD_ST_ST1));
                            this.put(194, new OpcodeX86("fcmovnb", true, OD_ST_ST2));
                            this.put(195, new OpcodeX86("fcmovnb", true, OD_ST_ST3));
                            this.put(196, new OpcodeX86("fcmovnb", true, OD_ST_ST4));
                            this.put(197, new OpcodeX86("fcmovnb", true, OD_ST_ST5));
                            this.put(198, new OpcodeX86("fcmovnb", true, OD_ST_ST6));
                            this.put(199, new OpcodeX86("fcmovnb", true, OD_ST_ST7));
                            this.put(200, new OpcodeX86("fcmovne", true, OD_ST_ST0));
                            this.put(201, new OpcodeX86("fcmovne", true, OD_ST_ST1));
                            this.put(202, new OpcodeX86("fcmovne", true, OD_ST_ST2));
                            this.put(203, new OpcodeX86("fcmovne", true, OD_ST_ST3));
                            this.put(204, new OpcodeX86("fcmovne", true, OD_ST_ST4));
                            this.put(205, new OpcodeX86("fcmovne", true, OD_ST_ST5));
                            this.put(206, new OpcodeX86("fcmovne", true, OD_ST_ST6));
                            this.put(207, new OpcodeX86("fcmovne", true, OD_ST_ST7));
                            this.put(208, new OpcodeX86("fcmovnbe", true, OD_ST_ST0));
                            this.put(209, new OpcodeX86("fcmovnbe", true, OD_ST_ST1));
                            this.put(210, new OpcodeX86("fcmovnbe", true, OD_ST_ST2));
                            this.put(211, new OpcodeX86("fcmovnbe", true, OD_ST_ST3));
                            this.put(212, new OpcodeX86("fcmovnbe", true, OD_ST_ST4));
                            this.put(213, new OpcodeX86("fcmovnbe", true, OD_ST_ST5));
                            this.put(214, new OpcodeX86("fcmovnbe", true, OD_ST_ST6));
                            this.put(215, new OpcodeX86("fcmovnbe", true, OD_ST_ST7));
                            this.put(216, new OpcodeX86("fcmovnu", true, OD_ST_ST0));
                            this.put(217, new OpcodeX86("fcmovnu", true, OD_ST_ST1));
                            this.put(218, new OpcodeX86("fcmovnu", true, OD_ST_ST2));
                            this.put(219, new OpcodeX86("fcmovnu", true, OD_ST_ST3));
                            this.put(220, new OpcodeX86("fcmovnu", true, OD_ST_ST4));
                            this.put(221, new OpcodeX86("fcmovnu", true, OD_ST_ST5));
                            this.put(222, new OpcodeX86("fcmovnu", true, OD_ST_ST6));
                            this.put(223, new OpcodeX86("fcmovnu", true, OD_ST_ST7));
                            this.put(224, sInvalidOpcode);
                            this.put(225, sInvalidOpcode);
                            this.put(226, new OpcodeX86("fclex", true, OD_NO_OPERAND));
                            this.put(227, new OpcodeX86("finit", true, OD_NO_OPERAND));
                            this.put(228, sInvalidOpcode);
                            this.put(229, sInvalidOpcode);
                            this.put(230, sInvalidOpcode);
                            this.put(231, sInvalidOpcode);
                            this.put(232, new OpcodeX86("fucomi", true, OD_ST_ST0));
                            this.put(233, new OpcodeX86("fucomi", true, OD_ST_ST1));
                            this.put(234, new OpcodeX86("fucomi", true, OD_ST_ST2));
                            this.put(235, new OpcodeX86("fucomi", true, OD_ST_ST3));
                            this.put(236, new OpcodeX86("fucomi", true, OD_ST_ST4));
                            this.put(237, new OpcodeX86("fucomi", true, OD_ST_ST5));
                            this.put(238, new OpcodeX86("fucomi", true, OD_ST_ST6));
                            this.put(239, new OpcodeX86("fucomi", true, OD_ST_ST7));
                            this.put(240, new OpcodeX86("fcomi", true, OD_ST_ST0));
                            this.put(241, new OpcodeX86("fcomi", true, OD_ST_ST1));
                            this.put(242, new OpcodeX86("fcomi", true, OD_ST_ST2));
                            this.put(243, new OpcodeX86("fcomi", true, OD_ST_ST3));
                            this.put(244, new OpcodeX86("fcomi", true, OD_ST_ST4));
                            this.put(245, new OpcodeX86("fcomi", true, OD_ST_ST5));
                            this.put(246, new OpcodeX86("fcomi", true, OD_ST_ST6));
                            this.put(247, new OpcodeX86("fcomi", true, OD_ST_ST7));
                            this.put(248, sInvalidOpcode);
                            this.put(249, sInvalidOpcode);
                            this.put(250, sInvalidOpcode);
                            this.put(251, sInvalidOpcode);
                            this.put(252, sInvalidOpcode);
                            this.put(253, sInvalidOpcode);
                            this.put(254, sInvalidOpcode);
                            this.put(255, sInvalidOpcode);
                        }
                    });
                }
            });
            this.put(220, new ArrayList<Map<Integer, OpcodeX86>>(){
                {
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(0, new OpcodeX86("faddl", true, OD_Ev));
                            this.put(1, new OpcodeX86("fmull", true, OD_Ev));
                            this.put(2, new OpcodeX86("fcoml", true, OD_Ev));
                            this.put(3, new OpcodeX86("fcompl", true, OD_Ev));
                            this.put(4, new OpcodeX86("fsubl", true, OD_Ev));
                            this.put(5, new OpcodeX86("fsubrl", true, OD_Ev));
                            this.put(6, new OpcodeX86("fdivl", true, OD_Ev));
                            this.put(7, new OpcodeX86("fdivrl", true, OD_Ev));
                        }
                    });
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(192, new OpcodeX86("fadd", true, OD_ST0_ST));
                            this.put(193, new OpcodeX86("fadd", true, OD_ST1_ST));
                            this.put(194, new OpcodeX86("fadd", true, OD_ST2_ST));
                            this.put(195, new OpcodeX86("fadd", true, OD_ST3_ST));
                            this.put(196, new OpcodeX86("fadd", true, OD_ST4_ST));
                            this.put(197, new OpcodeX86("fadd", true, OD_ST5_ST));
                            this.put(198, new OpcodeX86("fadd", true, OD_ST6_ST));
                            this.put(199, new OpcodeX86("fadd", true, OD_ST7_ST));
                            this.put(200, new OpcodeX86("fmul", true, OD_ST0_ST));
                            this.put(201, new OpcodeX86("fmul", true, OD_ST1_ST));
                            this.put(202, new OpcodeX86("fmul", true, OD_ST2_ST));
                            this.put(203, new OpcodeX86("fmul", true, OD_ST3_ST));
                            this.put(204, new OpcodeX86("fmul", true, OD_ST4_ST));
                            this.put(205, new OpcodeX86("fmul", true, OD_ST5_ST));
                            this.put(206, new OpcodeX86("fmul", true, OD_ST6_ST));
                            this.put(207, new OpcodeX86("fmul", true, OD_ST7_ST));
                            this.put(208, sInvalidOpcode);
                            this.put(209, sInvalidOpcode);
                            this.put(210, sInvalidOpcode);
                            this.put(211, sInvalidOpcode);
                            this.put(212, sInvalidOpcode);
                            this.put(213, sInvalidOpcode);
                            this.put(214, sInvalidOpcode);
                            this.put(215, sInvalidOpcode);
                            this.put(216, sInvalidOpcode);
                            this.put(217, sInvalidOpcode);
                            this.put(218, sInvalidOpcode);
                            this.put(219, sInvalidOpcode);
                            this.put(220, sInvalidOpcode);
                            this.put(221, sInvalidOpcode);
                            this.put(222, sInvalidOpcode);
                            this.put(223, sInvalidOpcode);
                            this.put(224, new OpcodeX86("fsubr", true, OD_ST0_ST));
                            this.put(225, new OpcodeX86("fsubr", true, OD_ST1_ST));
                            this.put(226, new OpcodeX86("fsubr", true, OD_ST2_ST));
                            this.put(227, new OpcodeX86("fsubr", true, OD_ST3_ST));
                            this.put(228, new OpcodeX86("fsubr", true, OD_ST4_ST));
                            this.put(229, new OpcodeX86("fsubr", true, OD_ST5_ST));
                            this.put(230, new OpcodeX86("fsubr", true, OD_ST6_ST));
                            this.put(231, new OpcodeX86("fsubr", true, OD_ST7_ST));
                            this.put(232, new OpcodeX86("fsub", true, OD_ST0_ST));
                            this.put(233, new OpcodeX86("fsub", true, OD_ST1_ST));
                            this.put(234, new OpcodeX86("fsub", true, OD_ST2_ST));
                            this.put(235, new OpcodeX86("fsub", true, OD_ST3_ST));
                            this.put(236, new OpcodeX86("fsub", true, OD_ST4_ST));
                            this.put(237, new OpcodeX86("fsub", true, OD_ST5_ST));
                            this.put(238, new OpcodeX86("fsub", true, OD_ST6_ST));
                            this.put(239, new OpcodeX86("fsub", true, OD_ST7_ST));
                            this.put(240, new OpcodeX86("fdivr", true, OD_ST0_ST));
                            this.put(241, new OpcodeX86("fdivr", true, OD_ST1_ST));
                            this.put(242, new OpcodeX86("fdivr", true, OD_ST2_ST));
                            this.put(243, new OpcodeX86("fdivr", true, OD_ST3_ST));
                            this.put(244, new OpcodeX86("fdivr", true, OD_ST4_ST));
                            this.put(245, new OpcodeX86("fdivr", true, OD_ST5_ST));
                            this.put(246, new OpcodeX86("fdivr", true, OD_ST6_ST));
                            this.put(247, new OpcodeX86("fdivr", true, OD_ST7_ST));
                            this.put(248, new OpcodeX86("fdiv", true, OD_ST0_ST));
                            this.put(249, new OpcodeX86("fdiv", true, OD_ST1_ST));
                            this.put(250, new OpcodeX86("fdiv", true, OD_ST2_ST));
                            this.put(251, new OpcodeX86("fdiv", true, OD_ST3_ST));
                            this.put(252, new OpcodeX86("fdiv", true, OD_ST4_ST));
                            this.put(253, new OpcodeX86("fdiv", true, OD_ST5_ST));
                            this.put(254, new OpcodeX86("fdiv", true, OD_ST6_ST));
                            this.put(255, new OpcodeX86("fdiv", true, OD_ST7_ST));
                        }
                    });
                }
            });
            this.put(221, new ArrayList<Map<Integer, OpcodeX86>>(){
                {
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(0, new OpcodeX86("fldl", true, OD_Ev));
                            this.put(1, new OpcodeX86("fisttpll", true, OD_Ev));
                            this.put(2, new OpcodeX86("fstl", true, OD_Ev));
                            this.put(3, new OpcodeX86("fstpl", true, OD_Ev));
                            this.put(4, new OpcodeX86("frstor", true, OD_Ev));
                            this.put(5, sInvalidOpcode);
                            this.put(6, new OpcodeX86("fnsave", true, OD_Ev));
                            this.put(7, new OpcodeX86("fnstsw", true, OD_Ev));
                        }
                    });
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(192, new OpcodeX86("ffree", true, OD_ST0));
                            this.put(193, new OpcodeX86("ffree", true, OD_ST1));
                            this.put(194, new OpcodeX86("ffree", true, OD_ST2));
                            this.put(195, new OpcodeX86("ffree", true, OD_ST3));
                            this.put(196, new OpcodeX86("ffree", true, OD_ST4));
                            this.put(197, new OpcodeX86("ffree", true, OD_ST5));
                            this.put(198, new OpcodeX86("ffree", true, OD_ST6));
                            this.put(199, new OpcodeX86("ffree", true, OD_ST7));
                            this.put(200, sInvalidOpcode);
                            this.put(201, sInvalidOpcode);
                            this.put(202, sInvalidOpcode);
                            this.put(203, sInvalidOpcode);
                            this.put(204, sInvalidOpcode);
                            this.put(205, sInvalidOpcode);
                            this.put(206, sInvalidOpcode);
                            this.put(207, sInvalidOpcode);
                            this.put(208, new OpcodeX86("fst", true, OD_ST0));
                            this.put(209, new OpcodeX86("fst", true, OD_ST1));
                            this.put(210, new OpcodeX86("fst", true, OD_ST2));
                            this.put(211, new OpcodeX86("fst", true, OD_ST3));
                            this.put(212, new OpcodeX86("fst", true, OD_ST4));
                            this.put(213, new OpcodeX86("fst", true, OD_ST5));
                            this.put(214, new OpcodeX86("fst", true, OD_ST6));
                            this.put(215, new OpcodeX86("fst", true, OD_ST7));
                            this.put(216, new OpcodeX86("fstp", true, OD_ST0));
                            this.put(217, new OpcodeX86("fstp", true, OD_ST1));
                            this.put(218, new OpcodeX86("fstp", true, OD_ST2));
                            this.put(219, new OpcodeX86("fstp", true, OD_ST3));
                            this.put(220, new OpcodeX86("fstp", true, OD_ST4));
                            this.put(221, new OpcodeX86("fstp", true, OD_ST5));
                            this.put(222, new OpcodeX86("fstp", true, OD_ST6));
                            this.put(223, new OpcodeX86("fstp", true, OD_ST7));
                            this.put(224, new OpcodeX86("fucom", true, OD_ST0));
                            this.put(225, new OpcodeX86("fucom", true, OD_ST1));
                            this.put(226, new OpcodeX86("fucom", true, OD_ST2));
                            this.put(227, new OpcodeX86("fucom", true, OD_ST3));
                            this.put(228, new OpcodeX86("fucom", true, OD_ST4));
                            this.put(229, new OpcodeX86("fucom", true, OD_ST5));
                            this.put(230, new OpcodeX86("fucom", true, OD_ST6));
                            this.put(231, new OpcodeX86("fucom", true, OD_ST7));
                            this.put(232, new OpcodeX86("fucomp", true, OD_ST0));
                            this.put(233, new OpcodeX86("fucomp", true, OD_ST1));
                            this.put(234, new OpcodeX86("fucomp", true, OD_ST2));
                            this.put(235, new OpcodeX86("fucomp", true, OD_ST3));
                            this.put(236, new OpcodeX86("fucomp", true, OD_ST4));
                            this.put(237, new OpcodeX86("fucomp", true, OD_ST5));
                            this.put(238, new OpcodeX86("fucomp", true, OD_ST6));
                            this.put(239, new OpcodeX86("fucomp", true, OD_ST7));
                            this.put(240, sInvalidOpcode);
                            this.put(241, sInvalidOpcode);
                            this.put(242, sInvalidOpcode);
                            this.put(243, sInvalidOpcode);
                            this.put(244, sInvalidOpcode);
                            this.put(245, sInvalidOpcode);
                            this.put(246, sInvalidOpcode);
                            this.put(247, sInvalidOpcode);
                            this.put(248, sInvalidOpcode);
                            this.put(249, sInvalidOpcode);
                            this.put(250, sInvalidOpcode);
                            this.put(251, sInvalidOpcode);
                            this.put(252, sInvalidOpcode);
                            this.put(253, sInvalidOpcode);
                            this.put(254, sInvalidOpcode);
                            this.put(255, sInvalidOpcode);
                        }
                    });
                }
            });
            this.put(222, new ArrayList<Map<Integer, OpcodeX86>>(){
                {
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(0, new OpcodeX86("fiadd", true, OD_Ev));
                            this.put(1, new OpcodeX86("fimul", true, OD_Ev));
                            this.put(2, new OpcodeX86("ficom", true, OD_Ev));
                            this.put(3, new OpcodeX86("ficomp", true, OD_Ev));
                            this.put(4, new OpcodeX86("fisub", true, OD_Ev));
                            this.put(5, new OpcodeX86("fisubr", true, OD_Ev));
                            this.put(6, new OpcodeX86("fidiv", true, OD_Ev));
                            this.put(7, new OpcodeX86("fidivr", true, OD_Ev));
                        }
                    });
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(192, new OpcodeX86("faddp", true, OD_ST0_ST));
                            this.put(193, new OpcodeX86("faddp", true, OD_ST1_ST));
                            this.put(194, new OpcodeX86("faddp", true, OD_ST2_ST));
                            this.put(195, new OpcodeX86("faddp", true, OD_ST3_ST));
                            this.put(196, new OpcodeX86("faddp", true, OD_ST4_ST));
                            this.put(197, new OpcodeX86("faddp", true, OD_ST5_ST));
                            this.put(198, new OpcodeX86("faddp", true, OD_ST6_ST));
                            this.put(199, new OpcodeX86("faddp", true, OD_ST7_ST));
                            this.put(200, new OpcodeX86("fmulp", true, OD_ST0_ST));
                            this.put(201, new OpcodeX86("fmulp", true, OD_ST1_ST));
                            this.put(202, new OpcodeX86("fmulp", true, OD_ST2_ST));
                            this.put(203, new OpcodeX86("fmulp", true, OD_ST3_ST));
                            this.put(204, new OpcodeX86("fmulp", true, OD_ST4_ST));
                            this.put(205, new OpcodeX86("fmulp", true, OD_ST5_ST));
                            this.put(206, new OpcodeX86("fmulp", true, OD_ST6_ST));
                            this.put(207, new OpcodeX86("fmulp", true, OD_ST7_ST));
                            this.put(208, sInvalidOpcode);
                            this.put(209, sInvalidOpcode);
                            this.put(210, sInvalidOpcode);
                            this.put(211, sInvalidOpcode);
                            this.put(212, sInvalidOpcode);
                            this.put(213, sInvalidOpcode);
                            this.put(214, sInvalidOpcode);
                            this.put(215, sInvalidOpcode);
                            this.put(216, sInvalidOpcode);
                            this.put(217, new OpcodeX86("fcompp", true, OD_NO_OPERAND));
                            this.put(218, sInvalidOpcode);
                            this.put(219, sInvalidOpcode);
                            this.put(220, sInvalidOpcode);
                            this.put(221, sInvalidOpcode);
                            this.put(222, sInvalidOpcode);
                            this.put(223, sInvalidOpcode);
                            this.put(224, new OpcodeX86("fsubrp", true, OD_ST0_ST));
                            this.put(225, new OpcodeX86("fsubrp", true, OD_ST1_ST));
                            this.put(226, new OpcodeX86("fsubrp", true, OD_ST2_ST));
                            this.put(227, new OpcodeX86("fsubrp", true, OD_ST3_ST));
                            this.put(228, new OpcodeX86("fsubrp", true, OD_ST4_ST));
                            this.put(229, new OpcodeX86("fsubrp", true, OD_ST5_ST));
                            this.put(230, new OpcodeX86("fsubrp", true, OD_ST6_ST));
                            this.put(231, new OpcodeX86("fsubrp", true, OD_ST7_ST));
                            this.put(232, new OpcodeX86("fsubp", true, OD_ST0_ST));
                            this.put(233, new OpcodeX86("fsubp", true, OD_ST1_ST));
                            this.put(234, new OpcodeX86("fsubp", true, OD_ST2_ST));
                            this.put(235, new OpcodeX86("fsubp", true, OD_ST3_ST));
                            this.put(236, new OpcodeX86("fsubp", true, OD_ST4_ST));
                            this.put(237, new OpcodeX86("fsubp", true, OD_ST5_ST));
                            this.put(238, new OpcodeX86("fsubp", true, OD_ST6_ST));
                            this.put(239, new OpcodeX86("fsubp", true, OD_ST7_ST));
                            this.put(240, new OpcodeX86("fdivrp", true, OD_ST0_ST));
                            this.put(241, new OpcodeX86("fdivrp", true, OD_ST1_ST));
                            this.put(242, new OpcodeX86("fdivrp", true, OD_ST2_ST));
                            this.put(243, new OpcodeX86("fdivrp", true, OD_ST3_ST));
                            this.put(244, new OpcodeX86("fdivrp", true, OD_ST4_ST));
                            this.put(245, new OpcodeX86("fdivrp", true, OD_ST5_ST));
                            this.put(246, new OpcodeX86("fdivrp", true, OD_ST6_ST));
                            this.put(247, new OpcodeX86("fdivrp", true, OD_ST7_ST));
                            this.put(248, new OpcodeX86("fdivp", true, OD_ST0_ST));
                            this.put(249, new OpcodeX86("fdivp", true, OD_ST1_ST));
                            this.put(250, new OpcodeX86("fdivp", true, OD_ST2_ST));
                            this.put(251, new OpcodeX86("fdivp", true, OD_ST3_ST));
                            this.put(252, new OpcodeX86("fdivp", true, OD_ST4_ST));
                            this.put(253, new OpcodeX86("fdivp", true, OD_ST5_ST));
                            this.put(254, new OpcodeX86("fdivp", true, OD_ST6_ST));
                            this.put(255, new OpcodeX86("fdivp", true, OD_ST7_ST));
                        }
                    });
                }
            });
            this.put(223, new ArrayList<Map<Integer, OpcodeX86>>(){
                {
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(0, new OpcodeX86("fild", true, OD_Ev));
                            this.put(1, new OpcodeX86("fisttp", true, OD_Ev));
                            this.put(2, new OpcodeX86("fist", true, OD_Ev));
                            this.put(3, new OpcodeX86("fistp", true, OD_Ev));
                            this.put(4, new OpcodeX86("fbld", true, OD_Ev));
                            this.put(5, new OpcodeX86("fildll", true, OD_Ev));
                            this.put(6, new OpcodeX86("fbstp", true, OD_Ev));
                            this.put(7, new OpcodeX86("fistpll", true, OD_Ev));
                        }
                    });
                    this.add(new HashMap<Integer, OpcodeX86>(){
                        {
                            this.put(192, sInvalidOpcode);
                            this.put(193, sInvalidOpcode);
                            this.put(194, sInvalidOpcode);
                            this.put(195, sInvalidOpcode);
                            this.put(196, sInvalidOpcode);
                            this.put(197, sInvalidOpcode);
                            this.put(198, sInvalidOpcode);
                            this.put(199, sInvalidOpcode);
                            this.put(200, sInvalidOpcode);
                            this.put(201, sInvalidOpcode);
                            this.put(202, sInvalidOpcode);
                            this.put(203, sInvalidOpcode);
                            this.put(204, sInvalidOpcode);
                            this.put(205, sInvalidOpcode);
                            this.put(206, sInvalidOpcode);
                            this.put(207, sInvalidOpcode);
                            this.put(208, sInvalidOpcode);
                            this.put(209, sInvalidOpcode);
                            this.put(210, sInvalidOpcode);
                            this.put(211, sInvalidOpcode);
                            this.put(212, sInvalidOpcode);
                            this.put(213, sInvalidOpcode);
                            this.put(214, sInvalidOpcode);
                            this.put(215, sInvalidOpcode);
                            this.put(216, sInvalidOpcode);
                            this.put(217, sInvalidOpcode);
                            this.put(218, sInvalidOpcode);
                            this.put(219, sInvalidOpcode);
                            this.put(220, sInvalidOpcode);
                            this.put(221, sInvalidOpcode);
                            this.put(222, sInvalidOpcode);
                            this.put(223, sInvalidOpcode);
                            this.put(224, new OpcodeX86("fnstsw", true, OD_AX));
                            this.put(225, sInvalidOpcode);
                            this.put(226, sInvalidOpcode);
                            this.put(227, sInvalidOpcode);
                            this.put(228, sInvalidOpcode);
                            this.put(229, sInvalidOpcode);
                            this.put(230, sInvalidOpcode);
                            this.put(231, sInvalidOpcode);
                            this.put(232, new OpcodeX86("fucomip", true, OD_ST_ST0));
                            this.put(233, new OpcodeX86("fucomip", true, OD_ST_ST1));
                            this.put(234, new OpcodeX86("fucomip", true, OD_ST_ST2));
                            this.put(235, new OpcodeX86("fucomip", true, OD_ST_ST3));
                            this.put(236, new OpcodeX86("fucomip", true, OD_ST_ST4));
                            this.put(237, new OpcodeX86("fucomip", true, OD_ST_ST5));
                            this.put(238, new OpcodeX86("fucomip", true, OD_ST_ST6));
                            this.put(239, new OpcodeX86("fucomip", true, OD_ST_ST7));
                            this.put(240, new OpcodeX86("fcomip", true, OD_ST_ST0));
                            this.put(241, new OpcodeX86("fcomip", true, OD_ST_ST1));
                            this.put(242, new OpcodeX86("fcomip", true, OD_ST_ST2));
                            this.put(243, new OpcodeX86("fcomip", true, OD_ST_ST3));
                            this.put(244, new OpcodeX86("fcomip", true, OD_ST_ST4));
                            this.put(245, new OpcodeX86("fcomip", true, OD_ST_ST5));
                            this.put(246, new OpcodeX86("fcomip", true, OD_ST_ST6));
                            this.put(247, new OpcodeX86("fcomip", true, OD_ST_ST7));
                            this.put(248, sInvalidOpcode);
                            this.put(249, sInvalidOpcode);
                            this.put(250, sInvalidOpcode);
                            this.put(251, sInvalidOpcode);
                            this.put(252, sInvalidOpcode);
                            this.put(253, sInvalidOpcode);
                            this.put(254, sInvalidOpcode);
                            this.put(255, sInvalidOpcode);
                        }
                    });
                }
            });
        }
    };

    public OpcodeX86(String name, boolean needModRM, String[] operandDescriptors) {
        this.needModRM = needModRM;
        this.name = name;
        this.operandDescriptors = operandDescriptors;
    }

    public String getName() {
        return this.name;
    }

    public boolean needModRM() {
        return this.needModRM;
    }

    public String[] getOperandDescriptors() {
        return this.operandDescriptors;
    }

    public String toString() {
        return String.valueOf(this.name) + " " + Arrays.toString(this.operandDescriptors) + "\nNeed ModRM : " + this.needModRM;
    }

    public static OpcodeX86 selectExtensionOpcodeByRM(int opcodeID, InstructionParserX86.ModRM modrm) {
        OpcodeX86 opc = null;
        if (opcodeID == 1 && modrm.mod == 3) {
            block0 : switch (modrm.reg) {
                case 0: {
                    switch (modrm.rm) {
                        case 1: {
                            opc = new OpcodeX86("vmcall", true, OD_NO_OPERAND);
                            break block0;
                        }
                        case 2: {
                            opc = new OpcodeX86("vmlaunch", true, OD_NO_OPERAND);
                            break block0;
                        }
                        case 3: {
                            opc = new OpcodeX86("vmresume", true, OD_NO_OPERAND);
                            break block0;
                        }
                        case 4: {
                            opc = new OpcodeX86("vmxoff", true, OD_NO_OPERAND);
                            break block0;
                        }
                    }
                    opc = sInvalidOpcode;
                    break;
                }
                case 1: {
                    switch (modrm.rm) {
                        case 0: {
                            opc = new OpcodeX86("monitor", true, OD_NO_OPERAND);
                            break block0;
                        }
                        case 1: {
                            opc = new OpcodeX86("mwait", true, OD_NO_OPERAND);
                            break block0;
                        }
                    }
                    opc = sInvalidOpcode;
                    break;
                }
                case 2: {
                    switch (modrm.rm) {
                        case 0: {
                            opc = new OpcodeX86("xgetbv", true, OD_NO_OPERAND);
                            break block0;
                        }
                        case 1: {
                            opc = new OpcodeX86("xsetbv", true, OD_NO_OPERAND);
                            break block0;
                        }
                    }
                    opc = sInvalidOpcode;
                    break;
                }
                case 7: {
                    switch (modrm.rm) {
                        case 0: {
                            opc = new OpcodeX86("swapgs", true, OD_NO_OPERAND);
                            break block0;
                        }
                        case 1: {
                            opc = new OpcodeX86("rdtscp", true, OD_NO_OPERAND);
                            break block0;
                        }
                    }
                    opc = sInvalidOpcode;
                    break;
                }
                default: {
                    assert (false) : "Should not get here.";
                    break;
                }
            }
        }
        return opc;
    }
}

