/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.formatter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.formatter.IVariableFormatManager;
import org.eclipse.cdt.debug.edc.internal.formatter.IVariableFormatProviderChooser;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatExtensionManager
implements IVariableFormatManager {
    public static final String VARIABLE_FORMATS_ENABLED = "variable_formats_enabled";
    public static final boolean VARIABLE_FORMATS_ENABLED_DEFAULT = true;
    private static IVariableFormatManager instance = new FormatExtensionManager(new DefaultFormatProviderChooser());
    private Map<String, FormatProviderExtension> formatProviders;
    private IVariableFormatProviderChooser chooser;
    private boolean enabled = true;

    public static IVariableFormatManager instance() {
        return instance;
    }

    private FormatExtensionManager(IVariableFormatProviderChooser chooser) {
        this.readProviders();
        this.setFormatProviderChooser(chooser);
        IEclipsePreferences scope = new InstanceScope().getNode("org.eclipse.cdt.debug.edc");
        this.enabled = scope.getBoolean(VARIABLE_FORMATS_ENABLED, true);
    }

    private void readProviders() {
        IConfigurationElement[] elements;
        if (this.formatProviders != null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.debug.edc.variableFormatProvider");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String id = element.getAttribute("id");
                String label = element.getAttribute("label");
                IVariableFormatProvider formatProvider = (IVariableFormatProvider)element.createExecutableExtension("class");
                if (this.formatProviders == null) {
                    this.formatProviders = new HashMap<String, FormatProviderExtension>();
                }
                this.formatProviders.put(id, new FormatProviderExtension(label, formatProvider));
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError("Could not create formatting extension", e);
            }
            ++n2;
        }
    }

    private <T> T getProvider(IType type, Getter<T> getter) {
        if (!this.enabled) {
            return null;
        }
        HashMap<String, T> providers = new HashMap<String, T>();
        for (Map.Entry<String, FormatProviderExtension> entry : this.formatProviders.entrySet()) {
            IVariableFormatProvider fp = entry.getValue().getFormatProvider();
            T t = getter.get(fp, type);
            if (t == null) continue;
            providers.put(entry.getKey(), t);
        }
        String id = getter.choose(type, providers.keySet());
        return (T)providers.get(id);
    }

    @Override
    public ITypeContentProvider getTypeContentProvider(IType type) {
        return this.getProvider(type, new Getter<ITypeContentProvider>(){

            @Override
            public ITypeContentProvider get(IVariableFormatProvider fp, IType type) {
                return fp.getTypeContentProvider(type);
            }

            @Override
            public String choose(IType type, Collection<String> ids) {
                return FormatExtensionManager.this.chooser.chooseTypeContentProvider(type, ids);
            }
        });
    }

    @Override
    public IVariableValueConverter getVariableValueConverter(IType type) {
        return this.getProvider(type, new Getter<IVariableValueConverter>(){

            @Override
            public IVariableValueConverter get(IVariableFormatProvider fp, IType type) {
                return fp.getVariableValueConverter(type);
            }

            @Override
            public String choose(IType type, Collection<String> ids) {
                return FormatExtensionManager.this.chooser.chooseVariableValueConverter(type, ids);
            }
        });
    }

    @Override
    public IVariableValueConverter getDetailValueConverter(IType type) {
        return this.getProvider(type, new Getter<IVariableValueConverter>(){

            @Override
            public IVariableValueConverter get(IVariableFormatProvider fp, IType type) {
                return fp.getDetailValueConverter(type);
            }

            @Override
            public String choose(IType type, Collection<String> ids) {
                return FormatExtensionManager.this.chooser.chooseDetailValueConverter(type, ids);
            }
        });
    }

    @Override
    public void setFormatProviderChooser(IVariableFormatProviderChooser chooser) {
        this.chooser = chooser;
    }

    @Override
    public String[] getVariableFormatProviderIds() {
        Set<String> keySet = this.formatProviders.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    @Override
    public String getFormatProviderLabel(String id) {
        return this.formatProviders.get(id).getLabel();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultFormatProviderChooser
    implements IVariableFormatProviderChooser {
        private static final String DEFAULT_COMPOSITE = "org.eclipse.cdt.debug.edc.formatter.default.composite";
        private static final String DEFAULT_ARRAY = "org.eclipse.cdt.debug.edc.formatter.default.array";

        private DefaultFormatProviderChooser() {
        }

        @Override
        public String chooseDetailValueConverter(IType type, Collection<String> ids) {
            return this.chooseAnyBeforeDefault(ids);
        }

        @Override
        public String chooseTypeContentProvider(IType type, Collection<String> ids) {
            return this.chooseAnyBeforeDefault(ids);
        }

        @Override
        public String chooseVariableValueConverter(IType type, Collection<String> ids) {
            return this.chooseAnyBeforeDefault(ids);
        }

        private String chooseAnyBeforeDefault(Collection<String> ids) {
            if (ids.size() > 1) {
                for (String id : ids) {
                    if (id.equals(DEFAULT_COMPOSITE) || id.equals(DEFAULT_ARRAY)) continue;
                    return id;
                }
            } else if (ids.size() == 1) {
                return ids.iterator().next();
            }
            return null;
        }
    }

    public class FormatProviderExtension {
        private String label;
        private IVariableFormatProvider formatProvider;

        public FormatProviderExtension(String label, IVariableFormatProvider formatProvider) {
            this.label = label;
            this.formatProvider = formatProvider;
        }

        public String getLabel() {
            return this.label;
        }

        public IVariableFormatProvider getFormatProvider() {
            return this.formatProvider;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Getter<T> {
        public T get(IVariableFormatProvider var1, IType var2);

        public String choose(IType var1, Collection<String> var2);
    }
}

