/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Breakpoints;
import org.eclipse.cdt.debug.edc.internal.services.dsf.MemoryCache;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.IDSFServiceUsingTCF;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.IEDCMemory;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.tm.tcf.protocol.IService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Memory
extends AbstractEDCService
implements IEDCMemory,
ICachingService,
ISnapshotContributor,
IDSFServiceUsingTCF {
    private org.eclipse.tm.tcf.services.IMemory tcfMemoryService;
    private Map<String, MemoryCache> memoryCaches;
    private static final String MEMORY_CONTEXT = "memory_context";
    private static final String MEMORY = "memory";
    private static final String CONTEXT_ID = "context_id";

    public Memory(DsfSession session) {
        super(session, new String[]{IEDCMemory.class.getName(), IMemory.class.getName(), Memory.class.getName(), ISnapshotContributor.class.getName()});
    }

    private MemoryCache getMemoryCache(IMemory.IMemoryDMContext memoryDMC) {
        assert (memoryDMC instanceof IEDCDMContext);
        MemoryCache cache = this.memoryCaches.get(((IEDCDMContext)memoryDMC).getID());
        if (cache == null) {
            cache = new MemoryCache(this.getTargetEnvironmentService().getMemoryCacheMinimumBlockSize());
            this.memoryCaches.put(((IEDCDMContext)memoryDMC).getID(), cache);
        }
        return cache;
    }

    @Override
    protected void doInitialize(RequestMonitor requestMonitor) {
        super.doInitialize(requestMonitor);
        this.memoryCaches = new HashMap<String, MemoryCache>();
        this.getSession().addServiceEventListener((Object)this, null);
    }

    public void fillMemory(IMemory.IMemoryDMContext context, IAddress address, long offset, int word_size, int count, byte[] pattern, RequestMonitor rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/memory", new Object[]{address.toHexAddressString(), offset, word_size, count});
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Unknown context type", null));
            rm.done();
            return;
        }
        if (word_size != 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "Word size not supported (!= 1)", null));
            rm.done();
            return;
        }
        if (count < 0) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Invalid repeat count (< 0)", null));
            rm.done();
            return;
        }
        if (pattern.length < 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Empty pattern", null));
            rm.done();
            return;
        }
        int length = pattern.length;
        byte[] buffer = new byte[count * length];
        int i = 0;
        while (i < count) {
            System.arraycopy(pattern, 0, buffer, i * length, length);
            ++i;
        }
        this.getMemoryCache(context).setMemory(this.tcfMemoryService, context, address, offset, word_size, count * length, buffer, rm);
        EDCDebugger.getDefault().getTrace().traceExit("/debug/memory");
    }

    public void getMemory(IMemory.IMemoryDMContext context, final IAddress address, final long offset, int word_size, int count, final DataRequestMonitor<MemoryByte[]> drm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/memory", new Object[]{address.toHexAddressString(), offset, word_size, count});
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Unknown context type", null));
            drm.done();
            return;
        }
        if (word_size != 1) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "Word size not supported (!= 1)", null));
            drm.done();
            return;
        }
        if (count < 0) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Invalid word count (< 0)", null));
            drm.done();
            return;
        }
        this.getMemoryCache(context).getMemory(this.tcfMemoryService, context, address.add(offset), word_size, count, new DataRequestMonitor<MemoryByte[]>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                MemoryByte[] data = (MemoryByte[])this.getData();
                Breakpoints bpService = (Breakpoints)Memory.this.getServicesTracker().getService(Breakpoints.class);
                bpService.removeBreakpointFromMemoryBuffer(address.add(offset), data);
                drm.setData((Object)data);
                drm.done();
            }
        });
        if (RunControl.timeStepping()) {
            System.out.println("Time since stepping start: " + (double)(System.currentTimeMillis() - RunControl.getSteppingStartTime()) / 1000.0);
        }
        EDCDebugger.getDefault().getTrace().traceExit("/debug/memory");
    }

    public void setMemory(IMemory.IMemoryDMContext context, IAddress address, long offset, int word_size, int count, byte[] buffer, RequestMonitor rm) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/memory", new Object[]{address.toHexAddressString(), offset, word_size, count});
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Unknown context type", null));
            rm.done();
            return;
        }
        if (word_size != 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "Word size not supported (!= 1)", null));
            rm.done();
            return;
        }
        if (count < 0) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Invalid word count (< 0)", null));
            rm.done();
            return;
        }
        if (buffer.length < count) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Buffer too short", null));
            rm.done();
            return;
        }
        this.getMemoryCache(context).setMemory(this.tcfMemoryService, context, address, offset, word_size, count, buffer, rm);
        if (rm.isSuccess()) {
            IAddress[] addresses = new IAddress[count];
            int i = 0;
            while (i < count) {
                addresses[i] = address.add(offset + (long)i);
                ++i;
            }
            this.getSession().dispatchEvent((Object)new MemoryChangedEvent(context, addresses), this.getProperties());
        }
        EDCDebugger.getDefault().getTrace().traceExit("/debug/memory");
    }

    public void flushCache(IDMContext context) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/memory", new Object[]{context});
        if (this.isSnapshot()) {
            return;
        }
        if (context == null) {
            for (String key : this.memoryCaches.keySet()) {
                this.memoryCaches.get(key).reset();
            }
        } else {
            IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMemory.IMemoryDMContext.class);
            if (this.memoryCaches.containsKey(((IEDCDMContext)memoryDMC).getID())) {
                this.memoryCaches.get(((IEDCDMContext)memoryDMC).getID()).reset();
            }
        }
        EDCDebugger.getDefault().getTrace().traceExit("/debug/memory");
    }

    @Override
    public IStatus getMemory(IEDCExecutionDMC context, IAddress address, final ArrayList<MemoryByte> memBuffer, int count, int word_size) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/memory", new Object[]{address.toHexAddressString(), count});
        final IStatus[] ret = new IStatus[]{Status.OK_STATUS};
        this.getMemory(context, address, 0L, word_size, count, new DataRequestMonitor<MemoryByte[]>(ImmediateExecutor.getInstance(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MemoryByte[] resultMem = (MemoryByte[])this.getData();
                    memBuffer.addAll(Arrays.asList(resultMem));
                } else {
                    ret[0] = this.getStatus();
                }
            }
        });
        EDCDebugger.getDefault().getTrace().traceExit("/debug/memory", (Object)ret[0]);
        return ret[0];
    }

    public IStatus setMemory(IMemory.IMemoryDMContext context, IAddress address, int word_size, int count, byte[] buffer) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/memory", new Object[]{address.toHexAddressString(), count});
        final IStatus[] ret = new IStatus[]{Status.OK_STATUS};
        this.setMemory(context, address, 0L, word_size, count, buffer, new RequestMonitor(ImmediateExecutor.getInstance(), null){

            protected void handleFailure() {
                ret[0] = this.getStatus();
            }
        });
        EDCDebugger.getDefault().getTrace().traceExit("/debug/memory", (Object)ret[0]);
        return ret[0];
    }

    @Override
    public void tcfServiceReady(IService service) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/memory", new Object[]{service});
        this.tcfMemoryService = (org.eclipse.tm.tcf.services.IMemory)service;
        EDCDebugger.getDefault().getTrace().traceExit("/debug/memory");
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/memory", new Object[]{e.getClass()});
        this.flushCache(e.getDMContext());
        EDCDebugger.getDefault().getTrace().traceExit("/debug/memory");
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/memory", new Object[]{e.getClass()});
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.flushCache(e.getDMContext());
        }
        EDCDebugger.getDefault().getTrace().traceExit("/debug/memory");
    }

    @DsfServiceEventHandler
    public void eventDispatched(IExpressions.IExpressionChangedDMEvent e) {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/memory", new Object[]{e.getClass()});
        final IExpressions.IExpressionDMContext context = (IExpressions.IExpressionDMContext)e.getDMContext();
        IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        if (expressionService != null) {
            expressionService.getExpressionAddressData(context, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMAddress>((Executor)this.getExecutor(), null){

                protected void handleSuccess() {
                    Addr64 address;
                    IExpressions.IExpressionDMAddress expression = (IExpressions.IExpressionDMAddress)this.getData();
                    int count = expression.getSize();
                    IAddress expAddress = expression.getAddress();
                    if (expAddress instanceof Addr64) {
                        address = (Addr64)expAddress;
                    } else if (expAddress instanceof IAddress) {
                        address = new Addr64(expAddress.getValue());
                    } else {
                        return;
                    }
                    IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMemory.IMemoryDMContext.class);
                    boolean modified = Memory.this.getMemoryCache(memoryDMC).refreshMemory(Memory.this.tcfMemoryService, memoryDMC, (IAddress)address, 0, 1, count, new RequestMonitor((Executor)Memory.this.getExecutor(), null));
                    if (modified) {
                        IAddress[] addresses = new IAddress[count];
                        int i = 0;
                        while (i < count) {
                            addresses[i] = address.add((long)i);
                            ++i;
                        }
                        Memory.this.getSession().dispatchEvent((Object)new MemoryChangedEvent(memoryDMC, addresses), Memory.this.getProperties());
                    }
                }
            });
        }
        EDCDebugger.getDefault().getTrace().traceExit("/debug/memory");
    }

    @Override
    public void loadSnapshot(Element element) throws Exception {
        this.memoryCaches = new HashMap<String, MemoryCache>();
        NodeList contextElements = element.getElementsByTagName(MEMORY_CONTEXT);
        int numContexts = contextElements.getLength();
        int i = 0;
        while (i < numContexts) {
            Element contextElement = (Element)contextElements.item(i);
            String contextID = contextElement.getAttribute(CONTEXT_ID);
            MemoryCache cache = new MemoryCache(this.getTargetEnvironmentService().getMemoryCacheMinimumBlockSize());
            cache.loadSnapshot(contextElement);
            this.memoryCaches.put(contextID, cache);
            ++i;
        }
    }

    @Override
    public Element takeShapshot(IAlbum album, Document document, IProgressMonitor monitor) {
        Element memoryElement = document.createElement(MEMORY);
        for (String key : this.memoryCaches.keySet()) {
            MemoryCache cache = this.memoryCaches.get(key);
            Element memoryCacheElement = document.createElement(MEMORY_CONTEXT);
            memoryCacheElement.setAttribute(CONTEXT_ID, key);
            memoryCacheElement.appendChild(cache.takeShapshot(album, document, monitor));
            memoryElement.appendChild(memoryCacheElement);
        }
        return memoryElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MemoryChangedEvent
    extends AbstractDMEvent<IMemory.IMemoryDMContext>
    implements IMemory.IMemoryChangedEvent {
        IAddress[] addresses;

        public MemoryChangedEvent(IMemory.IMemoryDMContext context, IAddress[] addresses) {
            super((IDMContext)context);
            this.addresses = addresses;
        }

        public IAddress[] getAddresses() {
            return this.addresses;
        }
    }
}

