/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.symbols.RegisterOffsetVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.SymbolsMessages;
import org.eclipse.cdt.debug.edc.services.Registers;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.IRegisterVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;

public class RegisterVariableLocation
implements IRegisterVariableLocation {
    protected String name;
    protected int id;
    protected final IDMContext context;
    protected final DsfServicesTracker tracker;

    public RegisterVariableLocation(DsfServicesTracker tracker, IDMContext context, String name, int id) {
        this.tracker = tracker;
        this.context = context;
        this.name = name;
        this.id = id;
        if (name == null) {
            Registers registerservice = (Registers)tracker.getService(Registers.class);
            this.name = registerservice.getRegisterNameFromCommonID(this.getRegisterID());
        }
    }

    public String toString() {
        return this.getRegisterName() != null ? this.getRegisterName() : "R" + this.id + (this.context instanceof Stack.StackFrameDMC && ((Stack.StackFrameDMC)this.context).getLevel() > 0 ? " (level " + ((Stack.StackFrameDMC)this.context).getLevel() + ")" : "");
    }

    public String getRegisterName() {
        return this.name;
    }

    public int getRegisterID() {
        return this.id;
    }

    public BigInteger readValue(int bytes) throws CoreException {
        if (this.context instanceof Stack.StackFrameDMC) {
            return ((Stack.StackFrameDMC)this.context).getFrameRegisters().getRegister(this.id, bytes);
        }
        throw EDCDebugger.newCoreException(SymbolsMessages.RegisterVariableLocation_CannotReadFramelessRegister);
    }

    public IVariableLocation addOffset(long offset) {
        return new RegisterOffsetVariableLocation(this.tracker, this.context, this.name, this.id, offset);
    }

    public String getLocationName() {
        return "$" + this.getRegisterName();
    }

    public IAddress getAddress() {
        return null;
    }

    public void writeValue(int bytes, BigInteger value) throws CoreException {
        if (!(this.context instanceof Stack.StackFrameDMC)) {
            throw EDCDebugger.newCoreException(SymbolsMessages.RegisterVariableLocation_CannotWriteFramelessRegister);
        }
        ((Stack.StackFrameDMC)this.context).getFrameRegisters().writeRegister(this.id, bytes, value);
    }
}

