/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.IJumpToAddress;
import org.eclipse.cdt.utils.Addr64;

public class JumpToAddress
implements IJumpToAddress {
    public static final String EXPRESSION_RETURN_NEAR = "ret-near";
    public static final String EXPRESSION_RETURN_FAR = "ret-far";
    private final IAddress address;
    private final String expression;
    private final boolean isSoleDestination;
    private final boolean isSubroutineAddress;

    public JumpToAddress(IAddress address, boolean isSoleDestination, boolean isSubroutineAddress) {
        this.address = address;
        this.expression = null;
        this.isSoleDestination = isSoleDestination;
        this.isSubroutineAddress = isSubroutineAddress;
    }

    public JumpToAddress(long address, boolean isSoleDestination, boolean isSubroutineAddress) {
        this((IAddress)new Addr64(Long.toString(address)), isSoleDestination, isSubroutineAddress);
    }

    public JumpToAddress(String expression, boolean isSoleDestination, boolean isSubroutineAddress) {
        this.address = null;
        this.expression = expression;
        this.isSoleDestination = isSoleDestination;
        this.isSubroutineAddress = isSubroutineAddress;
    }

    public boolean isSoleDestination() {
        return this.isSoleDestination;
    }

    public boolean isSubroutineAddress() {
        return this.isSubroutineAddress;
    }

    public boolean isImmediate() {
        return this.address != null;
    }

    public Object getValue() {
        if (this.address != null) {
            return this.address;
        }
        assert (this.expression != null);
        return this.expression;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.isSoleDestination ? 1231 : 1237);
        result = 31 * result + (this.isSubroutineAddress ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JumpToAddress other = (JumpToAddress)obj;
        if (this.address == null ? other.address != null : !this.address.equals((Object)other.address)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.isSoleDestination != other.isSoleDestination) {
            return false;
        }
        return this.isSubroutineAddress == other.isSubroutineAddress;
    }

    public String toString() {
        return "JumpToAddress [address=" + this.address + ", expression=" + this.expression + ", isSoleDestination=" + this.isSoleDestination + ", isSubroutineAddress=" + this.isSubroutineAddress + "]";
    }
}

