/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.disassembler;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembledInstruction;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembler;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDisassembler
implements IDisassembler {
    @Override
    public List<IDisassembledInstruction> disassembleInstructions(IAddress startAddress, IAddress endAddress, ByteBuffer codeBuffer, Map<String, Object> options) throws CoreException {
        IDisassembledInstruction inst = null;
        ArrayList<IDisassembledInstruction> result = new ArrayList<IDisassembledInstruction>();
        IAddress address = startAddress;
        while (codeBuffer.hasRemaining() && address.compareTo((Object)endAddress) < 0) {
            try {
                inst = this.disassembleOneInstruction(address, codeBuffer, options);
                result.add(inst);
                address = address.add((long)inst.getSize());
            }
            catch (CoreException e) {
                throw EDCDebugger.newCoreException("Fail to disassemble instruction at " + address.toHexAddressString() + "\nCause: " + e.getLocalizedMessage(), e);
            }
        }
        return result;
    }
}

