/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.launch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.cdt.debug.edc.internal.launch.ShutdownSequence;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Processes;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupDirector;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.Protocol;

@ThreadSafe
public class EDCLaunch
extends Launch {
    private DefaultDsfExecutor executor;
    private final DsfSession session;
    private DsfServicesTracker tracker;
    private boolean initialized = false;
    private boolean shutDown = false;
    private DsfMemoryBlockRetrieval memRetrieval;
    private IDsfDebugServicesFactory serviceFactory;
    private final String debugModelID;
    private Album album;
    private boolean snapshotSupportInitialized;
    private static final Map<EDCLaunch, List<IChannel>> launchChannels = Collections.synchronizedMap(new HashMap());
    private static final Map<String, EDCLaunch> launchSessions = Collections.synchronizedMap(new HashMap());

    public EDCLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator, String ownerID) {
        super(launchConfiguration, mode, locator);
        this.debugModelID = ownerID;
        DefaultDsfExecutor dsfExecutor = new DefaultDsfExecutor(ownerID);
        dsfExecutor.prestartCoreThread();
        this.executor = dsfExecutor;
        this.session = DsfSession.startSession((DsfExecutor)this.executor, (String)ownerID);
        launchSessions.put(this.session.getId(), this);
    }

    public static EDCLaunch getLaunchForSession(String sessionID) {
        return launchSessions.get(sessionID);
    }

    public DsfExecutor getDsfExecutor() {
        return this.executor;
    }

    public IDsfDebugServicesFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void initialize() {
        DsfRunnable initRunnable = new DsfRunnable(){

            public void run() {
                EDCLaunch.this.tracker = new DsfServicesTracker(EDCDebugger.getDefault().getBundle().getBundleContext(), EDCLaunch.this.session.getId());
                EDCLaunch.this.session.addServiceEventListener((Object)EDCLaunch.this, null);
                EDCLaunch.this.memRetrieval = null;
                EDCLaunch.this.initialized = true;
                EDCLaunch.this.fireChanged();
            }
        };
        try {
            this.executor.submit((Runnable)initRunnable).get();
        }
        catch (Exception e) {
            EDCDebugger.getMessageLogger().log((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Error initializing launch", (Throwable)e));
        }
    }

    public void initializeMemoryRetrieval() throws CoreException {
        try {
            this.executor.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws CoreException {
                    EDCLaunch.this.memRetrieval = new DsfMemoryBlockRetrieval(EDCLaunch.this.getDebugModelID(), EDCLaunch.this.getLaunchConfiguration(), EDCLaunch.this.session);
                    EDCLaunch.this.session.registerModelAdapter(IMemoryBlockRetrieval.class, (Object)EDCLaunch.this.memRetrieval);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    public DsfSession getSession() {
        return this.session;
    }

    public DsfMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return this.memRetrieval;
    }

    public void setServiceFactory(IDsfDebugServicesFactory factory) {
        this.serviceFactory = factory;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e.getDMContext() instanceof RunControl.RootExecutionDMC) {
            this.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent event) {
        this.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
    }

    public boolean canTerminate() {
        return this.initialized && !this.shutDown;
    }

    public boolean isTerminated() {
        return this.shutDown;
    }

    public void terminate() throws DebugException {
        this.getDsfExecutor().execute(new Runnable(){

            public void run() {
                RunControl runControlService = (RunControl)EDCLaunch.this.tracker.getService(RunControl.class);
                if (runControlService != null) {
                    runControlService.terminateAllContexts(null);
                }
            }
        });
    }

    public boolean canDisconnect() {
        return this.canTerminate();
    }

    public boolean isDisconnected() {
        return this.isTerminated();
    }

    public void disconnect() throws DebugException {
        this.getDsfExecutor().execute(new Runnable(){

            public void run() {
                Processes procService = (Processes)EDCLaunch.this.tracker.getService(Processes.class);
                if (procService != null) {
                    procService.detachDebuggerFromSession(null);
                }
            }
        });
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void shutdownSession(final RequestMonitor rm) {
        if (this.shutDown) {
            rm.done();
            return;
        }
        this.shutDown = true;
        ShutdownSequence shutdownSeq = new ShutdownSequence(this.getDsfExecutor(), this.session.getId(), new RequestMonitor((Executor)this.session.getExecutor(), rm){

            public void handleCompleted() {
                EDCLaunch.this.session.removeServiceEventListener((Object)EDCLaunch.this);
                if (!this.isSuccess()) {
                    EDCDebugger.getMessageLogger().log((IStatus)new MultiStatus("org.eclipse.cdt.debug.edc", -1, new IStatus[]{this.getStatus()}, "Session shutdown failed", null));
                }
                EDCLaunch.this.tracker.dispose();
                EDCLaunch.this.tracker = null;
                DsfSession.endSession((DsfSession)EDCLaunch.this.session);
                EDCLaunch.this.memRetrieval.saveMemoryBlocks();
                EDCLaunch.this.executor.shutdown();
                EDCLaunch.this.executor = null;
                EDCLaunch.this.fireTerminate();
                try {
                    EDCLaunch.this.closeUnusedChannels();
                }
                catch (Throwable e) {
                    EDCDebugger.getMessageLogger().logError(null, e);
                }
                rm.setStatus(this.getStatus());
                rm.done();
            }
        });
        this.executor.execute((Runnable)((Object)shutdownSeq));
        if (this.isSnapshotLaunch()) {
            try {
                ILaunchConfiguration lc = SnapshotUtils.findExistingLaunchForAlbum(this.album);
                if (lc != null) {
                    lc.delete();
                }
            }
            catch (Throwable e) {
                EDCDebugger.getMessageLogger().logError(null, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeUnusedChannels() {
        Map<EDCLaunch, List<IChannel>> map = launchChannels;
        synchronized (map) {
            List<IChannel> channelList = launchChannels.get((Object)this);
            launchChannels.remove((Object)this);
            if (channelList == null) {
                return;
            }
            Collection<List<IChannel>> remainingChannels = launchChannels.values();
            for (List<IChannel> list : remainingChannels) {
                channelList.removeAll(list);
            }
            for (final IChannel channel : channelList) {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    public void run() {
                        channel.close();
                    }
                });
            }
        }
    }

    public Object getAdapter(Class adapter) {
        Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        return super.getAdapter(adapter);
    }

    public String getDebugModelID() {
        return this.debugModelID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usingTCFChannel(IChannel channel) {
        Map<EDCLaunch, List<IChannel>> map = launchChannels;
        synchronized (map) {
            List<IChannel> channelList = launchChannels.get((Object)this);
            if (channelList == null) {
                channelList = new ArrayList<IChannel>();
            }
            if (!channelList.contains(channel)) {
                channelList.add(channel);
            }
            launchChannels.put(this, channelList);
        }
    }

    public IAlbum getAlbum() {
        return this.album;
    }

    public void setAlbum(IAlbum album) {
        this.album = (Album)album;
    }

    public boolean isSnapshotLaunch() {
        assert (this.snapshotSupportInitialized);
        return this.album != null;
    }

    public ISourceLocator getExecutableLocator() {
        CSourceLookupDirector director = new CSourceLookupDirector();
        director.initializeParticipants();
        try {
            if (this.isSnapshotLaunch()) {
                this.getAlbum().configureSourceLookupDirector((ISourceLookupDirector)director);
            } else {
                String exePath = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                if (exePath.length() > 0) {
                    IPath exeDirectory = new Path(exePath).removeLastSegments(1);
                    ISourceContainer[] containers = new ISourceContainer[]{new DirectorySourceContainer(exeDirectory, false)};
                    director.setSourceContainers(containers);
                }
            }
        }
        catch (CoreException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
        return director;
    }

    public void initializeSnapshotSupport() {
        try {
            String albumFile = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", "");
            IPath albumPath = PathUtils.createPath(albumFile);
            if (albumPath.toFile().exists()) {
                this.album = Album.getAlbumByLocation(albumPath);
                if (this.album == null) {
                    this.album = new Album();
                    this.album.setLocation(albumPath);
                    this.album.loadAlbum(false);
                }
                this.album.setSessionID(this.session.getId());
                IAlbum album = Album.getAlbumBySession(this.session.getId());
                DsfSourceLookupDirector director = (DsfSourceLookupDirector)this.getSourceLocator();
                album.configureSourceLookupDirector((ISourceLookupDirector)director);
            }
            this.snapshotSupportInitialized = true;
        }
        catch (Exception e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }
}

