/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitForResult<V>
implements Future<V> {
    public static final long DEFAULT_WAIT_TIMEOUT_SECONDS = 10L;
    public static final long WAIT_INTERVAL_MILLIS = 50L;
    private boolean running;
    private boolean canceled;
    private boolean done;
    private V data;
    private Throwable exception;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.running) {
            return false;
        }
        this.canceled = true;
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long limitMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        this.running = true;
        while (!this.canceled && this.exception == null && !this.hasResult()) {
            Thread.sleep(50L);
            if (System.currentTimeMillis() <= limitMillis) continue;
            throw new TimeoutException();
        }
        this.done = true;
        this.running = false;
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.data;
    }

    public void setData(V data) {
        this.data = data;
    }

    public V getData() {
        return this.data;
    }

    public boolean hasResult() {
        return this.getData() != null;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public void handleException(Throwable e) {
        this.exception = e;
    }
}

