/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.scripting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.scripting.DOMUtils;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.model.IBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDC {
    public static String[] getSessions() {
        DsfSession[] sessions;
        ArrayList<String> ids = new ArrayList<String>();
        DsfSession[] dsfSessionArray = sessions = DsfSession.getActiveSessions();
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            DsfSession dsfSession = dsfSessionArray[n2];
            ids.add(dsfSession.getId());
            ++n2;
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static Map<String, Object>[] getContexts(String sessionId) throws Exception {
        return DOMUtils.getDMContextProperties(DOMUtils.getContexts(sessionId));
    }

    public static Map<String, Object>[] getSuspendedContexts(String sessionId) throws Exception {
        return DOMUtils.getDMContextProperties(DOMUtils.getSuspendedContexts(sessionId));
    }

    public static Map<String, Object>[] getSuspendedThreads(String sessionId) throws Exception {
        return DOMUtils.getDMContextProperties(DOMUtils.getSuspendedThreads(sessionId));
    }

    public static IBreakpoint createAddressBreakpoint(long address, String condition) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", "org.eclipse.cdt.debug.edc");
        attributes.put("charStart", -1);
        attributes.put("charEnd", -1);
        attributes.put("lineNumber", -1);
        attributes.put("org.eclipse.cdt.debug.core.address", Long.toHexString(address));
        attributes.put("org.eclipse.debug.core.enabled", true);
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", 0);
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.breakpointType", 0);
        IWorkspaceRoot rootResource = ResourcesPlugin.getWorkspace().getRoot();
        return new CAddressBreakpoint((IResource)rootResource, attributes, true);
    }

    public static IBreakpoint createFunctionBreakpoint(String sourceFilePath, String functionName, String condition) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", "org.eclipse.cdt.debug.edc");
        attributes.put("charStart", -1);
        attributes.put("charEnd", -1);
        attributes.put("lineNumber", -1);
        attributes.put("org.eclipse.cdt.debug.core.function", functionName);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceFilePath);
        attributes.put("org.eclipse.debug.core.enabled", true);
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", 0);
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.breakpointType", 0);
        IWorkspaceRoot rootResource = ResourcesPlugin.getWorkspace().getRoot();
        return new CFunctionBreakpoint((IResource)rootResource, attributes, true);
    }

    public static IBreakpoint createLineBreakpoint(String sourceFilePath, int lineNumber, String condition) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", "org.eclipse.cdt.debug.edc");
        attributes.put("charStart", -1);
        attributes.put("charEnd", -1);
        attributes.put("lineNumber", lineNumber);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceFilePath);
        attributes.put("org.eclipse.debug.core.enabled", true);
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", 0);
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.breakpointType", 0);
        IWorkspaceRoot rootResource = ResourcesPlugin.getWorkspace().getRoot();
        return new CLineBreakpoint((IResource)rootResource, attributes, true);
    }
}

