/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayBoundType;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.MayBeQualifiedType;
import org.eclipse.cdt.debug.edc.symbols.IScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayType
extends MayBeQualifiedType
implements IArrayType {
    protected ArrayList<IArrayBoundType> bounds = new ArrayList();

    public ArrayType(String name, IScope scope, int byteSize, Map<Object, Object> properties) {
        super(name, scope, byteSize, properties);
    }

    @Override
    public int getBoundsCount() {
        return this.bounds.size();
    }

    @Override
    public void addBound(IArrayBoundType bound) {
        for (IArrayBoundType existingBound : this.bounds) {
            existingBound.multiplyElementCount(bound.getBoundCount());
            existingBound.incDimensionIndex();
        }
        this.bounds.add(bound);
        this.byteSize = 0;
    }

    @Override
    public IArrayBoundType[] getBounds() {
        IArrayBoundType[] boundsArray = new IArrayBoundType[this.bounds.size()];
        int i = 0;
        while (i < this.bounds.size()) {
            boundsArray[i] = this.bounds.get(i);
            ++i;
        }
        return boundsArray;
    }

    @Override
    public IArrayBoundType getBound(int index) {
        if (index >= 0 && index < this.bounds.size()) {
            return this.bounds.get(index);
        }
        return null;
    }

    @Override
    public int getByteSize() {
        if (this.byteSize == 0 && this.bounds.size() > 0) {
            this.updateByteSizeFromSubType();
            for (IArrayBoundType bound : this.bounds) {
                this.byteSize = (int)((long)this.byteSize * bound.getElementCount());
            }
        }
        return this.byteSize;
    }
}

