/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.edc.internal.symbols.FieldType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.IField;
import org.eclipse.cdt.debug.edc.internal.symbols.IInheritance;
import org.eclipse.cdt.debug.edc.internal.symbols.MayBeQualifiedType;
import org.eclipse.cdt.debug.edc.symbols.IScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeType
extends MayBeQualifiedType
implements ICompositeType {
    private final int key;
    private final String baseName;
    protected ArrayList<IField> fields = new ArrayList();
    protected ArrayList<IInheritance> inheritances = null;

    public CompositeType(String name, IScope scope, int key, int byteSize, Map<Object, Object> properties, String prefix) {
        super(name, scope, byteSize, properties);
        this.baseName = name;
        this.name = String.valueOf(prefix) + " " + name;
        this.key = key;
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public int fieldCount() {
        return this.fields.size();
    }

    @Override
    public void addField(IField field) {
        this.fields.add(field);
    }

    @Override
    public IField[] getFields() {
        ArrayList<IField> fieldList = new ArrayList<IField>(this.fields);
        return fieldList.toArray(new IField[this.fields.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public int inheritanceCount() {
        return this.inheritances == null ? 0 : this.inheritances.size();
    }

    @Override
    public void addInheritance(IInheritance inheritance) {
        if (this.inheritances == null) {
            this.inheritances = new ArrayList();
        }
        this.inheritances.add(inheritance);
    }

    @Override
    public IInheritance[] getInheritances() {
        if (this.inheritances == null) {
            return new IInheritance[0];
        }
        return this.inheritances.toArray(new IInheritance[this.inheritances.size()]);
    }

    @Override
    public IField[] findFields(String name) {
        String baseFieldName = name;
        ArrayList<String> nameQualifiers = new ArrayList<String>();
        if (name.contains("::")) {
            StringTokenizer st = new StringTokenizer(name, "::", false);
            while (st.hasMoreTokens()) {
                baseFieldName = st.nextToken();
                nameQualifiers.add(baseFieldName);
            }
            nameQualifiers.remove(nameQualifiers.size() - 1);
            if (nameQualifiers.size() >= 0 && nameQualifiers.get(0).equals(this.baseName)) {
                nameQualifiers.remove(0);
            }
        }
        if (nameQualifiers.size() == 0) {
            int i = 0;
            while (i < this.fields.size()) {
                if (((FieldType)this.fields.get(i)).getName().equals(baseFieldName)) {
                    IField[] foundFields = new IField[]{this.fields.get(i)};
                    return foundFields;
                }
                ++i;
            }
            if (this.inheritances != null) {
                for (IInheritance inheritance : this.inheritances) {
                    if (!inheritance.getName().equals(baseFieldName)) continue;
                    IField[] foundFields = new IField[1];
                    FieldType newField = new FieldType(inheritance.getName(), this.scope, this, inheritance.getFieldsOffset(), 0, 0, inheritance.getType().getByteSize(), inheritance.getAccessibility(), inheritance.getProperties());
                    newField.setType(inheritance.getType());
                    foundFields[0] = newField;
                    return foundFields;
                }
            }
        }
        if (this.inheritances == null) {
            return null;
        }
        ArrayList<IField> matches = new ArrayList<IField>();
        for (IInheritance inheritance : this.inheritances) {
            if (!(inheritance.getType() instanceof ICompositeType)) continue;
            ICompositeType inheritComposite = (ICompositeType)inheritance.getType();
            matches = this.findInheritedByName(baseFieldName, inheritComposite, inheritComposite.getBaseName(), inheritance.getFieldsOffset(), matches);
        }
        matches = this.pruneMatches(nameQualifiers, matches);
        IField[] foundFields = null;
        if (matches.size() > 0) {
            foundFields = new IField[matches.size()];
            int i = 0;
            while (i < matches.size()) {
                foundFields[i] = matches.get(i);
                ++i;
            }
        }
        return foundFields;
    }

    private ArrayList<IField> pruneMatches(ArrayList<String> nameQualifiers, ArrayList<IField> matches) {
        if (nameQualifiers.size() == 0) {
            return matches;
        }
        int i = 0;
        while (i < matches.size()) {
            ArrayList<String> matchQualifiers = new ArrayList<String>();
            String matchName = matches.get(i).getName();
            if (matchName.contains("::")) {
                StringTokenizer st = new StringTokenizer(matchName, "::", false);
                while (st.hasMoreTokens()) {
                    matchQualifiers.add(st.nextToken());
                }
                matchQualifiers.remove(matchQualifiers.size() - 1);
                int nameIndex = 0;
                int matchIndex = 0;
                while (nameIndex < nameQualifiers.size() && matchIndex < matchQualifiers.size()) {
                    boolean found = false;
                    while (!found && matchIndex < matchQualifiers.size()) {
                        found = nameQualifiers.get(nameIndex).equals(matchQualifiers.get(matchIndex));
                        ++matchIndex;
                    }
                    if (!found) {
                        matches.remove(i);
                        break;
                    }
                    ++nameIndex;
                }
            }
            ++i;
        }
        return matches;
    }

    private ArrayList<IField> findInheritedByName(String name, ICompositeType composite, String prefix, long offset, ArrayList<IField> matches) {
        IInheritance[] compositeInheritances;
        FieldType newField;
        int n;
        IField[] fields = composite.getFields();
        if (fields != null) {
            IField[] iFieldArray = fields;
            n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                String fieldName = field.getName();
                if (fieldName.equals(name)) {
                    newField = new FieldType(String.valueOf(prefix) + "::" + field.getName(), this.scope, composite, offset + field.getFieldOffset(), 0, 0, field.getType().getByteSize(), field.getAccessibility(), field.getProperties());
                    newField.setType(field.getType());
                    matches.add(newField);
                    break;
                }
                ++n2;
            }
        }
        if ((compositeInheritances = composite.getInheritances()).length == 0) {
            return matches;
        }
        IInheritance[] iInheritanceArray = compositeInheritances;
        int n3 = compositeInheritances.length;
        n = 0;
        while (n < n3) {
            IInheritance inheritance = iInheritanceArray[n];
            if (inheritance.getName().equals(name)) {
                newField = new FieldType(inheritance.getName(), this.scope, this, offset + inheritance.getFieldsOffset(), 0, 0, inheritance.getType().getByteSize(), inheritance.getAccessibility(), inheritance.getProperties());
                newField.setType(inheritance.getType());
            }
            if (inheritance.getType() instanceof ICompositeType) {
                ICompositeType inheritComposite = (ICompositeType)inheritance.getType();
                matches = this.findInheritedByName(name, inheritComposite, String.valueOf(prefix) + "::" + inheritComposite.getBaseName(), offset + inheritance.getFieldsOffset(), matches);
            }
            ++n;
        }
        return matches;
    }
}

