/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.io.IOException;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ElfExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ExecutableSymbolicsReaderFactory;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReaderFactory;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IPath;

public class ElfExecutableSymbolicsReaderFactory
implements IExecutableSymbolicsReaderFactory {
    public IExecutableSymbolicsReader createExecutableSymbolicsReader(IPath binaryFile) {
        IPath symbolFilePath;
        IExecutableSymbolicsReader reader = null;
        reader = this.detectExecutable(binaryFile);
        if (reader == null && (symbolFilePath = ExecutableSymbolicsReaderFactory.findSymbolicsFile(binaryFile)) != null) {
            reader = this.detectExecutable(symbolFilePath);
        }
        return reader;
    }

    private IExecutableSymbolicsReader detectExecutable(IPath binaryFile) {
        try {
            Elf elf = new Elf(binaryFile.toOSString());
            return new ElfExecutableSymbolicsReader(binaryFile, elf);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

