/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.Section;
import org.eclipse.cdt.debug.edc.internal.symbols.Symbol;
import org.eclipse.cdt.debug.edc.internal.symbols.files.BaseExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ExecutableSection;
import org.eclipse.cdt.debug.edc.internal.symbols.files.SectionInfo;
import org.eclipse.cdt.debug.edc.internal.symbols.files.SectionMapper;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglerEABI;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglerWin32;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglerWin32EABI;
import org.eclipse.cdt.debug.edc.symbols.ISymbol;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.core.runtime.IPath;

public class PEFileExecutableSymbolicsReader
extends BaseExecutableSymbolicsReader {
    protected boolean isLE = true;

    public PEFileExecutableSymbolicsReader(IPath binaryFile, PE peFile) throws IOException {
        super(binaryFile);
        this.exeBaseAddress = new Addr32((long)peFile.getNTOptionalHeader().ImageBase);
        this.modificationDate = binaryFile.toFile().lastModified();
        this.sectionMapper = new SectionMapper(binaryFile, this.isLE);
        this.recordSections(peFile);
        boolean isWin32 = false;
        boolean isEABI = false;
        for (ISymbol symbol : this.symbols) {
            String symname = symbol.getName();
            if (symname.startsWith("__Z") && symname.endsWith("v")) {
                isWin32 = true;
                isEABI = true;
                break;
            }
            if (symname.startsWith("_Z") && symname.endsWith("v")) {
                isEABI = true;
                break;
            }
            if (!symname.contains("@") || !symname.contains("?")) continue;
            isWin32 = true;
            break;
        }
        this.unmangler = isWin32 && isEABI ? new UnmanglerWin32EABI() : (isEABI ? new UnmanglerEABI() : new UnmanglerWin32());
    }

    private void recordSections(PE peFile) throws IOException {
        int id = 0;
        Coff.SectionHeader[] secHeaders = peFile.getSectionHeaders();
        long imageBase = (long)peFile.getNTOptionalHeader().ImageBase & 0xFFFFFFFFL;
        Coff.SectionHeader[] sectionHeaderArray = secHeaders;
        int n = secHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                String name;
                Coff.SectionHeader s;
                block9: {
                    String sectionName;
                    block11: {
                        block10: {
                            block8: {
                                s = sectionHeaderArray[n2];
                                name = new String(s.s_name).trim();
                                if (name.startsWith("/")) {
                                    int stringTableOffset = Integer.parseInt(name.substring(1));
                                    name = peFile.getStringTableEntry(stringTableOffset);
                                }
                                if (this.executableSections.containsKey(name)) {
                                    throw new IllegalStateException("duplicate section " + name);
                                }
                                ExecutableSection exeSection = new ExecutableSection(this.sectionMapper, name, new SectionInfo(s.s_scnptr, s.s_paddr));
                                this.executableSections.put(name, exeSection);
                                sectionName = name;
                                if (!sectionName.equals(".text")) break block8;
                                name = ".text";
                                break block9;
                            }
                            if (!sectionName.equals(".data")) break block10;
                            name = ".data";
                            break block9;
                        }
                        if (!sectionName.equals(".rdata")) break block11;
                        name = ".rodata";
                        break block9;
                    }
                    if (!sectionName.equals(".bss")) break block12;
                    name = ".bss";
                }
                long size = s.s_paddr;
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("name", name);
                this.sections.add(new Section(id++, size, (IAddress)new Addr64(Long.toString(imageBase + (long)s.s_vaddr)), props));
            }
            ++n2;
        }
        Coff.Symbol[] rawSymbols = peFile.getSymbols();
        int i = 0;
        while (i < rawSymbols.length) {
            Coff.Symbol symbol = rawSymbols[i];
            String symName = symbol.getName(peFile.getStringTable());
            this.symbols.add(new Symbol(symName, (IAddress)new Addr32((long)symbol.n_value), 1L));
            if (symbol.n_numaux > 0) {
                i += symbol.n_numaux;
            }
            ++i;
        }
        Collections.sort(this.symbols);
    }

    public ByteOrder getByteOrder() {
        return this.isLE ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

