/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.launch;

import org.eclipse.cdt.debug.edc.internal.launch.CSourceLookup;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Breakpoints;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Expressions;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Memory;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Processes;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Signals;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Snapshots;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.services.Disassembly;
import org.eclipse.cdt.debug.edc.services.ISnapshots;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.dsf.debug.service.AbstractDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISignals;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.ISymbols;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DebugServicesFactory
extends AbstractDsfDebugServicesFactory {
    public <V> V createService(Class<V> clazz, DsfSession session, Object ... optionalArguments) {
        if (ITargetEnvironment.class.isAssignableFrom(clazz)) {
            Object[] objectArray = optionalArguments;
            int n = optionalArguments.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                if (arg instanceof ILaunch) {
                    return (V)this.createTargetEnvironmentService(session, (ILaunch)arg);
                }
                ++n2;
            }
        }
        if (Snapshots.class.isAssignableFrom(clazz)) {
            return (V)this.createSnapshotsService(session);
        }
        return (V)super.createService(clazz, session, optionalArguments);
    }

    protected abstract ITargetEnvironment createTargetEnvironmentService(DsfSession var1, ILaunch var2);

    protected abstract IStack createStackService(DsfSession var1);

    protected abstract IRegisters createRegistersService(DsfSession var1);

    protected ISourceLookup createSourceLookupService(DsfSession session) {
        return new CSourceLookup(session);
    }

    protected IRunControl createRunControlService(DsfSession session) {
        return new RunControl(session);
    }

    protected IMemory createMemoryService(DsfSession session) {
        return new Memory(session);
    }

    protected IBreakpoints createBreakpointService(DsfSession session) {
        return new Breakpoints(session);
    }

    protected IDisassembly createDisassemblyService(DsfSession session) {
        return new Disassembly(session);
    }

    protected IExpressions createExpressionService(DsfSession session) {
        return new Expressions(session);
    }

    protected IModules createModulesService(DsfSession session) {
        return new Modules(session);
    }

    protected IProcesses createProcessesService(DsfSession session) {
        return new Processes(session);
    }

    protected ISignals createSignalsService(DsfSession session) {
        return new Signals(session);
    }

    protected ISymbols createSymbolsService(DsfSession session) {
        return new Symbols(session);
    }

    protected ISnapshots createSnapshotsService(DsfSession session) {
        return new Snapshots(session);
    }
}

