/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.launch;

import java.text.MessageFormat;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.debug.edc.internal.launch.ServicesLaunchSequence;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotLaunchSequence;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupDirector;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate2;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;

public abstract class EDCLaunchDelegate
extends AbstractCLaunchDelegate2 {
    public EDCLaunchDelegate() {
        super(false);
    }

    public EDCLaunchDelegate(boolean requireCProject) {
        super(requireCProject);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        LaunchUtils.enableActivity((String)"org.eclipse.cdt.debug.edc.ui.edcActivity", (boolean)true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!mode.equals("debug")) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, MessageFormat.format("Launch mode ''{0}'' is not (yet) implemented", mode), null));
        }
        this.launchDebugger(configuration, launch, monitor);
    }

    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Launching debugger session", 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            this.launchDebugSession(config, launch, monitor);
        }
        finally {
            monitor.done();
        }
    }

    private ISourceLocator getSourceLocator(ILaunchConfiguration configuration, DsfSession session) throws CoreException {
        DsfSourceLookupDirector locator = new DsfSourceLookupDirector(session);
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        if (memento == null) {
            locator.initializeDefaults(configuration);
        } else {
            locator.initializeFromMemento(memento, configuration);
        }
        return locator;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        EDCLaunch launch = new EDCLaunch(configuration, mode, null, this.getDebugModelID());
        launch.initialize();
        launch.setSourceLocator(this.getSourceLocator(configuration, launch.getSession()));
        return launch;
    }

    public abstract String getDebugModelID();

    protected abstract Sequence getLiveLaunchSequence(DsfExecutor var1, EDCLaunch var2, IProgressMonitor var3);

    protected Sequence getSnapshotLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm) {
        return new SnapshotLaunchSequence(executor, launch, pm);
    }

    protected Sequence getFinalLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm) {
        if (launch.isSnapshotLaunch()) {
            return this.getSnapshotLaunchSequence(executor, launch, pm);
        }
        return this.getLiveLaunchSequence(executor, launch, pm);
    }

    private void launchDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        EDCLaunch launch = (EDCLaunch)l;
        monitor.worked(1);
        launch.setServiceFactory(this.newServiceFactory());
        launch.initializeSnapshotSupport();
        SubProgressMonitor subMon1 = new SubProgressMonitor(monitor, 4, 4);
        ServicesLaunchSequence servicesLaunchSequence = new ServicesLaunchSequence(launch.getSession(), launch, (IProgressMonitor)subMon1);
        launch.getSession().getExecutor().execute((Runnable)((Object)servicesLaunchSequence));
        try {
            servicesLaunchSequence.get();
        }
        catch (InterruptedException e1) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, "Interrupted Exception in dispatch thread.\n" + e1.getLocalizedMessage(), (Throwable)e1));
        }
        catch (ExecutionException e1) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Error in services launch sequence.", e1.getCause()));
        }
        if (monitor.isCanceled()) {
            return;
        }
        launch.initializeMemoryRetrieval();
        monitor.worked(1);
        SubProgressMonitor subMon2 = new SubProgressMonitor(monitor, 4, 4);
        Sequence finalLaunchSequence = this.getFinalLaunchSequence(launch.getSession().getExecutor(), launch, (IProgressMonitor)subMon2);
        launch.getSession().getExecutor().execute((Runnable)finalLaunchSequence);
        boolean succeed = false;
        try {
            try {
                finalLaunchSequence.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, "Interrupted Exception in dispatch thread.\n" + e1.getLocalizedMessage(), (Throwable)e1));
            }
            catch (CancellationException cancellationException) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            catch (ExecutionException e1) {
                IStatus s;
                Throwable cause = e1.getCause();
                if (cause instanceof CoreException && (s = ((CoreException)cause).getStatus()).getSeverity() == 8) {
                    throw (CoreException)cause;
                }
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Error in final launch sequence.", e1.getCause()));
            }
        }
        catch (Throwable throwable) {
            if (!succeed) {
                Query<Object> launchShutdownQuery = new Query<Object>(launch){
                    private final /* synthetic */ EDCLaunch val$launch;
                    {
                        this.val$launch = eDCLaunch;
                    }

                    protected void execute(DataRequestMonitor<Object> rm) {
                        this.val$launch.shutdownSession((RequestMonitor)rm);
                    }
                };
                launch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                try {
                    launchShutdownQuery.get();
                }
                catch (InterruptedException e) {
                    throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, "InterruptedException while shutting down debugger launch " + (Object)((Object)launch), (Throwable)e));
                }
                catch (ExecutionException e) {
                    throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Error in shutting down debugger launch " + (Object)((Object)launch), (Throwable)e));
                }
            }
            throw throwable;
        }
        if (!succeed) {
            Query<Object> launchShutdownQuery = new /* invalid duplicate definition of identical inner class */;
            launch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
            try {
                launchShutdownQuery.get();
            }
            catch (InterruptedException e) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, "InterruptedException while shutting down debugger launch " + (Object)((Object)launch), (Throwable)e));
            }
            catch (ExecutionException e) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Error in shutting down debugger launch " + (Object)((Object)launch), (Throwable)e));
            }
        }
    }

    protected abstract IDsfDebugServicesFactory newServiceFactory();
}

