/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import org.eclipse.cdt.debug.edc.IStreamBuffer;

public abstract class StreamBufferBase
implements IStreamBuffer {
    public static final int BUFFER_SIZE = 4096;
    protected final ByteOrder order;
    private long position;
    private long sourceCapacity;
    private byte[] buffer;
    private long sourceOffset;
    private long sourceLimit;
    private final long baseOffset;

    public StreamBufferBase(ByteOrder order, long baseOffset, long capacity) {
        this.order = order;
        this.baseOffset = baseOffset;
        this.position = 0L;
        this.sourceCapacity = capacity;
        this.buffer = new byte[4096];
        this.sourceOffset = 0L;
        this.sourceLimit = 0L;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " pos=" + this.position() + " of " + this.capacity() + " base=" + this.baseOffset;
    }

    protected abstract void fetchPage(byte[] var1, long var2, int var4);

    protected abstract IStreamBuffer createSubBuffer(long var1, long var3);

    public IStreamBuffer wrapSubsection(long size) {
        long availableSize = this.capacity() - this.position();
        if (availableSize < size) {
            size = availableSize;
        }
        return this.createSubBuffer(this.position() + this.baseOffset, size);
    }

    public long capacity() {
        return this.sourceCapacity;
    }

    public boolean hasRemaining() {
        return this.position < this.sourceCapacity;
    }

    public long remaining() {
        return this.sourceCapacity - this.position;
    }

    public long position() {
        return this.position;
    }

    public IStreamBuffer position(long newPosition) {
        if (newPosition < 0L || newPosition > this.sourceCapacity) {
            throw new IllegalArgumentException(String.valueOf(newPosition) + " not in 0.." + this.sourceCapacity);
        }
        this.position = newPosition;
        return this;
    }

    public IStreamBuffer get(byte[] dst, int offset, int length) {
        while (length > 0) {
            int left;
            if (this.needFetch()) {
                this.refetch();
            }
            if ((left = (int)Math.min(this.sourceLimit - this.position, (long)length)) <= 0) continue;
            System.arraycopy(this.buffer, (int)(this.position - this.sourceOffset), dst, offset, left);
            offset += left;
            this.position += (long)left;
            length -= left;
        }
        return this;
    }

    public IStreamBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    protected void refetch() {
        long newSourceOffset = this.position - (this.position & (long)(this.buffer.length - 1));
        if (newSourceOffset < 0L) {
            throw new BufferUnderflowException();
        }
        if (newSourceOffset >= this.sourceCapacity) {
            throw new BufferUnderflowException();
        }
        int toFetch = (int)Math.min(this.sourceCapacity - newSourceOffset, (long)this.buffer.length);
        this.fetchPage(this.buffer, newSourceOffset + this.baseOffset, toFetch);
        this.sourceOffset = newSourceOffset;
        this.sourceLimit = this.sourceOffset + (long)toFetch;
    }

    protected final boolean needFetch() {
        return this.position < this.sourceOffset || this.position >= this.sourceLimit;
    }

    public byte get() {
        if (this.needFetch()) {
            this.refetch();
        }
        if (this.position < this.sourceCapacity) {
            return this.buffer[(int)(this.position++ - this.sourceOffset)];
        }
        throw new BufferUnderflowException();
    }

    public char getChar() {
        return (char)this.getShort();
    }

    public short getShort() {
        int a = this.get() & 0xFF;
        int b = this.get() & 0xFF;
        if (this.order == ByteOrder.LITTLE_ENDIAN) {
            return (short)(a | b << 8);
        }
        return (short)(b | a << 8);
    }

    public int getInt() {
        int a = this.getShort() & 0xFFFF;
        int b = this.getShort() & 0xFFFF;
        if (this.order == ByteOrder.LITTLE_ENDIAN) {
            return a | b << 16;
        }
        return b | a << 16;
    }

    public long getLong() {
        long a = this.getInt();
        long b = this.getInt();
        if (this.order == ByteOrder.LITTLE_ENDIAN) {
            return a | b << 32;
        }
        return b | a << 32;
    }
}

