/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import java.text.MessageFormat;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.symbols.IAggregate;
import org.eclipse.cdt.debug.edc.internal.symbols.IBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.IEnumeration;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.IQualifierType;
import org.eclipse.cdt.debug.edc.internal.symbols.IReferenceType;
import org.eclipse.cdt.debug.edc.internal.symbols.TypedefType;
import org.eclipse.cdt.debug.edc.symbols.IEnumerator;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.core.runtime.CoreException;

public class OperandValue {
    protected IVariableLocation valueLocation;
    protected Number value;
    protected String stringValue;
    protected IType type;
    protected boolean isBitField;

    public OperandValue(IType type) {
        this(type, false);
    }

    public OperandValue(IType type, boolean isBitField) {
        this.type = type;
        this.isBitField = isBitField;
    }

    public OperandValue(Number value, IType type) {
        this.type = type;
        this.value = value;
    }

    public OperandValue(String string, IType type) {
        this(type, false);
        this.stringValue = string;
    }

    public IType getValueType() {
        return this.type;
    }

    public IVariableLocation getValueLocation() {
        return this.valueLocation;
    }

    public void setValueLocation(IVariableLocation valueLocation) {
        this.valueLocation = valueLocation;
    }

    public Number getValueLocationAddress() throws CoreException {
        IVariableLocation location = this.getValueLocation();
        if (location == null) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.OperandValue_VariableNoAddress);
        }
        return this.getLocationAddress(location);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Number getValueByType(IType varType, IVariableLocation location) throws CoreException {
        if (varType == null) throw EDCDebugger.newCoreException(ASTEvalMessages.VariableWithValue_VariableHasNoType);
        if (varType instanceof ICPPBasicType) {
            return this.getBasicTypeValue(varType, location);
        }
        if (varType instanceof IPointerType) {
            return this.getBasicTypeValue(varType, location);
        }
        if (varType instanceof IReferenceType) {
            return this.getBasicTypeValue(varType, location);
        }
        if (varType instanceof IAggregate) {
            return this.getAggregateTypeValue((IAggregate)((Object)varType), location);
        }
        if (varType instanceof IQualifierType) return this.getValueByType(varType.getType(), location);
        if (varType instanceof TypedefType) {
            return this.getValueByType(varType.getType(), location);
        }
        if (varType instanceof IEnumeration) {
            return this.getBasicTypeValue(varType, location);
        }
        if ($assertionsDisabled) throw EDCDebugger.newCoreException(String.valueOf(ASTEvalMessages.VariableWithValue_UnhandledType) + varType.getName());
        throw new AssertionError();
    }

    public Number getValue() throws CoreException {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public void setAddressValue(IVariableLocation location) throws CoreException {
        this.setValue(this.getLocationAddress(location));
    }

    protected Number getLocationAddress(IVariableLocation location) throws CoreException {
        IAddress addr = location.getAddress();
        if (addr == null) {
            throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.OperandValue_CannotGetAddress, location.getLocationName()));
        }
        return addr.getValue();
    }

    private Number getAggregateTypeValue(IAggregate varType, IVariableLocation location) throws CoreException {
        return this.getLocationAddress(location);
    }

    private Number getBasicTypeValue(IType varType, IVariableLocation location) throws CoreException {
        EDCDebugger.getDefault().getTrace().traceEntry("/debug/variableValue", new Object[]{varType, location});
        Number result = null;
        try {
            Number number = result = this.doGetBasicTypeValue(varType, location);
            return number;
        }
        finally {
            EDCDebugger.getDefault().getTrace().traceExit("/debug/variableValue", (Object)result);
        }
    }

    private Number doGetBasicTypeValue(IType varType, IVariableLocation location) throws CoreException {
        Number result = null;
        int varSize = varType.getByteSize();
        int basicType = 0;
        boolean isSigned = false;
        boolean isShort = false;
        boolean isLong = false;
        boolean isLongLong = false;
        boolean isComplex = false;
        if (varType instanceof IBasicType) {
            IBasicType type = (IBasicType)varType;
            basicType = type.getBaseType();
            if (basicType == 1) {
                throw EDCDebugger.newCoreException(ASTEvalMessages.OperandValue_CannotReadVoid);
            }
            if (basicType == 0) {
                throw EDCDebugger.newCoreException(ASTEvalMessages.OperandValue_CannotReadUnspecifiedType);
            }
            isSigned = type.isSigned();
            isShort = type.isShort();
            isLong = type.isLong();
            if (varType instanceof ICPPBasicType) {
                ICPPBasicType cppType = (ICPPBasicType)varType;
                isLongLong = cppType.isLongLong();
                isComplex = cppType.isComplex();
            }
        } else if (varType instanceof IPointerType) {
            basicType = 3;
        } else if (varType instanceof IEnumerator) {
            basicType = 3;
            isSigned = true;
        } else {
            basicType = 3;
            isSigned = false;
        }
        if (varSize == 0) {
            varSize = this.getDefaultSize(varType, basicType, isShort, isLong, isLongLong, isComplex);
        }
        IVariableLocation varLocation = location;
        BigInteger varValue = null;
        if (varLocation == null) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.VariableWithValue_UnknownLocation);
        }
        varValue = varLocation.readValue(varSize);
        switch (basicType) {
            case 4: 
            case 5: {
                if (varSize == 4) {
                    result = Float.valueOf(Float.intBitsToFloat(varValue.intValue()));
                    break;
                }
                if (varSize == 8) {
                    result = Double.longBitsToDouble(varValue.longValue());
                    break;
                }
                throw EDCDebugger.newCoreException(ASTEvalMessages.VariableWithValue_NoTwelveByteLongDouble);
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                if (isSigned) {
                    if (varSize == 4) {
                        result = new Integer(varValue.intValue());
                        break;
                    }
                    if (varSize == 2) {
                        int intResult = varValue.intValue() & 0xFFFF;
                        if ((intResult & 0x8000) != 0) {
                            intResult |= 0xFFFF0000;
                        }
                        result = new Integer(intResult);
                        break;
                    }
                    if (varSize == 1) {
                        int intResult = varValue.intValue() & 0xFF;
                        if ((intResult & 0x80) != 0) {
                            intResult |= 0xFFFFFF00;
                        }
                        result = new Integer(intResult);
                        break;
                    }
                    result = new Long(varValue.longValue());
                    break;
                }
                if (varSize == 4) {
                    result = new Long(varValue.longValue() & 0xFFFFFFFFL);
                    break;
                }
                if (varSize == 2) {
                    result = new Integer(varValue.intValue() & 0xFFFF);
                    break;
                }
                if (varSize == 1) {
                    result = new Integer(varValue.intValue() & 0xFF);
                    break;
                }
                result = new Long(varValue.longValue());
                break;
            }
            default: {
                assert (false);
                throw EDCDebugger.newCoreException(ASTEvalMessages.OperandValue_UnhandledType);
            }
        }
        return result;
    }

    private int getDefaultSize(IType varType, int basicType, boolean isShort, boolean isLong, boolean isLongLong, boolean isComplex) {
        int varSize = 0;
        varSize = 1;
        return varSize;
    }

    public long getLongValue() throws CoreException {
        return this.getValue().longValue();
    }

    public boolean isFloating() {
        return this.value instanceof Float || this.value instanceof Double;
    }

    public boolean isBitField() {
        return this.isBitField;
    }

    public BigInteger getBigIntValue() throws CoreException {
        if (this.getValue() == null) {
            return BigInteger.ZERO;
        }
        BigInteger bigIntVal = this.value instanceof BigInteger ? (BigInteger)this.value : BigInteger.valueOf(this.value.longValue());
        return bigIntVal;
    }

    public OperandValue copyWithType(IType otherType) {
        OperandValue value = new OperandValue(otherType);
        value.value = this.value;
        value.stringValue = this.stringValue;
        value.valueLocation = this.valueLocation;
        return value;
    }
}

