/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.debug.edc.MemoryUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvaluationEngine;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.IArrayDimensionType;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.InstructionSequence;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Interpreter;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.formatter.FormatExtensionManager;
import org.eclipse.cdt.debug.edc.internal.services.dsf.EDCServicesMessages;
import org.eclipse.cdt.debug.edc.internal.symbols.IAggregate;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.IEnumeration;
import org.eclipse.cdt.debug.edc.internal.symbols.IField;
import org.eclipse.cdt.debug.edc.internal.symbols.IInheritance;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.IReferenceType;
import org.eclipse.cdt.debug.edc.internal.symbols.ISubroutineType;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.IEnumerator;
import org.eclipse.cdt.debug.edc.symbols.IInvalidVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expressions
extends AbstractEDCService
implements IExpressions2 {
    private static final String HEX_PREFIX = "0x";
    private static final String OCTAL_PREFIX = "0";
    private static final String BINARY_PREFIX = "0b";
    private static final String SINGLE_QUOTE = "'";
    private static final String DECIMAL_SUFFIX = " (Decimal)";

    public Expressions(DsfSession session) {
        super(session, new String[]{IExpressions.class.getName(), Expressions.class.getName(), IExpressions2.class.getName()});
    }

    public boolean canWriteExpression(IEDCExpression expressionDMC) {
        EDCLaunch launch = EDCLaunch.getLaunchForSession(this.getSession().getId());
        if (launch.isSnapshotLaunch()) {
            return false;
        }
        IVariableValueConverter converter = this.getCustomValueConverter(expressionDMC);
        if (converter != null) {
            return converter.canEditValue();
        }
        return !this.isComposite(expressionDMC);
    }

    public void canWriteExpression(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<Boolean> rm) {
        IEDCExpression expressionDMC = (IEDCExpression)exprContext;
        rm.setData((Object)this.canWriteExpression(expressionDMC));
        rm.done();
    }

    private boolean isComposite(IEDCExpression expressionDMC) {
        IType exprType = TypeUtils.getStrippedType(expressionDMC.getEvaluatedType());
        return exprType instanceof ICompositeType;
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext context, String expression) {
        Stack.StackFrameDMC frameDmc = (Stack.StackFrameDMC)DMContexts.getAncestorOfType((IDMContext)context, Stack.StackFrameDMC.class);
        if (frameDmc != null) {
            return new ExpressionDMC((IDMContext)frameDmc, expression);
        }
        return new InvalidContextExpressionDMC(this.getSession().getId(), expression, context);
    }

    public IExpressions2.ICastedExpressionDMContext createCastedExpression(IExpressions.IExpressionDMContext exprDMC, IExpressions2.CastInfo castInfo) {
        if (exprDMC instanceof IEDCExpression) {
            CastedExpressionDMC castedDMC = new CastedExpressionDMC((IEDCExpression)exprDMC, exprDMC.getExpression(), ((IEDCExpression)exprDMC).getName(), castInfo);
            return castedDMC;
        }
        assert (false);
        return null;
    }

    public void getBaseExpressions(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        rm.setData((Object)new IEDCExpression[0]);
        rm.done();
    }

    public void getExpressionAddressData(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMAddress> rm) {
        if (exprContext instanceof IEDCExpression) {
            rm.setData((Object)new ExpressionDMAddress(exprContext));
        } else {
            rm.setData((Object)new ExpressionDMAddress(null));
        }
        rm.done();
    }

    public void getExpressionData(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMData> rm) {
        if (exprContext instanceof IEDCExpression) {
            rm.setData((Object)new ExpressionData((IEDCExpression)exprContext));
        } else {
            rm.setData((Object)new ExpressionData(null));
        }
        rm.done();
    }

    public void getSubExpressionCount(IExpressions.IExpressionDMContext exprContext, final DataRequestMonitor<Integer> rm) {
        IExpressions2.CastInfo cast = null;
        if (exprContext instanceof IEDCExpression && (cast = ((IEDCExpression)exprContext).getCastInfo()) != null && cast.getArrayCount() > 0) {
            if (((IEDCExpression)exprContext).getEvaluationError() != null) {
                rm.setData((Object)0);
                rm.done();
                return;
            }
            rm.setData((Object)cast.getArrayCount());
            rm.done();
            return;
        }
        this.getSubExpressions(exprContext, new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                rm.setData((Object)((IExpressions.IExpressionDMContext[])this.getData()).length);
                rm.done();
            }
        });
    }

    public void getSubExpressions(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        if (!(exprContext instanceof IEDCExpression) || ((IEDCExpression)exprContext).getFrame() == null) {
            rm.setData((Object)new IEDCExpression[0]);
            rm.done();
            return;
        }
        IEDCExpression expr = (IEDCExpression)exprContext;
        if (expr.getEvaluatedValue() == null && expr.getEvaluatedValueString() != null) {
            expr.evaluateExpression();
        }
        Stack.StackFrameDMC frame = (Stack.StackFrameDMC)expr.getFrame();
        IType exprType = TypeUtils.getStrippedType(expr.getEvaluatedType());
        IExpressions2.CastInfo castInfo = expr.getCastInfo();
        if (castInfo != null && castInfo.getArrayCount() > 0) {
            try {
                exprType = frame.getTypeEngine().convertToArrayType(exprType, castInfo.getArrayCount());
            }
            catch (CoreException e) {
                rm.setStatus(e.getStatus());
                rm.done();
                return;
            }
        }
        boolean pointerType = exprType instanceof IPointerType;
        boolean referenceType = exprType instanceof IReferenceType;
        IType pointedTo = null;
        if (referenceType) {
            pointedTo = TypeUtils.getStrippedType(((IReferenceType)exprType).getType());
        }
        if (!(exprType instanceof IAggregate || pointerType || referenceType && pointedTo instanceof IAggregate)) {
            rm.setData((Object)new IEDCExpression[0]);
            rm.done();
            return;
        }
        ITypeContentProvider customProvider = FormatExtensionManager.instance().getTypeContentProvider(exprType);
        if (customProvider != null) {
            try {
                this.getSubExpressions(expr, frame, customProvider, rm);
            }
            catch (CoreException coreException) {
                this.getSubExpressions(expr, frame, exprType, rm);
            }
            catch (Throwable e) {
                EDCDebugger.getMessageLogger().logError(String.valueOf(EDCServicesMessages.Expressions_ErrorInVariableFormatter) + customProvider.getClass().getName(), e);
                this.getSubExpressions(expr, frame, exprType, rm);
            }
        } else {
            this.getSubExpressions(expr, frame, exprType, rm);
        }
    }

    public void getSubExpressions(IExpressions.IExpressionDMContext exprContext, final int startIndex_, final int length_, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        this.getSubExpressions(exprContext, new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                IExpressions.IExpressionDMContext[] allExprs = (IExpressions.IExpressionDMContext[])this.getData();
                if (startIndex_ == 0 && length_ >= allExprs.length) {
                    rm.setData((Object)allExprs);
                    rm.done();
                } else {
                    int startIndex = startIndex_;
                    int length = length_;
                    if (startIndex > allExprs.length) {
                        startIndex = allExprs.length;
                        length = 0;
                    } else if (startIndex + length > allExprs.length && (length = allExprs.length - startIndex) < 0) {
                        length = 0;
                    }
                    IExpressions.IExpressionDMContext[] result = new IExpressions.IExpressionDMContext[length];
                    System.arraycopy(allExprs, startIndex, result, 0, length);
                    rm.setData((Object)result);
                    rm.done();
                }
            }
        });
    }

    private void getSubExpressions(IEDCExpression expr, Stack.StackFrameDMC frame, ITypeContentProvider customProvider, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) throws CoreException {
        ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
        Iterator<IExpressions.IExpressionDMContext> childIterator = customProvider.getChildIterator(expr);
        while (childIterator.hasNext() && !rm.isCanceled()) {
            children.add(childIterator.next());
        }
        rm.setData((Object)children.toArray(new IExpressions.IExpressionDMContext[children.size()]));
        rm.done();
    }

    private void getSubExpressions(IEDCExpression expr, Stack.StackFrameDMC frame, IType exprType, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        IEDCExpression[] children = this.getLogicalSubExpressions(expr);
        rm.setData((Object)children);
        rm.done();
    }

    public IEDCExpression[] getLogicalSubExpressions(IEDCExpression expr) {
        IType exprType = TypeUtils.getStrippedType(expr.getEvaluatedType());
        IExpressions2.CastInfo castInfo = expr.getCastInfo();
        if (castInfo != null && castInfo.getArrayCount() > 0) {
            String exprName = expr.getExpression();
            if (exprName.contains("(")) {
                exprName = String.valueOf('(') + exprName + ')';
            }
            long lowerBound = castInfo.getArrayStartIndex();
            long count = castInfo.getArrayCount();
            ArrayList<ExpressionDMC> arrayChildren = new ArrayList<ExpressionDMC>();
            int i = 0;
            while ((long)i < count) {
                ExpressionDMC newExpr;
                String arrayElement = "[" + ((long)i + lowerBound) + "]";
                ExpressionDMC exprChild = newExpr = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(exprName) + arrayElement, String.valueOf(expr.getName()) + arrayElement);
                arrayChildren.add(exprChild);
                ++i;
            }
            return arrayChildren.toArray(new IEDCExpression[arrayChildren.size()]);
        }
        if (exprType instanceof IPointerType) {
            ExpressionDMC exprChild;
            String exprName = expr.getExpression();
            IType typePointedTo = TypeUtils.getStrippedType(exprType.getType());
            boolean indirected = false;
            if (exprName.startsWith("&")) {
                ExpressionDMC newExpr;
                exprName = exprName.substring(1);
                exprChild = newExpr = new ExpressionDMC((IDMContext)expr.getFrame(), exprName);
                indirected = true;
            } else {
                ExpressionDMC newExpr;
                if (typePointedTo instanceof ICPPBasicType && ((ICPPBasicType)typePointedTo).getBaseType() == 1) {
                    return new IEDCExpression[0];
                }
                if (expr.getEvaluatedValue() != null && expr.getEvaluatedValue().intValue() == 0) {
                    return new IEDCExpression[0];
                }
                exprChild = newExpr = new ExpressionDMC((IDMContext)expr.getFrame(), "*" + exprName, "*" + expr.getName());
            }
            return this.doGetLogicalSubExpressions(exprChild, typePointedTo, indirected);
        }
        if (exprType instanceof IReferenceType) {
            IType typePointedTo = TypeUtils.getStrippedType(exprType.getType());
            return this.doGetLogicalSubExpressions(expr, typePointedTo, false);
        }
        return this.doGetLogicalSubExpressions(expr, exprType, false);
    }

    private IEDCExpression[] doGetLogicalSubExpressions(IEDCExpression expr, IType exprType, boolean indirected) {
        ArrayList<IEDCExpression> exprList = new ArrayList<IEDCExpression>();
        String expression = expr.getExpression();
        if (expression.contains("(")) {
            expression = String.valueOf('(') + expression + ')';
        }
        if (exprType instanceof ICompositeType) {
            IInheritance[] inheritedFrom;
            ExpressionDMC exprChild;
            IField[] fields;
            expression = expression.startsWith("*") ? String.valueOf(expression.substring(1)) + "->" : String.valueOf(expression) + '.';
            ICompositeType compositeType = (ICompositeType)exprType;
            IField[] iFieldArray = fields = compositeType.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (field.getName().length() == 0) {
                    assert (false);
                } else {
                    exprChild = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(expression) + field.getName(), field.getName());
                    exprList.add(exprChild);
                }
                ++n2;
            }
            IInheritance[] iInheritanceArray = inheritedFrom = compositeType.getInheritances();
            int n3 = inheritedFrom.length;
            n = 0;
            while (n < n3) {
                IInheritance inherited = iInheritanceArray[n];
                if (inherited.getName().length() == 0) {
                    assert (false);
                } else {
                    exprChild = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(expression) + inherited.getName(), inherited.getName());
                    exprList.add(exprChild);
                }
                ++n;
            }
        } else if (exprType instanceof IArrayType) {
            IArrayType arrayType = (IArrayType)exprType;
            if (arrayType.getBoundsCount() > 0) {
                long lowerBound = expr.getCastInfo() != null && expr.getCastInfo().getArrayCount() > 0 ? expr.getCastInfo().getArrayStartIndex() : 0;
                long upperBound = arrayType.getBound(0).getBoundCount();
                if (upperBound == 0L) {
                    upperBound = 1L;
                }
                int i = 0;
                while ((long)i < upperBound) {
                    ExpressionDMC newExpr;
                    String arrayElementName = "[" + ((long)i + lowerBound) + "]";
                    ExpressionDMC exprChild = newExpr = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(expression) + arrayElementName, String.valueOf(expr.getName()) + arrayElementName);
                    exprList.add(exprChild);
                    ++i;
                }
            }
        } else if (exprType instanceof IArrayDimensionType) {
            IArrayDimensionType arrayDimensionType = (IArrayDimensionType)((Object)exprType);
            IArrayType arrayType = arrayDimensionType.getArrayType();
            if (arrayType.getBoundsCount() > arrayDimensionType.getDimensionCount()) {
                long lowerBound = expr.getCastInfo() != null && expr.getCastInfo().getArrayCount() > 0 ? expr.getCastInfo().getArrayStartIndex() : 0;
                long upperBound = arrayType.getBound(arrayDimensionType.getDimensionCount()).getBoundCount();
                int i = 0;
                while ((long)i < upperBound) {
                    ExpressionDMC newExpr;
                    String arrayElement = "[" + ((long)i + lowerBound) + "]";
                    ExpressionDMC exprChild = newExpr = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(expression) + arrayElement, String.valueOf(expr.getName()) + arrayElement);
                    exprList.add(exprChild);
                    ++i;
                }
            }
        } else {
            exprList.add(expr);
        }
        return exprList.toArray(new IEDCExpression[exprList.size()]);
    }

    public void writeExpression(IExpressions.IExpressionDMContext exprContext, String expressionValue, String formatId, RequestMonitor rm) {
        IEDCExpression expressionDMC = (IEDCExpression)exprContext;
        if (this.isComposite(expressionDMC)) {
            rm.setStatus(EDCDebugger.dsfRequestFailedStatus(EDCServicesMessages.Expressions_CannotModifyCompositeValue, null));
            rm.done();
            return;
        }
        IType exprType = TypeUtils.getStrippedType(expressionDMC.getEvaluatedType());
        Number number = this.parseIntegerByFormat(expressionValue, formatId);
        if (number == null) {
            IEDCExpression temp = (IEDCExpression)this.createExpression((IDMContext)expressionDMC.getFrame(), expressionValue);
            temp.evaluateExpression();
            number = temp.getEvaluatedValue();
            if (number == null) {
                rm.setStatus(EDCDebugger.dsfRequestFailedStatus(EDCServicesMessages.Expressions_CannotParseExpression, null));
                rm.done();
                return;
            }
        }
        BigInteger value = null;
        try {
            value = MemoryUtils.convertValueToMemory(exprType, number);
        }
        catch (CoreException e) {
            rm.setStatus(e.getStatus());
            rm.done();
            return;
        }
        IVariableLocation variableLocation = expressionDMC.getValueLocation();
        if (variableLocation == null) {
            rm.setStatus(EDCDebugger.dsfRequestFailedStatus(EDCServicesMessages.Expressions_ExpressionNoLocation, null));
            rm.done();
            return;
        }
        try {
            variableLocation.writeValue(exprType.getByteSize(), value);
            this.getSession().dispatchEvent((Object)new ExpressionChangedDMEvent(exprContext), this.getProperties());
        }
        catch (CoreException e) {
            rm.setStatus(e.getStatus());
        }
        rm.done();
    }

    private BigInteger parseIntegerByFormat(String expressionValue, String formatId) {
        int radix = 10;
        if ("HEX.Format".equals(formatId)) {
            if (expressionValue.startsWith(HEX_PREFIX)) {
                expressionValue = expressionValue.substring(HEX_PREFIX.length());
            }
            radix = 16;
        } else if ("OCTAL.Format".equals(formatId)) {
            if (expressionValue.startsWith(OCTAL_PREFIX)) {
                expressionValue = expressionValue.substring(OCTAL_PREFIX.length());
            }
            radix = 8;
        } else if ("BINARY.Format".equals(formatId)) {
            if (expressionValue.startsWith(BINARY_PREFIX)) {
                expressionValue = expressionValue.substring(BINARY_PREFIX.length());
            }
            radix = 2;
        } else if ("NATURAL.Format".equals(formatId)) {
            if (expressionValue.startsWith(BINARY_PREFIX)) {
                expressionValue = expressionValue.substring(BINARY_PREFIX.length());
                radix = 2;
            } else if (expressionValue.startsWith(OCTAL_PREFIX)) {
                expressionValue = expressionValue.substring(OCTAL_PREFIX.length());
                radix = 8;
            } else if (expressionValue.startsWith(HEX_PREFIX)) {
                expressionValue = expressionValue.substring(HEX_PREFIX.length());
                radix = 16;
            }
        }
        try {
            return new BigInteger(expressionValue, radix);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext formattedDataContext, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)new String[]{"NATURAL.Format", "DECIMAL.Format", "HEX.Format", "OCTAL.Format", "BINARY.Format"});
        rm.done();
    }

    public void getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext formattedDataContext, DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        IDMContext idmContext = formattedDataContext.getParents()[0];
        IFormattedValues.FormattedValueDMData formattedValue = null;
        IEDCExpression exprDMC = null;
        if (idmContext instanceof IEDCExpression) {
            IVariableValueConverter customConverter;
            exprDMC = (IEDCExpression)formattedDataContext.getParents()[0];
            exprDMC.evaluateExpression();
            if (exprDMC != null && exprDMC.getEvaluationError() != null) {
                rm.setStatus(exprDMC.getEvaluationError());
                rm.done();
                return;
            }
            formattedValue = exprDMC.getFormattedValue(formattedDataContext);
            if (formattedDataContext.getFormatID().equals("NATURAL.Format") && (customConverter = this.getCustomValueConverter(exprDMC)) != null) {
                IFormattedValues.FormattedValueDMData customFormattedValue = null;
                try {
                    formattedValue = customFormattedValue = new IFormattedValues.FormattedValueDMData(customConverter.getValue(exprDMC));
                }
                catch (CoreException e) {
                    rm.setStatus(e.getStatus());
                    rm.done();
                    return;
                }
                catch (Throwable t) {
                    EDCDebugger.getMessageLogger().logError(String.valueOf(EDCServicesMessages.Expressions_ErrorInVariableFormatter) + customConverter.getClass().getName(), t);
                }
            }
        } else {
            formattedValue = new IFormattedValues.FormattedValueDMData("");
        }
        rm.setData((Object)formattedValue);
        rm.done();
    }

    private IVariableValueConverter getCustomValueConverter(IEDCExpression exprDMC) {
        IType exprType = TypeUtils.getStrippedType(exprDMC.getEvaluatedType());
        return FormatExtensionManager.instance().getVariableValueConverter(exprType);
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext formattedDataContext, String formatId) {
        return new IFormattedValues.FormattedValueDMContext((IDsfService)this, (IDMContext)formattedDataContext, formatId);
    }

    public void getModelData(IDMContext context, DataRequestMonitor<?> rm) {
    }

    public String getExpressionValue(IExpressions.IExpressionDMContext expression) {
        return this.getExpressionValue(expression, "NATURAL.Format");
    }

    public String getExpressionValue(IExpressions.IExpressionDMContext expression, String format) {
        final StringBuffer holder = new StringBuffer();
        IFormattedValues.FormattedValueDMContext formattedValueContext = this.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)expression, format);
        this.getFormattedExpressionValue(formattedValueContext, new DataRequestMonitor<IFormattedValues.FormattedValueDMData>(ImmediateExecutor.getInstance(), null){

            protected void handleSuccess() {
                holder.append(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
            }

            protected void handleFailure() {
            }
        });
        return holder.toString();
    }

    public void loadExpressionValues(IExpressions.IExpressionDMContext expression, int depth) {
        this.loadExpressionValues(expression, new Integer[]{depth});
    }

    private void loadExpressionValues(IExpressions.IExpressionDMContext expression, final Integer[] depth) {
        this.getExpressionValue(expression);
        if (depth[0] > 0) {
            this.getSubExpressions(expression, new DataRequestMonitor<IExpressions.IExpressionDMContext[]>(ImmediateExecutor.getInstance(), null){

                protected void handleSuccess() {
                    IExpressions.IExpressionDMContext[] subExpressions;
                    depth[0] = depth[0] - 1;
                    IExpressions.IExpressionDMContext[] iExpressionDMContextArray = subExpressions = (IExpressions.IExpressionDMContext[])this.getData();
                    int n = subExpressions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExpressions.IExpressionDMContext iExpressionDMContext = iExpressionDMContextArray[n2];
                        Expressions.this.loadExpressionValues(iExpressionDMContext, depth);
                        ++n2;
                    }
                }
            });
        }
    }

    public abstract class BaseEDCExpressionDMC
    extends DMContext
    implements IEDCExpression {
        protected String expression;
        private InstructionSequence parsedExpression;
        private final ASTEvaluationEngine engine;
        private final Stack.StackFrameDMC frame;
        protected Number value;
        protected IStatus valueError;
        private IVariableLocation valueLocation;
        private IType valueType;
        private boolean hasChildren;
        private String valueString;

        public BaseEDCExpressionDMC(IDMContext parent, String expression, String name) {
            super((IDsfService)Expressions.this, new IDMContext[]{parent}, name, String.valueOf(((IEDCDMContext)parent).getID()) + "." + name);
            this.hasChildren = false;
            this.expression = expression;
            this.frame = (Stack.StackFrameDMC)DMContexts.getAncestorOfType((IDMContext)parent, Stack.StackFrameDMC.class);
            this.engine = new ASTEvaluationEngine(Expressions.this.getServicesTracker(), (IDMContext)this.frame, this.frame.getTypeEngine());
        }

        public BaseEDCExpressionDMC(IDMContext parent, String expression) {
            this(parent, expression, expression);
        }

        public String toString() {
            return this.getExpression();
        }

        public IStack.IFrameDMContext getFrame() {
            return this.frame;
        }

        public String getExpression() {
            return this.expression;
        }

        public void evaluateExpression() {
            IType pointedTo;
            Interpreter interpreter;
            if (this.value != null || this.valueError != null) {
                return;
            }
            String expression = this.getExpression();
            if (this.parsedExpression == null) {
                try {
                    this.parsedExpression = this.engine.getCompiledExpression(expression);
                }
                catch (CoreException e) {
                    this.value = null;
                    this.valueError = e.getStatus();
                    this.valueLocation = null;
                    this.valueType = null;
                    return;
                }
            }
            if (this.parsedExpression.getInstructions().length == 0) {
                this.value = null;
                this.valueError = new Status(4, "org.eclipse.cdt.debug.edc", EDCServicesMessages.Expressions_SyntaxError);
                this.valueLocation = null;
                this.valueType = null;
                return;
            }
            try {
                interpreter = this.engine.evaluateCompiledExpression(this.parsedExpression);
            }
            catch (CoreException e) {
                this.value = null;
                this.valueError = e.getStatus();
                this.valueLocation = null;
                this.valueType = null;
                return;
            }
            OperandValue variableValue = interpreter.getResult();
            if (variableValue == null) {
                this.value = null;
                this.valueError = null;
                this.valueLocation = null;
                this.valueType = null;
                return;
            }
            try {
                this.value = variableValue.getValue();
                this.valueString = variableValue.getStringValue();
            }
            catch (CoreException e1) {
                this.value = null;
                this.valueError = e1.getStatus();
                this.valueLocation = null;
                this.valueType = null;
                return;
            }
            this.valueLocation = variableValue.getValueLocation();
            this.valueType = variableValue.getValueType();
            if (this.valueType instanceof IAggregate && this.valueLocation != null) {
                try {
                    this.value = variableValue.getValueLocationAddress();
                }
                catch (CoreException e) {
                    this.value = null;
                    this.valueError = e.getStatus();
                }
                if (!(this.value instanceof IInvalidVariableLocation)) {
                    this.hasChildren = true;
                }
            } else if (TypeUtils.getStrippedType(this.valueType) instanceof IReferenceType && ((pointedTo = TypeUtils.getStrippedType(this.valueType).getType()) instanceof ICPPBasicType || pointedTo instanceof IPointerType || pointedTo instanceof IEnumeration)) {
                this.valueLocation = variableValue.getValueLocation();
            }
            if (this.valueLocation instanceof IInvalidVariableLocation) {
                this.value = null;
                this.valueError = new Status(4, "org.eclipse.cdt.debug.edc", ((IInvalidVariableLocation)this.valueLocation).getMessage());
                this.valueLocation = null;
                return;
            }
        }

        public IFormattedValues.FormattedValueDMData getFormattedValue(IFormattedValues.FormattedValueDMContext dmc) {
            EDCDebugger.getDefault().getTrace().traceEntry("/debug/variableValue", (Object)dmc);
            this.evaluateExpression();
            String result = "";
            if (this.valueError != null) {
                result = this.valueError.getMessage();
            } else if (this.value != null) {
                result = this.value.toString();
                IType unqualifiedType = TypeUtils.getStrippedType(this.valueType);
                String temp = null;
                String formatID = dmc.getFormatID();
                if (formatID.equals("HEX.Format")) {
                    temp = this.toHexString(this.value);
                } else if (formatID.equals("OCTAL.Format")) {
                    temp = this.toOctalString(this.value);
                } else if (formatID.equals("BINARY.Format")) {
                    temp = this.asBinary(this.value);
                } else if (formatID.equals("NATURAL.Format")) {
                    long enumeratorValue;
                    IEnumerator enumerator;
                    if (unqualifiedType instanceof ICPPBasicType) {
                        ICPPBasicType basicType = (ICPPBasicType)unqualifiedType;
                        switch (basicType.getBaseType()) {
                            case 2: {
                                temp = this.toCharString(this.value);
                                break;
                            }
                            case 7: {
                                temp = this.toCharString(this.value);
                                break;
                            }
                            case 6: {
                                temp = Boolean.toString(this.value.longValue() != 0L);
                                break;
                            }
                            default: {
                                if (basicType.getName().equals("wchar_t")) {
                                    temp = this.toCharString(this.value);
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else if (this.valueType instanceof IAggregate || this.valueType instanceof IPointerType) {
                        temp = this.toHexString(this.value);
                    }
                    if (unqualifiedType instanceof IEnumeration && (enumerator = ((IEnumeration)unqualifiedType).getEnumeratorByValue(enumeratorValue = this.value.longValue())) != null) {
                        if (temp == null) {
                            temp = result;
                        }
                        temp = String.valueOf(enumerator.getName()) + " [" + temp + "]";
                    }
                }
                if (temp != null) {
                    result = temp;
                }
            }
            EDCDebugger.getDefault().getTrace().traceExit("/debug/variableValue", (Object)result);
            return new IFormattedValues.FormattedValueDMData(result);
        }

        private String toHexString(Number number) {
            String str = null;
            if (number instanceof Integer) {
                str = Integer.toHexString((Integer)number);
            } else if (number instanceof Long) {
                str = Long.toHexString((Long)number);
            } else if (number instanceof BigInteger) {
                str = ((BigInteger)number).toString(16);
            } else if (number instanceof Float) {
                str = Float.toHexString(((Float)number).floatValue());
            } else if (number instanceof Double) {
                str = Double.toHexString((Double)number);
            }
            if (str != null && !str.startsWith(Expressions.HEX_PREFIX)) {
                return Expressions.HEX_PREFIX + str;
            }
            return str;
        }

        private String toOctalString(Number number) {
            String str = null;
            if (number instanceof Integer) {
                str = Integer.toOctalString((Integer)number);
            } else if (number instanceof Long) {
                str = Long.toOctalString((Long)number);
            } else if (number instanceof BigInteger) {
                str = ((BigInteger)number).toString(8);
            }
            if (str != null && !str.startsWith(Expressions.OCTAL_PREFIX)) {
                str = Expressions.OCTAL_PREFIX + str;
            }
            if (str == null && (number instanceof Float || number instanceof Double)) {
                str = String.valueOf(number.toString()) + Expressions.DECIMAL_SUFFIX;
            }
            return str;
        }

        private String asBinary(Number number) {
            String str = null;
            if (number instanceof Integer) {
                str = Integer.toBinaryString((Integer)number);
            } else if (number instanceof Long) {
                str = Long.toBinaryString((Long)number);
            } else if (number instanceof BigInteger) {
                str = ((BigInteger)number).toString(2);
            }
            if (str != null && !str.startsWith(Expressions.BINARY_PREFIX)) {
                str = Expressions.BINARY_PREFIX + str;
            }
            if (str == null && (number instanceof Float || number instanceof Double)) {
                str = String.valueOf(number.toString()) + Expressions.DECIMAL_SUFFIX;
            }
            return str;
        }

        private String toCharString(Number number) {
            int intValue = number.intValue();
            String charVal = null;
            if (intValue < 128) {
                switch ((char)intValue) {
                    case '\u0000': {
                        charVal = "\\0";
                        break;
                    }
                    case '\b': {
                        charVal = "\\b";
                        break;
                    }
                    case '\f': {
                        charVal = "\\f";
                        break;
                    }
                    case '\n': {
                        charVal = "\\n";
                        break;
                    }
                    case '\r': {
                        charVal = "\\r";
                        break;
                    }
                    case '\t': {
                        charVal = "\\t";
                        break;
                    }
                    case '\'': {
                        charVal = "\\'";
                        break;
                    }
                    case '\"': {
                        charVal = "\\\"";
                        break;
                    }
                    case '\\': {
                        charVal = "\\\\";
                        break;
                    }
                    case '\u000b': {
                        charVal = "\\v";
                    }
                }
            }
            boolean isWchart = this.valueType instanceof ICPPBasicType && ((ICPPBasicType)this.valueType).getBaseType() == 7 || this.valueType.getName().equals("wchar_t");
            StringBuilder info = new StringBuilder();
            if (isWchart) {
                info.append(Expressions.HEX_PREFIX);
                if (this.valueType.getByteSize() == 2) {
                    info.append(String.format("%04X", intValue));
                } else {
                    info.append(String.format("%08X", intValue));
                }
                info.append(" (L");
            } else {
                info.append("" + intValue);
                info.append(" (");
            }
            if (charVal == null) {
                String fmt = "\\U%08X";
                switch (this.valueType.getByteSize()) {
                    case 1: {
                        fmt = "\\%03o";
                        intValue &= 0xFF;
                        break;
                    }
                    case 2: {
                        fmt = "\\u%04X";
                        intValue &= 0xFFFF;
                        break;
                    }
                    case 4: {
                        fmt = "\\U%08X";
                        intValue &= 0xFFFFFFFF;
                    }
                }
                boolean gotRepr = false;
                try {
                    if (!Character.isISOControl(intValue)) {
                        char[] chars = Character.toChars(intValue);
                        info.append(this.asStringQuoted(new String(chars)));
                        gotRepr = true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (!gotRepr) {
                    info.append(this.asStringQuoted(String.format(fmt, intValue)));
                }
            } else {
                info.append(this.asStringQuoted(charVal));
            }
            info.append(')');
            return info.toString();
        }

        private String asStringQuoted(String val) {
            StringBuilder sb = new StringBuilder(Expressions.SINGLE_QUOTE);
            sb.append(val);
            sb.append(Expressions.SINGLE_QUOTE);
            return sb.toString();
        }

        public IVariableLocation getValueLocation() {
            this.evaluateExpression();
            return this.getEvaluatedLocation();
        }

        public IStatus getEvaluationError() {
            return this.valueError;
        }

        public Number getEvaluatedValue() {
            return this.value;
        }

        public String getEvaluatedValueString() {
            if (this.valueError != null) {
                return this.valueError.getMessage();
            }
            if (this.valueString != null) {
                return this.valueString;
            }
            this.valueString = this.value != null ? this.value.toString() : "";
            return this.valueString;
        }

        public void setEvaluatedValueString(String string) {
            this.valueString = string;
        }

        public void setEvaluatedValue(Number value) {
            this.value = value;
        }

        public IVariableLocation getEvaluatedLocation() {
            return this.valueLocation;
        }

        public IType getEvaluatedType() {
            return this.valueType;
        }

        public String getTypeName() {
            this.evaluateExpression();
            if (this.valueType == null) {
                if (this.valueError != null) {
                    return "";
                }
                return "<UNKNOWN>";
            }
            return this.engine.getTypeEngine().getTypeName(this.valueType);
        }

        public boolean hasChildren() {
            return this.hasChildren;
        }

        public DsfServicesTracker getServiceTracker() {
            return Expressions.this.getServicesTracker();
        }

        public Executor getExecutor() {
            return Expressions.this.getSession().getExecutor();
        }
    }

    class CastInfoCachedData {
        private IExpressions2.CastInfo info;
        private IType type;
        private IStatus error;
        private Stack.StackFrameDMC frameDmc;

        public CastInfoCachedData(ExpressionDMC exprDMC, IExpressions2.CastInfo info) {
            this.info = info;
            this.frameDmc = (Stack.StackFrameDMC)DMContexts.getAncestorOfType((IDMContext)exprDMC, Stack.StackFrameDMC.class);
        }

        public String getTypeString() {
            return this.info.getTypeString();
        }

        public int getArrayStartIndex() {
            return this.info.getArrayStartIndex();
        }

        public int getArrayCount() {
            return this.info.getArrayCount();
        }

        public IType getType() {
            if (this.info.getTypeString() == null) {
                return null;
            }
            if (this.type == null && this.error == null) {
                if (this.frameDmc != null) {
                    ASTEvaluationEngine engine = new ASTEvaluationEngine(Expressions.this.getServicesTracker(), (IDMContext)this.frameDmc, this.frameDmc.getTypeEngine());
                    try {
                        IASTTypeId typeId = engine.getCompiledType(this.info.getTypeString());
                        this.type = engine.getTypeEngine().getTypeForTypeId(typeId);
                    }
                    catch (CoreException e) {
                        this.error = e.getStatus();
                    }
                } else {
                    this.error = EDCDebugger.dsfRequestFailedStatus(EDCServicesMessages.Expressions_CannotCastOutsideFrame, null);
                }
            }
            return this.type;
        }

        public IStatus getError() {
            if (this.type == null && this.error == null) {
                this.getType();
            }
            return this.error;
        }
    }

    private class CastedExpressionDMC
    extends BaseEDCExpressionDMC
    implements IExpressions2.ICastedExpressionDMContext {
        private final IExpressions2.CastInfo castInfo;
        private IType castType;
        private IStatus castError;

        public CastedExpressionDMC(IEDCExpression exprDMC, String expression, String name, IExpressions2.CastInfo castInfo) {
            super((IDMContext)exprDMC, name);
            this.castType = null;
            this.castInfo = castInfo;
            String castType = castInfo.getTypeString();
            String castExpression = expression;
            if (castType != null) {
                if (castInfo.getArrayCount() > 0) {
                    castType = String.valueOf(castType) + "[]";
                    exprDMC.evaluateExpression();
                    IType exprType = TypeUtils.getStrippedType(exprDMC.getEvaluatedType());
                    if (exprType != null && !(exprType instanceof IPointerType) && !(exprType instanceof IArrayType)) {
                        expression = "&" + expression;
                    }
                }
                castExpression = "reinterpret_cast<" + castType + ">(" + expression + ")";
            } else if (castInfo.getArrayCount() > 0) {
                exprDMC.evaluateExpression();
                IType exprType = TypeUtils.getStrippedType(exprDMC.getEvaluatedType());
                if (exprType != null && !(exprType instanceof IPointerType) && !(exprType instanceof IArrayType)) {
                    castExpression = "(" + exprDMC.getTypeName() + "[])&" + expression;
                }
            }
            this.expression = castExpression;
        }

        public void evaluateExpression() {
            if (this.castError != null) {
                return;
            }
            super.evaluateExpression();
        }

        public IType getEvaluatedType() {
            if (this.castType != null) {
                return this.castType;
            }
            return super.getEvaluatedType();
        }

        public IExpressions2.CastInfo getCastInfo() {
            return this.castInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    private static class ExpressionChangedDMEvent
    extends AbstractDMEvent<IExpressions.IExpressionDMContext>
    implements IExpressions.IExpressionChangedDMEvent {
        ExpressionChangedDMEvent(IExpressions.IExpressionDMContext expression) {
            super((IDMContext)expression);
        }
    }

    public class ExpressionDMAddress
    implements IExpressions.IExpressionDMLocation {
        private final IVariableLocation valueLocation;

        public ExpressionDMAddress(IExpressions.IExpressionDMContext exprContext) {
            this.valueLocation = exprContext instanceof IEDCExpression ? ((IEDCExpression)exprContext).getValueLocation() : null;
        }

        public IAddress getAddress() {
            IAddress address;
            if (this.valueLocation != null && (address = this.valueLocation.getAddress()) != null) {
                return address;
            }
            return new Addr64(BigInteger.ZERO);
        }

        public int getSize() {
            return 4;
        }

        public String getLocation() {
            if (this.valueLocation instanceof IInvalidVariableLocation) {
                return ((IInvalidVariableLocation)this.valueLocation).getMessage();
            }
            if (this.valueLocation == null) {
                return "";
            }
            return this.valueLocation.getLocationName();
        }
    }

    private class ExpressionDMC
    extends BaseEDCExpressionDMC {
        public ExpressionDMC(IDMContext parent, String expression) {
            super(parent, expression);
        }

        public ExpressionDMC(IDMContext parent, String expression, String name) {
            super(parent, expression, name);
        }

        public IExpressions2.CastInfo getCastInfo() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExpressionData
    implements IExpressions.IExpressionDMData {
        private final IEDCExpression dmc;

        public ExpressionData(IEDCExpression dmc) {
            this.dmc = dmc;
        }

        public IExpressions.IExpressionDMData.BasicType getBasicType() {
            IExpressions.IExpressionDMData.BasicType basicType = IExpressions.IExpressionDMData.BasicType.unknown;
            if (this.dmc == null) {
                return basicType;
            }
            IType type = this.dmc.getEvaluatedType();
            if ((type = TypeUtils.getStrippedType(type)) instanceof IArrayType) {
                basicType = IExpressions.IExpressionDMData.BasicType.array;
            } else if (type instanceof IBasicType) {
                basicType = IExpressions.IExpressionDMData.BasicType.basic;
            } else if (type instanceof ICompositeType) {
                basicType = IExpressions.IExpressionDMData.BasicType.composite;
            } else if (type instanceof IEnumeration) {
                basicType = IExpressions.IExpressionDMData.BasicType.enumeration;
            } else if (type instanceof IPointerType) {
                basicType = IExpressions.IExpressionDMData.BasicType.pointer;
            } else if (type instanceof ISubroutineType) {
                basicType = IExpressions.IExpressionDMData.BasicType.function;
            }
            return basicType;
        }

        public String getEncoding() {
            return null;
        }

        public Map<String, Integer> getEnumerations() {
            return null;
        }

        public String getName() {
            if (this.dmc != null) {
                return this.dmc.getName();
            }
            return "";
        }

        public IRegisters.IRegisterDMContext getRegister() {
            return null;
        }

        public String getTypeId() {
            return "TYPEID_INTEGER";
        }

        public String getTypeName() {
            if (this.dmc != null) {
                return this.dmc.getTypeName();
            }
            return "";
        }
    }

    protected static class InvalidContextExpressionDMC
    extends AbstractDMContext
    implements IExpressions.IExpressionDMContext {
        private final String expression;

        public InvalidContextExpressionDMC(String sessionId, String expr, IDMContext parent) {
            super(sessionId, new IDMContext[]{parent});
            this.expression = expr;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && this.expression == null ? ((InvalidContextExpressionDMC)((Object)other)).getExpression() == null : this.expression.equals(((InvalidContextExpressionDMC)((Object)other)).getExpression());
        }

        public int hashCode() {
            return this.expression == null ? super.baseHashCode() : super.baseHashCode() ^ this.expression.hashCode();
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".invalid_expr[" + this.expression + "]";
        }

        public String getExpression() {
            return this.expression;
        }
    }
}

