/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.ILineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IModuleLineEntryProvider;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineEntryMapper {
    public static Collection<IModules.AddressRange> getAddressRangesAtSource(IModuleLineEntryProvider moduleLineEntryProvider, IPath sourceFile, int line) {
        Collection<ILineEntryProvider> fileProviders = moduleLineEntryProvider.getLineEntryProvidersForFile(sourceFile);
        if (fileProviders.isEmpty()) {
            return Collections.emptyList();
        }
        int lastColumn = -1;
        IPath lastFile = null;
        ArrayList<Modules.EDCAddressRange> addrRanges = null;
        for (ILineEntryProvider fileProvider : fileProviders) {
            Collection<ILineEntry> entries = fileProvider.getLineEntriesForLines(sourceFile, line, line);
            if (addrRanges == null) {
                addrRanges = new ArrayList<Modules.EDCAddressRange>();
            }
            for (ILineEntry entry : entries) {
                Modules.EDCAddressRange range;
                boolean addNewRange = true;
                if (addrRanges.size() > 0 && entry.getFilePath().equals(lastFile) && lastColumn != entry.getColumnNumber()) {
                    addNewRange = false;
                }
                if (addNewRange) {
                    range = new Modules.EDCAddressRange(entry.getLowAddress(), entry.getHighAddress());
                    addrRanges.add(range);
                } else {
                    range = (Modules.EDCAddressRange)addrRanges.remove(addrRanges.size() - 1);
                    range.setEndAddress(entry.getHighAddress());
                    addrRanges.add(range);
                }
                lastColumn = entry.getColumnNumber();
                lastFile = entry.getFilePath();
            }
        }
        if (addrRanges == null) {
            return Collections.emptyList();
        }
        ArrayList<Modules.EDCAddressRange> returnRanges = addrRanges;
        return Collections.unmodifiableCollection(returnRanges);
    }
}

