/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.snapshot;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.cdt.debug.edc.internal.ZipFileUtils;
import org.eclipse.cdt.debug.edc.internal.snapshot.ISnapshotAlbumEventListener;
import org.eclipse.cdt.debug.edc.internal.snapshot.Snapshot;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.internal.core.LaunchManager;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Album
extends PlatformObject
implements IAlbum {
    public static final String SNAPSHOT = "snapshot";
    private static final String ALBUM = "album";
    private static final String LAUNCH = "launch";
    private static final String RESOURCES = "resources";
    private static final String FILE = "file";
    private static final String INFO = "info";
    public static final String METADATA = "snapshotMetaData";
    public static final String SNAPSHOT_LIST = "snapshots";
    private static final String ALBUM_DATA = "album.xml";
    private static final String ALBUM_VERSION = "100";
    private static String[] DSA_FILE_EXTENSIONS = new String[]{"dsa"};
    public static final String PREF_CREATION_CONTROL = "creation_control";
    public static final String CREATE_MANUAL = "manual";
    public static final String CREATE_WHEN_STOPPED = "suspend";
    public static final String CREATE_AT_BEAKPOINTS = "breakpoints";
    public static final String PREF_VARIABLE_CAPTURE_DEPTH = "variable_capture_depth";
    private static final String CAMERA_CLICK_WAV = "/sounds/camera_click.wav";
    private Document document;
    private Element albumRootElement;
    private final List<Snapshot> snapshotList = new ArrayList<Snapshot>();
    private String sessionID = "";
    private String recordingSessionID = "";
    private IPath albumRootDirectory;
    private boolean launchConfigSaved;
    private String launchType;
    private HashMap<String, Object> launchProperties;
    private String launchName = "";
    private String name;
    private boolean loaded;
    private boolean metaDataLoaded;
    private final Set<IPath> files = new HashSet<IPath>();
    private int currentSnapshotIndex;
    private IPath location;
    private boolean resourceListSaved;
    private boolean metadataSaved;
    private boolean albumInfoSaved;
    private String displayName;
    protected static List<ISnapshotAlbumEventListener> listeners = new ArrayList<ISnapshotAlbumEventListener>();
    private static Map<String, Album> albumsBySessionID = Collections.synchronizedMap(new HashMap());
    private static Map<String, Album> albumsRecordingBySessionID = Collections.synchronizedMap(new HashMap());
    private static Map<IPath, Album> albumsByLocation = Collections.synchronizedMap(new HashMap());
    private static Map<String, Integer> launchNames = Collections.synchronizedMap(new HashMap());
    private static boolean sessionEndedListenerAdded;
    private static DsfSession.SessionEndedListener sessionEndedListener;

    static {
        sessionEndedListener = new DsfSession.SessionEndedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionEnded(DsfSession session) {
                Album album = (Album)albumsRecordingBySessionID.get(session.getId());
                if (album == null) {
                    album = (Album)albumsBySessionID.get(session.getId());
                }
                if (album != null && session.getId().equals(album.getRecordingSessionID())) {
                    album.saveResources((IProgressMonitor)new NullProgressMonitor());
                    album.setRecordingSessionID("");
                }
                Map map = albumsRecordingBySessionID;
                synchronized (map) {
                    albumsRecordingBySessionID.remove(session.getId());
                }
                map = albumsBySessionID;
                synchronized (map) {
                    albumsBySessionID.remove(session.getId());
                }
                if (album != null) {
                    for (ISnapshotAlbumEventListener l : listeners) {
                        l.snapshotSessionEnded(album, session);
                    }
                }
            }
        };
    }

    public Album() {
        try {
            this.setDocument(DebugPlugin.newDocument());
            if (!sessionEndedListenerAdded) {
                DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)sessionEndedListener);
            }
            sessionEndedListenerAdded = true;
        }
        catch (CoreException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getDefaultAlbumName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null || this.displayName.length() == 0) {
            this.displayName = this.getName();
        }
        return this.displayName;
    }

    @Override
    public String getSessionID() {
        this.sessionID = "";
        if (albumsBySessionID != null) {
            for (Map.Entry<String, Album> entry : albumsBySessionID.entrySet()) {
                if (entry.getValue().location == null || !entry.getValue().location.equals((Object)this.getLocation())) continue;
                this.sessionID = entry.getKey();
            }
        }
        return this.sessionID;
    }

    @Override
    public String getRecordingSessionID() {
        return this.recordingSessionID;
    }

    public void setRecordingSessionID(String sessionID) {
        this.recordingSessionID = sessionID;
        if (sessionID.length() > 0) {
            albumsRecordingBySessionID.put(sessionID, this);
        }
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
        if (sessionID.length() > 0) {
            albumsBySessionID.put(sessionID, this);
        }
    }

    public static boolean isSnapshotSession(String sessionId) {
        EDCLaunch launch = EDCLaunch.getLaunchForSession(sessionId);
        return launch != null && launch.isSnapshotLaunch();
    }

    public Snapshot createSnapshot(DsfSession session, Stack.StackFrameDMC stackFrame, IProgressMonitor monitor) {
        this.configureAlbum();
        if (this.getLocation() == null || !this.getLocation().toFile().exists()) {
            this.createEmptyAlbum();
        }
        Snapshot snapshot = new Snapshot(this, session, stackFrame);
        snapshot.writeSnapshotData(monitor);
        this.snapshotList.add(snapshot);
        this.saveAlbum(monitor);
        return snapshot;
    }

    private void configureAlbum() {
        this.saveAlbumInfo();
        this.saveLaunchConfiguration();
    }

    private void saveAlbumInfo() {
        if (!this.albumInfoSaved) {
            Element infoElement = this.document.createElement(INFO);
            infoElement.setAttribute("version", ALBUM_VERSION);
            Calendar calendar = Calendar.getInstance();
            infoElement.setAttribute("month", Integer.toString(calendar.get(2)));
            infoElement.setAttribute("day", Integer.toString(calendar.get(5)));
            infoElement.setAttribute("year", Integer.toString(calendar.get(1)));
            infoElement.setAttribute("hour", Integer.toString(calendar.get(10)));
            infoElement.setAttribute("minute", Integer.toString(calendar.get(12)));
            infoElement.setAttribute("second", Integer.toString(calendar.get(13)));
            Properties systemProps = System.getProperties();
            HashMap<String, Object> infoProps = new HashMap<String, Object>();
            Set<Object> systemKeys = systemProps.keySet();
            for (Object sysKey : systemKeys) {
                if (!(sysKey instanceof String)) continue;
                infoProps.put((String)sysKey, systemProps.get(sysKey));
            }
            Element propsElement = SnapshotUtils.makeXMLFromProperties(this.document, infoProps);
            infoElement.appendChild(propsElement);
            this.getAlbumRootElement().appendChild(infoElement);
            this.albumInfoSaved = true;
        }
    }

    private void saveResourceList() {
        if (!this.resourceListSaved) {
            Element resourcesElement = this.document.createElement(RESOURCES);
            for (IPath filePath : this.files) {
                Element fileElement = this.document.createElement(FILE);
                fileElement.setAttribute("path", filePath.toOSString());
                resourcesElement.appendChild(fileElement);
            }
            this.getAlbumRootElement().appendChild(resourcesElement);
            this.resourceListSaved = true;
        }
    }

    private void saveSnapshotMetadata() {
        if (!this.metadataSaved || this.isRecording()) {
            if (this.metadataSaved) {
                NodeList snapMetaDataNode = this.document.getElementsByTagName(METADATA);
                assert (snapMetaDataNode.item(0) != null);
                this.document.getDocumentElement().removeChild(snapMetaDataNode.item(0));
            }
            Element metadataElement = this.document.createElement(METADATA);
            Element albumElement = this.document.createElement(ALBUM);
            albumElement.setAttribute("albumName", this.getDisplayName());
            metadataElement.appendChild(albumElement);
            Element snapshotsElement = this.document.createElement(SNAPSHOT_LIST);
            metadataElement.appendChild(snapshotsElement);
            for (Snapshot snap : this.snapshotList) {
                Element snapshotMetadataElement = this.document.createElement(SNAPSHOT);
                if (snap.getSnapshotDisplayName().length() == 0) {
                    snapshotMetadataElement.setAttribute("displayName", snap.getSnapshotFileName());
                } else {
                    snapshotMetadataElement.setAttribute("displayName", snap.getSnapshotDisplayName());
                }
                if (snap.getCreationDate() != null) {
                    snapshotMetadataElement.setAttribute("date", snap.getCreationDate().toString());
                } else {
                    snapshotMetadataElement.setAttribute("date", "unknown");
                }
                snapshotMetadataElement.setAttribute("description", snap.getSnapshotDescription());
                snapshotMetadataElement.setAttribute("fileName", snap.getSnapshotFileName());
                snapshotMetadataElement.setAttribute("referenceLocationSourceFile", snap.getReferenceLocationSourceFile());
                snapshotMetadataElement.setAttribute("referenceLocationLineNumber", String.valueOf(snap.getReferenceLocationLineNumber()));
                snapshotsElement.appendChild(snapshotMetadataElement);
            }
            this.getAlbumRootElement().appendChild(metadataElement);
            this.metadataSaved = true;
        }
    }

    private void saveLaunchConfiguration() {
        if (!this.launchConfigSaved) {
            EDCLaunch launch = EDCLaunch.getLaunchForSession(this.getRecordingSessionID());
            try {
                Map map = launch.getLaunchConfiguration().getAttributes();
                Element launchElement = this.document.createElement(LAUNCH);
                this.launchType = launch.getLaunchConfiguration().getType().getIdentifier();
                this.launchName = launch.getLaunchConfiguration().getName();
                Integer count = launchNames.get(this.launchName);
                if (count == null) {
                    launchNames.put(this.launchName, new Integer(0));
                } else {
                    count = new Integer(count + 1);
                    launchNames.put(this.launchName, count);
                    this.launchName = String.valueOf(this.launchName) + " (" + count.toString() + ")";
                }
                launchElement.setAttribute("type", this.launchType);
                launchElement.setAttribute("name", this.launchName);
                Element propsElement = SnapshotUtils.makeXMLFromProperties(this.document, map);
                launchElement.appendChild(propsElement);
                this.getAlbumRootElement().appendChild(launchElement);
            }
            catch (CoreException e) {
                EDCDebugger.getMessageLogger().logError(null, e);
            }
            this.launchConfigSaved = true;
        }
    }

    private static void addZipEntry(ZipOutputStream zipOut, IAlbumArchiveEntry entry, File file) throws FileNotFoundException, IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    Album.addZipEntry(zipOut, entry, child);
                    ++n2;
                }
            } else {
                int len;
                String path = "";
                path = entry != null ? entry.createEntryName(file) : file.getName();
                zipOut.putNextEntry(new ZipEntry(path));
                byte[] buf = new byte[1024];
                FileInputStream in = new FileInputStream(file);
                while ((len = in.read(buf)) > 0) {
                    zipOut.write(buf, 0, len);
                }
                zipOut.closeEntry();
                in.close();
            }
        }
    }

    private void saveAlbum(IProgressMonitor monitor) {
        IPath zipPath = this.getLocation();
        ZipOutputStream zipOut = null;
        try {
            try {
                zipOut = new ZipOutputStream(new FileOutputStream(zipPath.toFile()));
                zipOut.putNextEntry(new ZipEntry(ALBUM_DATA));
                this.saveResourceList();
                this.saveSnapshotMetadata();
                String xml = LaunchManager.serializeDocument((Document)this.document);
                zipOut.write(xml.getBytes("UTF8"));
                zipOut.closeEntry();
                for (Snapshot snap : this.snapshotList) {
                    zipOut.putNextEntry(new ZipEntry(snap.getSnapshotFileName()));
                    snap.saveSnapshot(zipOut);
                }
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError(null, e);
                try {
                    zipOut.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                zipOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveResources(IProgressMonitor monitor) {
        IPath zipPath = this.getLocation();
        ZipOutputStream zipOut = null;
        try {
            try {
                zipOut = new ZipOutputStream(new FileOutputStream(zipPath.toFile()));
                for (IPath path : this.files) {
                    IAlbumArchiveEntry entry = new IAlbumArchiveEntry(){

                        public String createEntryName(File file) {
                            StringBuffer entryPath = new StringBuffer();
                            entryPath.append("Resources/");
                            Path filepath = new Path(file.getAbsolutePath());
                            String deviceName = filepath.getDevice();
                            if (deviceName != null) {
                                entryPath.append(deviceName.substring(0, deviceName.length() - 1));
                                entryPath.append("/");
                            }
                            String[] segments = filepath.segments();
                            int numSegments = segments.length - 1;
                            int i = 0;
                            while (i < numSegments) {
                                entryPath.append(segments[i]);
                                entryPath.append("/");
                                ++i;
                            }
                            entryPath.append(file.getName());
                            return entryPath.toString();
                        }
                    };
                    Album.addZipEntry(zipOut, entry, path.toFile());
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                zipOut.putNextEntry(new ZipEntry(ALBUM_DATA));
                this.saveResourceList();
                this.saveSnapshotMetadata();
                String xml = LaunchManager.serializeDocument((Document)this.document);
                zipOut.write(xml.getBytes("UTF8"));
                zipOut.closeEntry();
                for (Snapshot snap : this.snapshotList) {
                    zipOut.putNextEntry(new ZipEntry(snap.getSnapshotFileName()));
                    snap.saveSnapshot(zipOut);
                }
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError(null, e);
                try {
                    zipOut.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                zipOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getDefaultAlbumName() {
        return this.getLaunchName();
    }

    public void saveAlbum(IPath path) throws TransformerException, IOException {
        String xml = LaunchManager.serializeDocument((Document)this.document);
        File file = path.toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(xml.getBytes("UTF8"));
        stream.close();
    }

    @Override
    public void openSnapshot(final int index) {
        final DsfSession session = DsfSession.getSession((String)this.sessionID);
        DsfRunnable openIt = new DsfRunnable(){

            public void run() {
                Album.this.currentSnapshotIndex = index;
                try {
                    Album.this.loadAlbum(false);
                }
                catch (Exception e) {
                    EDCDebugger.getMessageLogger().logError(null, e);
                }
                if (session != null && Album.this.snapshotList.size() > index) {
                    Snapshot snapshot = (Snapshot)((Object)Album.this.snapshotList.get(index));
                    snapshot.open(session);
                    for (ISnapshotAlbumEventListener l : listeners) {
                        l.snapshotOpened(snapshot);
                    }
                }
            }
        };
        if (session.getExecutor().isInExecutorThread()) {
            openIt.run();
        } else {
            session.getExecutor().execute((Runnable)openIt);
        }
    }

    @Override
    public int getCurrentSnapshotIndex() {
        return this.currentSnapshotIndex;
    }

    @Override
    public void openNextSnapshot() throws Exception {
        int nextIndex = this.currentSnapshotIndex + 1;
        if (nextIndex >= this.snapshotList.size()) {
            nextIndex = 0;
        }
        this.openSnapshot(nextIndex);
    }

    @Override
    public void openPreviousSnapshot() throws Exception {
        int previousIndex = this.currentSnapshotIndex - 1;
        if (previousIndex < 0) {
            previousIndex = this.snapshotList.size() - 1;
        }
        this.openSnapshot(previousIndex);
    }

    public void loadAlbum(boolean force) throws ParserConfigurationException, SAXException, IOException {
        if (force) {
            this.loaded = false;
        }
        if (!this.loaded) {
            File albumFile = this.location.toFile();
            this.setName(albumFile.getName());
            if (!this.isRecording()) {
                try {
                    ZipFileUtils.unzipFiles(albumFile, this.getAlbumRootDirectory().toOSString(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    EDCDebugger.getMessageLogger().logError(null, e);
                }
            }
            BufferedInputStream stream = ZipFileUtils.openFile(albumFile, ALBUM_DATA, DSA_FILE_EXTENSIONS);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            this.setDocument(parser.parse(new InputSource(stream)));
            this.loadAlbumInfo();
            this.loadLaunchConfiguration();
            this.loadResourceList();
            try {
                try {
                    this.loadSnapshotMetadata();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.loaded = true;
                    ZipFileUtils.unmount();
                }
            }
            finally {
                this.loaded = true;
                ZipFileUtils.unmount();
            }
        }
    }

    public void loadAlbumMetada(boolean force) throws Exception {
        if (force) {
            this.metaDataLoaded = false;
        }
        if (!this.metaDataLoaded) {
            File albumFile = this.location.toFile();
            this.setDisplayName(albumFile.getName());
            BufferedInputStream stream = null;
            try {
                try {
                    stream = ZipFileUtils.openFile(albumFile, ALBUM_DATA, DSA_FILE_EXTENSIONS);
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    parser.setErrorHandler(new DefaultHandler());
                    this.setDocument(parser.parse(new InputSource(stream)));
                    this.loadSnapshotMetadata();
                    this.loadLaunchConfiguration();
                }
                catch (Exception e) {
                    EDCDebugger.getMessageLogger().logError("Failed to load album: " + this.getName(), e);
                    this.metaDataLoaded = true;
                    ZipFileUtils.unmount();
                }
            }
            finally {
                this.metaDataLoaded = true;
                ZipFileUtils.unmount();
            }
        }
    }

    private void loadAlbumInfo() {
        this.document.getElementsByTagName(INFO).item(0);
    }

    private void setDocument(Document newDoc) {
        this.document = newDoc;
        this.albumRootElement = null;
    }

    private Element getAlbumRootElement() {
        if (this.albumRootElement == null) {
            NodeList albumRootElements = this.document.getElementsByTagName(ALBUM);
            if (albumRootElements.getLength() == 0) {
                this.albumRootElement = this.document.createElement(ALBUM);
                this.document.appendChild(this.albumRootElement);
            } else {
                this.albumRootElement = (Element)albumRootElements.item(0);
            }
        }
        return this.albumRootElement;
    }

    private void loadResourceList() {
        NodeList resources = this.document.getElementsByTagName(RESOURCES);
        NodeList elementFiles = ((Element)resources.item(0)).getElementsByTagName(FILE);
        int numFiles = elementFiles.getLength();
        int i = 0;
        while (i < numFiles) {
            Element fileElement = (Element)elementFiles.item(i);
            String elementPath = fileElement.getAttribute("path");
            this.files.add(PathUtils.createPath(elementPath));
            ++i;
        }
    }

    private void loadSnapshotMetadata() throws Exception {
        this.snapshotList.clear();
        NodeList snapMetaDataNode = this.document.getElementsByTagName(METADATA);
        if (snapMetaDataNode.getLength() == 0) {
            throw new Exception("Invalid or corrupted Album : " + this.getName());
        }
        NodeList albumNameElement = ((Element)snapMetaDataNode.item(0)).getElementsByTagName(ALBUM);
        Element albumElement = (Element)albumNameElement.item(0);
        String albumDisplayName = albumElement.getAttribute("albumName");
        this.setDisplayName(albumDisplayName);
        NodeList elementSnapshots = ((Element)snapMetaDataNode.item(0)).getElementsByTagName(SNAPSHOT);
        int numSnapshots = elementSnapshots.getLength();
        int i = 0;
        while (i < numSnapshots) {
            Element snapshotElement = (Element)elementSnapshots.item(i);
            String elementDescription = snapshotElement.getAttribute("description");
            String elementDate = snapshotElement.getAttribute("date");
            String elementDispalyName = snapshotElement.getAttribute("displayName");
            String elementFileName = snapshotElement.getAttribute("fileName");
            String referenceLocationSourceFile = snapshotElement.getAttribute("referenceLocationSourceFile");
            String referenceLocationLineNumber = snapshotElement.getAttribute("referenceLocationLineNumber");
            Snapshot s = new Snapshot(this);
            s.setCreationDate(elementDate);
            s.setSnapshotFileName(elementFileName);
            s.setSnapshotDisplayName(elementDispalyName);
            s.setSnapshotDescription(elementDescription);
            if (referenceLocationLineNumber.length() > 0) {
                s.setReferenceLocationLineNumber(Long.parseLong(referenceLocationLineNumber));
            }
            s.setReferenceLocationSourceFile(referenceLocationSourceFile);
            this.snapshotList.add(s);
            ++i;
        }
    }

    private void loadLaunchConfiguration() {
        NodeList launchElements = this.document.getElementsByTagName(LAUNCH);
        Element launchElement = (Element)launchElements.item(0);
        if (launchElement == null) {
            return;
        }
        this.launchType = launchElement.getAttribute("type");
        this.launchName = launchElement.getAttribute("name");
        Element propElement = (Element)launchElement.getElementsByTagName("properties").item(0);
        this.launchProperties = new HashMap();
        try {
            SnapshotUtils.initializeFromXML(propElement, this.launchProperties);
        }
        catch (Exception e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(Document.class)) {
            return this.document;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IPath getAlbumRootDirectory() {
        if (this.albumRootDirectory == null) {
            File dir;
            IPath path = EDCDebugger.getDefault().getStateLocation().append("SnapshotAlbums");
            String locationName = this.location.lastSegment();
            int extension = locationName.lastIndexOf(".");
            if (extension > 0) {
                locationName = locationName.substring(0, extension);
            }
            if (!(dir = (path = path.append(locationName)).toFile()).exists()) {
                dir.mkdirs();
            }
            this.albumRootDirectory = path;
        }
        return this.albumRootDirectory;
    }

    @Override
    public String getLaunchTypeID() {
        return this.launchType;
    }

    @Override
    public HashMap<String, Object> getLaunchProperties() {
        return this.launchProperties;
    }

    public void setLaunchProperties(HashMap<String, Object> launchProperties) {
        this.launchProperties = launchProperties;
    }

    @Override
    public String getLaunchName() {
        return this.launchName;
    }

    @Override
    public void playSnapshots(DsfSession session) {
    }

    @Override
    public void addFile(IPath path) {
        this.files.add(path);
    }

    public static Album getAlbumByLocation(IPath path) {
        return albumsByLocation.get(path);
    }

    public static IAlbum getAlbumBySession(String sessionId) {
        return albumsBySessionID.get(sessionId);
    }

    public static Album getRecordingForSession(String sessionId) {
        return albumsRecordingBySessionID.get(sessionId);
    }

    public void setLocation(IPath albumPath) {
        this.location = albumPath;
        albumsByLocation.put(albumPath, this);
    }

    @Override
    public IPath getLocation() {
        return this.location;
    }

    @Override
    public void configureSourceLookupDirector(ISourceLookupDirector director) {
        MappingSourceContainer sourceContainer = new MappingSourceContainer(this.getName());
        this.configureMappingSourceContainer(sourceContainer);
        ArrayList<ISourceContainer> containers = new ArrayList<ISourceContainer>(Arrays.asList(director.getSourceContainers()));
        containers.add((ISourceContainer)sourceContainer);
        DirectorySourceContainer directoryContainer = new DirectorySourceContainer(this.getResourcesDirectory(), true);
        containers.add((ISourceContainer)directoryContainer);
        director.setSourceContainers(containers.toArray(new ISourceContainer[containers.size()]));
    }

    protected IPath getResourcesDirectory() {
        return this.getAlbumRootDirectory().append("Resources");
    }

    @Override
    public void configureMappingSourceContainer(MappingSourceContainer mappingContainer) {
        IPath albumRoot = this.getResourcesDirectory();
        ArrayList<MapEntrySourceContainer> containers = new ArrayList<MapEntrySourceContainer>();
        HashSet<String> devicesAlreadyAdded = new HashSet<String>();
        String deviceName = null;
        for (IPath iPath : this.files) {
            deviceName = iPath.getDevice();
            if (deviceName == null || devicesAlreadyAdded.contains(deviceName)) continue;
            String albumRootSuffix = deviceName;
            if (albumRootSuffix.endsWith(":")) {
                albumRootSuffix = albumRootSuffix.substring(0, albumRootSuffix.length() - 1);
            }
            devicesAlreadyAdded.add(deviceName);
            MapEntrySourceContainer newContainer = new MapEntrySourceContainer(PathUtils.createPath(deviceName), albumRoot.append(albumRootSuffix));
            containers.add(newContainer);
        }
        mappingContainer.addMapEntries(containers.toArray(new MapEntrySourceContainer[containers.size()]));
    }

    public static void setVariableCaptureDepth(int newSetting) {
        IEclipsePreferences scope = new InstanceScope().getNode("org.eclipse.cdt.debug.edc");
        scope.putInt(PREF_VARIABLE_CAPTURE_DEPTH, newSetting);
        try {
            scope.flush();
        }
        catch (BackingStoreException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }

    public static int getVariableCaptureDepth() {
        return Platform.getPreferencesService().getInt("org.eclipse.cdt.debug.edc", PREF_VARIABLE_CAPTURE_DEPTH, 5, null);
    }

    public static void setSnapshotCreationControl(String newSetting) {
        IEclipsePreferences scope = new InstanceScope().getNode("org.eclipse.cdt.debug.edc");
        scope.put(PREF_CREATION_CONTROL, newSetting);
        try {
            scope.flush();
        }
        catch (BackingStoreException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }

    public static String getSnapshotCreationControl() {
        return Platform.getPreferencesService().getString("org.eclipse.cdt.debug.edc", PREF_CREATION_CONTROL, CREATE_MANUAL, null);
    }

    public static void createSnapshotForSession(final DsfSession session, final Stack.StackFrameDMC stackFrame, final IProgressMonitor monitor) {
        String sessionId = session.getId();
        Album album = Album.getRecordingForSession(sessionId);
        if (album == null) {
            album = new Album();
            album.setRecordingSessionID(sessionId);
        }
        final Album finalAlbum = album;
        final Snapshot[] newSnapshot = new Snapshot[1];
        Album.playSnapshotSound();
        Query<Boolean> query = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                newSnapshot[0] = finalAlbum.createSnapshot(session, stackFrame, monitor);
                rm.setData((Object)true);
                rm.done();
            }
        };
        session.getExecutor().execute((Runnable)query);
        try {
            query.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
        for (ISnapshotAlbumEventListener l : listeners) {
            l.snapshotCreated(album, newSnapshot[0], session, stackFrame);
        }
    }

    protected static void playSnapshotSound() {
        block10: {
            Bundle bundle = Platform.getBundle((String)EDCDebugger.getUniqueIdentifier());
            if (bundle == null) {
                return;
            }
            URL url = null;
            try {
                try {
                    url = FileLocator.toFileURL((URL)bundle.getEntry(CAMERA_CLICK_WAV));
                }
                catch (IOException iOException) {
                    if (url != null) {
                        File f = new File(url.getFile());
                        SnapshotUtils.playSoundFile(f);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (url == null) break block10;
                    File f = new File(url.getFile());
                    SnapshotUtils.playSoundFile(f);
                }
            }
            finally {
                if (url != null) {
                    File f = new File(url.getFile());
                    SnapshotUtils.playSoundFile(f);
                }
            }
        }
    }

    @Override
    public List<Snapshot> getSnapshots() {
        if (this.snapshotList == null || this.snapshotList.size() == 0) {
            try {
                this.loadAlbumMetada(false);
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError("Failed to load snapshots", e);
            }
        }
        return this.snapshotList;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    public int getIndexOfSnapshot(Snapshot snap) {
        return this.snapshotList.indexOf((Object)snap);
    }

    public void setCurrentSnapshotIndex(int index) {
        if (this.currentSnapshotIndex >= 0 && this.currentSnapshotIndex < this.snapshotList.size()) {
            this.currentSnapshotIndex = index;
        }
    }

    public void updateSnapshotMetaData(String albumName, Snapshot snap) {
        NodeList snapMetaDataNode = this.document.getElementsByTagName(METADATA);
        if (albumName != null) {
            NodeList albumNameNode = ((Element)snapMetaDataNode.item(0)).getElementsByTagName(ALBUM);
            ((Element)albumNameNode.item(0)).setAttribute("albumName", albumName);
        }
        if (snap != null) {
            NodeList elementSnapshots = ((Element)snapMetaDataNode.item(0)).getElementsByTagName(SNAPSHOT);
            int numSnapshots = elementSnapshots.getLength();
            int i = 0;
            while (i < numSnapshots) {
                Element currentSnapshotNode = (Element)elementSnapshots.item(i);
                String fileName = currentSnapshotNode.getAttribute("fileName");
                if (fileName.equals(snap.getSnapshotFileName())) {
                    currentSnapshotNode.setAttribute("description", snap.getSnapshotDescription());
                    currentSnapshotNode.setAttribute("displayName", snap.getSnapshotDisplayName());
                    break;
                }
                ++i;
            }
        }
        this.saveAlbumData();
        try {
            this.loadAlbumMetada(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveAlbumData() {
        try {
            File tempFile = File.createTempFile(ALBUM, ".xml");
            File tempFile2 = new File(String.valueOf(tempFile.getParent()) + File.separator + ALBUM_DATA);
            tempFile.delete();
            if (!tempFile2.exists()) {
                tempFile2.delete();
            }
            tempFile2.createNewFile();
            this.saveAlbum((IPath)new Path(tempFile2.toString()));
            File[] fileList = new File[]{tempFile2};
            ZipFileUtils.addFilesToZip(fileList, this.getLocation().toFile(), DSA_FILE_EXTENSIONS);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public void deleteSnapshot(Snapshot snap) {
        NodeList snapMetaDataNode = this.document.getElementsByTagName(METADATA);
        NodeList elementSnapshotList = ((Element)snapMetaDataNode.item(0)).getElementsByTagName(SNAPSHOT_LIST);
        NodeList elementSnapshots = ((Element)snapMetaDataNode.item(0)).getElementsByTagName(SNAPSHOT);
        int numSnapshots = elementSnapshots.getLength();
        int i = 0;
        while (i < numSnapshots) {
            Element currentSnapshotNode = (Element)elementSnapshots.item(i);
            String fileName = currentSnapshotNode.getAttribute("fileName");
            if (fileName.equals(snap.getSnapshotFileName())) {
                elementSnapshotList.item(0).removeChild(currentSnapshotNode);
                break;
            }
            ++i;
        }
        this.snapshotList.remove((Object)snap);
        this.saveAlbumData();
        try {
            this.loadAlbum(true);
            this.loadAlbumMetada(true);
        }
        catch (Exception exception) {}
        ZipFileUtils.deleteFileFromZip(snap.getSnapshotFileName(), this.getLocation().toFile(), DSA_FILE_EXTENSIONS);
    }

    public String toString() {
        return "Album [name=" + this.name + ", launchName=" + this.launchName + ", sessionID=" + this.sessionID + "]";
    }

    public IPath createEmptyAlbum() {
        IPath zipPath = null;
        zipPath = SnapshotUtils.getSnapshotsProject().getLocation();
        zipPath = zipPath.append(this.getDefaultAlbumName());
        zipPath = zipPath.addFileExtension("dsa");
        boolean created = ZipFileUtils.createNewZip(zipPath.toFile());
        if (!created || !zipPath.toFile().exists()) {
            return null;
        }
        this.setLocation(zipPath);
        try {
            SnapshotUtils.getSnapshotsProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            EDCDebugger.getMessageLogger().logError(e.getLocalizedMessage(), e);
        }
        return zipPath;
    }

    @Override
    public boolean isRecording() {
        return this.recordingSessionID.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSnapshotAlbumEventListener(ISnapshotAlbumEventListener listener) {
        ISnapshotAlbumEventListener iSnapshotAlbumEventListener = listener;
        synchronized (iSnapshotAlbumEventListener) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSnapshotAlbumEventListener(ISnapshotAlbumEventListener listener) {
        ISnapshotAlbumEventListener iSnapshotAlbumEventListener = listener;
        synchronized (iSnapshotAlbumEventListener) {
            listeners.remove(listener);
        }
    }

    public static void captureSnapshotForSession(final DsfSession session, final IRunControl.IExecutionDMContext dmContext) {
        Job createSnapshotJob = new Job("Creating Debug Snapshot"){

            protected IStatus run(IProgressMonitor monitor) {
                Query<IStack.IFrameDMContext> query = new Query<IStack.IFrameDMContext>(){

                    protected void execute(DataRequestMonitor<IStack.IFrameDMContext> rm) {
                        DsfServicesTracker servicesTracker = new DsfServicesTracker(EDCDebugger.getBundleContext(), dmContext.getSessionId());
                        try {
                            Stack stackService = (Stack)((Object)servicesTracker.getService(Stack.class));
                            if (stackService != null) {
                                stackService.getTopFrame((IDMContext)dmContext, rm);
                            }
                        }
                        finally {
                            servicesTracker.dispose();
                        }
                    }
                };
                session.getExecutor().execute((Runnable)query);
                try {
                    IStack.IFrameDMContext result = (IStack.IFrameDMContext)query.get();
                    Stack.StackFrameDMC topFrame = (Stack.StackFrameDMC)result;
                    Album.createSnapshotForSession(session, topFrame, monitor);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    EDCDebugger.getMessageLogger().logError(null, e);
                }
                return Status.OK_STATUS;
            }
        };
        createSnapshotJob.schedule();
    }

    public static interface IAlbumArchiveEntry {
        public String createEntryName(File var1);
    }
}

