/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.MayBeQualifiedType;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPPBasicType
extends MayBeQualifiedType
implements ICPPBasicType {
    private final int baseType;
    private final int qualifierBits;

    public CPPBasicType(String name, IScope scope, int baseType, int qualifierBits, int byteSize, Map<Object, Object> properties) {
        super(name, scope, byteSize, properties);
        this.baseType = baseType;
        this.qualifierBits = qualifierBits;
    }

    public CPPBasicType(String name, int baseType, int qualifierBits, int byteSize) {
        super(name, null, byteSize, null);
        this.baseType = baseType;
        this.qualifierBits = qualifierBits;
    }

    public int hashCode() {
        int result = 12345;
        result = 31 * result + this.baseType;
        result = 31 * result + this.qualifierBits;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CPPBasicType other = (CPPBasicType)obj;
        if (this.baseType != other.baseType) {
            return false;
        }
        return this.qualifierBits == other.qualifierBits;
    }

    @Override
    public int getQualifierBits() {
        return this.qualifierBits;
    }

    @Override
    public int getBaseType() {
        return this.baseType;
    }

    @Override
    public boolean isLong() {
        return (this.qualifierBits & 1) != 0;
    }

    @Override
    public boolean isLongLong() {
        return (this.qualifierBits & 0x40) != 0;
    }

    @Override
    public boolean isShort() {
        return (this.qualifierBits & 2) != 0;
    }

    @Override
    public boolean isSigned() {
        return (this.qualifierBits & 4) != 0;
    }

    @Override
    public boolean isUnsigned() {
        return (this.qualifierBits & 8) != 0;
    }

    @Override
    public boolean isComplex() {
        return (this.qualifierBits & 0x10) != 0;
    }

    @Override
    public IType getType() {
        return null;
    }
}

