/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.memorybrowser;

import org.eclipse.cdt.debug.ui.memory.memorybrowser.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GoToAddressBarWidget {
    private Text fExpression;
    private ControlDecoration fEmptyExpression;
    private ControlDecoration fWrongExpression;
    private Button fOKButton;
    private Button fOKNewTabButton;
    private Composite fComposite;
    protected static int ID_GO_NEW_TAB = 2000;

    public Control createControl(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fComposite, ".GoToAddressComposite_context");
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        this.fComposite.setLayout((Layout)layout);
        this.fExpression = this.createExpressionField(this.fComposite);
        this.fOKButton = new Button(this.fComposite, 0);
        this.fOKButton.setText(Messages.getString("GoToAddressBarWidget.Go"));
        this.fOKButton.setEnabled(false);
        this.fOKNewTabButton = new Button(this.fComposite, 0);
        this.fOKNewTabButton.setText(Messages.getString("GoToAddressBarWidget.NewTab"));
        this.fOKNewTabButton.setEnabled(false);
        return this.fComposite;
    }

    private Text createExpressionField(Composite parent) {
        Text expression = new Text(parent, 2052);
        expression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GoToAddressBarWidget.this.updateButtons();
            }
        });
        this.fEmptyExpression = new ControlDecoration((Control)expression, 0x1004000);
        this.fEmptyExpression.setDescriptionText(Messages.getString("GoToAddressBarWidget.EnterExpressionMessage"));
        FieldDecoration fieldDec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED");
        this.fEmptyExpression.setImage(fieldDec.getImage());
        this.fWrongExpression = new ControlDecoration((Control)expression, 16512);
        fieldDec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.fWrongExpression.setImage(fieldDec.getImage());
        this.fWrongExpression.hide();
        GridData data = new GridData(768);
        data.horizontalIndent = Math.max(this.fEmptyExpression.getImage().getBounds().width, this.fWrongExpression.getImage().getBounds().width);
        expression.setLayoutData((Object)data);
        return expression;
    }

    protected void updateButtons() {
        boolean empty = this.getExpressionText().length() == 0;
        this.fOKNewTabButton.setEnabled(!empty);
        this.fOKButton.setEnabled(!empty);
        if (empty) {
            this.fEmptyExpression.show();
        } else {
            this.fEmptyExpression.hide();
        }
        this.fWrongExpression.hide();
    }

    public int getHeight() {
        int height = this.fComposite.computeSize((int)-1, (int)-1).y;
        return height;
    }

    public Button getButton(int id) {
        if (id == 0) {
            return this.fOKButton;
        }
        if (id == ID_GO_NEW_TAB) {
            return this.fOKNewTabButton;
        }
        return null;
    }

    public String getExpressionText() {
        return this.fExpression.getText().trim();
    }

    public Text getExpressionWidget() {
        return this.fExpression;
    }

    public void handleExpressionStatus(IStatus message) {
        if (message.isOK()) {
            this.fWrongExpression.hide();
        } else {
            this.fWrongExpression.setDescriptionText(message.getMessage());
            this.fWrongExpression.show();
        }
    }
}

