/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.elements.adapters;

import org.eclipse.cdt.debug.core.model.IDisassemblyLine;
import org.eclipse.cdt.debug.internal.core.model.DisassemblyRetrieval;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditorPresentation;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentBaseChangeUpdate;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementContentProvider;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementContentUpdate;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;

public class DisassemblyElementContentProvider
implements IDocumentElementContentProvider {
    public void updateContent(final IDocumentElementContentUpdate update) {
        Job job = new Job("Source content update"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!update.isCanceled()) {
                    DisassemblyElementContentProvider.this.retrieveDisassembly(update);
                }
                update.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void updateInput(final IDocumentBaseChangeUpdate update) {
        Job job = new Job("Input update"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!update.isCanceled()) {
                    DisassemblyElementContentProvider.this.changeBaseElement(update);
                }
                update.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void changeBaseElement(IDocumentBaseChangeUpdate update) {
        Object root = update.getRootElement();
        if (root instanceof DisassemblyRetrieval) {
            DisassemblyRetrieval retrieval = (DisassemblyRetrieval)root;
            try {
                retrieval.changeBase(update.getElement(), update.getOriginalOffset(), this.getPresentationFlags((IDocumentPresentation)update.getPresentationContext()));
                update.setBaseElement(retrieval.getBaseElement());
                update.setOffset(retrieval.getCurrentOffset());
            }
            catch (DebugException e) {
                update.setStatus(e.getStatus());
            }
        }
    }

    protected void retrieveDisassembly(IDocumentElementContentUpdate update) {
        Object root = update.getRootElement();
        if (root instanceof DisassemblyRetrieval) {
            DisassemblyRetrieval retrieval = (DisassemblyRetrieval)root;
            try {
                retrieval.retrieveDisassembly(update.getElement(), update.getBaseElement(), update.getOriginalOffset(), update.getRequestedLineCount(), update.reveal(), this.getPresentationFlags((IDocumentPresentation)update.getPresentationContext()));
                IDisassemblyLine[] lines = retrieval.getLines();
                update.setOffset(retrieval.getCurrentOffset());
                update.setLineCount(lines.length);
                int i = 0;
                while (i < lines.length) {
                    update.addElement(i, lines[i]);
                    ++i;
                }
            }
            catch (DebugException e) {
                update.setStatus(e.getStatus());
            }
        }
    }

    private int getPresentationFlags(IDocumentPresentation presentation) {
        int flags = 0;
        if (presentation instanceof DisassemblyEditorPresentation) {
            DisassemblyEditorPresentation dep = (DisassemblyEditorPresentation)presentation;
            if (dep.showIntstructions()) {
                flags |= 1;
            }
            if (dep.showSource()) {
                flags |= 2;
            }
        }
        return flags;
    }
}

