/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener;
import org.eclipse.cdt.debug.internal.ui.views.executables.Messages;
import org.eclipse.cdt.debug.internal.ui.views.executables.SourceFilesViewer;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFilesContentProvider
extends CElementContentProvider
implements IExecutablesChangeListener {
    private Map<IPath, QuickParseJob> pathToJobMap = new HashMap<IPath, QuickParseJob>();
    private Map<IPath, ITranslationUnit[]> fetchedExecutables = new HashMap<IPath, ITranslationUnit[]>();
    private final SourceFilesViewer viewer;

    public SourceFilesContentProvider(SourceFilesViewer viewer) {
        super(true, true);
        this.viewer = viewer;
        ExecutablesManager.getExecutablesManager().addExecutablesChangeListener((IExecutablesChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ExecutablesManager.getExecutablesManager().removeExecutablesChangeListener((IExecutablesChangeListener)this);
        Map<IPath, Object> map = this.fetchedExecutables;
        synchronized (map) {
            this.fetchedExecutables.clear();
        }
        map = this.pathToJobMap;
        synchronized (map) {
            this.pathToJobMap.clear();
        }
        super.dispose();
    }

    public boolean hasChildren(Object element) {
        SourceFilesViewer.TranslationUnitInfo info;
        if (element instanceof ITranslationUnit && (info = SourceFilesViewer.fetchTranslationUnitInfo((Executable)this.viewer.getInput(), element)) != null && !info.exists) {
            return false;
        }
        return super.hasChildren(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Executable) {
            QuickParseJob job;
            final Executable executable = (Executable)inputElement;
            final IPath exePath = executable.getPath();
            Map<IPath, QuickParseJob> map = this.pathToJobMap;
            synchronized (map) {
                job = this.pathToJobMap.get(exePath);
            }
            if (job != null) {
                return new String[]{Messages.SourceFilesContentProvider_Refreshing};
            }
            map = this.fetchedExecutables;
            synchronized (map) {
                if (this.fetchedExecutables.containsKey(exePath)) {
                    return this.fetchedExecutables.get(exePath);
                }
            }
            job = new QuickParseJob(executable);
            map = this.pathToJobMap;
            synchronized (map) {
                this.pathToJobMap.put(exePath, job);
            }
            final QuickParseJob theJob = job;
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    Map map = SourceFilesContentProvider.this.pathToJobMap;
                    synchronized (map) {
                        SourceFilesContentProvider.this.pathToJobMap.values().remove((Object)theJob);
                    }
                    if (event.getResult().isOK()) {
                        map = SourceFilesContentProvider.this.fetchedExecutables;
                        synchronized (map) {
                            SourceFilesContentProvider.this.fetchedExecutables.put(exePath, theJob.tus);
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (!SourceFilesContentProvider.this.viewer.getControl().isDisposed()) {
                                    SourceFilesContentProvider.this.viewer.getTree().setLayoutDeferred(true);
                                    SourceFilesContentProvider.this.viewer.refresh(executable);
                                    SourceFilesContentProvider.this.viewer.packColumns();
                                    SourceFilesContentProvider.this.viewer.getTree().setLayoutDeferred(false);
                                }
                            }
                        });
                    }
                }
            });
            job.schedule();
            return new String[]{Messages.SourceFilesContentProvider_Refreshing};
        }
        return new Object[0];
    }

    public void executablesListChanged() {
        this.cancelQuickParseJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelQuickParseJobs() {
        Map<IPath, QuickParseJob> map = this.pathToJobMap;
        synchronized (map) {
            for (QuickParseJob job : this.pathToJobMap.values()) {
                job.cancel();
            }
            this.pathToJobMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executablesChanged(List<Executable> executables) {
        for (Executable executable : executables) {
            IPath exePath = executable.getPath();
            Map<IPath, Object> map = this.fetchedExecutables;
            synchronized (map) {
                this.fetchedExecutables.remove(exePath);
            }
            map = this.pathToJobMap;
            synchronized (map) {
                QuickParseJob job = this.pathToJobMap.get(exePath);
                if (job != null) {
                    job.cancel();
                    this.pathToJobMap.remove(exePath);
                }
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, final Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (newInput instanceof Executable && SourceFilesContentProvider.this.fetchedExecutables.containsKey(((Executable)newInput).getPath())) {
                    SourceFilesContentProvider.this.viewer.packColumns();
                }
            }
        });
    }

    static class QuickParseJob
    extends Job {
        final Executable executable;
        ITranslationUnit[] tus;

        public QuickParseJob(Executable executable) {
            super(String.valueOf(Messages.SourceFilesContentProvider_ReadingDebugSymbolInformationLabel) + executable.getName());
            this.executable = executable;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.tus = this.executable.getSourceFiles(monitor);
            return Status.OK_STATUS;
        }
    }
}

