/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GDBProcess;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.IRestartHandler;
import org.eclipse.debug.core.model.IProcess;

public class GdbRestartCommand
implements IRestartHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final GdbLaunch fLaunch;

    public GdbRestartCommand(DsfSession session, GdbLaunch launch) {
        this.fExecutor = session.getExecutor();
        this.fLaunch = launch;
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                IGDBControl gdbControl = (IGDBControl)GdbRestartCommand.this.fTracker.getService(IGDBControl.class);
                if (gdbControl != null) {
                    request.setEnabled(gdbControl.canRestart());
                } else {
                    request.setEnabled(false);
                }
                request.done();
            }
        });
    }

    public boolean execute(final IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                final IGDBControl gdbControl = (IGDBControl)GdbRestartCommand.this.fTracker.getService(IGDBControl.class);
                if (gdbControl != null) {
                    gdbControl.initInferiorInputOutput(new RequestMonitor((Executor)GdbRestartCommand.this.fExecutor, null){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                gdbControl.createInferiorProcess();
                                new UpdateLaunchJob(request).schedule();
                            } else {
                                request.done();
                            }
                        }
                    });
                } else {
                    request.done();
                }
            }
        });
        return false;
    }

    private class UpdateLaunchJob
    extends Job {
        IDebugCommandRequest fRequest;

        UpdateLaunchJob(IDebugCommandRequest request) {
            super("");
            this.setSystem(true);
            this.fRequest = request;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IProcess[] launchProcesses;
            String inferiorLabel = null;
            IProcess[] iProcessArray = launchProcesses = GdbRestartCommand.this.fLaunch.getProcesses();
            int n = launchProcesses.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess p = iProcessArray[n2];
                if (!(p instanceof GDBProcess)) {
                    inferiorLabel = p.getLabel();
                    GdbRestartCommand.this.fLaunch.removeProcess(p);
                    break;
                }
                ++n2;
            }
            if (inferiorLabel != null) {
                try {
                    GdbRestartCommand.this.fLaunch.addInferiorProcess(inferiorLabel);
                }
                catch (CoreException coreException) {}
            }
            GdbRestartCommand.this.fExecutor.submit((Runnable)new DsfRunnable(){

                public void run() {
                    IGDBControl gdbControl = (IGDBControl)GdbRestartCommand.this.fTracker.getService(IGDBControl.class);
                    if (gdbControl != null) {
                        gdbControl.restart(GdbRestartCommand.this.fLaunch, new RequestMonitor((Executor)GdbRestartCommand.this.fExecutor, null){

                            protected void handleCompleted() {
                                (this).UpdateLaunchJob.this.fRequest.done();
                            }
                        });
                    } else {
                        UpdateLaunchJob.this.fRequest.done();
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

