/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service.command;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.GDBBackendCLIProcess;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControlDMContext;
import org.eclipse.cdt.dsf.gdb.service.command.GDBInferiorProcess;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.AbstractCLIProcess;
import org.eclipse.cdt.dsf.mi.service.command.AbstractMIControl;
import org.eclipse.cdt.dsf.mi.service.command.CLIEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.MIControlDMContext;
import org.eclipse.cdt.dsf.mi.service.command.MIInferiorProcess;
import org.eclipse.cdt.dsf.mi.service.command.MIRunControlEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class GDBControl
extends AbstractMIControl
implements IGDBControl {
    private GDBControlDMContext fControlDmc;
    private IGDBBackend fMIBackend;
    private boolean fConnected;
    private MIRunControlEventProcessor fMIEventProcessor;
    private CLIEventProcessor fCLICommandProcessor;
    private AbstractCLIProcess fCLIProcess;
    private MIInferiorProcess fInferiorProcess;
    private PTY fPty;

    public GDBControl(DsfSession session, ILaunchConfiguration config, CommandFactory factory) {
        super(session, false, factory);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                GDBControl.this.doInitialize(requestMonitor);
            }
        });
    }

    public void doInitialize(RequestMonitor requestMonitor) {
        this.fMIBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fControlDmc = new GDBControlDMContext(this.getSession().getId(), this.getId());
        final Sequence.Step[] initializeSteps = new Sequence.Step[]{new CommandMonitoringStep(InitializationShutdownStep.Direction.INITIALIZING), new InferiorInputOutputInitStep(InitializationShutdownStep.Direction.INITIALIZING), new CommandProcessorsStep(InitializationShutdownStep.Direction.INITIALIZING), new RegisterStep(InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    public void shutdown(final RequestMonitor requestMonitor) {
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new RegisterStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandProcessorsStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new InferiorInputOutputInitStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandMonitoringStep(InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence shutdownSequence = new Sequence(this.getExecutor(), new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                GDBControl.super.shutdown(requestMonitor);
            }
        }){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)shutdownSequence);
    }

    public String getId() {
        return this.fMIBackend.getId();
    }

    public MIControlDMContext getControlDMContext() {
        return this.fControlDmc;
    }

    public ICommandControlService.ICommandControlDMContext getContext() {
        return this.fControlDmc;
    }

    public void terminate(final RequestMonitor rm) {
        if (this.fInferiorProcess.getState() == MIInferiorProcess.State.RUNNING) {
            this.fMIBackend.interrupt();
        }
        final ScheduledFuture forceQuitTask = this.getExecutor().schedule((Runnable)new DsfRunnable(){

            public void run() {
                GDBControl.this.fMIBackend.destroy();
                rm.done();
            }

            protected boolean isExecutionRequired() {
                return false;
            }
        }, 2L, TimeUnit.SECONDS);
        this.queueCommand(this.getCommandFactory().createMIGDBExit(this.fControlDmc), new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleCompleted() {
                if (this.isSuccess()) {
                    forceQuitTask.cancel(false);
                    rm.done();
                }
            }
        });
    }

    public void initInferiorInputOutput(final RequestMonitor requestMonitor) {
        if (this.fMIBackend.getSessionType() == SessionType.REMOTE || this.fMIBackend.getIsAttachSession()) {
            this.fPty = null;
            requestMonitor.done();
        } else {
            try {
                this.fPty = new PTY();
                this.queueCommand(this.getCommandFactory().createMIInferiorTTYSet(this.fControlDmc, this.fPty.getSlaveName()), new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor){

                    protected void handleFailure() {
                        GDBControl.this.fPty = null;
                        requestMonitor.done();
                    }
                });
            }
            catch (IOException iOException) {
                this.fPty = null;
                requestMonitor.done();
            }
        }
    }

    public boolean canRestart() {
        if (this.fMIBackend.getIsAttachSession() || this.fMIBackend.getSessionType() == SessionType.CORE) {
            return false;
        }
        return this.fMIBackend.getSessionType() != SessionType.REMOTE;
    }

    public void start(GdbLaunch launch, RequestMonitor requestMonitor) {
        this.startOrRestart(launch, false, requestMonitor);
    }

    public void restart(GdbLaunch launch, RequestMonitor requestMonitor) {
        this.startOrRestart(launch, true, requestMonitor);
    }

    protected void startOrRestart(GdbLaunch launch, boolean restart, RequestMonitor requestMonitor) {
        if (this.fMIBackend.getIsAttachSession()) {
            requestMonitor.done();
            return;
        }
        DsfServicesTracker servicesTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.getSession().getId());
        IMIProcesses procService = (IMIProcesses)servicesTracker.getService(IMIProcesses.class);
        servicesTracker.dispose();
        IProcesses.IProcessDMContext procDmc = procService.createProcessContext(this.fControlDmc, "");
        final IMIContainerDMContext containerDmc = procService.createContainerContext(procDmc, "");
        final ICommand<MIInfo> execCommand = this.fMIBackend.getSessionType() == SessionType.REMOTE ? this.getCommandFactory().createMIExecContinue((IRunControl.IExecutionDMContext)containerDmc) : this.getCommandFactory().createMIExecRun((IRunControl.IExecutionDMContext)containerDmc);
        boolean stopInMain = false;
        try {
            stopInMain = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
        }
        catch (CoreException e) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot retrieve stop at entry point boolean", (Throwable)e));
            requestMonitor.done();
            return;
        }
        DataRequestMonitor<MIInfo> execMonitor = new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                if (GDBControl.this.fMIBackend.getSessionType() != SessionType.REMOTE) {
                    GDBControl.this.getSession().dispatchEvent((Object)new MIProcesses.ContainerStartedDMEvent(containerDmc), GDBControl.this.getProperties());
                }
                super.handleSuccess();
            }
        };
        if (!stopInMain) {
            this.queueCommand(execCommand, execMonitor);
        } else {
            String stopSymbol = null;
            try {
                stopSymbol = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5014, "Cannot retrieve the entry point symbol", (Throwable)e));
                requestMonitor.done();
                return;
            }
            this.queueCommand(this.getCommandFactory().createMIBreakInsert(this.fControlDmc, true, false, null, 0, stopSymbol, 0), new DataRequestMonitor<MIBreakInsertInfo>((Executor)this.getExecutor(), requestMonitor, (DataRequestMonitor)execMonitor){
                private final /* synthetic */ DataRequestMonitor val$execMonitor;
                {
                    this.val$execMonitor = dataRequestMonitor;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    GDBControl.this.queueCommand(execCommand, this.val$execMonitor);
                }
            });
        }
    }

    public void createInferiorProcess() {
        this.fInferiorProcess = this.fPty == null ? new GDBInferiorProcess((ICommandControlService)this, this.fMIBackend, this.fMIBackend.getMIOutputStream()) : new GDBInferiorProcess((ICommandControlService)this, this.fMIBackend, this.fPty);
        if (this.fCLICommandProcessor != null) {
            this.fCLICommandProcessor.dispose();
        }
        this.fCLICommandProcessor = new CLIEventProcessor(this, this.fControlDmc);
    }

    public boolean isConnected() {
        return this.fInferiorProcess.getState() != MIInferiorProcess.State.TERMINATED && (!this.fMIBackend.getIsAttachSession() || this.fConnected);
    }

    public void setConnected(boolean connected) {
        this.fConnected = connected;
    }

    public AbstractCLIProcess getCLIProcess() {
        return this.fCLIProcess;
    }

    public MIInferiorProcess getInferiorProcess() {
        return this.fInferiorProcess;
    }

    public void setTracingStream(OutputStream tracingStream) {
        this.setMITracingStream(tracingStream);
    }

    public void setEnvironment(Properties props, boolean clear, RequestMonitor rm) {
        int count = 0;
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        if (clear) {
            ++count;
            this.queueCommand(this.getCommandFactory().createCLIUnsetEnv(this.getContext()), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            ++count;
            String name = (String)property.getKey();
            String value = (String)property.getValue();
            this.queueCommand(this.getCommandFactory().createMIGDBSetEnv(this.getContext(), name, value), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
        countingRm.setDoneCount(count);
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        this.stopCommandProcessing();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMIBackend.BackendStateChangedEvent e) {
        if (e.getState() == IMIBackend.State.TERMINATED && e.getBackendId().equals(this.fMIBackend.getId())) {
            this.getSession().dispatchEvent((Object)new GDBControlShutdownDMEvent(this.fControlDmc), this.getProperties());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIProcesses.ContainerExitedDMEvent e) {
        if (Platform.getPreferencesService().getBoolean("org.eclipse.cdt.dsf.gdb.ui", "autoTerminateGdb", true, null)) {
            this.terminate(new RequestMonitor(ImmediateExecutor.getInstance(), null));
        }
    }

    protected class CommandMonitoringStep
    extends InitializationShutdownStep {
        CommandMonitoringStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        protected void initialize(RequestMonitor requestMonitor) {
            GDBControl.this.startCommandProcessing(GDBControl.this.fMIBackend.getMIInputStream(), GDBControl.this.fMIBackend.getMIOutputStream());
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.stopCommandProcessing();
            requestMonitor.done();
        }
    }

    protected class CommandProcessorsStep
    extends InitializationShutdownStep {
        CommandProcessorsStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor requestMonitor) {
            try {
                GDBControl.this.fCLIProcess = new GDBBackendCLIProcess(GDBControl.this, GDBControl.this.fMIBackend);
            }
            catch (IOException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Failed to create CLI Process", (Throwable)e));
                requestMonitor.done();
                return;
            }
            GDBControl.this.createInferiorProcess();
            GDBControl.this.fMIEventProcessor = new MIRunControlEventProcessor(GDBControl.this, GDBControl.this.fControlDmc);
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.fCLICommandProcessor.dispose();
            GDBControl.this.fMIEventProcessor.dispose();
            GDBControl.this.fCLIProcess.dispose();
            GDBControl.this.fInferiorProcess.dispose();
            requestMonitor.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GDBControlInitializedDMEvent
    extends AbstractDMEvent<ICommandControlService.ICommandControlDMContext>
    implements ICommandControlService.ICommandControlInitializedDMEvent {
        public GDBControlInitializedDMEvent(ICommandControlService.ICommandControlDMContext context) {
            super((IDMContext)context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GDBControlShutdownDMEvent
    extends AbstractDMEvent<ICommandControlService.ICommandControlDMContext>
    implements ICommandControlService.ICommandControlShutdownDMEvent {
        public GDBControlShutdownDMEvent(ICommandControlService.ICommandControlDMContext context) {
            super((IDMContext)context);
        }
    }

    protected class InferiorInputOutputInitStep
    extends InitializationShutdownStep {
        InferiorInputOutputInitStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        protected void initialize(RequestMonitor requestMonitor) {
            GDBControl.this.initInferiorInputOutput(requestMonitor);
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }
    }

    public static class InitializationShutdownStep
    extends Sequence.Step {
        private Direction fDirection;

        public InitializationShutdownStep(Direction direction) {
            this.fDirection = direction;
        }

        public final void execute(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.initialize(requestMonitor);
            } else {
                this.shutdown(requestMonitor);
            }
        }

        public final void rollBack(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.shutdown(requestMonitor);
            } else {
                super.rollBack(requestMonitor);
            }
        }

        protected void initialize(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Direction {
            INITIALIZING,
            SHUTTING_DOWN;

        }
    }

    protected class RegisterStep
    extends InitializationShutdownStep {
        RegisterStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor requestMonitor) {
            GDBControl.this.getSession().addServiceEventListener((Object)GDBControl.this, null);
            GDBControl.this.register(new String[]{ICommandControl.class.getName(), ICommandControlService.class.getName(), IMICommandControl.class.getName(), AbstractMIControl.class.getName(), IGDBControl.class.getName()}, new Hashtable());
            GDBControl.this.getSession().dispatchEvent((Object)new GDBControlInitializedDMEvent(GDBControl.this.fControlDmc), GDBControl.this.getProperties());
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.unregister();
            GDBControl.this.getSession().removeServiceEventListener((Object)GDBControl.this);
            requestMonitor.done();
        }
    }
}

