/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.MIExpressions;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.MemoryByte;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIMemory
extends AbstractDsfService
implements IMemory,
ICachingService {
    private CommandCache fCommandCache;
    private CommandFactory fCommandFactory;
    private Map<IMemory.IMemoryDMContext, MIMemoryCache> fMemoryCaches;

    private MIMemoryCache getMemoryCache(IMemory.IMemoryDMContext memoryDMC) {
        MIMemoryCache cache = this.fMemoryCaches.get(memoryDMC);
        if (cache == null) {
            cache = new MIMemoryCache();
            this.fMemoryCaches.put(memoryDMC, cache);
        }
        return cache;
    }

    public MIMemory(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                MIMemory.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)commandControl, this.getExecutor(), 2);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fCommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fCommandCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.register(new String[]{MIMemory.class.getName(), IMemory.class.getName()}, new Hashtable());
        this.fMemoryCaches = new HashMap<IMemory.IMemoryDMContext, MIMemoryCache>();
        this.getSession().addServiceEventListener((Object)this, null);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void getMemory(IMemory.IMemoryDMContext memoryDMC, IAddress address, long offset, int word_size, int count, DataRequestMonitor<MemoryByte[]> drm) {
        if (memoryDMC == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unknown context type", null));
            drm.done();
            return;
        }
        if (word_size != 1) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Word size not supported (!= 1)", null));
            drm.done();
            return;
        }
        if (count < 0) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid word count (< 0)", null));
            drm.done();
            return;
        }
        this.getMemoryCache(memoryDMC).getMemory(memoryDMC, address.add(offset), word_size, count, drm);
    }

    public void setMemory(IMemory.IMemoryDMContext memoryDMC, IAddress address, long offset, int word_size, int count, byte[] buffer, RequestMonitor rm) {
        if (memoryDMC == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unknown context type", null));
            rm.done();
            return;
        }
        if (word_size != 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Word size not supported (!= 1)", null));
            rm.done();
            return;
        }
        if (count < 0) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid word count (< 0)", null));
            rm.done();
            return;
        }
        if (buffer.length < count) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Buffer too short", null));
            rm.done();
            return;
        }
        this.getMemoryCache(memoryDMC).setMemory(memoryDMC, address, offset, word_size, count, buffer, rm);
    }

    public void fillMemory(IMemory.IMemoryDMContext memoryDMC, IAddress address, long offset, int word_size, int count, byte[] pattern, RequestMonitor rm) {
        if (memoryDMC == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unknown context type", null));
            rm.done();
            return;
        }
        if (word_size != 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Word size not supported (!= 1)", null));
            rm.done();
            return;
        }
        if (count < 0) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid repeat count (< 0)", null));
            rm.done();
            return;
        }
        if (pattern.length < 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Empty pattern", null));
            rm.done();
            return;
        }
        int length = pattern.length;
        byte[] buffer = new byte[count * length];
        int i = 0;
        while (i < count) {
            System.arraycopy(pattern, 0, buffer, i * length, length);
            ++i;
        }
        this.getMemoryCache(memoryDMC).setMemory(memoryDMC, address, offset, word_size, count * length, buffer, rm);
    }

    protected void readMemoryBlock(IDMContext dmc, IAddress address, long offset, final int word_size, final int count, final DataRequestMonitor<MemoryByte[]> drm) {
        int mode = 0;
        int nb_rows = 1;
        int nb_cols = count;
        Character asChar = null;
        this.fCommandCache.execute(this.fCommandFactory.createMIDataReadMemory(dmc, offset, address.toString(), mode, word_size, nb_rows, nb_cols, asChar), (DataRequestMonitor)new DataRequestMonitor<MIDataReadMemoryInfo>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                drm.setData((Object)((MIDataReadMemoryInfo)this.getData()).getMIMemoryBlock());
                drm.done();
            }

            protected void handleFailure() {
                MemoryByte[] block = new MemoryByte[word_size * count];
                int i = 0;
                while (i < block.length) {
                    block[i] = new MemoryByte(0, 0);
                    ++i;
                }
                drm.setData((Object)block);
                drm.done();
            }
        });
    }

    protected void writeMemoryBlock(IDMContext dmc, IAddress address, long offset, int word_size, int count, byte[] buffer, RequestMonitor rm) {
        CountingRequestMonitor countingRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        countingRM.setDoneCount(count);
        int format = 3;
        String baseAddress = address.toString();
        int i = 0;
        while (i < count) {
            String value = new Byte(buffer[i]).toString();
            this.fCommandCache.execute(this.fCommandFactory.createMIDataWriteMemory(dmc, offset + (long)i, baseAddress, format, word_size, value), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRM));
            ++i;
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.fCommandCache.setContextAvailable(e.getDMContext(), false);
        }
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fCommandCache.reset(e.getDMContext());
            IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IMemory.IMemoryDMContext.class);
            if (this.fMemoryCaches.containsKey(memoryDMC)) {
                this.fMemoryCaches.get(memoryDMC).reset();
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.fCommandCache.setContextAvailable(e.getDMContext(), true);
        }
        this.fCommandCache.reset(e.getDMContext());
        IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IMemory.IMemoryDMContext.class);
        if (this.fMemoryCaches.containsKey(memoryDMC)) {
            this.fMemoryCaches.get(memoryDMC).reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIExpressions.ExpressionChangedEvent e) {
        final IExpressions.IExpressionDMContext context = (IExpressions.IExpressionDMContext)e.getDMContext();
        IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        if (expressionService != null) {
            expressionService.getExpressionAddressData(context, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMAddress>((Executor)this.getExecutor(), null){

                protected void handleSuccess() {
                    IExpressions.IExpressionDMAddress expression = (IExpressions.IExpressionDMAddress)this.getData();
                    int count = expression.getSize();
                    IAddress expAddress = expression.getAddress();
                    Addr64 address = expAddress instanceof Addr64 ? (Addr64)expAddress : new Addr64(expAddress.getValue());
                    IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMemory.IMemoryDMContext.class);
                    MIMemory.this.getMemoryCache(memoryDMC).refreshMemory(memoryDMC, (IAddress)address, 0L, 1, count, new RequestMonitor((Executor)MIMemory.this.getExecutor(), null));
                }
            });
        }
    }

    public void flushCache(IDMContext context) {
        this.fCommandCache.reset(context);
        IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMemory.IMemoryDMContext.class);
        if (this.fMemoryCaches.containsKey(memoryDMC)) {
            this.fMemoryCaches.get(memoryDMC).reset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MIMemoryCache {
        private SortedMemoryBlockList fMemoryBlockList;

        public MIMemoryCache() {
            this.fMemoryBlockList = new SortedMemoryBlockList();
        }

        public void reset() {
            this.fMemoryBlockList.clear();
        }

        private LinkedList<MemoryBlock> getListOfMissingBlocks(IAddress reqBlockStart, int count) {
            LinkedList<MemoryBlock> list = new LinkedList<MemoryBlock>();
            ListIterator it = this.fMemoryBlockList.listIterator();
            while (it.hasNext() && count > 0) {
                MemoryBlock cachedBlock = (MemoryBlock)it.next();
                IAddress cachedBlockStart = cachedBlock.fAddress;
                IAddress cachedBlockEnd = cachedBlock.fAddress.add(cachedBlock.fLength);
                if (reqBlockStart.distanceTo(cachedBlockStart).longValue() >= 0L) {
                    int length = (int)Math.min(reqBlockStart.distanceTo(cachedBlockStart).longValue(), (long)count);
                    if (length > 0) {
                        MemoryBlock newBlock = new MemoryBlock(reqBlockStart, length, new MemoryByte[0]);
                        list.add(newBlock);
                    }
                    reqBlockStart = cachedBlockEnd;
                    count = (int)((long)count - ((long)length + cachedBlock.fLength));
                    continue;
                }
                if (cachedBlockStart.distanceTo(reqBlockStart).longValue() <= 0L || reqBlockStart.distanceTo(cachedBlockEnd).longValue() < 0L) continue;
                count = (int)((long)count - reqBlockStart.distanceTo(cachedBlockEnd).longValue());
                reqBlockStart = cachedBlockEnd;
            }
            if (count > 0) {
                MemoryBlock newBlock = new MemoryBlock(reqBlockStart, count, new MemoryByte[0]);
                list.add(newBlock);
            }
            return list;
        }

        private MemoryByte[] getMemoryBlockFromCache(IAddress reqBlockStart, int count) {
            IAddress reqBlockEnd = reqBlockStart.add((long)count);
            MemoryByte[] resultBlock = new MemoryByte[count];
            ListIterator iter = this.fMemoryBlockList.listIterator();
            while (iter.hasNext()) {
                int length;
                int pos;
                MemoryBlock cachedBlock = (MemoryBlock)iter.next();
                IAddress cachedBlockStart = cachedBlock.fAddress;
                IAddress cachedBlockEnd = cachedBlock.fAddress.add(cachedBlock.fLength);
                if (cachedBlockStart.distanceTo(reqBlockStart).longValue() >= 0L && reqBlockEnd.distanceTo(cachedBlockEnd).longValue() >= 0L) {
                    pos = (int)cachedBlockStart.distanceTo(reqBlockStart).longValue();
                    System.arraycopy(cachedBlock.fBlock, pos, resultBlock, 0, count);
                    continue;
                }
                if (reqBlockStart.distanceTo(cachedBlockStart).longValue() >= 0L && cachedBlockStart.distanceTo(reqBlockEnd).longValue() > 0L) {
                    pos = (int)reqBlockStart.distanceTo(cachedBlockStart).longValue();
                    length = (int)Math.min(cachedBlock.fLength, (long)(count - pos));
                    System.arraycopy(cachedBlock.fBlock, 0, resultBlock, pos, length);
                    continue;
                }
                if (cachedBlockStart.distanceTo(reqBlockStart).longValue() < 0L || reqBlockStart.distanceTo(cachedBlockEnd).longValue() <= 0L) continue;
                pos = (int)cachedBlockStart.distanceTo(reqBlockStart).longValue();
                length = (int)Math.min(cachedBlock.fLength - (long)pos, (long)count);
                System.arraycopy(cachedBlock.fBlock, pos, resultBlock, 0, length);
            }
            return resultBlock;
        }

        private void updateMemoryCache(IAddress modBlockStart, int count, MemoryByte[] modBlock) {
            IAddress modBlockEnd = modBlockStart.add((long)count);
            ListIterator iter = this.fMemoryBlockList.listIterator();
            while (iter.hasNext()) {
                int length;
                int pos;
                MemoryBlock cachedBlock = (MemoryBlock)iter.next();
                IAddress cachedBlockStart = cachedBlock.fAddress;
                IAddress cachedBlockEnd = cachedBlock.fAddress.add(cachedBlock.fLength);
                if (cachedBlockStart.distanceTo(modBlockStart).longValue() >= 0L && modBlockEnd.distanceTo(cachedBlockEnd).longValue() >= 0L) {
                    pos = (int)cachedBlockStart.distanceTo(modBlockStart).longValue();
                    System.arraycopy(modBlock, 0, cachedBlock.fBlock, pos, count);
                    continue;
                }
                if (cachedBlockStart.distanceTo(modBlockStart).longValue() >= 0L && modBlockStart.distanceTo(cachedBlockEnd).longValue() > 0L) {
                    pos = (int)cachedBlockStart.distanceTo(modBlockStart).longValue();
                    length = (int)cachedBlockStart.distanceTo(modBlockEnd).longValue();
                    System.arraycopy(modBlock, 0, cachedBlock.fBlock, pos, length);
                    continue;
                }
                if (cachedBlockStart.distanceTo(modBlockEnd).longValue() <= 0L || modBlockEnd.distanceTo(cachedBlockEnd).longValue() < 0L) continue;
                pos = (int)modBlockStart.distanceTo(cachedBlockStart).longValue();
                length = (int)cachedBlockStart.distanceTo(modBlockEnd).longValue();
                System.arraycopy(modBlock, pos, cachedBlock.fBlock, 0, length);
            }
        }

        public void getMemory(IMemory.IMemoryDMContext memoryDMC, IAddress address, int word_size, final int count, DataRequestMonitor<MemoryByte[]> drm) {
            LinkedList<MemoryBlock> missingBlocks = this.getListOfMissingBlocks(address, count);
            int numberOfRequests = missingBlocks.size();
            final CountingRequestMonitor countingRM = new CountingRequestMonitor((Executor)MIMemory.this.getExecutor(), (RequestMonitor)drm, (DataRequestMonitor)drm, address, count){
                private final /* synthetic */ DataRequestMonitor val$drm;
                private final /* synthetic */ IAddress val$address;
                private final /* synthetic */ int val$count;
                {
                    this.val$drm = dataRequestMonitor;
                    this.val$address = iAddress;
                    this.val$count = n;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    this.val$drm.setData((Object)MIMemoryCache.this.getMemoryBlockFromCache(this.val$address, this.val$count));
                    this.val$drm.done();
                }
            };
            countingRM.setDoneCount(numberOfRequests);
            int i = 0;
            while (i < numberOfRequests) {
                MemoryBlock block = missingBlocks.get(i);
                final IAddress startAddress = block.fAddress;
                final int length = (int)block.fLength;
                MIMemory.this.readMemoryBlock((IDMContext)memoryDMC, startAddress, 0L, word_size, length, new DataRequestMonitor<MemoryByte[]>((Executor)MIMemory.this.getSession().getExecutor(), drm){

                    protected void handleSuccess() {
                        MemoryByte[] block = new MemoryByte[count];
                        block = (MemoryByte[])this.getData();
                        MemoryBlock memoryBlock = new MemoryBlock(startAddress, length, block);
                        MIMemoryCache.this.fMemoryBlockList.add(memoryBlock);
                        countingRM.done();
                    }
                });
                ++i;
            }
        }

        public void setMemory(final IMemory.IMemoryDMContext memoryDMC, final IAddress address, final long offset, final int word_size, final int count, byte[] buffer, final RequestMonitor rm) {
            MIMemory.this.writeMemoryBlock((IDMContext)memoryDMC, address, offset, word_size, count, buffer, new RequestMonitor((Executor)MIMemory.this.getSession().getExecutor(), rm){

                protected void handleSuccess() {
                    MIMemory.this.fCommandCache.reset();
                    MIMemory.this.readMemoryBlock((IDMContext)memoryDMC, address, offset, word_size, count, new DataRequestMonitor<MemoryByte[]>((Executor)MIMemory.this.getExecutor(), rm){

                        protected void handleSuccess() {
                            MIMemoryCache.this.updateMemoryCache(address.add(offset), count, (MemoryByte[])this.getData());
                            IAddress[] addresses = new IAddress[count];
                            int i = 0;
                            while (i < count) {
                                addresses[i] = address.add(offset + (long)i);
                                ++i;
                            }
                            MIMemory.this.getSession().dispatchEvent((Object)new MemoryChangedEvent(memoryDMC, addresses), MIMemory.this.getProperties());
                            rm.done();
                        }
                    });
                }
            });
        }

        public void refreshMemory(final IMemory.IMemoryDMContext memoryDMC, final IAddress address, long offset, int word_size, final int count, final RequestMonitor rm) {
            LinkedList<MemoryBlock> list = this.getListOfMissingBlocks(address, count);
            int sizeToRead = 0;
            for (MemoryBlock block : list) {
                sizeToRead = (int)((long)sizeToRead + block.fLength);
            }
            if (sizeToRead == count) {
                rm.done();
                return;
            }
            final IAddress[] addresses = new IAddress[count];
            int i = 0;
            while (i < count) {
                addresses[i] = address.add((long)i);
                ++i;
            }
            MIMemory.this.fCommandCache.reset();
            MIMemory.this.readMemoryBlock((IDMContext)memoryDMC, address, 0L, 1, count, new DataRequestMonitor<MemoryByte[]>((Executor)MIMemory.this.getExecutor(), rm){

                protected void handleSuccess() {
                    MemoryByte[] oldBlock = MIMemoryCache.this.getMemoryBlockFromCache(address, count);
                    MemoryByte[] newBlock = (MemoryByte[])this.getData();
                    boolean blocksDiffer = false;
                    int i = 0;
                    while (i < oldBlock.length) {
                        if (oldBlock[i].getValue() != newBlock[i].getValue()) {
                            blocksDiffer = true;
                            break;
                        }
                        ++i;
                    }
                    if (blocksDiffer) {
                        MIMemoryCache.this.updateMemoryCache(address, count, newBlock);
                        MIMemory.this.getSession().dispatchEvent((Object)new MemoryChangedEvent(memoryDMC, addresses), MIMemory.this.getProperties());
                    }
                    rm.done();
                }
            });
        }
    }

    private class MemoryBlock {
        public IAddress fAddress;
        public long fLength;
        public MemoryByte[] fBlock;

        public MemoryBlock(IAddress address, long length, MemoryByte[] block) {
            this.fAddress = address;
            this.fLength = length;
            this.fBlock = block;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MemoryChangedEvent
    extends AbstractDMEvent<IMemory.IMemoryDMContext>
    implements IMemory.IMemoryChangedEvent {
        IAddress[] fAddresses;
        IDMContext fContext;

        public MemoryChangedEvent(IMemory.IMemoryDMContext context, IAddress[] addresses) {
            super((IDMContext)context);
            this.fAddresses = addresses;
        }

        public IAddress[] getAddresses() {
            return this.fAddresses;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedMemoryBlockList
    extends LinkedList<MemoryBlock> {
        @Override
        public boolean add(MemoryBlock block) {
            if (this.isEmpty()) {
                this.addFirst(block);
                return true;
            }
            ListIterator it = this.listIterator();
            while (it.hasNext()) {
                int index = it.nextIndex();
                MemoryBlock item = (MemoryBlock)it.next();
                if (block.fAddress.compareTo((Object)item.fAddress) >= 0) continue;
                this.add(index, block);
                this.compact(index);
                return true;
            }
            this.addLast(block);
            this.compact(this.size() - 1);
            return true;
        }

        private void compact(int index) {
            int lastIndex;
            MemoryBlock newBlock = (MemoryBlock)this.get(index);
            if (index > 0) {
                long newLength;
                MemoryBlock prevBlock = (MemoryBlock)this.get(index - 1);
                IAddress endOfPreviousBlock = prevBlock.fAddress.add(prevBlock.fLength);
                if (endOfPreviousBlock.distanceTo(newBlock.fAddress).longValue() == 0L && (newLength = prevBlock.fLength + newBlock.fLength) <= Integer.MAX_VALUE) {
                    MemoryByte[] block = new MemoryByte[(int)newLength];
                    System.arraycopy(prevBlock.fBlock, 0, block, 0, (int)prevBlock.fLength);
                    System.arraycopy(newBlock.fBlock, 0, block, (int)prevBlock.fLength, (int)newBlock.fLength);
                    newBlock = new MemoryBlock(prevBlock.fAddress, newLength, block);
                    this.remove(index);
                    this.set(--index, newBlock);
                }
            }
            if (index < (lastIndex = this.size() - 1)) {
                long newLength;
                MemoryBlock nextBlock = (MemoryBlock)this.get(index + 1);
                IAddress endOfNewBlock = newBlock.fAddress.add(newBlock.fLength);
                if (endOfNewBlock.distanceTo(nextBlock.fAddress).longValue() == 0L && (newLength = newBlock.fLength + nextBlock.fLength) <= Integer.MAX_VALUE) {
                    MemoryByte[] block = new MemoryByte[(int)newLength];
                    System.arraycopy(newBlock.fBlock, 0, block, 0, (int)newBlock.fLength);
                    System.arraycopy(nextBlock.fBlock, 0, block, (int)newBlock.fLength, (int)nextBlock.fLength);
                    newBlock = new MemoryBlock(newBlock.fAddress, newLength, block);
                    this.set(index, newBlock);
                    this.remove(index + 1);
                }
            }
        }
    }
}

