/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.MIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.LargePipedInputStream;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIExecAsyncOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIGDBShowExitCodeInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITargetStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MIInferiorProcess
extends Process
implements IEventListener,
ICommandListener {
    private final OutputStream fOutputStream;
    private final InputStream fInputStream;
    private final PipedOutputStream fInputStreamPiped;
    private final PipedInputStream fErrorStream;
    private final PipedOutputStream fErrorStreamPiped;
    private final DsfSession fSession;
    private final PTY fPty;
    private final ICommandControlService fCommandControl;
    private CommandFactory fCommandFactory;
    private IRunControl.IContainerDMContext fContainerDMContext;
    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private boolean fDisposed = false;
    private int fSuppressTargetOutputCounter = 0;
    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private boolean fGiveUpOnPidQuery;
    @ThreadSafe
    Integer fExitCode = null;
    private State fState = State.RUNNING;
    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private String fInferiorPid;

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public MIInferiorProcess(ICommandControlService commandControl, OutputStream gdbOutputStream) {
        this(commandControl, gdbOutputStream, null);
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public MIInferiorProcess(ICommandControlService commandControl, PTY p) {
        this(commandControl, null, p);
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private MIInferiorProcess(ICommandControlService commandControl, final OutputStream gdbOutputStream, PTY p) {
        this.fCommandControl = commandControl;
        this.fSession = commandControl.getSession();
        this.fCommandFactory = this.fCommandControl instanceof IMICommandControl ? ((IMICommandControl)this.fCommandControl).getCommandFactory() : new CommandFactory();
        commandControl.addEventListener((IEventListener)this);
        commandControl.addCommandListener((ICommandListener)this);
        this.fPty = p;
        if (this.fPty != null) {
            this.fOutputStream = this.fPty.getOutputStream();
            this.fInputStream = this.fPty.getInputStream();
            this.fInputStreamPiped = null;
        } else {
            this.fOutputStream = new OutputStream(){

                public void write(int b) throws IOException {
                    if (MIInferiorProcess.this.getState() != State.RUNNING) {
                        throw new IOException("Target is not running");
                    }
                    gdbOutputStream.write(b);
                }
            };
            this.fInputStreamPiped = new PipedOutputStream();
            LargePipedInputStream inputStream = null;
            try {
                inputStream = new LargePipedInputStream(this.fInputStreamPiped);
            }
            catch (IOException iOException) {}
            this.fInputStream = inputStream;
        }
        this.fErrorStreamPiped = new PipedOutputStream();
        LargePipedInputStream errorStream = null;
        try {
            errorStream = new LargePipedInputStream(this.fErrorStreamPiped);
        }
        catch (IOException iOException) {}
        this.fErrorStream = errorStream;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public void dispose() {
        this.fCommandControl.removeEventListener((IEventListener)this);
        this.fCommandControl.removeCommandListener((ICommandListener)this);
        this.closeIO();
        this.setState(State.TERMINATED);
        this.fDisposed = true;
    }

    @ThreadSafe
    protected DsfSession getSession() {
        return this.fSession;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    protected ICommandControlService getCommandControlService() {
        return this.fCommandControl;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    protected boolean isDisposed() {
        return this.fDisposed;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public InputStream getErrorStream() {
        return this.fErrorStream;
    }

    /*
     * Unable to fully structure code
     */
    @ThreadSafeAndProhibitedFromDsfExecutor(value="fSession#getExecutor")
    public synchronized void waitForSync() throws InterruptedException {
        if (MIInferiorProcess.$assertionsDisabled || !this.getSession().getExecutor().isInExecutorThread()) ** GOTO lbl4
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.wait(100L);
lbl4:
            // 2 sources

            ** while (this.getState() != State.TERMINATED)
        }
lbl5:
        // 1 sources

    }

    @ThreadSafeAndProhibitedFromDsfExecutor(value="fSession#getExecutor")
    public int waitFor() throws InterruptedException {
        assert (!this.getSession().getExecutor().isInExecutorThread());
        this.waitForSync();
        return this.exitValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafeAndProhibitedFromDsfExecutor(value="fSession#getExecutor")
    public int exitValue() {
        block13: {
            assert (!this.getSession().getExecutor().isInExecutorThread());
            MIInferiorProcess mIInferiorProcess = this;
            synchronized (mIInferiorProcess) {
                if (this.fExitCode != null) {
                    return this.fExitCode;
                }
            }
            try {
                Query<Integer> exitCodeQuery = new Query<Integer>(){

                    protected void execute(final DataRequestMonitor<Integer> rm) {
                        if (!DsfSession.isSessionActive((String)MIInferiorProcess.this.fSession.getId())) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Debug session already shut down.", null));
                            rm.done();
                            return;
                        }
                        if (MIInferiorProcess.this.isDisposed()) {
                            rm.setData((Object)0);
                            rm.done();
                        } else if (MIInferiorProcess.this.getState() != State.TERMINATED) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "GDB is still running.", (Throwable)new IllegalThreadStateException()));
                            rm.done();
                        } else {
                            MIInferiorProcess.this.getCommandControlService().queueCommand(MIInferiorProcess.this.fCommandFactory.createMIGDBShowExitCode(MIInferiorProcess.this.getCommandControlService().getContext()), (DataRequestMonitor)new DataRequestMonitor<MIGDBShowExitCodeInfo>((Executor)MIInferiorProcess.this.fSession.getExecutor(), rm){

                                protected void handleSuccess() {
                                    rm.setData((Object)((MIGDBShowExitCodeInfo)this.getData()).getCode());
                                    rm.done();
                                }
                            });
                        }
                    }
                };
                this.fSession.getExecutor().execute((Runnable)exitCodeQuery);
                int exitCode = (Integer)exitCodeQuery.get();
                MIInferiorProcess mIInferiorProcess2 = this;
                synchronized (mIInferiorProcess2) {
                    this.fExitCode = exitCode;
                }
                return exitCode;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof CoreException) || !(((CoreException)e.getCause()).getStatus().getException() instanceof RuntimeException)) break block13;
                throw (RuntimeException)((CoreException)e.getCause()).getStatus().getException();
            }
        }
        return 0;
    }

    public void destroy() {
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    MIInferiorProcess.this.doDestroy();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        this.closeIO();
    }

    private void closeIO() {
        try {
            this.fOutputStream.close();
        }
        catch (IOException iOException) {}
        try {
            this.fInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            if (this.fInputStreamPiped != null) {
                this.fInputStreamPiped.close();
            }
        }
        catch (IOException iOException) {}
        try {
            this.fErrorStream.close();
        }
        catch (IOException iOException) {}
        try {
            this.fErrorStreamPiped.close();
        }
        catch (IOException iOException) {}
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private void doDestroy() {
        if (this.isDisposed() || !this.fSession.isActive() || this.getState() == State.TERMINATED) {
            return;
        }
        ICommand<MIInfo> cmd = this.fCommandFactory.createCLIExecAbort(this.getCommandControlService().getContext());
        this.getCommandControlService().queueCommand(cmd, (DataRequestMonitor)new DataRequestMonitor<MIInfo>(ImmediateExecutor.getInstance(), null){

            protected void handleCompleted() {
                MIInferiorProcess.this.setState(State.TERMINATED);
            }
        });
    }

    @ThreadSafe
    public synchronized State getState() {
        return this.fState;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public IRunControl.IExecutionDMContext getExecutionContext() {
        return this.fContainerDMContext;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public void setContainerContext(IRunControl.IContainerDMContext containerDmc) {
        this.fContainerDMContext = containerDmc;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    synchronized void setState(State state) {
        if (this.fState == State.TERMINATED) {
            return;
        }
        this.fState = state;
        if (this.fState == State.TERMINATED) {
            if (this.fContainerDMContext != null) {
                this.getSession().dispatchEvent((Object)new MIProcesses.ContainerExitedDMEvent(this.fContainerDMContext), this.getCommandControlService().getProperties());
            }
            this.closeIO();
        }
        this.notifyAll();
    }

    public OutputStream getPipedOutputStream() {
        return this.fInputStreamPiped;
    }

    public OutputStream getPipedErrorStream() {
        return this.fErrorStreamPiped;
    }

    public PTY getPTY() {
        return this.fPty;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public String getPid() {
        return this.fInferiorPid;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public void setPid(String pid) {
        this.fInferiorPid = pid;
    }

    public void eventReceived(Object output) {
        MIOOBRecord[] mIOOBRecordArray = ((MIOutput)output).getMIOOBRecords();
        int n = mIOOBRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIOOBRecord oobr = mIOOBRecordArray[n2];
            if (oobr instanceof MIExecAsyncOutput) {
                MIExecAsyncOutput async = (MIExecAsyncOutput)oobr;
                String state = async.getAsyncClass();
                if ("stopped".equals(state)) {
                    boolean handled = false;
                    MIResult[] results = async.getMIResults();
                    int i = 0;
                    while (i < results.length) {
                        MIValue value;
                        String var = results[i].getVariable();
                        if (var.equals("reason") && (value = results[i].getMIValue()) instanceof MIConst) {
                            String reason = ((MIConst)value).getString();
                            if ("exited-signalled".equals(reason) || "exited-normally".equals(reason) || "exited".equals(reason)) {
                                this.setState(State.TERMINATED);
                            } else {
                                this.setState(State.STOPPED);
                            }
                            handled = true;
                        }
                        ++i;
                    }
                    if (!handled) {
                        this.setState(State.STOPPED);
                    }
                }
            } else if (oobr instanceof MITargetStreamOutput) {
                if (this.fSuppressTargetOutputCounter > 0) {
                    return;
                }
                MITargetStreamOutput tgtOut = (MITargetStreamOutput)oobr;
                if (this.fInputStreamPiped != null && tgtOut.getString() != null) {
                    try {
                        this.fInputStreamPiped.write(tgtOut.getString().getBytes());
                        this.fInputStreamPiped.flush();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++n2;
        }
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
        if (token.getCommand() instanceof CLICommand) {
            ++this.fSuppressTargetOutputCounter;
        }
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        MIInfo cmdResult;
        MIOutput output;
        MIResultRecord rr;
        String state;
        if (token.getCommand() instanceof CLICommand) {
            --this.fSuppressTargetOutputCounter;
        }
        if ("running".equals(state = (rr = (output = (cmdResult = (MIInfo)result).getMIOutput()).getMIResultRecord()).getResultClass())) {
            this.setState(State.RUNNING);
        } else if ("exit".equals(state)) {
            this.setState(State.TERMINATED);
        } else if ("error".equals(state)) {
            this.setState(State.STOPPED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        RUNNING,
        STOPPED,
        TERMINATED;

    }
}

