/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MILogStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

@Immutable
public class MIErrorEvent
extends MIStoppedEvent {
    private final String msg;
    private final String log;
    private final MIOOBRecord[] oobs;

    protected MIErrorEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIOOBRecord[] oobs, String msg, String log) {
        super(ctx, token, results, null);
        this.msg = msg;
        this.log = log;
        this.oobs = oobs;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getLogMessage() {
        return this.log;
    }

    public static MIErrorEvent parse(IRunControl.IContainerDMContext containerDmc, int token, MIResult[] results, MIOOBRecord[] oobs) {
        String msg = "";
        String log = "";
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("msg")) {
                    msg = str;
                }
                ++i;
            }
        }
        if (oobs != null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MILogStreamOutput) {
                    MIStreamRecord o = (MIStreamRecord)oobs[i];
                    sb.append(o.getString());
                }
                ++i;
            }
            log = sb.toString();
        }
        return new MIErrorEvent((IRunControl.IExecutionDMContext)containerDmc, token, results, oobs, msg, log);
    }

    public String toString() {
        if (this.oobs != null) {
            StringBuilder builder = new StringBuilder();
            MIOOBRecord[] mIOOBRecordArray = this.oobs;
            int n = this.oobs.length;
            int n2 = 0;
            while (n2 < n) {
                MIOOBRecord oob = mIOOBRecordArray[n2];
                builder.append(oob.toString());
                ++n2;
            }
            builder.append(super.toString());
            return builder.toString();
        }
        return super.toString();
    }
}

