/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model;

import java.math.BigInteger;
import java.util.Iterator;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.LabelPosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IBreakpointLocationProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class BreakpointsAnnotationModel
extends AnnotationModel
implements IBreakpointListener,
IDocumentListener {
    private Runnable fCatchup;

    public void connect(IDocument document) {
        super.connect(document);
        if (document instanceof DisassemblyDocument) {
            IBreakpointManager bpMgr = DebugPlugin.getDefault().getBreakpointManager();
            this.addBreakpoints(bpMgr.getBreakpoints());
            bpMgr.addBreakpointListener((IBreakpointListener)this);
            document.addDocumentListener((IDocumentListener)this);
        }
    }

    public void disconnect(IDocument document) {
        if (document instanceof DisassemblyDocument) {
            IBreakpointManager bpMgr = DebugPlugin.getDefault().getBreakpointManager();
            bpMgr.removeBreakpointListener((IBreakpointListener)this);
            document.removeDocumentListener((IDocumentListener)this);
            this.fCatchup = null;
        }
        super.disconnect(document);
    }

    private void catchupWithBreakpoints() {
        this.removeAllAnnotations(false);
        IBreakpointManager bpMgr = DebugPlugin.getDefault().getBreakpointManager();
        this.addBreakpoints(bpMgr.getBreakpoints());
    }

    private void addBreakpoints(IBreakpoint[] breakpoints) {
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            this.addBreakpointAnnotation(breakpoint, false);
            ++n2;
        }
        this.fireModelChanged();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.addBreakpointAnnotation(breakpoint, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        Annotation a = this.findAnnotation(breakpoint.getMarker());
        if (a != null) {
            if (a instanceof SimpleMarkerAnnotation) {
                ((SimpleMarkerAnnotation)a).update();
            }
            Object object = this.getLockObject();
            synchronized (object) {
                this.getAnnotationModelEvent().annotationChanged(a);
            }
            this.fireModelChanged();
        } else {
            this.addBreakpointAnnotation(breakpoint, true);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        Annotation a = this.findAnnotation(breakpoint.getMarker());
        if (a != null) {
            this.removeAnnotation(a, true);
        }
    }

    private Annotation findAnnotation(IMarker marker) {
        Iterator it = this.getAnnotationIterator(false);
        while (it.hasNext()) {
            SimpleMarkerAnnotation a = (SimpleMarkerAnnotation)it.next();
            if (!a.getMarker().equals((Object)marker)) continue;
            return a;
        }
        return null;
    }

    private void addBreakpointAnnotation(IBreakpoint breakpoint, boolean fireEvent) {
        IMarker marker = breakpoint.getMarker();
        if (marker == null) {
            return;
        }
        try {
            Position position = this.createPositionFromBreakpoint(breakpoint);
            if (position != null) {
                this.addAnnotation((Annotation)new MarkerAnnotation(marker), position, fireEvent);
            }
        }
        catch (CoreException coreException) {
        }
        catch (BadLocationException badLocationException) {}
    }

    private Position createPositionFromBreakpoint(IBreakpoint breakpoint) throws CoreException {
        IBreakpointLocationProvider locationProvider = (IBreakpointLocationProvider)breakpoint.getAdapter(IBreakpointLocationProvider.class);
        if (locationProvider != null) {
            String sourceFile = locationProvider.getSourceFile(breakpoint);
            if (sourceFile != null) {
                int lineNumber = locationProvider.getLineNumber(breakpoint) - 1;
                return this.createPositionFromSourceLine(sourceFile, lineNumber);
            }
            IAddress labelAddress = locationProvider.getLabelAddress(breakpoint);
            if (labelAddress != null) {
                return this.createPositionFromLabel(labelAddress.getValue());
            }
            IAddress[] addresses = locationProvider.getAddresses(breakpoint);
            int i = 0;
            while (addresses != null && i < addresses.length) {
                BigInteger address = addresses[i].getValue();
                Position position = this.createPositionFromAddress(address);
                if (position != null) {
                    return position;
                }
                ++i;
            }
        } else {
            if (breakpoint instanceof ICAddressBreakpoint) {
                ICAddressBreakpoint addressBreakpoint = (ICAddressBreakpoint)breakpoint;
                return this.createPositionFromAddress(BreakpointsAnnotationModel.decodeAddress(addressBreakpoint.getAddress()));
            }
            if (breakpoint instanceof ILineBreakpoint) {
                ILineBreakpoint lineBreakpoint = (ILineBreakpoint)breakpoint;
                Position position = null;
                int lineNumber = lineBreakpoint.getLineNumber() - 1;
                IMarker marker = breakpoint.getMarker();
                if (marker.getResource().getType() == 1) {
                    position = this.createPositionFromSourceLine((IFile)marker.getResource(), lineNumber);
                } else if (breakpoint instanceof ICLineBreakpoint) {
                    ICLineBreakpoint cBreakpoint = (ICLineBreakpoint)breakpoint;
                    position = this.createPositionFromSourceLine(cBreakpoint.getFileName(), lineNumber);
                    if (position == null) {
                        position = this.createPositionFromAddress(BreakpointsAnnotationModel.decodeAddress(cBreakpoint.getAddress()));
                    }
                } else {
                    String fileName = marker.getAttribute("org.eclipse.cdt.debug.core.sourceHandle", null);
                    if (fileName != null) {
                        position = this.createPositionFromSourceLine(fileName, lineNumber);
                    }
                }
                return position;
            }
        }
        return null;
    }

    private Position createPositionFromSourceLine(String fileName, int lineNumber) {
        return this.getDisassemblyDocument().getSourcePosition(fileName, lineNumber);
    }

    private Position createPositionFromSourceLine(IFile file, int lineNumber) {
        return this.getDisassemblyDocument().getSourcePosition((IStorage)file, lineNumber);
    }

    private Position createPositionFromAddress(BigInteger address) {
        AddressRangePosition p;
        if (address != null && (p = this.getDisassemblyDocument().getDisassemblyPosition(address)) != null && p.fValid) {
            return new Position(p.offset, p.length);
        }
        return null;
    }

    private Position createPositionFromLabel(BigInteger address) {
        LabelPosition p;
        if (address != null && (p = this.getDisassemblyDocument().getLabelPosition(address)) != null && p.fValid) {
            return new Position(p.offset, p.length);
        }
        return null;
    }

    private DisassemblyDocument getDisassemblyDocument() {
        return (DisassemblyDocument)this.fDocument;
    }

    private static BigInteger decodeAddress(String string) {
        try {
            if (string.startsWith("0x")) {
                return new BigInteger(string.substring(2), 16);
            }
            if (string.length() > 0) {
                return new BigInteger(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if (this.fCatchup == null && event.fText != null && event.fText.length() > 0) {
            this.fCatchup = new Runnable(){

                public void run() {
                    if (BreakpointsAnnotationModel.this.fCatchup == this) {
                        BreakpointsAnnotationModel.this.catchupWithBreakpoints();
                        BreakpointsAnnotationModel.this.fCatchup = null;
                    }
                }
            };
            Display.getCurrent().timerExec(50, this.fCatchup);
        }
    }
}

