/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyPosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyUtils;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.ErrorPosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyDocument;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.LabelPosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.SourcePosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyWithSourcePosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.SourceFileInfo;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.SourceReadingJob;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.text.REDDocument;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.text.REDTextStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisassemblyDocument
extends REDDocument
implements IDisassemblyDocument {
    public static final String CATEGORY_MODEL = "category_model";
    public static final String CATEGORY_DISASSEMBLY = "category_disassembly";
    public static final String CATEGORY_SOURCE = "category_source";
    public static final String CATEGORY_LABELS = "category_labels";
    private final List<AddressRangePosition> fInvalidAddressRanges = new ArrayList<AddressRangePosition>();
    private final List<SourcePosition> fInvalidSource = new ArrayList<SourcePosition>();
    private final Map<IStorage, SourceFileInfo> fFileInfoMap = new HashMap<IStorage, SourceFileInfo>();
    private int fMaxFunctionLength = 0;
    private boolean fShowAddresses = false;
    private int fRadix = 16;
    private boolean fShowRadixPrefix = false;
    private String fRadixPrefix;
    private int fNumberOfDigits;
    private boolean fShowCodeBytes = false;
    private int fNumberOfInstructions;
    private double fMeanSizeOfInstructions = 4.0;
    private long fErrorAlignment = 1L;

    protected void completeInitialization() {
        super.completeInitialization();
        this.addPositionCategory(CATEGORY_MODEL);
        this.addPositionCategory(CATEGORY_DISASSEMBLY);
        this.addPositionCategory(CATEGORY_SOURCE);
        this.addPositionCategory(CATEGORY_LABELS);
        this.setRadix(16);
        this.setShowRadixPrefix(false);
        this.fNumberOfInstructions = 0;
        this.fMeanSizeOfInstructions = 4.0;
    }

    @Override
    public void dispose() {
        assert (DisassemblyDocument.isGuiThread());
        super.dispose();
        for (SourceFileInfo fi : this.fFileInfoMap.values()) {
            fi.dispose();
        }
        this.fFileInfoMap.clear();
        this.fInvalidAddressRanges.clear();
        this.fInvalidSource.clear();
    }

    public void clear() {
        this.dispose();
        this.setTextStore(new REDTextStore());
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.completeInitialization();
    }

    public AddressRangePosition[] getInvalidAddressRanges() {
        assert (DisassemblyDocument.isGuiThread());
        return this.fInvalidAddressRanges.toArray(new AddressRangePosition[this.fInvalidAddressRanges.size()]);
    }

    public void setMaxOpcodeLength(int opcodeLength) {
        this.fMaxFunctionLength = opcodeLength;
    }

    public int getMaxFunctionLength() {
        return this.fMaxFunctionLength;
    }

    public int getAddressLength() {
        return this.fNumberOfDigits + 2;
    }

    public int getMeanSizeOfInstructions() {
        return (int)(this.fMeanSizeOfInstructions + 0.9);
    }

    public Iterator<AddressRangePosition> getModelPositionIterator(BigInteger address) {
        try {
            return this.getPositionIterator(CATEGORY_MODEL, address);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            return null;
        }
    }

    public Iterator<Position> getPositionIterator(String category, int offset) throws BadPositionCategoryException {
        List positions = (List)this.getDocumentManagedPositions().get(category);
        if (positions == null) {
            throw new BadPositionCategoryException();
        }
        int idx = this.computeIndexInPositionList(positions, offset, true);
        return positions.listIterator(idx);
    }

    public Iterator<AddressRangePosition> getPositionIterator(String category, BigInteger address) throws BadPositionCategoryException {
        List positions = (List)this.getDocumentManagedPositions().get(category);
        if (positions == null) {
            throw new BadPositionCategoryException();
        }
        int idx = this.computeIndexInPositionListFirst(positions, address);
        return positions.listIterator(idx);
    }

    public int computeIndexInCategory(String category, BigInteger address) throws BadPositionCategoryException {
        List c = (List)this.getDocumentManagedPositions().get(category);
        if (c == null) {
            throw new BadPositionCategoryException();
        }
        return this.computeIndexInPositionListFirst(c, address);
    }

    protected int computeIndexInPositionListFirst(List<AddressRangePosition> positions, BigInteger address) {
        int size = positions.size();
        if (size == 0) {
            return 0;
        }
        int left = 0;
        int right = size - 1;
        int mid = 0;
        while (left <= right) {
            mid = (left + right) / 2;
            AddressRangePosition range = positions.get(mid);
            if (address.compareTo(range.fAddressOffset) < 0) {
                right = mid - 1;
                continue;
            }
            if (address.compareTo(range.fAddressOffset) == 0 || address.compareTo(range.fAddressOffset.add(range.fAddressLength)) < 0) break;
            left = mid + 1;
        }
        int idx = mid;
        AddressRangePosition p = positions.get(idx);
        if (address.compareTo(p.fAddressOffset.add(p.fAddressLength)) > 0) {
            ++idx;
        } else if (address.compareTo(p.fAddressOffset) == 0) {
            while (--idx >= 0) {
                p = positions.get(idx);
                if (address.compareTo(p.fAddressOffset) == 0) continue;
            }
            ++idx;
        }
        return idx;
    }

    protected int computeIndexInPositionListLast(List<AddressRangePosition> positions, BigInteger address) {
        int size = positions.size();
        if (size == 0) {
            return 0;
        }
        int left = 0;
        int right = size - 1;
        int mid = 0;
        while (left <= right) {
            mid = (left + right) / 2;
            AddressRangePosition range = positions.get(mid);
            if (address.compareTo(range.fAddressOffset) < 0) {
                right = mid - 1;
                continue;
            }
            if (address.compareTo(range.fAddressOffset) == 0 || address.compareTo(range.fAddressOffset.add(range.fAddressLength)) < 0) break;
            left = mid + 1;
        }
        int idx = mid;
        AddressRangePosition p = positions.get(idx);
        if (address.compareTo(p.fAddressOffset) > 0) {
            ++idx;
        } else if (address.compareTo(p.fAddressOffset) == 0 && p.fAddressLength.compareTo(BigInteger.ZERO) == 0) {
            while (++idx != size) {
                p = positions.get(idx);
                if (address.compareTo(p.fAddressOffset) == 0 && p.fAddressLength.compareTo(BigInteger.ZERO) == 0) continue;
            }
        }
        return idx;
    }

    protected int computeIndexInPositionListLast(List<Position> positions, int offset) {
        if (positions.size() == 0) {
            return 0;
        }
        int left = 0;
        int right = positions.size() - 1;
        int mid = 0;
        Position p = null;
        while (left < right) {
            mid = (left + right) / 2;
            p = positions.get(mid);
            if (offset < p.getOffset()) {
                if (left == mid) {
                    right = left;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if (offset > p.getOffset()) {
                if (right == mid) {
                    left = right;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            if (offset != p.getOffset()) continue;
            left = right = mid;
        }
        int pos = left;
        p = positions.get(pos);
        while (offset >= p.getOffset()) {
            if (++pos == positions.size()) break;
            p = positions.get(pos);
        }
        assert (pos >= 0 && pos <= positions.size());
        return pos;
    }

    public Position getPositionOfIndex(String category, int index) throws BadPositionCategoryException {
        if (index >= 0) {
            List positions = (List)this.getDocumentManagedPositions().get(category);
            if (positions == null) {
                throw new BadPositionCategoryException();
            }
            if (index < positions.size()) {
                return (Position)positions.get(index);
            }
        }
        return null;
    }

    public AddressRangePosition getPositionOfAddress(BigInteger address) {
        AddressRangePosition pos = this.getPositionOfAddress(CATEGORY_DISASSEMBLY, address);
        return pos;
    }

    public AddressRangePosition getPositionOfAddress(String category, BigInteger address) {
        List positions = (List)this.getDocumentManagedPositions().get(category);
        if (positions == null) {
            return null;
        }
        int index = this.computeIndexInPositionListFirst(positions, address);
        if (index < positions.size()) {
            AddressRangePosition p = (AddressRangePosition)positions.get(index);
            if (address.compareTo(p.fAddressOffset) == 0 || p.containsAddress(address)) {
                return p;
            }
        }
        return null;
    }

    public AddressRangePosition getPositionInAddressRange(String category, AddressRangePosition range) {
        List positions = (List)this.getDocumentManagedPositions().get(category);
        if (positions == null) {
            return null;
        }
        BigInteger endAddress = range.fAddressOffset.add(range.fAddressLength);
        int index = this.computeIndexInPositionListFirst(positions, range.fAddressOffset);
        if (index < positions.size()) {
            do {
                AddressRangePosition p = (AddressRangePosition)positions.get(index);
                if (p.fAddressOffset.compareTo(endAddress) >= 0) continue;
                return p;
            } while (--index >= 0);
        }
        return null;
    }

    public BigInteger getAddressOfLine(int line) {
        try {
            int offset = this.getLineOffset(line);
            return this.getAddressOfOffset(offset);
        }
        catch (BadLocationException badLocationException) {
            return BigInteger.valueOf(-1L);
        }
    }

    public BigInteger getAddressOfOffset(int offset) {
        AddressRangePosition pos;
        try {
            pos = this.getModelPosition(offset);
        }
        catch (BadLocationException e) {
            this.internalError(e);
            return BigInteger.valueOf(-1L);
        }
        if (pos == null) {
            return BigInteger.valueOf(-1L);
        }
        return pos.fAddressOffset;
    }

    public AddressRangePosition getDisassemblyPosition(int offset) throws BadLocationException {
        Position p = null;
        try {
            p = this.getPosition(CATEGORY_DISASSEMBLY, offset, false);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return (AddressRangePosition)p;
    }

    public AddressRangePosition getDisassemblyPosition(BigInteger address) {
        return this.getPositionOfAddress(CATEGORY_DISASSEMBLY, address);
    }

    public AddressRangePosition getModelPosition(int offset) throws BadLocationException {
        Position p = null;
        try {
            p = this.getPosition(CATEGORY_MODEL, offset, false);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return (AddressRangePosition)p;
    }

    public SourcePosition getSourcePosition(int offset) throws BadLocationException {
        Position p = null;
        try {
            p = this.getPosition(CATEGORY_SOURCE, offset, true);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return (SourcePosition)p;
    }

    public SourcePosition getSourcePosition(BigInteger address) {
        return (SourcePosition)this.getPositionOfAddress(CATEGORY_SOURCE, address);
    }

    public LabelPosition getLabelPosition(BigInteger address) {
        return (LabelPosition)this.getPositionOfAddress(CATEGORY_LABELS, address);
    }

    public SourcePosition getSourcePositionInAddressRange(AddressRangePosition range) {
        return (SourcePosition)this.getPositionInAddressRange(CATEGORY_SOURCE, range);
    }

    public Position getSourcePosition(IStorage file, int lineNumber) {
        SourceFileInfo info = this.getSourceInfo(file);
        return this.getSourcePosition(info, lineNumber);
    }

    public Position getSourcePosition(String fileName, int lineNumber) {
        SourceFileInfo info = this.getSourceInfo(fileName);
        if (info == null) {
            info = this.getSourceInfo((IStorage)new LocalFileStorage(new File(fileName)));
        }
        return this.getSourcePosition(info, lineNumber);
    }

    public Position getSourcePosition(SourceFileInfo info, int lineNumber) {
        int lineLength;
        int lineOffset;
        SourcePosition srcPos;
        block12: {
            block11: {
                if (info == null || info.fSource == null) {
                    return null;
                }
                srcPos = null;
                IRegion stmtLineRegion = info.fSource.getLineInformation(lineNumber);
                lineOffset = stmtLineRegion.getOffset();
                lineLength = stmtLineRegion.getLength() + 1;
                BigInteger stmtAddress = info.fLine2Addr[lineNumber];
                if (stmtAddress != null && stmtAddress.compareTo(BigInteger.ZERO) > 0) {
                    srcPos = this.getSourcePosition(stmtAddress);
                }
                if (srcPos != null) break block11;
                Iterator<Position> iterator = this.getPositionIterator(CATEGORY_SOURCE, 0);
                while (iterator.hasNext()) {
                    int baseOffset;
                    SourcePosition pos = (SourcePosition)iterator.next();
                    if (pos.fFileInfo != info || !pos.fValid || lineNumber < pos.fLine || lineOffset + lineLength - (baseOffset = info.fSource.getLineOffset(pos.fLine)) > pos.length) continue;
                    srcPos = pos;
                    break;
                }
                if (srcPos == null) {
                    return null;
                }
                break block12;
            }
            if (srcPos.fValid) break block12;
            return null;
        }
        try {
            assert (lineNumber >= srcPos.fLine);
            int baseOffset = info.fSource.getLineOffset(srcPos.fLine);
            int offset = srcPos.offset + lineOffset - baseOffset;
            if (offset >= srcPos.offset && offset < srcPos.offset + srcPos.length) {
                return new Position(offset, lineLength);
            }
        }
        catch (BadLocationException exc) {
            this.internalError(exc);
        }
        catch (BadPositionCategoryException exc) {
            this.internalError(exc);
        }
        return null;
    }

    public Position getPosition(String category, int offset, boolean allowZeroLength) throws BadLocationException, BadPositionCategoryException {
        List list = (List)this.getDocumentManagedPositions().get(category);
        int idx = this.computeIndexInPositionList(list, offset, true);
        if (idx > 0) {
            --idx;
        }
        while (idx < list.size()) {
            Position pos = (Position)list.get(idx);
            if (pos.offset > offset) break;
            if (pos.includes(offset)) {
                return pos;
            }
            if (allowZeroLength && pos.offset == offset) {
                return pos;
            }
            ++idx;
        }
        return null;
    }

    public void addModelPosition(AddressRangePosition pos) {
        try {
            this.addPositionLast(CATEGORY_MODEL, pos);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void addModelPositionFirst(AddressRangePosition pos) {
        List list = (List)this.getDocumentManagedPositions().get(CATEGORY_MODEL);
        int idx = this.computeIndexInPositionListFirst(list, pos.fAddressOffset.add(pos.fAddressLength));
        if (idx < list.size()) {
            AddressRangePosition nextPos = (AddressRangePosition)list.get(idx);
            assert (nextPos.fAddressOffset.compareTo(pos.fAddressOffset.add(pos.fAddressLength)) == 0);
        }
        list.add(idx, pos);
    }

    public void addDisassemblyPosition(AddressRangePosition pos) throws BadLocationException {
        try {
            this.addPositionLast(CATEGORY_DISASSEMBLY, pos);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        if (pos instanceof DisassemblyPosition) {
            int functionLength = ((DisassemblyPosition)pos).fFunction.length;
            if (functionLength > this.fMaxFunctionLength) {
                this.fMaxFunctionLength = functionLength;
            }
            if (this.fNumberOfInstructions < 100) {
                this.fMeanSizeOfInstructions = (this.fMeanSizeOfInstructions * (double)this.fNumberOfInstructions + (double)pos.fAddressLength.floatValue()) / (double)(++this.fNumberOfInstructions);
            }
        }
    }

    public void addPositionLast(String category, AddressRangePosition pos) throws BadPositionCategoryException {
        List list = (List)this.getDocumentManagedPositions().get(category);
        if (list == null) {
            throw new BadPositionCategoryException();
        }
        if (DisassemblyUtils.DEBUG) {
            System.out.println("Adding position to category <" + category + "> : " + pos);
        }
        list.add(this.computeIndexInPositionListLast(list, pos.fAddressOffset), pos);
    }

    public void addLabelPosition(AddressRangePosition pos) throws BadLocationException {
        try {
            this.addPositionLast(CATEGORY_LABELS, pos);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void addSourcePosition(AddressRangePosition pos) throws BadLocationException {
        try {
            this.addPositionLast(CATEGORY_SOURCE, pos);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void removeDisassemblyPosition(AddressRangePosition pos) {
        try {
            this.removePosition(CATEGORY_DISASSEMBLY, (Position)pos);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void removeSourcePosition(AddressRangePosition pos) {
        try {
            this.removePosition(CATEGORY_SOURCE, (Position)pos);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void removeModelPosition(AddressRangePosition pos) {
        try {
            this.removePosition(DisassemblyDocument.getCategory(pos), (Position)pos);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    private static String getCategory(AddressRangePosition pos) {
        if (pos instanceof LabelPosition) {
            return CATEGORY_LABELS;
        }
        if (pos instanceof SourcePosition) {
            return CATEGORY_SOURCE;
        }
        return CATEGORY_DISASSEMBLY;
    }

    public void removePosition(String category, Position position) throws BadPositionCategoryException {
        super.removePosition(category, position);
        if (DisassemblyUtils.DEBUG && DisassemblyDocument.isOneOfOurs(category)) {
            System.out.println("Removing position from category(" + category + ") :" + position);
        }
        if (!category.equals(CATEGORY_MODEL) && position instanceof AddressRangePosition) {
            super.removePosition(CATEGORY_MODEL, position);
        }
    }

    public void removePositions(String category, List<AddressRangePosition> toRemove) {
        List positions;
        if (toRemove.isEmpty()) {
            return;
        }
        if (DisassemblyUtils.DEBUG && DisassemblyDocument.isOneOfOurs(category)) {
            System.out.println("Removing positions from category(" + category + ')');
            int i = 0;
            for (AddressRangePosition pos : toRemove) {
                System.out.println("[" + i++ + "] " + pos);
            }
        }
        if ((positions = (List)this.getDocumentManagedPositions().get(category)) != null) {
            positions.removeAll(toRemove);
        }
        if (category != CATEGORY_MODEL && (positions = (List)this.getDocumentManagedPositions().get(CATEGORY_MODEL)) != null) {
            positions.removeAll(toRemove);
        }
    }

    public void addPositionLast(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        if (position.offset < 0 || position.length < 0 || position.offset + position.length > this.getLength()) {
            throw new BadLocationException();
        }
        if (category == null) {
            throw new BadPositionCategoryException();
        }
        List list = (List)this.getDocumentManagedPositions().get(category);
        if (list == null) {
            throw new BadPositionCategoryException();
        }
        list.add(this.computeIndexInPositionListLast(list, position.offset), position);
    }

    public void checkConsistency() {
        block8: {
            AddressRangePosition last = null;
            try {
                Iterator<Position> it = this.getPositionIterator(CATEGORY_MODEL, 0);
                while (it.hasNext()) {
                    AddressRangePosition pos = (AddressRangePosition)it.next();
                    if (last != null) {
                        assert (last.fAddressOffset.compareTo(pos.fAddressOffset) <= 0);
                        assert (last.fAddressOffset.add(last.fAddressLength).compareTo(pos.fAddressOffset) == 0);
                        assert (last.offset <= pos.offset);
                        assert (last.offset + last.length == pos.offset);
                    }
                    last = pos;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
    }

    public void replace(AddressRangePosition insertPos, int replaceLength, String text) throws BadLocationException {
        int delta = (text != null ? text.length() : 0) - replaceLength;
        if (delta != 0) {
            AddressRangePosition pos;
            BigInteger address = insertPos.fAddressOffset;
            Iterator<AddressRangePosition> it = this.getModelPositionIterator(address);
            while (it.hasNext()) {
                pos = it.next();
                assert (pos.fAddressOffset.compareTo(address) >= 0);
                if (pos.fAddressOffset.compareTo(address) > 0 || pos.offset > insertPos.offset || pos == insertPos) break;
            }
            while (it.hasNext()) {
                pos = it.next();
                pos.offset += delta;
            }
        }
        if (DisassemblyUtils.DEBUG) {
            String escapedText = null;
            if (text != null) {
                escapedText = text.replace(new StringBuffer("\n"), new StringBuffer("\\n"));
                escapedText = escapedText.replace(new StringBuffer("\r"), new StringBuffer("\\r"));
                escapedText = escapedText.replace(new StringBuffer("\t"), new StringBuffer("\\t"));
            }
            System.out.println("Calling AbstractDocument.replace(" + insertPos.offset + ',' + replaceLength + ",\"" + escapedText + "\")");
        }
        super.replace(insertPos.offset, replaceLength, text);
    }

    public AddressRangePosition insertAddressRange(AddressRangePosition pos, AddressRangePosition insertPos, String line, boolean addToModel) throws BadLocationException {
        int insertOffset;
        assert (DisassemblyDocument.isGuiThread());
        BigInteger address = insertPos.fAddressOffset;
        BigInteger length = insertPos.fAddressLength;
        if (pos == null) {
            pos = this.getPositionOfAddress(address);
        }
        assert (!(pos.isDeleted || pos.fValid || length.compareTo(BigInteger.ZERO) != 0 && !pos.containsAddress(address)));
        int replaceLength = 0;
        if (length.compareTo(BigInteger.ONE) > 0 && !pos.containsAddress(address.add(length.subtract(BigInteger.ONE)))) {
            Iterator<AddressRangePosition> it = this.getModelPositionIterator(pos.fAddressOffset.add(pos.fAddressLength));
            assert (it.hasNext());
            do {
                AddressRangePosition overlap = it.next();
                BigInteger posEndAddress = pos.fAddressOffset.add(pos.fAddressLength);
                assert (pos.offset <= overlap.offset && overlap.fAddressOffset.compareTo(posEndAddress) == 0);
                if (overlap instanceof LabelPosition || overlap instanceof SourcePosition) {
                    length = insertPos.fAddressLength = posEndAddress.subtract(address.max(pos.fAddressOffset));
                    break;
                }
                pos.fAddressLength = pos.fAddressLength.add(overlap.fAddressLength);
                replaceLength = overlap.offset + overlap.length - pos.offset - pos.length;
                it.remove();
                this.removeModelPosition(overlap);
                if (overlap.fValid) continue;
                this.removeInvalidAddressRange(overlap);
            } while (!pos.containsAddress(address.add(length.subtract(BigInteger.ONE))));
        }
        BigInteger newEndAddress = pos.fAddressOffset.add(pos.fAddressLength);
        BigInteger newStartAddress = address.add(length);
        assert (newEndAddress.compareTo(newStartAddress) >= 0);
        if (address.compareTo(pos.fAddressOffset) == 0) {
            insertOffset = pos.offset;
            if (replaceLength == 0 && newEndAddress.compareTo(newStartAddress) > 0) {
                pos.fAddressOffset = newStartAddress;
                pos.fAddressLength = pos.fAddressLength.subtract(length);
                newEndAddress = newStartAddress;
            } else {
                replaceLength += pos.length;
                this.removeInvalidAddressRange(pos);
                this.removeDisassemblyPosition(pos);
                pos = null;
            }
        } else {
            insertOffset = pos.offset + pos.length;
            pos.fAddressLength = address.subtract(pos.fAddressOffset);
            assert (pos.fAddressLength.compareTo(BigInteger.ZERO) > 0);
            pos = null;
        }
        if (newEndAddress.compareTo(newStartAddress) > 0) {
            pos = this.insertInvalidAddressRange(insertOffset + replaceLength, 0, newStartAddress, newEndAddress);
        }
        assert (pos == null || pos.fAddressLength.compareTo(BigInteger.ZERO) > 0 && pos.containsAddress(address.add(length)));
        assert (insertOffset + replaceLength <= this.getLength());
        insertPos.offset = insertOffset;
        if (addToModel) {
            this.addModelPosition(insertPos);
        }
        this.replace(insertPos, replaceLength, line);
        if (DisassemblyUtils.DEBUG) {
            this.checkConsistency();
        }
        return pos;
    }

    public AddressRangePosition insertDisassemblyLine(AddressRangePosition pos, BigInteger address, int length, String opcode, String instruction, String file, int lineNr) throws BadLocationException {
        assert (DisassemblyDocument.isGuiThread());
        String disassLine = null;
        disassLine = instruction == null || instruction.length() == 0 ? "" : this.buildDisassemblyLine(address, opcode, instruction);
        Object disassPos = lineNr < 0 ? new DisassemblyPosition(0, disassLine.length(), address, BigInteger.valueOf(length), opcode) : new DisassemblyWithSourcePosition(0, disassLine.length(), address, BigInteger.valueOf(length), opcode, file, lineNr);
        pos = this.insertAddressRange(pos, (AddressRangePosition)disassPos, disassLine, true);
        this.addDisassemblyPosition((AddressRangePosition)disassPos);
        return pos;
    }

    private String buildDisassemblyLine(BigInteger address, String opcode, String instruction) {
        StringBuffer buf = new StringBuffer(40);
        if (this.fShowAddresses) {
            if (this.fRadixPrefix != null) {
                buf.append(this.fRadixPrefix);
            }
            String str = address.toString(this.fRadix);
            int i = str.length();
            while (i < this.fNumberOfDigits) {
                buf.append('0');
                ++i;
            }
            buf.append(str);
            buf.append(':');
            buf.append(' ');
        }
        if (this.fShowCodeBytes && opcode != null && opcode.length() > 0) {
            buf.append(opcode);
            int tab = 16;
            if (opcode.length() >= 16) {
                tab = opcode.length() + 8 & 0xFFFFFFF8;
            }
            int diff = tab - opcode.length();
            while (diff-- > 0) {
                buf.append(' ');
            }
        } else if (!this.fShowAddresses) {
            buf.append(' ');
            buf.append(' ');
        }
        int n = instruction.length();
        int prefixLen = buf.length();
        int j = 0;
        while (j < n) {
            char ch = instruction.charAt(j);
            if (ch == '\t') {
                int tab = buf.length() - prefixLen + 8 & 0xFFFFFFF8;
                do {
                    buf.append(' ');
                } while (buf.length() - prefixLen < tab);
            } else {
                buf.append(ch);
            }
            ++j;
        }
        buf.append('\n');
        return buf.toString();
    }

    public void setRadix(int radix) {
        this.fRadix = radix;
        this.fNumberOfDigits = (int)(Math.log(4.294967296E9) / Math.log(radix) + 0.9);
        this.setShowRadixPrefix(this.fShowRadixPrefix);
    }

    public void setShowRadixPrefix(boolean showRadixPrefix) {
        this.fShowRadixPrefix = showRadixPrefix;
        this.fRadixPrefix = !this.fShowRadixPrefix ? null : (this.fRadix == 16 ? "0x" : (this.fRadix == 8 ? "0" : null));
    }

    public AddressRangePosition insertErrorLine(AddressRangePosition pos, BigInteger address, BigInteger length, String line) throws BadLocationException {
        assert (DisassemblyDocument.isGuiThread());
        int hashCode = line.hashCode();
        long alignment = this.fErrorAlignment;
        if (alignment > 1L && !(pos instanceof ErrorPosition)) {
            AddressRangePosition after;
            AddressRangePosition before = this.getPositionOfAddress(address.subtract(BigInteger.ONE));
            if (before instanceof ErrorPosition && before.hashCode() == hashCode && before.offset + before.length == pos.offset) {
                assert (before.fAddressOffset.add(before.fAddressLength).compareTo(address) == 0);
                assert (pos.fAddressOffset.compareTo(address) == 0);
                BigInteger pageOffset = before.fAddressOffset.and(BigInteger.valueOf(alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL));
                BigInteger mergeLen = pageOffset.add(BigInteger.valueOf(alignment)).subtract(before.fAddressOffset.add(before.fAddressLength)).min(length);
                if (mergeLen.compareTo(BigInteger.ZERO) > 0) {
                    pos.fAddressLength = pos.fAddressLength.subtract(mergeLen);
                    if (pos.fAddressLength.compareTo(BigInteger.ZERO) == 0) {
                        this.replace(pos, pos.length, null);
                        this.removeModelPosition(pos);
                        this.removeInvalidAddressRange(pos);
                        pos = null;
                    } else {
                        pos.fAddressOffset = pos.fAddressOffset.add(mergeLen);
                    }
                    before.fAddressLength = before.fAddressLength.add(mergeLen);
                    address = address.add(mergeLen);
                    length = length.subtract(mergeLen);
                    if (DisassemblyUtils.DEBUG) {
                        this.checkConsistency();
                    }
                    if (length.compareTo(BigInteger.ZERO) == 0) {
                        return pos;
                    }
                }
            }
            if ((after = this.getPositionOfAddress(address.add(length))) instanceof ErrorPosition && after.hashCode() == hashCode && pos != null && pos.offset + pos.length == after.offset) {
                assert (after.fAddressOffset == address.add(length));
                assert (pos.fAddressOffset.add(pos.fAddressLength).compareTo(after.fAddressOffset) == 0);
                BigInteger pageOffset = after.fAddressOffset.add(BigInteger.valueOf(alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL));
                BigInteger mergeLen = after.fAddressOffset.subtract(pageOffset).min(length);
                if (mergeLen.compareTo(BigInteger.ZERO) > 0) {
                    after.fAddressOffset = after.fAddressOffset.subtract(mergeLen);
                    after.fAddressLength = after.fAddressLength.add(mergeLen);
                    pos.fAddressLength = pos.fAddressLength.subtract(mergeLen);
                    if (pos.fAddressLength.compareTo(BigInteger.ZERO) == 0) {
                        this.replace(pos, pos.length, null);
                        this.removeModelPosition(pos);
                        this.removeInvalidAddressRange(pos);
                        pos = null;
                    }
                    if (DisassemblyUtils.DEBUG) {
                        this.checkConsistency();
                    }
                    if ((length = length.subtract(mergeLen)).compareTo(BigInteger.ZERO) == 0) {
                        return pos;
                    }
                }
            }
        }
        BigInteger pageOffset = address.and(BigInteger.valueOf(alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL));
        BigInteger posLen = pageOffset.add(BigInteger.valueOf(alignment)).subtract(address).min(length);
        while (length.compareTo(BigInteger.ZERO) > 0) {
            ErrorPosition errorPos = new ErrorPosition(0, 0, address, posLen, hashCode);
            String errorLine = this.buildDisassemblyLine(address, null, line);
            errorPos.length = errorLine.length();
            pos = this.insertAddressRange(pos, (AddressRangePosition)errorPos, errorLine, true);
            this.addDisassemblyPosition((AddressRangePosition)errorPos);
            if (!errorPos.fValid) {
                this.addInvalidAddressRange((AddressRangePosition)errorPos);
            }
            length = length.subtract(posLen);
            address = address.add(posLen);
            posLen = BigInteger.valueOf(alignment).min(length);
        }
        return pos;
    }

    public AddressRangePosition insertLabel(AddressRangePosition pos, BigInteger address, String label, boolean showLabels) throws BadLocationException {
        assert (DisassemblyDocument.isGuiThread());
        String labelLine = showLabels ? String.valueOf(label) + ":\n" : "";
        LabelPosition labelPos = this.getLabelPosition(address);
        if (labelPos != null) {
            assert (labelPos.fAddressOffset.compareTo(address) == 0);
            if (labelPos.length != labelLine.length()) {
                int oldLength = labelPos.length;
                labelPos.length = labelLine.length();
                this.replace((AddressRangePosition)labelPos, oldLength, labelLine);
            }
            return pos;
        }
        labelPos = new LabelPosition(0, labelLine.length(), address, null);
        pos = this.insertAddressRange(pos, (AddressRangePosition)labelPos, labelLine, true);
        this.addLabelPosition((AddressRangePosition)labelPos);
        return pos;
    }

    public SourcePosition insertSource(SourcePosition pos, String source, int line, boolean endOfSource) {
        String sourceLines = source;
        if (source.length() > 0 && sourceLines.charAt(source.length() - 1) != '\n') {
            sourceLines = String.valueOf(sourceLines) + "\n";
        }
        try {
            assert (!pos.fValid);
            int oldLength = pos.length;
            pos.length = sourceLines.length();
            pos.fLine = line;
            pos.fValid = true;
            this.removeInvalidSourcePosition(pos);
            this.replace(pos, oldLength, sourceLines);
            if (!endOfSource && pos.length > 0) {
                SourcePosition oldPos = this.getSourcePosition(pos.offset + pos.length);
                if (oldPos == null || oldPos.fAddressOffset.compareTo(pos.fAddressOffset) != 0) {
                    pos = new SourcePosition(pos.offset + pos.length, 0, pos.fAddressOffset, pos.fFileInfo, line, false);
                    this.addSourcePosition(pos);
                    this.addModelPosition(pos);
                    this.addInvalidSourcePositions(pos);
                } else {
                    pos = oldPos;
                }
            }
        }
        catch (BadLocationException e) {
            this.internalError(e);
        }
        return pos;
    }

    public AddressRangePosition insertInvalidSource(AddressRangePosition pos, BigInteger address, SourceFileInfo fi, int lineNr) {
        assert (DisassemblyDocument.isGuiThread());
        SourcePosition sourcePos = this.getSourcePosition(address);
        if (sourcePos != null) {
            return pos;
        }
        String sourceLine = "";
        sourcePos = new SourcePosition(0, sourceLine.length(), address, fi, lineNr, false);
        try {
            pos = this.insertAddressRange(pos, sourcePos, sourceLine, true);
            this.addSourcePosition(sourcePos);
            assert (!this.fInvalidSource.contains((Object)sourcePos));
            this.addInvalidSourcePositions(sourcePos);
        }
        catch (BadLocationException e) {
            this.internalError(e);
        }
        return pos;
    }

    public AddressRangePosition insertInvalidAddressRange(int offset, int replaceLength, BigInteger startAddress, BigInteger endAddress) {
        assert (DisassemblyDocument.isGuiThread());
        String periods = "...\n";
        AddressRangePosition newPos = new AddressRangePosition(offset, periods.length(), startAddress, endAddress.subtract(startAddress), false);
        try {
            this.addModelPositionFirst(newPos);
            this.replace(newPos, replaceLength, periods);
            this.addDisassemblyPosition(newPos);
            this.addInvalidAddressRange(newPos);
        }
        catch (BadLocationException e) {
            this.internalError(e);
        }
        return newPos;
    }

    public void invalidateAddressRange(BigInteger startAddress, BigInteger endAddress, boolean collapse) {
        this.deleteDisassemblyRange(startAddress, endAddress, true, collapse);
    }

    public void deleteDisassemblyRange(BigInteger startAddress, BigInteger endAddress, boolean invalidate, boolean collapse) {
        assert (DisassemblyDocument.isGuiThread());
        DocumentRewriteSession session = this.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        try {
            String replacement = invalidate ? "...\n" : null;
            int replaceLen = replacement != null ? replacement.length() : 0;
            AddressRangePosition lastPos = null;
            ArrayList<AddressRangePosition> toRemove = new ArrayList<AddressRangePosition>();
            Iterator<AddressRangePosition> it = this.getModelPositionIterator(startAddress);
            while (it.hasNext()) {
                int oldLength;
                AddressRangePosition pos = it.next();
                BigInteger posEndAddress = pos.fAddressOffset.add(pos.fAddressLength);
                if (pos instanceof LabelPosition) {
                    if (!invalidate && pos.length > 0 && posEndAddress.compareTo(endAddress) > 0) {
                        try {
                            oldLength = pos.length;
                            pos.length = 0;
                            this.replace(pos, oldLength, null);
                        }
                        catch (BadLocationException e) {
                            this.internalError(e);
                        }
                    }
                    pos = null;
                } else if (pos instanceof SourcePosition) {
                    pos = null;
                } else if (pos instanceof ErrorPosition) {
                    pos = null;
                } else if (pos instanceof DisassemblyPosition && collapse && lastPos != null && (invalidate || lastPos.fValid == pos.fValid) && lastPos.offset + lastPos.length == pos.offset) {
                    assert (lastPos.fAddressOffset.add(lastPos.fAddressLength).compareTo(pos.fAddressOffset) == 0);
                    lastPos.length += pos.length;
                    lastPos.fAddressLength = lastPos.fAddressLength.add(pos.fAddressLength);
                    toRemove.add(pos);
                    if (!pos.fValid) {
                        this.removeInvalidAddressRange(pos);
                    }
                    pos = null;
                    if (posEndAddress.compareTo(endAddress) < 0) continue;
                }
                if (lastPos != null) {
                    try {
                        if (lastPos.length > 0 || replaceLen > 0) {
                            oldLength = lastPos.length;
                            lastPos.length = replaceLen;
                            this.replace(lastPos, oldLength, replacement);
                        }
                    }
                    catch (BadLocationException e) {
                        this.internalError(e);
                    }
                }
                if (pos == null && posEndAddress.compareTo(endAddress) >= 0) break;
                lastPos = null;
                if (pos == null) continue;
                if (pos.fValid && invalidate) {
                    pos.fValid = false;
                    this.addInvalidAddressRange(pos);
                }
                lastPos = pos;
            }
            this.removePositions(CATEGORY_DISASSEMBLY, toRemove);
        }
        finally {
            this.stopRewriteSession(session);
        }
        if (DisassemblyUtils.DEBUG) {
            this.checkConsistency();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void invalidateSource() {
        if (!DisassemblyDocument.$assertionsDisabled && !DisassemblyDocument.isGuiThread()) {
            throw new AssertionError();
        }
        try {
            it = this.getPositionIterator("category_source", 0);
            if (true) ** GOTO lbl16
        }
        catch (BadPositionCategoryException e) {
            this.internalError(e);
            return;
        }
        do {
            if ((srcPos = (SourcePosition)it.next()) == null || !srcPos.fValid) continue;
            srcPos.fValid = false;
            if (!DisassemblyDocument.$assertionsDisabled && this.fInvalidSource.contains((Object)srcPos)) {
                throw new AssertionError();
            }
            this.addInvalidSourcePositions(srcPos);
lbl16:
            // 3 sources

        } while (it.hasNext());
    }

    public SourcePosition[] getInvalidSourcePositions() {
        assert (DisassemblyDocument.isGuiThread());
        return this.fInvalidSource.toArray(new SourcePosition[this.fInvalidSource.size()]);
    }

    public boolean addInvalidSourcePositions(SourcePosition srcPos) {
        assert (DisassemblyDocument.isGuiThread());
        if (DisassemblyUtils.DEBUG) {
            System.out.println("Adding invalid source position to list: " + (Object)((Object)srcPos));
        }
        return this.fInvalidSource.add(srcPos);
    }

    public boolean removeInvalidSourcePosition(SourcePosition srcPos) {
        assert (DisassemblyDocument.isGuiThread());
        if (DisassemblyUtils.DEBUG) {
            System.out.println("Removing invalid source position from list: " + (Object)((Object)srcPos));
        }
        return this.fInvalidSource.remove((Object)srcPos);
    }

    public boolean hasInvalidSourcePositions() {
        assert (DisassemblyDocument.isGuiThread());
        return this.fInvalidSource.size() > 0;
    }

    public void invalidateDisassemblyWithSource(boolean removeDisassembly) {
        for (SourceFileInfo info : this.fFileInfoMap.values()) {
            if (info.fLine2Addr == null) continue;
            this.deleteDisassemblyRange(info.fStartAddress, info.fEndAddress.add(BigInteger.ONE), !removeDisassembly, !removeDisassembly);
        }
    }

    public void deleteLineRange(int start, int end) throws BadLocationException {
        assert (DisassemblyDocument.isGuiThread());
        if (start >= end) {
            return;
        }
        int startOffset = this.getLineOffset(start);
        int endOffset = this.getLineOffset(end);
        int replaceLength = 0;
        AddressRangePosition startPos = this.getDisassemblyPosition(startOffset);
        if (startPos == null) {
            return;
        }
        startOffset = startPos.offset;
        AddressRangePosition endPos = this.getDisassemblyPosition(endOffset);
        if (endPos == null) {
            return;
        }
        BigInteger startAddress = BigInteger.ZERO;
        BigInteger addressLength = BigInteger.ZERO;
        ArrayList<AddressRangePosition> toRemove = new ArrayList<AddressRangePosition>();
        try {
            Iterator<AddressRangePosition> it = this.getPositionIterator(CATEGORY_MODEL, startAddress);
            while (it.hasNext()) {
                AddressRangePosition p = it.next();
                addressLength = addressLength.add(p.fAddressLength);
                replaceLength += p.length;
                toRemove.add(p);
                if (!p.fValid) {
                    if (p instanceof SourcePosition) {
                        this.removeInvalidSourcePosition((SourcePosition)p);
                    } else {
                        this.removeInvalidAddressRange(p);
                    }
                }
                if (addressLength.compareTo(BigInteger.ZERO) <= 0 || p.fAddressOffset.compareTo(endPos.fAddressOffset) < 0) {
                    continue;
                }
                break;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        for (AddressRangePosition pos : toRemove) {
            this.removeModelPosition(pos);
        }
        if (addressLength.compareTo(BigInteger.ZERO) > 0) {
            this.insertInvalidAddressRange(startOffset, replaceLength, startAddress, startAddress.add(addressLength));
        }
    }

    public SourceFileInfo getSourceInfo(BigInteger address) {
        AddressRangePosition pos = this.getDisassemblyPosition(address);
        if (pos instanceof DisassemblyPosition) {
            DisassemblyPosition disassPos = (DisassemblyPosition)pos;
            return this.getSourceInfo(disassPos.getFile());
        }
        return null;
    }

    public SourceFileInfo getSourceInfo(String file) {
        if (this.fFileInfoMap == null || file == null) {
            return null;
        }
        for (SourceFileInfo info : this.fFileInfoMap.values()) {
            if (!file.equals(info.fFileKey)) continue;
            return info;
        }
        return this.getSourceInfo((IPath)new Path(file));
    }

    public SourceFileInfo getSourceInfo(IPath file) {
        if (this.fFileInfoMap == null || file == null) {
            return null;
        }
        for (SourceFileInfo info : this.fFileInfoMap.values()) {
            if (!file.equals((Object)new Path(info.fFileKey))) continue;
            return info;
        }
        return null;
    }

    public SourceFileInfo getSourceInfo(IStorage sourceElement) {
        if (this.fFileInfoMap == null) {
            return null;
        }
        SourceFileInfo fi = this.fFileInfoMap.get(sourceElement);
        return fi;
    }

    public SourceFileInfo createSourceInfo(String fileKey, IStorage sourceElement, Runnable done) {
        SourceFileInfo fi = new SourceFileInfo(fileKey, sourceElement);
        assert (this.fFileInfoMap != null);
        if (this.fFileInfoMap != null) {
            this.fFileInfoMap.put(sourceElement, fi);
            new SourceReadingJob(fi, done);
        }
        return fi;
    }

    private void internalError(Throwable e) {
        if (DisassemblyUtils.DEBUG) {
            System.err.println("Disassembly: Internal error");
            e.printStackTrace();
        }
    }

    public void addInvalidAddressRange(AddressRangePosition pos) {
        assert (DisassemblyDocument.isGuiThread());
        if (DisassemblyUtils.DEBUG) {
            System.out.println("Adding to invalid range list: " + pos);
        }
        this.fInvalidAddressRanges.add(pos);
    }

    public void removeInvalidAddressRanges(Collection<AddressRangePosition> positions) {
        assert (DisassemblyDocument.isGuiThread());
        if (DisassemblyUtils.DEBUG) {
            for (AddressRangePosition pos : positions) {
                System.out.println("Removing from invalid range list: " + pos);
            }
        }
        this.fInvalidAddressRanges.removeAll(positions);
    }

    public void removeInvalidAddressRange(AddressRangePosition pos) {
        assert (DisassemblyDocument.isGuiThread());
        if (DisassemblyUtils.DEBUG) {
            System.out.println("Removing from invalid range list: " + pos);
        }
        this.fInvalidAddressRanges.remove(pos);
    }

    private static boolean isGuiThread() {
        return Display.getCurrent() != null;
    }

    private static boolean isOneOfOurs(String category) {
        return category.equals(CATEGORY_MODEL) || category.equals(CATEGORY_DISASSEMBLY) || category.equals(CATEGORY_LABELS) || category.equals(CATEGORY_SOURCE);
    }
}

