/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfinedToDsfExecutor(value="fExecutor")
abstract class DataCache<V> {
    private final Executor fExecutor;
    private boolean fValid;
    protected DataRequestMonitor<V> fRm;
    private V fData;
    private IStatus fStatus;
    private List<DataRequestMonitor<V>> fWaitingList = new LinkedList<DataRequestMonitor<V>>();

    public DataCache(Executor executor) {
        this.fExecutor = executor;
    }

    protected abstract void retrieve(DataRequestMonitor<V> var1);

    public boolean isValid() {
        return this.fValid;
    }

    public boolean isPending() {
        return this.fRm != null;
    }

    public V getData() {
        return this.fData;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void request(DataRequestMonitor<V> rm) {
        if (!this.fValid) {
            boolean first = this.fWaitingList.isEmpty();
            this.fWaitingList.add(rm);
            if (first) {
                this.fRm = new DataRequestMonitor<V>(this.fExecutor, null){

                    protected void handleCompleted() {
                        if (!this.isCanceled()) {
                            DataCache.this.fValid = true;
                            DataCache.this.fRm = null;
                            DataCache.this.set(this.getData(), this.getStatus());
                        }
                    }
                };
                this.retrieve(this.fRm);
            }
        } else {
            rm.setData(this.fData);
            rm.setStatus(this.fStatus);
            rm.done();
        }
    }

    private void set(V data, IStatus status) {
        this.fData = data;
        this.fStatus = status;
        List<DataRequestMonitor<V>> waitingList = this.fWaitingList;
        this.fWaitingList = new LinkedList<DataRequestMonitor<V>>();
        for (DataRequestMonitor<V> rm : waitingList) {
            rm.setData(data);
            rm.setStatus(status);
            rm.done();
        }
    }

    public void reset() {
        this.reset(null, (IStatus)new Status(4, "org.eclipse.cdt.dsf", 10001, "Cache reset", null));
    }

    public void reset(V data, IStatus status) {
        this.fValid = false;
        if (this.fRm != null) {
            this.fRm.cancel();
            this.fRm = null;
        }
        this.set(data, status);
    }

    public void disable() {
        IStatus status;
        V data;
        if (this.fValid) {
            data = this.getData();
            status = this.getStatus();
        } else {
            data = null;
            status = new Status(4, "org.eclipse.cdt.dsf", 10001, "Cache disable", null);
        }
        this.disable(data, status);
    }

    public void disable(V data, IStatus status) {
        this.reset(data, status);
        this.fValid = true;
    }
}

