/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.register;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.ErrorLabelText;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.AbstractExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueLabelText;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueVMUtil;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.IFormattedValueVMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.MessagesForRegisterVM;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.RegisterCellModifier;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableLabelFont;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelBackground;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelForeground;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.update.StaleDataLabelBackground;
import org.eclipse.cdt.dsf.ui.viewmodel.update.StaleDataLabelForeground;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterVMNode
extends AbstractExpressionVMNode
implements IElementEditor,
IElementLabelProvider,
IElementMementoProvider,
IElementPropertiesProvider {
    private static final String PROP_REGISTER_SHOW_TYPE_NAMES = "register_show_type_names";
    private IWatchExpressionFactoryAdapter2 fRegisterExpressionFactory = null;
    private final SyncRegisterDataAccess fSyncRegisterDataAccess;
    private IElementLabelProvider fLabelProvider;
    private LabelBackground columnIdValueBackground;
    private IPropertyChangeListener fPreferenceChangeListener;
    private final String MEMENTO_NAME = "REGISTER_MEMENTO_NAME";

    public RegisterVMNode(AbstractDMVMProvider provider, DsfSession session, SyncRegisterDataAccess syncDataAccess) {
        super(provider, session, IRegisters.IRegisterDMContext.class);
        this.fSyncRegisterDataAccess = syncDataAccess;
        this.fLabelProvider = this.createLabelProvider();
    }

    private Object[] constructTypeObjects(Map<String, Object> properties) {
        int type = 0;
        if (Boolean.TRUE.equals(properties.get("is_float"))) {
            type = 1;
        }
        int readAttr = 0;
        if (Boolean.TRUE.equals(properties.get("is_readable"))) {
            readAttr = 1;
        } else if (Boolean.TRUE.equals(properties.get("is_readonce"))) {
            readAttr = 2;
        }
        int writeAttr = 0;
        if (Boolean.TRUE.equals(properties.get("is_writeable"))) {
            writeAttr = 1;
        } else if (Boolean.TRUE.equals(properties.get("is_writeonce"))) {
            writeAttr = 2;
        }
        Object[] messageAttrs = new Object[]{type, readAttr, writeAttr};
        return messageAttrs;
    }

    @Override
    public void dispose() {
        if (this.fPreferenceChangeListener != null) {
            DebugUITools.getPreferenceStore().removePropertyChangeListener(this.fPreferenceChangeListener);
        }
        super.dispose();
    }

    protected IElementLabelProvider createLabelProvider() {
        this.columnIdValueBackground = new LabelBackground(DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB()){
            {
                this.setPropertyNames(new String[]{"formatted_value_active_format_value", "is_changed.formatted_value_active_format_value", "formatted_value_active_format", "is_changed.formatted_value_active_format"});
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean activeFormatChanged = (Boolean)properties.get("is_changed.formatted_value_active_format");
                Boolean activeChanged = (Boolean)properties.get("is_changed.formatted_value_active_format_value");
                return Boolean.TRUE.equals(activeChanged) && !Boolean.TRUE.equals(activeFormatChanged);
            }
        };
        if (this.fPreferenceChangeListener != null) {
            DebugUITools.getPreferenceStore().removePropertyChangeListener(this.fPreferenceChangeListener);
        }
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND")) {
                    RegisterVMNode.this.columnIdValueBackground.setBackground(DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB());
                }
            }
        };
        DebugUITools.getPreferenceStore().addPropertyChangeListener(this.fPreferenceChangeListener);
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForRegisterVM.RegisterVMNode_Name_column__text_format, new String[]{"name"}), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_REGISTER")), new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__DESCRIPTION", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForRegisterVM.RegisterVMNode_Description_column__text_format, new String[]{"description"}), new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__TYPE", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForRegisterVM.RegisterVMNode_Type_column__text_format, new String[]{"is_float", "is_readable", "is_readonce", "is_writeable", "is_writeonce"}){

            @Override
            public void updateAttribute(ILabelUpdate update, int columnIndex, IStatus status, Map<String, Object> properties) {
                Object[] messageAttrs = RegisterVMNode.this.constructTypeObjects(properties);
                try {
                    update.setLabel(this.getMessageFormat().format(messageAttrs, new StringBuffer(), null).toString(), columnIndex);
                }
                catch (IllegalArgumentException e) {
                    update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 0, "Failed formatting a message for column " + columnIndex + ", for update " + update, (Throwable)e));
                }
            }
        }, new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE", new LabelColumnInfo(new LabelAttribute[]{new FormattedValueLabelText(), new ErrorLabelText(), new LabelForeground(new RGB(255, 0, 0)){
            {
                this.setPropertyNames(new String[]{"name"});
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                return !status.isOK();
            }
        }, this.columnIdValueBackground, new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__EXPRESSION", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForRegisterVM.RegisterVMNode_Expression_column__text_format, new String[]{"element_expression"}), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_REGISTER")), new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new FormattedValueLabelText(MessagesForRegisterVM.RegisterVMNode_No_columns__text_format, new String[]{"name", "formatted_value_active_format_value"}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean showTypeNames = (Boolean)properties.get(RegisterVMNode.PROP_REGISTER_SHOW_TYPE_NAMES);
                return showTypeNames != null && showTypeNames == false && super.isEnabled(status, properties);
            }
        }, new FormattedValueLabelText(MessagesForRegisterVM.RegisterVMNode_No_columns__text_format_with_type, new String[]{"name", "formatted_value_active_format_value", "is_float", "is_readable", "is_readonce", "is_writeable", "is_writeonce", PROP_REGISTER_SHOW_TYPE_NAMES}){

            @Override
            public void updateAttribute(ILabelUpdate update, int columnIndex, IStatus status, Map<String, Object> properties) {
                Object[] messageAttrs = RegisterVMNode.this.constructTypeObjects(properties);
                Object[] combinedAttrs = new Object[messageAttrs.length + 2];
                combinedAttrs[0] = super.getPropertyValue("name", status, properties);
                combinedAttrs[1] = super.getPropertyValue("formatted_value_active_format_value", status, properties);
                int idx = 0;
                while (idx < messageAttrs.length) {
                    combinedAttrs[idx + 2] = messageAttrs[idx];
                    ++idx;
                }
                try {
                    update.setLabel(this.getMessageFormat().format(combinedAttrs, new StringBuffer(), null).toString(), columnIndex);
                }
                catch (IllegalArgumentException e) {
                    update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 0, "Failed formatting a message for column " + columnIndex + ", for update " + update, (Throwable)e));
                }
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean showTypeNames = (Boolean)properties.get(RegisterVMNode.PROP_REGISTER_SHOW_TYPE_NAMES);
                return showTypeNames != null && showTypeNames != false && super.isEnabled(status, properties);
            }
        }, new ErrorLabelText(MessagesForRegisterVM.RegisterVMNode_No_columns__Error__text_format, new String[]{"name"}), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_REGISTER")), new LabelForeground(DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.changedDebugElement").getRGB()){
            {
                this.setPropertyNames(new String[]{"formatted_value_active_format_value", "is_changed.formatted_value_active_format_value", "formatted_value_active_format", "is_changed.formatted_value_active_format"});
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean activeFormatChanged = (Boolean)properties.get("is_changed.formatted_value_active_format");
                Boolean activeChanged = (Boolean)properties.get("is_changed.formatted_value_active_format_value");
                return Boolean.TRUE.equals(activeChanged) && !Boolean.TRUE.equals(activeFormatChanged);
            }
        }, new StaleDataLabelBackground(), new VariableLabelFont()}));
        return provider;
    }

    public String toString() {
        return "RegisterVMNode(" + this.getSession().getId() + ")";
    }

    protected SyncRegisterDataAccess getSyncRegisterDataAccess() {
        return this.fSyncRegisterDataAccess;
    }

    public IWatchExpressionFactoryAdapter2 getWatchExpressionFactory() {
        if (this.fRegisterExpressionFactory == null) {
            this.fRegisterExpressionFactory = new RegisterExpressionFactory();
        }
        return this.fRegisterExpressionFactory;
    }

    public void update(ILabelUpdate[] updates) {
        this.fLabelProvider.update(updates);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(final IPropertiesUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        RegisterVMNode.this.updatePropertiesInSessionThread(updates);
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException v0) {
                var5_2 = updates;
                var4_3 = updates.length;
                var3_4 = 0;
                ** while (var3_4 < var4_3)
            }
lbl-1000:
            // 1 sources

            {
                update = var5_2[var3_4];
                this.handleFailedUpdate(update);
                ++var3_4;
                continue;
            }
        }
    }

    private Boolean getShowTypeNamesState(IPresentationContext context) {
        Boolean attribute = (Boolean)context.getProperty("org.eclipse.debug.ui.displayVariableTypeNames");
        if (attribute != null) {
            return attribute;
        }
        return Boolean.FALSE;
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updatePropertiesInSessionThread(final IPropertiesUpdate[] updates) {
        IRegisters service = (IRegisters)this.getServicesTracker().getService(IRegisters.class, null);
        final CountingRequestMonitor countingRm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), null){

            protected void handleCompleted() {
                IPropertiesUpdate[] iPropertiesUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertiesUpdate update = iPropertiesUpdateArray[n2];
                    update.done();
                    ++n2;
                }
            }
        };
        int count = 0;
        if (service != null) {
            FormattedValueVMUtil.updateFormattedValues(updates, (IFormattedValues)service, IRegisters.IRegisterDMContext.class, (RequestMonitor)countingRm);
            ++count;
        }
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IRegisters.IRegisterDMContext dmc;
            final IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            IExpression expression = (IExpression)DebugPlugin.getAdapter((Object)update.getElement(), IExpression.class);
            if (expression != null) {
                update.setProperty("element_expression", expression.getExpressionText());
            }
            if ((dmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRegisters.IRegisterDMContext.class)) == null || service == null) {
                this.handleFailedUpdate(update);
            } else {
                if (update.getProperties().contains(PROP_REGISTER_SHOW_TYPE_NAMES)) {
                    update.setProperty(PROP_REGISTER_SHOW_TYPE_NAMES, this.getShowTypeNamesState(update.getPresentationContext()));
                }
                service.getRegisterData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRegisters.IRegisterDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            RegisterVMNode.this.fillRegisterDataProperties(update, (IRegisters.IRegisterDMData)this.getData());
                        } else {
                            update.setStatus(this.getStatus());
                        }
                        countingRm.done();
                    }
                });
                ++count;
            }
            ++n2;
        }
        countingRm.setDoneCount(count);
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void fillRegisterDataProperties(IPropertiesUpdate update, IRegisters.IRegisterDMData data) {
        update.setProperty("name", data.getName());
        update.setProperty("description", data.getDescription());
        update.setProperty("is_float", data.isFloat());
        update.setProperty("is_readable", data.isReadable());
        update.setProperty("is_readonce", data.isReadOnce());
        update.setProperty("is_writeable", data.isWriteable());
        update.setProperty("is_writeonce", data.isWriteOnce());
        IExpression expression = (IExpression)DebugPlugin.getAdapter((Object)update.getElement(), IExpression.class);
        if (expression == null) {
            update.setProperty("element_expression", data.getName());
        }
    }

    @Override
    public void update(IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
            update.setHasChilren(true);
            update.done();
            ++n2;
        }
    }

    @Override
    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        if (regService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        regService.getRegisters(this.createCompositeDMVMContext((IViewerUpdate)update), (DataRequestMonitor)new ViewerDataRequestMonitor<IRegisters.IRegisterDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    RegisterVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                RegisterVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    @Override
    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new RegisterVMC(dmc);
    }

    @Override
    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent || e instanceof IMemory.IMemoryChangedEvent || e instanceof IRegisters.IRegistersChangedDMEvent || e instanceof PropertyChangeEvent && ((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle") {
            return 1024;
        }
        if (e instanceof IRegisters.IRegisterChangedDMEvent) {
            return 2048;
        }
        return 0;
    }

    @Override
    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.ISuspendedDMEvent || e instanceof IMemory.IMemoryChangedEvent || e instanceof IRegisters.IRegistersChangedDMEvent || e instanceof PropertyChangeEvent && ((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle") {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        if (e instanceof IRegisters.IRegisterChangedDMEvent) {
            parentDelta.addNode(this.createVMContext(((IRegisters.IRegisterChangedDMEvent)e).getDMContext()), 2048);
        }
        rm.done();
    }

    @Override
    public boolean canParseExpression(IExpression expression) {
        return this.parseExpressionForRegisterName(expression.getExpressionText()) != null;
    }

    private String parseExpressionForRegisterName(String expression) {
        if (expression.startsWith("GRP(")) {
            int startIdx = "GRP(".length();
            int endIdx = expression.indexOf(41, startIdx);
            if (startIdx == -1 || endIdx == -1) {
                return null;
            }
            String remaining = expression.substring(endIdx + 1);
            if (!remaining.startsWith(".REG(")) {
                return null;
            }
            startIdx = ".REG(".length();
            endIdx = remaining.indexOf(41, startIdx);
            if (startIdx == -1 || endIdx == -1) {
                return null;
            }
            String regName = remaining.substring(startIdx, endIdx);
            return regName.trim();
        }
        if (expression.startsWith("$")) {
            return null;
        }
        return null;
    }

    @Override
    protected void testElementForExpression(Object element, IExpression expression, final DataRequestMonitor<Boolean> rm) {
        if (!(element instanceof IDMVMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        final IRegisters.IRegisterDMContext dmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IRegisterDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        final String regName = this.parseExpressionForRegisterName(expression.getExpressionText());
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRegisters registersService = (IRegisters)RegisterVMNode.this.getServicesTracker().getService(IRegisters.class);
                    if (registersService != null) {
                        registersService.getRegisterData(dmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>(ImmediateExecutor.getInstance(), (RequestMonitor)rm){

                            protected void handleSuccess() {
                                rm.setData((Object)((IRegisters.IRegisterDMData)this.getData()).getName().equals(regName));
                                rm.done();
                            }
                        });
                    } else {
                        rm.setStatus((IStatus)new Status(2, "org.eclipse.cdt.dsf.ui", 10001, "Register service not available", null));
                        rm.done();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            rm.setStatus((IStatus)new Status(2, "org.eclipse.cdt.dsf.ui", 10001, "DSF session shut down", null));
            rm.done();
        }
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof RegisterVMC) {
            ((RegisterVMC)element).setExpression(expression);
        }
    }

    @Override
    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        if (event instanceof IRegisters.IRegisterChangedDMEvent || event instanceof IMemory.IMemoryChangedEvent || event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            return 2048;
        }
        if (event instanceof IRegisters.IRegistersChangedDMEvent || event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDeltaForExpression(IExpression expression, int elementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (event instanceof IRegisters.IRegistersChangedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        rm.done();
    }

    @Override
    public void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IRegisters.IRegisterChangedDMEvent || event instanceof IMemory.IMemoryChangedEvent || event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            parentDelta.addNode(element, 2048);
        }
        rm.done();
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        IRegisters.IRegisterDMData regData;
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(columnId) && (regData = this.getSyncRegisterDataAccess().readRegister(element)) != null && regData.isWriteable()) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return new RegisterCellModifier(this.getDMVMProvider(), this.getSyncRegisterDataAccess());
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            final IElementCompareRequest request = iElementCompareRequestArray[n2];
            final IRegisters.IRegisterDMContext regDmc = this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IRegisters.IRegisterDMContext.class);
            final String mementoName = request.getMemento().getString("REGISTER_MEMENTO_NAME");
            if (regDmc == null || mementoName == null) {
                request.done();
            } else {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IRegisters regService = (IRegisters)RegisterVMNode.this.getServicesTracker().getService(IRegisters.class);
                            if (regService != null) {
                                regService.getRegisterData(regDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>((Executor)regService.getExecutor(), null){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            request.setEqual(mementoName.equals("Register." + ((IRegisters.IRegisterDMData)this.getData()).getName()));
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    request.done();
                }
            }
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            final IElementMementoRequest request = iElementMementoRequestArray[n2];
            final IRegisters.IRegisterDMContext regDmc = this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IRegisters.IRegisterDMContext.class);
            if (regDmc == null) {
                request.done();
            } else {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IRegisters regService = (IRegisters)RegisterVMNode.this.getServicesTracker().getService(IRegisters.class);
                            if (regService != null) {
                                regService.getRegisterData(regDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>((Executor)regService.getExecutor(), null){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            request.getMemento().putString("REGISTER_MEMENTO_NAME", "Register." + ((IRegisters.IRegisterDMData)this.getData()).getName());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    request.done();
                }
            }
            ++n2;
        }
    }

    protected class RegisterExpressionFactory
    implements IWatchExpressionFactoryAdapter2 {
        protected RegisterExpressionFactory() {
        }

        public boolean canCreateWatchExpression(Object element) {
            return element instanceof RegisterVMC;
        }

        public String createWatchExpression(Object element) throws CoreException {
            IRegisters.IRegisterGroupDMData groupData = RegisterVMNode.this.getSyncRegisterDataAccess().getRegisterGroupDMData(element);
            IRegisters.IRegisterDMData registerData = RegisterVMNode.this.getSyncRegisterDataAccess().getRegisterDMData(element);
            if (groupData != null && registerData != null) {
                StringBuffer exprBuf = new StringBuffer();
                exprBuf.append("GRP( ");
                exprBuf.append(groupData.getName());
                exprBuf.append(" )");
                exprBuf.append(".REG( ");
                exprBuf.append(registerData.getName());
                exprBuf.append(" )");
                return exprBuf.toString();
            }
            return null;
        }
    }

    protected class RegisterVMC
    extends AbstractDMVMNode.DMVMContext
    implements IFormattedValueVMContext {
        private IExpression fExpression;

        public RegisterVMC(IDMContext dmc) {
            super(RegisterVMNode.this, dmc);
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapter2.class)) {
                return RegisterVMNode.this.getWatchExpressionFactory();
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof RegisterVMC && super.equals(other)) {
                RegisterVMC otherReg = (RegisterVMC)other;
                return otherReg.fExpression == null && this.fExpression == null || otherReg.fExpression != null && otherReg.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }
    }
}

